/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.editor.ExpressionEditorArea;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignHyperlinkParameter;

public class JRLinkParameterDialog
extends JDialog {
    JRDesignHyperlinkParameter tmpParameter = null;
    private JButton jButtonCancel;
    private JButton jButtonOK;
    private JComboBox jComboBox1;
    private JLabel jLabel1;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private ExpressionEditorArea jRTextExpressionAreaDefaultExpression;
    private JTextField jTextFieldName;
    private int dialogResult;
    public static final int COMPONENT_NONE = 0;
    public static final int COMPONENT_PARAM_NAME = 1;
    public static final int COMPONENT_PARAM_EXPRESSION = 2;

    public JRLinkParameterDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public JRLinkParameterDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
        ArrayList<Tag> classes = new ArrayList<Tag>();
        classes.add(new Tag("java.lang.Boolean"));
        classes.add(new Tag("java.lang.Byte"));
        classes.add(new Tag("java.util.Date"));
        classes.add(new Tag("java.sql.Timestamp"));
        classes.add(new Tag("java.sql.Time"));
        classes.add(new Tag("java.lang.Double"));
        classes.add(new Tag("java.lang.Float"));
        classes.add(new Tag("java.lang.Integer"));
        classes.add(new Tag("java.lang.Long"));
        classes.add(new Tag("java.lang.Short"));
        classes.add(new Tag("java.math.BigDecimal"));
        classes.add(new Tag("java.lang.Number"));
        classes.add(new Tag("java.lang.String"));
        classes.add(new Tag("java.util.Collection"));
        classes.add(new Tag("java.util.List"));
        classes.add(new Tag("java.lang.Object"));
        classes.add(new Tag("java.io.InputStream"));
        classes.add(new Tag("net.sf.jasperreports.engine.JREmptyDataSource"));
        this.jComboBox1.setModel(new DefaultComboBoxModel<Object>(classes.toArray()));
        Misc.setComboboxSelectedTagValue(this.jComboBox1, "java.lang.String");
    }

    public void initAll() {
        this.initComponents();
        this.jRTextExpressionAreaDefaultExpression.setText("");
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                JRLinkParameterDialog.this.jButtonCancelActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jButtonOK = new JButton();
        this.jButtonCancel = new JButton();
        this.jPanel2 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jTextFieldName = new JTextField();
        this.jLabel4 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jRTextExpressionAreaDefaultExpression = new ExpressionEditorArea();
        this.jComboBox1 = new JComboBox();
        this.setTitle("Add/modify parameter");
        this.setModal(true);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                JRLinkParameterDialog.this.closeDialog(evt);
            }
        });
        this.jPanel1.setLayout(new FlowLayout(2));
        this.jButtonOK.setMnemonic('o');
        this.jButtonOK.setText("OK");
        this.jButtonOK.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRLinkParameterDialog.this.jButtonOKActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonOK);
        this.jButtonCancel.setMnemonic('c');
        this.jButtonCancel.setText("Cancel");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JRLinkParameterDialog.this.jButtonCancelActionPerformed(evt);
            }
        });
        this.jPanel1.add(this.jButtonCancel);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.setLayout(new GridBagLayout());
        this.jLabel1.setText("Link parameter name");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 0, 3);
        this.jPanel2.add((Component)this.jLabel1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jTextFieldName, gridBagConstraints);
        this.jLabel4.setText("Parameter Class Name");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jLabel4, gridBagConstraints);
        this.jLabel3.setText("Value expression");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.jPanel2.add((Component)this.jLabel3, gridBagConstraints);
        this.jRTextExpressionAreaDefaultExpression.setBorder(BorderFactory.createEtchedBorder());
        this.jRTextExpressionAreaDefaultExpression.setPreferredSize(new Dimension(300, 80));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(0, 3, 3, 3);
        this.jPanel2.add((Component)this.jRTextExpressionAreaDefaultExpression, gridBagConstraints);
        this.jComboBox1.setEditable(true);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 4, 4, 4);
        this.jPanel2.add((Component)this.jComboBox1, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.setBounds(0, 0, 327, 258);
    }

    private void jButtonCancelActionPerformed(ActionEvent evt) {
        this.setVisible(false);
        this.setDialogResult(2);
        this.dispose();
    }

    private void jButtonOKActionPerformed(ActionEvent evt) {
        Object itemType = this.jComboBox1.getSelectedItem();
        String expClassName = "java.lang.String";
        if (itemType != null && itemType instanceof Tag) {
            expClassName = ((Tag)itemType).getValue() + "";
        } else if (itemType != null) {
            expClassName = expClassName + "";
        }
        if (expClassName.length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRLinkParameterDialog.Message.Warning"), I18n.getString("JRLinkParameterDialog.Message.Error"), 2);
            return;
        }
        if (this.jTextFieldName.getText().trim().length() <= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JRLinkParameterDialog.Message.Warning"), I18n.getString("JRLinkParameterDialog.Message.Error"), 2);
            return;
        }
        this.tmpParameter = new JRDesignHyperlinkParameter();
        this.tmpParameter.setName(this.jTextFieldName.getText());
        this.tmpParameter.setValueExpression((JRExpression)Misc.createExpression(expClassName, this.jRTextExpressionAreaDefaultExpression.getText()));
        this.setVisible(false);
        this.setDialogResult(0);
        this.dispose();
    }

    private void closeDialog(WindowEvent evt) {
        this.setVisible(false);
        this.setDialogResult(-1);
        this.dispose();
    }

    public JRDesignHyperlinkParameter getParameter() {
        return this.tmpParameter;
    }

    public void setParameter(JRDesignHyperlinkParameter tmpParameter) {
        this.jTextFieldName.setText(new String(tmpParameter.getName()));
        if (tmpParameter.getValueExpression() != null && tmpParameter.getValueExpression().getValueClassName() != null) {
            this.jComboBox1.setSelectedItem(tmpParameter.getValueExpression().getValueClassName());
        }
        this.jRTextExpressionAreaDefaultExpression.setText(Misc.getExpressionText(tmpParameter.getValueExpression()));
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public void setFocusedExpression(int expID) {
        try {
            switch (expID) {
                case 2: {
                    Misc.selectTextAndFocusArea(this.jRTextExpressionAreaDefaultExpression);
                    break;
                }
                case 1: {
                    Misc.selectTextAndFocusArea(this.jTextFieldName);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void setExpressionContext(ExpressionContext ec) {
        this.jRTextExpressionAreaDefaultExpression.setExpressionContext(ec);
    }
}

