/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.jrctx;

import com.jaspersoft.ireport.designer.GenericCloseOperationHandler;
import com.jaspersoft.ireport.designer.jrctx.JRCTXDataObject;
import com.jaspersoft.ireport.designer.jrctx.JRCTXTextView;
import com.jaspersoft.ireport.designer.jrctx.JRCTXVisualView;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.IOException;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import net.sf.jasperreports.chartthemes.simple.ChartThemeSettings;
import net.sf.jasperreports.chartthemes.simple.XmlChartTheme;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Task;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JRCTXEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditorCookie,
EditCookie,
SaveAsCapable {
    private static Logger LOG = Logger.getLogger(JRCTXEditorSupport.class.getName());
    private InstanceContent specialNodeLookupIC = null;
    private Lookup specialNodeLookup = null;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            JRCTXEditorSupport.this.saveDocument();
        }
    };
    final MultiViewDescription[] descriptions = new MultiViewDescription[]{new JRCTXVisualView(this), new JRCTXTextView(this)};
    private ChartThemeSettings currentModel = null;

    protected Task reloadDocument() {
        ((JRCTXVisualView)this.descriptions[0]).refreshModel();
        return super.reloadDocument();
    }

    public MultiViewDescription[] getDescriptions() {
        return this.descriptions;
    }

    private JRCTXEditorSupport(JRCTXDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new JRCTXEnv(obj));
        this.specialNodeLookupIC = new InstanceContent();
        this.specialNodeLookupIC.add((Object)this);
        this.specialNodeLookup = new AbstractLookup((AbstractLookup.Content)this.specialNodeLookupIC);
    }

    public static JRCTXEditorSupport create(JRCTXDataObject obj) {
        JRCTXEditorSupport ed = new JRCTXEditorSupport(obj);
        ed.setMIMEType("text/xml");
        return ed;
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViewFactory.createCloneableMultiView((MultiViewDescription[])this.descriptions, (MultiViewDescription)this.descriptions[0], (CloseOperationHandler)new GenericCloseOperationHandler(this));
    }

    protected boolean notifyModified() {
        JRCTXDataObject obj;
        boolean retValue = super.notifyModified();
        if (retValue && (obj = (JRCTXDataObject)this.getDataObject()).getCookie(SaveCookie.class) == null) {
            obj.getIc().add((Object)this.saveCookie);
            this.specialNodeLookupIC.add((Object)this.saveCookie);
            obj.setModified(true);
        }
        return retValue;
    }

    protected void notifyUnmodified() {
        super.notifyUnmodified();
        JRCTXDataObject obj = (JRCTXDataObject)this.getDataObject();
        SaveCookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getIc().remove((Object)this.saveCookie);
            this.specialNodeLookupIC.remove((Object)this.saveCookie);
            obj.setModified(false);
        }
    }

    public void notifyModelChangeToTheView() {
        if (this.getCurrentModel() != null) {
            ((JRCTXVisualView)this.descriptions[0]).modelChanged();
            this.notifyModified();
        }
    }

    public DataEditorSupport.Env getEnv() {
        return (DataEditorSupport.Env)this.env;
    }

    public void saveDocument() throws IOException {
        if (this.getCurrentModel() != null) {
            ChartThemeSettings jrctx = this.getCurrentModel();
            String content = null;
            try {
                content = XmlChartTheme.saveSettings((ChartThemeSettings)jrctx);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), "Error saving the JRCTX: " + ex.getMessage() + "\nSee the log file for more details.", "Error saving", 0);
                ex.printStackTrace();
                return;
            }
            if (content != null) {
                try {
                    this.getDocument().remove(0, this.getDocument().getLength());
                    this.getDocument().insertString(0, content, null);
                    ((JRCTXVisualView)this.descriptions[0]).setNeedModelRefresh(false);
                }
                catch (BadLocationException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        super.saveDocument();
    }

    public Lookup getSpecialNodeLookup() {
        return this.specialNodeLookup;
    }

    public void setSpecialNodeLookup(Lookup specialNodeLookup) {
        this.specialNodeLookup = specialNodeLookup;
    }

    public ChartThemeSettings getCurrentModel() {
        return this.currentModel;
    }

    public void setCurrentModel(ChartThemeSettings currentModel) {
        if (this.currentModel != null) {
            ((JRCTXDataObject)this.getDataObject()).getIc().remove((Object)this.currentModel);
        }
        this.currentModel = currentModel;
        if (this.currentModel != null) {
            ((JRCTXDataObject)this.getDataObject()).getIc().add((Object)this.currentModel);
        }
    }

    public static final class JRCTXEnv
    extends DataEditorSupport.Env {
        public JRCTXEnv(JRCTXDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return super.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JRCTXDataObject)super.getDataObject()).getPrimaryEntry().takeLock();
        }
    }
}

