/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.data.fieldsproviders.olap;

import com.jaspersoft.ireport.designer.data.fieldsproviders.olap.OlapElement;
import java.awt.Color;
import java.awt.Component;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;

public class OlapTreeCellRenderer
extends DefaultTreeCellRenderer {
    static ImageIcon measureIcon;
    static ImageIcon dimensionIcon;
    static ImageIcon hierarchyIcon;

    public OlapTreeCellRenderer() {
        if (measureIcon == null) {
            measureIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/olap/measure.png"));
        }
        if (dimensionIcon == null) {
            dimensionIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/olap/axis.png"));
        }
        if (hierarchyIcon == null) {
            hierarchyIcon = new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/resources/olap/hierarchy.png"));
        }
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
        this.setForeground(Color.BLACK);
        ImageIcon icon = this.getElementIcon(value);
        this.setIcon(icon);
        this.setToolTipText(null);
        return this;
    }

    protected ImageIcon getElementIcon(Object value) {
        if (!(value instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
        if (node.getParent() != null) {
            if (!(node.getUserObject() instanceof OlapElement)) {
                return dimensionIcon;
            }
            OlapElement olapElement = (OlapElement)node.getUserObject();
            if (olapElement.getType() == 3) {
                return dimensionIcon;
            }
            if (olapElement.getType() == 2) {
                return hierarchyIcon;
            }
            if (olapElement.getType() == 0) {
                return measureIcon;
            }
            return hierarchyIcon;
        }
        return null;
    }
}

