/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2009 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.JRXMLADataSourceConnection;
import com.jaspersoft.ireport.designer.connection.CustomHTTPAuthenticator;
import java.net.Authenticator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jdesktop.swingx.JXBusyLabel;
import rex.graphics.datasourcetree.elements.CatalogElement;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;

/**
 *
 * @author  gtoffoli
 */
public class XMLADataSourceConnectionEditor extends javax.swing.JPanel implements IReportConnectionEditor {
    
    private IReportConnection iReportConnection = null;
    private boolean init = false;
    private rex.graphics.datasourcetree.elements.DataSourceTreeElement[] cachedDataSources = null;
    
    /** Creates new form EJBQLConnectionEditor */
    public XMLADataSourceConnectionEditor() {
        initComponents();
        //applyI18n();
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jPanelXMLA = new javax.swing.JPanel();
        jLabelXMLAUrl = new javax.swing.JLabel();
        jTextFieldXMLAUrl = new javax.swing.JTextField();
        jPanel1 = new javax.swing.JPanel();
        jLabelBusy = new org.jdesktop.swingx.JXBusyLabel();
        jButtonGetXMLAMetadata = new javax.swing.JButton();
        jLabelXMLADatasource = new javax.swing.JLabel();
        jComboBoxXMLADatasource = new javax.swing.JComboBox();
        jLabelXMLACatalog = new javax.swing.JLabel();
        jComboBoxXMLACatalog = new javax.swing.JComboBox();
        jSeparator8 = new javax.swing.JSeparator();
        jLabelXMLACube = new javax.swing.JLabel();
        jComboBoxXMLACube = new javax.swing.JComboBox();
        jSeparator10 = new javax.swing.JSeparator();
        jPanel16 = new javax.swing.JPanel();
        jLabel26 = new javax.swing.JLabel();
        jLabel27 = new javax.swing.JLabel();
        jTextFieldUsername1 = new javax.swing.JTextField();
        jTextFieldPassword1 = new javax.swing.JPasswordField();
        jCheckBoxSavePassword1 = new javax.swing.JCheckBox();
        jLabelAttention = new javax.swing.JLabel();

        setLayout(new java.awt.BorderLayout());

        jPanelXMLA.setLayout(new java.awt.GridBagLayout());

        jLabelXMLAUrl.setText("Url of XML/A server");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 0, 4);
        jPanelXMLA.add(jLabelXMLAUrl, gridBagConstraints);

        jTextFieldXMLAUrl.setText("http://localhost:8080/mondrian/xmla");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 4, 4, 4);
        jPanelXMLA.add(jTextFieldXMLAUrl, gridBagConstraints);

        jPanel1.setLayout(new java.awt.GridBagLayout());

        jLabelBusy.setText(" ");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanel1.add(jLabelBusy, gridBagConstraints);

        jButtonGetXMLAMetadata.setText("Get metadata");
        jButtonGetXMLAMetadata.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonGetXMLAMetadataActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel1.add(jButtonGetXMLAMetadata, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.EAST;
        gridBagConstraints.weightx = 1.0;
        jPanelXMLA.add(jPanel1, gridBagConstraints);

        jLabelXMLADatasource.setText("Datasource");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelXMLA.add(jLabelXMLADatasource, gridBagConstraints);

        jComboBoxXMLADatasource.setMinimumSize(new java.awt.Dimension(23, 22));
        jComboBoxXMLADatasource.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxXMLADatasourceActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelXMLA.add(jComboBoxXMLADatasource, gridBagConstraints);

        jLabelXMLACatalog.setText("Catalog");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelXMLA.add(jLabelXMLACatalog, gridBagConstraints);

        jComboBoxXMLACatalog.setMinimumSize(new java.awt.Dimension(23, 22));
        jComboBoxXMLACatalog.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jComboBoxXMLACatalogActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelXMLA.add(jComboBoxXMLACatalog, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelXMLA.add(jSeparator8, gridBagConstraints);

        jLabelXMLACube.setText("Cube");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 2, 4);
        jPanelXMLA.add(jLabelXMLACube, gridBagConstraints);

        jComboBoxXMLACube.setMinimumSize(new java.awt.Dimension(23, 22));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanelXMLA.add(jComboBoxXMLACube, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanelXMLA.add(jSeparator10, gridBagConstraints);

        jPanel16.setLayout(new java.awt.GridBagLayout());

        jLabel26.setText("Username");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel16.add(jLabel26, gridBagConstraints);

        jLabel27.setText("Password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel16.add(jLabel27, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel16.add(jTextFieldUsername1, gridBagConstraints);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 0);
        jPanel16.add(jTextFieldPassword1, gridBagConstraints);

        jCheckBoxSavePassword1.setText("Save password");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.WEST;
        gridBagConstraints.insets = new java.awt.Insets(2, 6, 0, 6);
        jPanel16.add(jCheckBoxSavePassword1, gridBagConstraints);

        jLabelAttention.setIcon(new javax.swing.ImageIcon(getClass().getResource("/com/jaspersoft/ireport/designer/connection/gui/warning.png"))); // NOI18N
        jLabelAttention.setText("<html>ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it.");
        jLabelAttention.setVerticalTextPosition(javax.swing.SwingConstants.TOP);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(4, 4, 4, 4);
        jPanel16.add(jLabelAttention, gridBagConstraints);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        jPanelXMLA.add(jPanel16, gridBagConstraints);

        add(jPanelXMLA, java.awt.BorderLayout.NORTH);
    }// </editor-fold>//GEN-END:initComponents

    private void jComboBoxXMLACatalogActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxXMLACatalogActionPerformed
            
        
            if (init  || cachedDataSources == null) return;
            
            jComboBoxXMLACube.removeAllItems();
            
            if (jComboBoxXMLACatalog.getSelectedItem() == null) {
              return;
            }
            
            if (jComboBoxXMLACatalog.getSelectedItem() instanceof String) return;
            // Get the catalog cubes...
            CatalogElement catalog = (CatalogElement)jComboBoxXMLACatalog.getSelectedItem();
            
            if (catalog.getChildren() != null)
            {
                for (DataSourceTreeElement cube : catalog.getChildren())
                {
                    jComboBoxXMLACube.addItem(cube);
                }
            }
            
    }//GEN-LAST:event_jComboBoxXMLACatalogActionPerformed

    private void jComboBoxXMLADatasourceActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jComboBoxXMLADatasourceActionPerformed
        
        if (init || cachedDataSources == null) return;
            int dsIndex = jComboBoxXMLADatasource.getSelectedIndex();
            
            init = true;
            jComboBoxXMLACatalog.removeAllItems();
            jComboBoxXMLACube.removeAllItems();
            

            if (dsIndex >= 0 &&
                cachedDataSources != null &&
                dsIndex < cachedDataSources.length)
            {
                rex.graphics.datasourcetree.elements.DataSourceTreeElement catalogs[] = cachedDataSources[dsIndex].getChildren();
                init = true;
                
                for (DataSourceTreeElement catalog : catalogs)
                {
                    jComboBoxXMLACatalog.addItem(catalog);
                }
                
            }
            else
            {
                jComboBoxXMLACatalog.removeAllItems();
                jComboBoxXMLACube.removeAllItems();
            }
        
            init = false;
            
            if (jComboBoxXMLACatalog.getItemCount() > 0)
            {
                jComboBoxXMLACatalog.setSelectedIndex(0);
            }
        
    }//GEN-LAST:event_jComboBoxXMLADatasourceActionPerformed
    
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonGetXMLAMetadata;
    private javax.swing.JCheckBox jCheckBoxSavePassword1;
    private javax.swing.JComboBox jComboBoxXMLACatalog;
    private javax.swing.JComboBox jComboBoxXMLACube;
    private javax.swing.JComboBox jComboBoxXMLADatasource;
    private javax.swing.JLabel jLabel26;
    private javax.swing.JLabel jLabel27;
    private javax.swing.JLabel jLabelAttention;
    private javax.swing.JLabel jLabelBusy;
    private javax.swing.JLabel jLabelXMLACatalog;
    private javax.swing.JLabel jLabelXMLACube;
    private javax.swing.JLabel jLabelXMLADatasource;
    private javax.swing.JLabel jLabelXMLAUrl;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel16;
    private javax.swing.JPanel jPanelXMLA;
    private javax.swing.JSeparator jSeparator10;
    private javax.swing.JSeparator jSeparator8;
    private javax.swing.JPasswordField jTextFieldPassword1;
    private javax.swing.JTextField jTextFieldUsername1;
    private javax.swing.JTextField jTextFieldXMLAUrl;
    // End of variables declaration//GEN-END:variables
    
    
    public void setIReportConnection(IReportConnection c) {
        
        this.iReportConnection = c;
        if (iReportConnection instanceof JRXMLADataSourceConnection)
        {
            /**   
             * Copyright (C) 2005, 2006 CINCOM SYSTEMS, INC.
             * All Rights Reserved
             * www.cincom.com
             *
             */
            JRXMLADataSourceConnection con = (JRXMLADataSourceConnection)iReportConnection;
            this.jTextFieldXMLAUrl.setText( con.getUrl() );  
            this.jComboBoxXMLADatasource.removeAllItems();
            this.jComboBoxXMLADatasource.addItem(con.getDatasource());
            this.jComboBoxXMLACatalog.removeAllItems();
            this.jComboBoxXMLACatalog.addItem(con.getCatalog());
            this.jComboBoxXMLACube.removeAllItems();
            this.jComboBoxXMLACube.addItem(con.getCube());
            
            this.jTextFieldUsername1.setText( con.getUsername());
            if (con.isSavePassword())
                this.jTextFieldPassword1.setText( con.getPassword());
            else 
                this.jTextFieldPassword1.setText( "");
            this.jCheckBoxSavePassword1.setSelected( con.isSavePassword());
        }
    }

    public IReportConnection getIReportConnection() {
        

        /**   
         * Copyright (C) 2005, 2006 CINCOM SYSTEMS, INC.
         * All Rights Reserved
         * www.cincom.com
         *
         */
        IReportConnection irConn = new JRXMLADataSourceConnection();

        if (this.jTextFieldXMLAUrl.getText().trim().length() == 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    //I18n.getString("messages.connectionDialog.xmla.invalidURL",
                    I18n.getString("XMLADataSourceConnectionEditor.Label.Url"),
                    //I18n.getString("messages.connectionDialog.xmla.invalidProperty",
                    I18n.getString("XMLADataSourceConnectionEditor.Label.InvalidProperty"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        ((JRXMLADataSourceConnection)irConn).setUrl( this.jTextFieldXMLAUrl.getText().trim());

        if (this.jComboBoxXMLADatasource.getSelectedIndex() < 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    //I18n.getString("messages.connectionDialog.xmla.invalidDatasource",
                    I18n.getString("XMLADataSourceConnectionEditor.Label.Datasource"),
                    //I18n.getString("messages.connectionDialog.setJDBCConnectionCaption",
                    I18n.getString("XMLADataSourceConnectionEditor.Label.NoJDBC"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        ((JRXMLADataSourceConnection)irConn).setDatasource( 
                ((String)this.jComboBoxXMLADatasource.getSelectedItem()).trim());

        if (this.jComboBoxXMLACatalog.getSelectedIndex() < 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    //I18n.getString("messages.connectionDialog.xmla.invalidCatalog",
                    I18n.getString("XMLADataSourceConnectionEditor.Message.Catalog"),
                    //I18n.getString("messages.connectionDialog.setJDBCConnectionCaption",
                    I18n.getString("XMLADataSourceConnectionEditor.Label.NoJDBC"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

            ((JRXMLADataSourceConnection)irConn).setCatalog( 
                ("" + jComboBoxXMLACatalog.getSelectedItem()).trim());

        if (this.jComboBoxXMLACube.getSelectedIndex() < 0) {
            javax.swing.JOptionPane.showMessageDialog(this,
                    //I18n.getString("messages.connectionDialog.xmla.invalidCube",
                    I18n.getString("XMLADataSourceConnectionEditor.Message.Cube"),
                    //I18n.getString("messages.connectionDialog.setJDBCConnectionCaption",
                    I18n.getString("XMLADataSourceConnectionEditor.Label.NoJDBC"),javax.swing.JOptionPane.WARNING_MESSAGE );
            return null;
        }

        ((JRXMLADataSourceConnection)irConn).setCube( 
                ("" + this.jComboBoxXMLACube.getSelectedItem()).trim());

        ((JRXMLADataSourceConnection)irConn).setUsername( this.jTextFieldUsername1.getText().trim() );
        if (jCheckBoxSavePassword1.isSelected())
            ((JRXMLADataSourceConnection)irConn).setPassword( new String(this.jTextFieldPassword1.getPassword()) );
        else
            ((JRXMLADataSourceConnection)irConn).setPassword("");
        ((JRXMLADataSourceConnection)irConn).setSavePassword( jCheckBoxSavePassword1.isSelected() );
            
        iReportConnection = irConn;
        return iReportConnection;
    }
    
    /*
    public void applyI18n(){
                // Start autogenerated code ----------------------
                jLabelAttention.setText( "<html>" + I18n.getString("connectionDialog.textArea1","ATTENTION! Passwords are stored in clear text. If you dont specify a password now, iReport will ask you for one only when required and will not save it."));
                jLabelXMLAUrl.setText(I18n.getString("connectionDialog.labelXMLAUrl","Url of XML/A server"));
                jButtonGetXMLAMetadata.setText(I18n.getString("connectionDialog.buttonGetXMLAMetadata","Get metadata"));
                jLabelXMLADatasource.setText(I18n.getString("connectionDialog.labelXMLADatasource","Datasource"));
                jLabelXMLACatalog.setText(I18n.getString("connectionDialog.labelXMLACatalog","Catalog"));
                jLabelXMLACube.setText(I18n.getString("connectionDialog.labelXMLACube","Cube"));
    }
     */

    
    
    
    private void jButtonGetXMLAMetadataActionPerformed(java.awt.event.ActionEvent evt) {                                                       
        
        
        final String urlstr = this.jTextFieldXMLAUrl.getText().trim();
        
        
        Authenticator.setDefault(new CustomHTTPAuthenticator( jTextFieldUsername1.getText(), new String(jTextFieldPassword1.getPassword()) ));

        Thread t = new Thread(new Runnable() {

            public void run() {
                
                
                try {
                    SwingUtilities.invokeLater(new Runnable() {

                        public void run() {
                            getBusyLabel().setBusy(true);
                            jButtonGetXMLAMetadata.setEnabled(false);
                        }
                    });
                
                
                    rex.metadata.ServerMetadata smd = new rex.metadata.ServerMetadata(urlstr, XMLADataSourceConnectionEditor.this);

                    if (smd.isValidUrl() == false) {

                        SwingUtilities.invokeLater(new Runnable() {

                            public void run() {
                                JOptionPane.showMessageDialog(XMLADataSourceConnectionEditor.this,
                               // I18n.getString("messages.connectionDialog.xmla.invalidUrl",
                                I18n.getString("XMLADataSourceConnectionEditor.Message.NoXMLA"),"",JOptionPane.INFORMATION_MESSAGE);

                            }
                        });
                        return;
                    }

                    try {
                        cachedDataSources = smd.discoverDataSources();


                        SwingUtilities.invokeLater(new Runnable() {

                            public void run() {
                               refreshDataSources();

                            }
                        });

                    } catch (Exception ex)
                    {
                        SwingUtilities.invokeLater(new Runnable() {

                            public void run() {
                                JOptionPane.showMessageDialog(XMLADataSourceConnectionEditor.this,
                               // I18n.getString("messages.connectionDialog.xmla.invalidUrl",
                                I18n.getString("XMLADataSourceConnectionEditor.Message.NoXMLA"),"",JOptionPane.INFORMATION_MESSAGE);

                            }
                        });
                    }
                }
                finally
                {
                    SwingUtilities.invokeLater(new Runnable() {

                        public void run() {
                            getBusyLabel().setBusy(false);
                            jButtonGetXMLAMetadata.setEnabled(true);
                        }
                    });
                }
            }
        });
        
        t.start();
        
    }
    
    
    public void refreshDataSources()
    {
        init = true;
        this.jComboBoxXMLADatasource.removeAllItems();
        this.jComboBoxXMLACatalog.removeAllItems();
        this.jComboBoxXMLACube.removeAllItems(); 
        
        
        
        if (cachedDataSources == null || cachedDataSources.length == 0) {
            JOptionPane.showMessageDialog(this,
                    I18n.getString("XMLADataSourceConnectionEditor.Message.NoDatasources"),"",JOptionPane.INFORMATION_MESSAGE);
            return;
        }
        
        
        for (int i=0;i<cachedDataSources.length;i++){
            this.jComboBoxXMLADatasource.addItem(cachedDataSources[i].getDataSourceInfo());
        }
        
        init = false;
        
        if (jComboBoxXMLADatasource.getItemCount() > 0)
        {
            jComboBoxXMLADatasource.setSelectedIndex(0);
        }
    }
 
    public JXBusyLabel getBusyLabel()
    {
        return (JXBusyLabel)jLabelBusy;
    }
   
}
