/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.repo;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReportContext;
import net.sf.jasperreports.repo.InputStreamResource;
import net.sf.jasperreports.repo.JasperDesignCache;
import net.sf.jasperreports.repo.ReportResource;
import net.sf.jasperreports.repo.RepositoryService;
import net.sf.jasperreports.repo.Resource;

public final class RepositoryUtil {
    private AtomicReference<List<RepositoryService>> repositoryServices = new AtomicReference();
    private JasperReportsContext jasperReportsContext;

    private RepositoryUtil(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    public static RepositoryUtil getInstance(JasperReportsContext jasperReportsContext) {
        return new RepositoryUtil(jasperReportsContext);
    }

    private List<RepositoryService> getServices() {
        List<RepositoryService> cachedServices = this.repositoryServices.get();
        if (cachedServices != null) {
            return cachedServices;
        }
        List<RepositoryService> services = this.jasperReportsContext.getExtensions(RepositoryService.class);
        if (this.repositoryServices.compareAndSet(null, services)) {
            return services;
        }
        return this.repositoryServices.get();
    }

    public JasperReport getReport(ReportContext reportContext, String location) throws JRException {
        JasperReport jasperReport = null;
        JasperDesignCache cache = JasperDesignCache.getInstance(this.jasperReportsContext, reportContext);
        if (cache != null) {
            jasperReport = cache.getJasperReport(location);
        }
        if (jasperReport == null) {
            ReportResource resource = this.getResourceFromLocation(location, ReportResource.class);
            if (resource == null) {
                throw new JRException("Report not found at : " + location);
            }
            jasperReport = resource.getReport();
            if (cache != null) {
                cache.set(location, jasperReport);
            }
        }
        return jasperReport;
    }

    public <K extends Resource> K getResourceFromLocation(String location, Class<K> resourceType) throws JRException {
        K resource = null;
        List<RepositoryService> services = this.getServices();
        if (services != null) {
            for (RepositoryService service : services) {
                resource = service.getResource(location, resourceType);
                if (resource != null) break;
            }
        }
        if (resource == null) {
            throw new JRException("Resource not found at : " + location);
        }
        return resource;
    }

    public InputStream getInputStreamFromLocation(String location) throws JRException {
        InputStream is = this.findInputStream(location);
        if (is == null) {
            throw new JRException("Input stream not found at : " + location);
        }
        return is;
    }

    private InputStream findInputStream(String location) throws JRException {
        InputStreamResource inputStreamResource = null;
        List<RepositoryService> services = this.getServices();
        if (services != null) {
            for (RepositoryService service : services) {
                inputStreamResource = service.getResource(location, InputStreamResource.class);
                if (inputStreamResource != null) break;
            }
        }
        return inputStreamResource == null ? null : inputStreamResource.getInputStream();
    }

    public byte[] getBytesFromLocation(String location) throws JRException {
        InputStream is = this.findInputStream(location);
        if (is == null) {
            throw new JRException("Byte data not found at : " + location);
        }
        ByteArrayOutputStream baos = null;
        try {
            try {
                baos = new ByteArrayOutputStream();
                byte[] bytes = new byte[10000];
                int ln = 0;
                while ((ln = is.read(bytes)) > 0) {
                    baos.write(bytes, 0, ln);
                }
                baos.flush();
            }
            catch (IOException e) {
                throw new JRException("Error loading byte data from : " + location, e);
            }
        }
        finally {
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException iOException) {}
            }
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        return baos.toByteArray();
    }
}

