/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.query;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.query.JRClauseFunction;
import net.sf.jasperreports.engine.query.JRClauseTokens;
import net.sf.jasperreports.engine.query.JRQueryClauseContext;
import net.sf.jasperreports.engine.query.ParameterTypesClauseFunction;
import net.sf.jasperreports.engine.query.ParameterTypesClauseFunctionBundle;
import net.sf.jasperreports.engine.query.TypesCandidateComparator;
import net.sf.jasperreports.engine.util.Pair;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ParameterTypeSelectorClauseFunction
implements JRClauseFunction {
    private static final Log log = LogFactory.getLog(ParameterTypeSelectorClauseFunction.class);
    private static final String CONTEXT_KEY_FUNCTION_PER_TYPES_CACHE = "net.sf.jasperreports.engine.query.ParameterTypeSelectorClauseFunction.cache";
    private final int[] parameterPositions;

    public ParameterTypeSelectorClauseFunction(int ... parameterPositions) {
        this.parameterPositions = parameterPositions;
    }

    @Override
    public void apply(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext) {
        ArrayList parameterTypes = new ArrayList(this.parameterPositions.length);
        int[] nArray = this.parameterPositions;
        int n = this.parameterPositions.length;
        int n2 = 0;
        while (n2 < n) {
            int position = nArray[n2];
            Class<?> parameterType = this.determineParameterType(clauseTokens, queryContext, position);
            parameterTypes.add(parameterType);
            ++n2;
        }
        JRClauseFunction function = this.getForParameterTypes(clauseTokens, queryContext, parameterTypes);
        if (function == null) {
            throw new JRRuntimeException("No clause function implementation found for clause " + clauseTokens.getClauseId() + " and parameter types " + parameterTypes);
        }
        function.apply(clauseTokens, queryContext);
    }

    protected Class<?> determineParameterType(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext, int parameterPosition) {
        String parameterName = clauseTokens.getToken(parameterPosition);
        if (parameterName == null) {
            throw new JRRuntimeException("Required token at position " + parameterPosition + " for query clause " + clauseTokens.getClauseId() + " not found");
        }
        JRValueParameter parameter = queryContext.getValueParameter(parameterName);
        Object parameterValue = parameter.getValue();
        Class<?> parameterType = parameterValue == null ? parameter.getValueClass() : parameterValue.getClass();
        if (log.isDebugEnabled()) {
            log.debug((Object)("query clause parameter " + parameterName + " at position " + parameterPosition + " has type " + parameterType.getName()));
        }
        return parameterType;
    }

    protected JRClauseFunction getForParameterTypes(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext, List<Class<?>> parameterTypes) {
        Object typesKey;
        Map<Object, JRClauseFunction> cache = this.getCache(queryContext);
        JRClauseFunction function = cache.get(typesKey = this.parameterTypesFunctionCacheKey(clauseTokens, queryContext, parameterTypes));
        if (function == null) {
            function = this.selectForParameterTypes(clauseTokens, queryContext, parameterTypes);
            cache.put(typesKey, function);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("found cached function " + function + " for clause " + clauseTokens.getClauseId() + " with types " + parameterTypes));
        }
        return function;
    }

    protected Map<Object, JRClauseFunction> getCache(JRQueryClauseContext queryContext) {
        ConcurrentHashMap cache = (ConcurrentHashMap)queryContext.getJasperReportsContext().getValue(CONTEXT_KEY_FUNCTION_PER_TYPES_CACHE);
        if (cache == null) {
            cache = new ConcurrentHashMap();
            queryContext.getJasperReportsContext().setValue(CONTEXT_KEY_FUNCTION_PER_TYPES_CACHE, cache);
        }
        return cache;
    }

    protected Object parameterTypesFunctionCacheKey(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext, List<Class<?>> parameterTypes) {
        int size = parameterTypes.size();
        Object typesKey = size == 1 ? parameterTypes.get(0) : (size == 2 ? new Pair(parameterTypes.get(0), parameterTypes.get(1)) : parameterTypes);
        Pair<String, String> clauseKey = new Pair<String, String>(queryContext.getCanonicalQueryLanguage(), clauseTokens.getClauseId());
        return new Pair(clauseKey, (Pair<Class<?>, Class<?>>)typesKey);
    }

    protected JRClauseFunction selectForParameterTypes(JRClauseTokens clauseTokens, JRQueryClauseContext queryContext, List<Class<?>> parameterTypes) {
        String queryLanguage = queryContext.getCanonicalQueryLanguage();
        String clauseId = clauseTokens.getClauseId();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selecting clause function " + clauseId + " for language " + queryLanguage + " and parameter types " + parameterTypes));
        }
        List<ParameterTypesClauseFunctionBundle> functionsBundles = queryContext.getJasperReportsContext().getExtensions(ParameterTypesClauseFunctionBundle.class);
        ArrayList candidateFunctions = new ArrayList();
        for (ParameterTypesClauseFunctionBundle functionsBundle : functionsBundles) {
            Collection<? extends ParameterTypesClauseFunction> functions = functionsBundle.getTypeFunctions(queryLanguage, clauseId);
            if (functions == null) continue;
            for (ParameterTypesClauseFunction parameterTypesClauseFunction : functions) {
                List<Class<?>> supportedTypes = this.findSupportedTypes(parameterTypesClauseFunction, parameterTypes);
                if (supportedTypes == null) continue;
                JRClauseFunction function = parameterTypesClauseFunction.getFunction();
                if (log.isDebugEnabled()) {
                    log.debug((Object)("found candidate function " + function + " for types " + supportedTypes));
                }
                Pair candidate = new Pair(supportedTypes, function);
                candidateFunctions.add(candidate);
            }
        }
        return this.selectFromCandidates(candidateFunctions);
    }

    protected JRClauseFunction selectFromCandidates(List<Pair<List<Class<?>>, JRClauseFunction>> candidateFunctions) {
        if (candidateFunctions.isEmpty()) {
            return null;
        }
        if (candidateFunctions.size() == 1) {
            return candidateFunctions.get(0).second();
        }
        Collections.sort(candidateFunctions, TypesCandidateComparator.INSTANCE);
        JRClauseFunction function = candidateFunctions.get(0).second();
        if (log.isDebugEnabled()) {
            log.debug((Object)("selected function " + function));
        }
        return function;
    }

    protected List<Class<?>> findSupportedTypes(ParameterTypesClauseFunction typesFunction, List<Class<?>> parameterTypes) {
        Collection<Class<?>> functionTypes = typesFunction.getSupportedTypes();
        ArrayList supportedTypes = new ArrayList(parameterTypes.size());
        for (Class<?> paramType : parameterTypes) {
            Class<?> supportedType = this.findSupportedType(functionTypes, paramType);
            if (supportedType == null) break;
            supportedTypes.add(supportedType);
        }
        if (supportedTypes.size() == parameterTypes.size()) {
            return supportedTypes;
        }
        return null;
    }

    protected Class<?> findSupportedType(Collection<Class<?>> supportedTypes, Class<?> parameterType) {
        for (Class<?> supportedType : supportedTypes) {
            if (!supportedType.isAssignableFrom(parameterType)) continue;
            return supportedType;
        }
        return null;
    }
}

