/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.IOException;
import java.io.Writer;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.Cut;
import net.sf.jasperreports.engine.export.LengthUtil;
import net.sf.jasperreports.engine.export.XlsRowLevelInfo;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxCellHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxSheetRelsHelper;
import net.sf.jasperreports.engine.export.ooxml.type.PaperSizeEnum;
import net.sf.jasperreports.engine.util.FileBufferedWriter;
import net.sf.jasperreports.export.XlsReportConfiguration;

public class XlsxSheetHelper
extends BaseHelper {
    private int rowIndex;
    private FileBufferedWriter colsWriter = new FileBufferedWriter();
    private FileBufferedWriter mergedCellsWriter = new FileBufferedWriter();
    private FileBufferedWriter hyperlinksWriter = new FileBufferedWriter();
    private XlsxSheetRelsHelper sheetRelsHelper;
    private final JRPropertiesUtil propertiesUtil;
    private final XlsReportConfiguration configuration;

    public XlsxSheetHelper(JasperReportsContext jasperReportsContext, Writer writer, XlsxSheetRelsHelper sheetRelsHelper, XlsReportConfiguration configuration) {
        super(jasperReportsContext, writer);
        this.sheetRelsHelper = sheetRelsHelper;
        this.propertiesUtil = JRPropertiesUtil.getInstance(jasperReportsContext);
        this.configuration = configuration;
    }

    public void exportHeader() {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<worksheet\n");
        this.write(" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n");
        this.write("<dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"/></sheetViews>\n");
        this.write("<sheetFormatPr/>\n");
    }

    public void exportHeader(int rowFreeze, int columnFreeze, JasperPrint jasperPrint) {
        this.exportHeader(0, rowFreeze, columnFreeze, jasperPrint);
    }

    public void exportHeader(boolean showGridlines, int scale, int rowFreeze, int columnFreeze, JasperPrint jasperPrint) {
        this.write("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        this.write("<worksheet\n");
        this.write(" xmlns=\"http://schemas.openxmlformats.org/spreadsheetml/2006/main\"\n");
        this.write(" xmlns:r=\"http://schemas.openxmlformats.org/officeDocument/2006/relationships\">\n");
        boolean noScale = scale < 10 || scale > 400;
        Integer fitWidth = this.configuration.getFitWidth();
        Integer fitHeight = this.configuration.getFitHeight();
        String fitToPage = noScale && (fitHeight != null || fitWidth != null) ? "<pageSetUpPr fitToPage=\"1\"/>" : "";
        this.write("<sheetPr><outlinePr summaryBelow=\"0\"/>" + fitToPage + "</sheetPr><dimension ref=\"A1\"/><sheetViews><sheetView workbookViewId=\"0\"");
        if (!showGridlines) {
            this.write(" showGridLines=\"0\"");
        }
        if (rowFreeze > 0 || columnFreeze > 0) {
            this.write(">\n<pane" + (columnFreeze > 0 ? " xSplit=\"" + columnFreeze + "\"" : "") + (rowFreeze > 0 ? " ySplit=\"" + rowFreeze + "\"" : ""));
            String columnName = this.propertiesUtil.getProperty(jasperPrint, "net.sf.jasperreports.export.xls.freeze.column") == null ? "A" : this.propertiesUtil.getProperty(jasperPrint, "net.sf.jasperreports.export.xls.freeze.column");
            this.write(" topLeftCell=\"" + columnName + (rowFreeze + 1) + "\"");
            String activePane = String.valueOf(rowFreeze > 0 ? "bottom" : "top") + (columnFreeze > 0 ? "Right" : "Left");
            this.write(" activePane=\"" + activePane + "\" state=\"frozen\"/>\n");
            this.write("<selection pane=\"" + activePane + "\"");
            this.write(" activeCell=\"" + columnName + (rowFreeze + 1) + "\"");
            this.write(" sqref=\"" + columnName + (rowFreeze + 1) + "\"");
            this.write("/>\n");
            this.write("</sheetView>\n</sheetViews>\n");
        } else {
            this.write("/></sheetViews>\n");
        }
        this.write("<sheetFormatPr defaultRowHeight=\"15\"/>\n");
    }

    public void exportHeader(int scale, int rowFreeze, int columnFreeze, JasperPrint jasperPrint) {
        this.exportHeader(true, scale, rowFreeze, columnFreeze, jasperPrint);
    }

    public void exportFooter(int index, JasperPrint jasperPrint, boolean isIgnorePageMargins, String autoFilter, Integer scale, Integer firstPageNumber, boolean firstPageNotSet) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        this.write("</sheetData>\n");
        if (autoFilter != null) {
            this.write("<autoFilter ref=\"" + autoFilter + "\"/>\n");
        }
        if (!this.mergedCellsWriter.isEmpty()) {
            this.write("<mergeCells>\n");
            this.mergedCellsWriter.writeData(this.writer);
            this.write("</mergeCells>\n");
        }
        if (!this.hyperlinksWriter.isEmpty()) {
            this.write("<hyperlinks>\n");
            this.hyperlinksWriter.writeData(this.writer);
            this.write("</hyperlinks>\n");
        }
        this.write("<pageMargins left=\"");
        this.write(String.valueOf(jasperPrint.getLeftMargin() == null ? (double)0.7f : LengthUtil.inchNoRound(isIgnorePageMargins ? 0 : jasperPrint.getLeftMargin())));
        this.write("\" right=\"");
        this.write(String.valueOf(jasperPrint.getRightMargin() == null ? (double)0.7f : LengthUtil.inchNoRound(isIgnorePageMargins ? 0 : jasperPrint.getRightMargin())));
        this.write("\" top=\"");
        this.write(String.valueOf(jasperPrint.getTopMargin() == null ? 0.75 : LengthUtil.inchNoRound(isIgnorePageMargins ? 0 : jasperPrint.getTopMargin())));
        this.write("\" bottom=\"");
        this.write(String.valueOf(jasperPrint.getBottomMargin() == null ? 0.75 : LengthUtil.inchNoRound(isIgnorePageMargins ? 0 : jasperPrint.getBottomMargin())));
        this.write("\" header=\"0.0\" footer=\"0.0\"/>\n");
        this.write("<pageSetup");
        if (jasperPrint.getOrientationValue() != null) {
            this.write(" orientation=\"" + jasperPrint.getOrientationValue().getName().toLowerCase() + "\"");
        }
        if (scale != null && scale > 9 && scale < 401) {
            this.write(" scale=\"" + scale + "\"");
        } else {
            Integer fitHeight;
            Integer fitWidth = this.configuration.getFitWidth();
            if (fitWidth != null && fitWidth != 1) {
                this.write(" fitToWidth=\"" + fitWidth + "\"");
            }
            if ((fitHeight = this.configuration.getFitHeight()) != null && fitHeight != 1) {
                this.write(" fitToHeight=\"" + fitHeight + "\"");
            }
        }
        byte pSize = this.getSuitablePaperSize(jasperPrint);
        String paperSize = pSize == PaperSizeEnum.UNDEFINED.getValue() ? "" : " paperSize=\"" + pSize + "\"";
        this.write(paperSize);
        if (firstPageNumber != null && firstPageNumber > 0) {
            this.write(" firstPageNumber=\"" + firstPageNumber + "\"");
            this.write(" useFirstPageNumber=\"1\"/>\n");
        } else {
            this.write("/>\n");
        }
        if (!firstPageNotSet) {
            this.write("<headerFooter><oddFooter>Page &amp;P</oddFooter></headerFooter>\n");
        }
        this.write("<drawing r:id=\"rIdDr" + index + "\"/></worksheet>");
    }

    public void exportColumn(int colIndex, int colWidth, boolean autoFit) {
        try {
            this.colsWriter.write("<col min=\"" + (colIndex + 1) + "\" max=\"" + (colIndex + 1) + "\"" + (autoFit ? " customWidth=\"0\" bestFit=\"1\"" : " customWidth=\"1\"") + " width=\"" + 3.0f * (float)colWidth / 18.0f + "\"/>\n");
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public void exportRow(int rowHeight, Cut yCut, XlsRowLevelInfo levelInfo) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        ++this.rowIndex;
        boolean isAutoFit = yCut.hasProperty("net.sf.jasperreports.export.xls.auto.fit.row") && (Boolean)yCut.getProperty("net.sf.jasperreports.export.xls.auto.fit.row") != false;
        this.write("<row r=\"" + this.rowIndex + "\"" + (isAutoFit ? " customHeight=\"0\" bestFit=\"1\"" : " customHeight=\"1\"") + " ht=\"" + rowHeight + "\"");
        if (levelInfo.getLevelMap().size() > 0) {
            this.write(" outlineLevel=\"" + levelInfo.getLevelMap().size() + "\"");
        }
        this.write(">\n");
    }

    public void exportRow(int rowHeight) {
        if (this.rowIndex > 0) {
            this.write("</row>\n");
        } else {
            if (!this.colsWriter.isEmpty()) {
                this.write("<cols>\n");
                this.colsWriter.writeData(this.writer);
                this.write("</cols>\n");
            }
            this.write("<sheetData>\n");
        }
        ++this.rowIndex;
        this.write("<row r=\"" + this.rowIndex + "\" customHeight=\"1\" ht=\"" + rowHeight + "\">\n");
    }

    public void exportMergedCells(int row, int col, int rowSpan, int colSpan) {
        int n = rowSpan = this.configuration.isCollapseRowSpan() != false ? 1 : rowSpan;
        if (rowSpan > 1 || colSpan > 1) {
            String ref = String.valueOf(XlsxCellHelper.getColumIndexLetter(col)) + (row + 1) + ":" + XlsxCellHelper.getColumIndexLetter(col + colSpan - 1) + (row + rowSpan);
            try {
                this.mergedCellsWriter.write("<mergeCell ref=\"" + ref + "\"/>\n");
            }
            catch (IOException e) {
                throw new JRRuntimeException(e);
            }
        }
    }

    public void exportHyperlink(int row, int col, String href) {
        this.exportHyperlink(row, col, href, false);
    }

    public void exportHyperlink(int row, int col, String href, boolean isLocal) {
        String ref = String.valueOf(XlsxCellHelper.getColumIndexLetter(col)) + (row + 1);
        try {
            if (isLocal) {
                this.hyperlinksWriter.write("<hyperlink ref=\"" + ref + "\" location=\"" + href + "\"/>\n");
            } else {
                this.hyperlinksWriter.write("<hyperlink ref=\"" + ref + "\" r:id=\"rIdLnk" + this.sheetRelsHelper.getHyperlink(href) + "\"/>\n");
            }
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    private final byte getSuitablePaperSize(JasperPrint jasP) {
        if (jasP == null) {
            return -1;
        }
        long width = 0L;
        long height = 0L;
        if (jasP.getPageWidth() != 0 && jasP.getPageHeight() != 0) {
            double dWidth = (double)jasP.getPageWidth() / 72.0;
            double dHeight = (double)jasP.getPageHeight() / 72.0;
            height = Math.round(dHeight * 25.4);
            width = Math.round(dWidth * 25.4);
            int i = 3;
            while (i < 6) {
                int w = this.calculateWidthForDinAN(i);
                int h = this.calculateHeightForDinAN(i);
                if ((long)w == width && (long)h == height || (long)h == width && (long)w == height) {
                    return i == 3 ? PaperSizeEnum.A3.getValue() : (i == 4 ? PaperSizeEnum.A4.getValue() : PaperSizeEnum.A5.getValue());
                }
                ++i;
            }
            if (width == 110L && height == 220L || width == 220L && height == 110L) {
                return PaperSizeEnum.ENVELOPE_DL.getValue();
            }
            if (width == 216L && height == 279L || width == 279L && height == 216L) {
                return PaperSizeEnum.LETTER.getValue();
            }
            if (width == 216L && height == 356L || width == 356L && height == 216L) {
                return PaperSizeEnum.LEGAL.getValue();
            }
            if (width == 190L && height == 254L || width == 254L && height == 190L) {
                return PaperSizeEnum.EXECUTIVE.getValue();
            }
        }
        return PaperSizeEnum.UNDEFINED.getValue();
    }

    protected final int calculateWidthForDinAN(int n) {
        return (int)(Math.pow(2.0, -0.25 - (double)n / 2.0) * 1000.0);
    }

    protected final int calculateHeightForDinAN(int n) {
        return (int)(Math.pow(2.0, 0.25 - (double)n / 2.0) * 1000.0);
    }
}

