/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export.ooxml;

import java.io.Writer;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.export.JRExporterGridCell;
import net.sf.jasperreports.engine.export.ooxml.BaseHelper;
import net.sf.jasperreports.engine.export.ooxml.XlsxFontInfo;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.export.XlsReportConfiguration;

public class XlsxFontHelper
extends BaseHelper {
    private Map<String, Integer> fontCache = new HashMap<String, Integer>();
    private String exporterKey;
    private XlsReportConfiguration configuration;

    public XlsxFontHelper(JasperReportsContext jasperReportsContext, Writer writer, String exporterKey) {
        super(jasperReportsContext, writer);
        this.exporterKey = exporterKey;
    }

    public void setConfiguration(XlsReportConfiguration configuration) {
        this.configuration = configuration;
    }

    public int getFont(JRExporterGridCell gridCell, Locale locale) {
        XlsxFontInfo xlsxFontInfo;
        Integer fontIndex;
        FontFamily family;
        String exportFont;
        JRFont font;
        JRFont jRFont = font = gridCell.getElement() instanceof JRFont ? (JRFont)((Object)gridCell.getElement()) : null;
        if (font == null) {
            return -1;
        }
        String fontName = font.getFontName();
        FontInfo fontInfo = FontUtil.getInstance(this.jasperReportsContext).getFontInfo(fontName, locale);
        if (fontInfo != null && (exportFont = (family = fontInfo.getFontFamily()).getExportFont(this.exporterKey)) != null) {
            fontName = exportFont;
        }
        if ((fontIndex = this.fontCache.get((xlsxFontInfo = new XlsxFontInfo(gridCell, fontName, this.configuration.isFontSizeFixEnabled())).getId())) == null) {
            fontIndex = this.fontCache.size();
            this.export(xlsxFontInfo);
            this.fontCache.put(xlsxFontInfo.getId(), fontIndex);
        }
        return fontIndex;
    }

    private void export(XlsxFontInfo fontInfo) {
        this.write("<font><sz val=\"" + fontInfo.fontSize + "\"/>" + "<color rgb=\"" + fontInfo.color + "\"/>" + "<name val=\"" + fontInfo.fontName + "\"/>" + "<b val=\"" + fontInfo.isBold + "\"/>" + "<i val=\"" + fontInfo.isItalic + "\"/>" + "<u val=\"" + (fontInfo.isUnderline ? "single" : "none") + "\"/>" + "<strike val=\"" + fontInfo.isStrikeThrough + "\"/>" + "<family val=\"2\"/></font>\n");
    }
}

