/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components;

import net.sf.jasperreports.components.barbecue.StandardBarbecueComponent;
import net.sf.jasperreports.components.barcode4j.CodabarComponent;
import net.sf.jasperreports.components.barcode4j.Code128Component;
import net.sf.jasperreports.components.barcode4j.Code39Component;
import net.sf.jasperreports.components.barcode4j.DataMatrixComponent;
import net.sf.jasperreports.components.barcode4j.EAN128Component;
import net.sf.jasperreports.components.barcode4j.EAN13Component;
import net.sf.jasperreports.components.barcode4j.EAN8Component;
import net.sf.jasperreports.components.barcode4j.Interleaved2Of5Component;
import net.sf.jasperreports.components.barcode4j.PDF417Component;
import net.sf.jasperreports.components.barcode4j.POSTNETComponent;
import net.sf.jasperreports.components.barcode4j.RoyalMailCustomerComponent;
import net.sf.jasperreports.components.barcode4j.UPCAComponent;
import net.sf.jasperreports.components.barcode4j.UPCEComponent;
import net.sf.jasperreports.components.barcode4j.USPSIntelligentMailComponent;
import net.sf.jasperreports.components.iconlabel.IconLabelComponentDigester;
import net.sf.jasperreports.components.list.DesignListContents;
import net.sf.jasperreports.components.list.StandardListComponent;
import net.sf.jasperreports.components.map.Item;
import net.sf.jasperreports.components.map.ItemData;
import net.sf.jasperreports.components.map.ItemDataXmlFactory;
import net.sf.jasperreports.components.map.ItemDatasetFactory;
import net.sf.jasperreports.components.map.ItemProperty;
import net.sf.jasperreports.components.map.ItemPropertyXmlFactory;
import net.sf.jasperreports.components.map.ItemXmlFactory;
import net.sf.jasperreports.components.map.MapXmlFactory;
import net.sf.jasperreports.components.map.Marker;
import net.sf.jasperreports.components.map.MarkerDataset;
import net.sf.jasperreports.components.map.MarkerDatasetXmlFactory;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.components.map.MarkerPropertyXmlFactory;
import net.sf.jasperreports.components.map.MarkerXmlFactory;
import net.sf.jasperreports.components.sort.SortComponentDigester;
import net.sf.jasperreports.components.spiderchart.SpiderChartDigester;
import net.sf.jasperreports.components.table.DesignCell;
import net.sf.jasperreports.components.table.StandardColumn;
import net.sf.jasperreports.components.table.StandardColumnGroup;
import net.sf.jasperreports.components.table.StandardGroupCell;
import net.sf.jasperreports.components.table.StandardTableFactory;
import net.sf.jasperreports.components.table.TableReportContextXmlRule;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.component.XmlDigesterConfigurer;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.xml.JRExpressionFactory;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import net.sf.jasperreports.engine.xml.StyleContainerRule;
import net.sf.jasperreports.engine.xml.UuidPropertyRule;
import net.sf.jasperreports.engine.xml.XmlConstantPropertyRule;
import org.apache.commons.digester.Digester;
import org.apache.commons.digester.Rule;

public class ComponentsXmlDigesterConfigurer
implements XmlDigesterConfigurer {
    @Override
    public void configureDigester(Digester digester) {
        this.addListRules(digester);
        this.addBarbecueRules(digester);
        this.addBarcode4jRules(digester);
        this.addTableRules(digester);
        SpiderChartDigester.addSpiderChartRules(digester);
        this.addMapRules(digester);
        SortComponentDigester.addSortComponentRules(digester);
        IconLabelComponentDigester.addIconLabelComponentRules(digester);
    }

    protected void addListRules(Digester digester) {
        String listPattern = "*/componentElement/list";
        digester.addObjectCreate(listPattern, StandardListComponent.class);
        digester.addSetProperties(listPattern, new String[]{"printOrder"}, new String[0]);
        digester.addRule(listPattern, (Rule)new XmlConstantPropertyRule("printOrder", "printOrderValue", PrintOrderEnum.values()));
        String listContentsPattern = String.valueOf(listPattern) + "/listContents";
        digester.addObjectCreate(listContentsPattern, DesignListContents.class);
        digester.addSetProperties(listContentsPattern);
        digester.addSetNext(listContentsPattern, "setContents");
    }

    protected void addBarbecueRules(Digester digester) {
        String barcodePattern = "*/componentElement/barbecue";
        digester.addObjectCreate(barcodePattern, StandardBarbecueComponent.class);
        digester.addSetProperties(barcodePattern, new String[]{"evaluationTime", "rotation"}, new String[0]);
        digester.addRule(barcodePattern, (Rule)new XmlConstantPropertyRule("evaluationTime", "evaluationTimeValue", EvaluationTimeEnum.values()));
        digester.addRule(barcodePattern, (Rule)new XmlConstantPropertyRule("rotation", RotationEnum.values()));
        String barcodeExpressionPattern = String.valueOf(barcodePattern) + "/codeExpression";
        digester.addFactoryCreate(barcodeExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(barcodeExpressionPattern, "setText", 0);
        digester.addSetNext(barcodeExpressionPattern, "setCodeExpression", JRExpression.class.getName());
        String applicationIdentifierExpressionPattern = String.valueOf(barcodePattern) + "/applicationIdentifierExpression";
        digester.addFactoryCreate(applicationIdentifierExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(applicationIdentifierExpressionPattern, "setText", 0);
        digester.addSetNext(applicationIdentifierExpressionPattern, "setApplicationIdentifierExpression", JRExpression.class.getName());
    }

    protected void addBarcode4jRules(Digester digester) {
        this.addBaseBarcode4jRules(digester, "*/componentElement/Codabar", CodabarComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/Code128", Code128Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/EAN128", EAN128Component.class);
        this.addTemplateRules(digester, "*/componentElement/EAN128");
        this.addBaseBarcode4jRules(digester, "*/componentElement/DataMatrix", DataMatrixComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/RoyalMailCustomer", RoyalMailCustomerComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/USPSIntelligentMail", USPSIntelligentMailComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/Code39", Code39Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/Interleaved2Of5", Interleaved2Of5Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/UPCA", UPCAComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/UPCE", UPCEComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/EAN13", EAN13Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/EAN8", EAN8Component.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/POSTNET", POSTNETComponent.class);
        this.addBaseBarcode4jRules(digester, "*/componentElement/PDF417", PDF417Component.class);
    }

    protected <T> void addBaseBarcode4jRules(Digester digester, String barcodePattern, Class<T> barcodeComponentClass) {
        digester.addObjectCreate(barcodePattern, barcodeComponentClass);
        digester.addSetProperties(barcodePattern, new String[]{"evaluationTime"}, new String[0]);
        digester.addRule(barcodePattern, (Rule)new XmlConstantPropertyRule("evaluationTime", "evaluationTimeValue", EvaluationTimeEnum.values()));
        String codeExpressionPattern = String.valueOf(barcodePattern) + "/codeExpression";
        digester.addFactoryCreate(codeExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(codeExpressionPattern, "setText", 0);
        digester.addSetNext(codeExpressionPattern, "setCodeExpression", JRExpression.class.getName());
        String patternExpressionPattern = String.valueOf(barcodePattern) + "/patternExpression";
        digester.addFactoryCreate(patternExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(patternExpressionPattern, "setText", 0);
        digester.addSetNext(patternExpressionPattern, "setPatternExpression", JRExpression.class.getName());
    }

    protected void addTemplateRules(Digester digester, String barcodePattern) {
        String templateExpressionPattern = String.valueOf(barcodePattern) + "/templateExpression";
        digester.addFactoryCreate(templateExpressionPattern, JRExpressionFactory.StringExpressionFactory.class.getName());
        digester.addCallMethod(templateExpressionPattern, "setText", 0);
        digester.addSetNext(templateExpressionPattern, "setTemplateExpression", JRExpression.class.getName());
    }

    protected void addMapRules(Digester digester) {
        int one = digester.getRules().rules().size();
        String mapPattern = "*/componentElement/map";
        digester.addFactoryCreate(mapPattern, MapXmlFactory.class);
        String latitudeExpressionPattern = String.valueOf(mapPattern) + "/latitudeExpression";
        digester.addFactoryCreate(latitudeExpressionPattern, JRExpressionFactory.class.getName());
        digester.addCallMethod(latitudeExpressionPattern, "setText", 0);
        digester.addSetNext(latitudeExpressionPattern, "setLatitudeExpression", JRExpression.class.getName());
        String longitudeExpressionPattern = String.valueOf(mapPattern) + "/longitudeExpression";
        digester.addFactoryCreate(longitudeExpressionPattern, JRExpressionFactory.class.getName());
        digester.addCallMethod(longitudeExpressionPattern, "setText", 0);
        digester.addSetNext(longitudeExpressionPattern, "setLongitudeExpression", JRExpression.class.getName());
        String addressExpressionPattern = String.valueOf(mapPattern) + "/addressExpression";
        digester.addFactoryCreate(addressExpressionPattern, JRExpressionFactory.class.getName());
        digester.addCallMethod(addressExpressionPattern, "setText", 0);
        digester.addSetNext(addressExpressionPattern, "setAddressExpression", JRExpression.class.getName());
        String zoomExpressionPattern = String.valueOf(mapPattern) + "/zoomExpression";
        digester.addFactoryCreate(zoomExpressionPattern, JRExpressionFactory.class.getName());
        digester.addCallMethod(zoomExpressionPattern, "setText", 0);
        digester.addSetNext(zoomExpressionPattern, "setZoomExpression", JRExpression.class.getName());
        String languageExpressionPattern = String.valueOf(mapPattern) + "/languageExpression";
        digester.addFactoryCreate(languageExpressionPattern, JRExpressionFactory.class.getName());
        digester.addCallMethod(languageExpressionPattern, "setText", 0);
        digester.addSetNext(languageExpressionPattern, "setLanguageExpression", JRExpression.class.getName());
        String componentNamespace = digester.getRuleNamespaceURI();
        String jrNamespace = "http://jasperreports.sourceforge.net/jasperreports";
        String markerDatasetPattern = String.valueOf(mapPattern) + "/markerDataset";
        digester.addFactoryCreate(markerDatasetPattern, MarkerDatasetXmlFactory.class.getName());
        digester.addSetNext(markerDatasetPattern, "setMarkerDataset", MarkerDataset.class.getName());
        String markerPattern = String.valueOf(markerDatasetPattern) + "/marker";
        digester.addFactoryCreate(markerPattern, MarkerXmlFactory.class.getName());
        digester.addSetNext(markerPattern, "addMarker", Marker.class.getName());
        String markerPropertyPattern = String.valueOf(markerPattern) + "/markerProperty";
        digester.addFactoryCreate(markerPropertyPattern, MarkerPropertyXmlFactory.class.getName());
        digester.addSetNext(markerPropertyPattern, "addMarkerProperty", MarkerProperty.class.getName());
        digester.setRuleNamespaceURI(jrNamespace);
        String markerPropertyValueExpressionPattern = String.valueOf(markerPropertyPattern) + "/" + "valueExpression";
        digester.addFactoryCreate(markerPropertyValueExpressionPattern, JRExpressionFactory.class.getName());
        digester.addCallMethod(markerPropertyValueExpressionPattern, "setText", 0);
        digester.addSetNext(markerPropertyValueExpressionPattern, "setValueExpression", JRExpression.class.getName());
        digester.setRuleNamespaceURI(componentNamespace);
        String markerDataPattern = String.valueOf(mapPattern) + "/markerData";
        digester.addFactoryCreate(markerDataPattern, ItemDataXmlFactory.class.getName());
        digester.addSetNext(markerDataPattern, "addMarkerData", ItemData.class.getName());
        this.addItemRules(digester, String.valueOf(markerDataPattern) + "/item", jrNamespace);
        digester.setRuleNamespaceURI(jrNamespace);
        digester.addFactoryCreate(String.valueOf(markerDataPattern) + "/dataset", ItemDatasetFactory.class.getName());
        digester.addSetNext(String.valueOf(markerDataPattern) + "/dataset", "setDataset", JRElementDataset.class.getName());
        digester.setRuleNamespaceURI(componentNamespace);
        String pathStylePattern = String.valueOf(mapPattern) + "/pathStyle";
        digester.addFactoryCreate(pathStylePattern, ItemDataXmlFactory.class.getName());
        digester.addSetNext(pathStylePattern, "addPathStyle", ItemData.class.getName());
        this.addItemRules(digester, String.valueOf(pathStylePattern) + "/item", jrNamespace);
        digester.setRuleNamespaceURI(jrNamespace);
        digester.addFactoryCreate(String.valueOf(pathStylePattern) + "/dataset", ItemDatasetFactory.class.getName());
        digester.addSetNext(String.valueOf(pathStylePattern) + "/dataset", "setDataset", JRElementDataset.class.getName());
        digester.setRuleNamespaceURI(componentNamespace);
        String pathDataPattern = String.valueOf(mapPattern) + "/pathData";
        digester.addFactoryCreate(pathDataPattern, ItemDataXmlFactory.class.getName());
        digester.addSetNext(pathDataPattern, "addPathData", ItemData.class.getName());
        this.addItemRules(digester, String.valueOf(pathDataPattern) + "/item", jrNamespace);
        digester.setRuleNamespaceURI(jrNamespace);
        digester.addFactoryCreate(String.valueOf(pathDataPattern) + "/dataset", ItemDatasetFactory.class.getName());
        digester.addSetNext(String.valueOf(pathDataPattern) + "/dataset", "setDataset", JRElementDataset.class.getName());
        digester.setRuleNamespaceURI(componentNamespace);
    }

    protected void addItemRules(Digester digester, String itemPattern, String namespace) {
        digester.addFactoryCreate(itemPattern, ItemXmlFactory.class.getName());
        digester.addSetNext(itemPattern, "addItem", Item.class.getName());
        String locationItemPropertyPattern = String.valueOf(itemPattern) + "/itemProperty";
        digester.addFactoryCreate(locationItemPropertyPattern, ItemPropertyXmlFactory.class.getName());
        digester.addSetNext(locationItemPropertyPattern, "addItemProperty", ItemProperty.class.getName());
        digester.setRuleNamespaceURI(namespace);
        String locationItemPropertyValueExpressionPattern = String.valueOf(locationItemPropertyPattern) + "/" + "valueExpression";
        digester.addFactoryCreate(locationItemPropertyValueExpressionPattern, JRExpressionFactory.class.getName());
        digester.addCallMethod(locationItemPropertyValueExpressionPattern, "setText", 0);
        digester.addSetNext(locationItemPropertyValueExpressionPattern, "setValueExpression", JRExpression.class.getName());
    }

    protected void addTableRules(Digester digester) {
        String tablePattern = "*/componentElement/table";
        digester.addFactoryCreate(tablePattern, StandardTableFactory.class.getName());
        String columnPattern = "*/column";
        digester.addObjectCreate(columnPattern, StandardColumn.class);
        digester.addSetNext(columnPattern, "addColumn");
        digester.addSetProperties(columnPattern, new String[]{"uuid"}, new String[0]);
        digester.addRule(columnPattern, (Rule)new UuidPropertyRule("uuid", "UUID"));
        this.addExpressionRules(digester, String.valueOf(columnPattern) + "/printWhenExpression", JRExpressionFactory.BooleanExpressionFactory.class, "setPrintWhenExpression", true);
        this.addTableCellRules(digester, String.valueOf(columnPattern) + "/tableHeader", "setTableHeader");
        this.addTableCellRules(digester, String.valueOf(columnPattern) + "/tableFooter", "setTableFooter");
        this.addTableGroupCellRules(digester, String.valueOf(columnPattern) + "/groupHeader", "addGroupHeader");
        this.addTableGroupCellRules(digester, String.valueOf(columnPattern) + "/groupFooter", "addGroupFooter");
        this.addTableCellRules(digester, String.valueOf(columnPattern) + "/columnHeader", "setColumnHeader");
        this.addTableCellRules(digester, String.valueOf(columnPattern) + "/columnFooter", "setColumnFooter");
        this.addTableCellRules(digester, String.valueOf(columnPattern) + "/detailCell", "setDetailCell");
        String columnGroupPattern = "*/columnGroup";
        digester.addObjectCreate(columnGroupPattern, StandardColumnGroup.class);
        digester.addSetNext(columnGroupPattern, "addColumn");
        digester.addSetProperties(columnGroupPattern, new String[]{"uuid"}, new String[0]);
        digester.addRule(columnGroupPattern, (Rule)new UuidPropertyRule("uuid", "UUID"));
        this.addExpressionRules(digester, String.valueOf(columnGroupPattern) + "/printWhenExpression", JRExpressionFactory.BooleanExpressionFactory.class, "setPrintWhenExpression", true);
        this.addTableCellRules(digester, String.valueOf(columnGroupPattern) + "/tableHeader", "setTableHeader");
        this.addTableCellRules(digester, String.valueOf(columnGroupPattern) + "/tableFooter", "setTableFooter");
        this.addTableGroupCellRules(digester, String.valueOf(columnGroupPattern) + "/groupHeader", "addGroupHeader");
        this.addTableGroupCellRules(digester, String.valueOf(columnGroupPattern) + "/groupFooter", "addGroupFooter");
        this.addTableCellRules(digester, String.valueOf(columnGroupPattern) + "/columnHeader", "setColumnHeader");
        this.addTableCellRules(digester, String.valueOf(columnGroupPattern) + "/columnFooter", "setColumnFooter");
    }

    protected void addTableCellRules(Digester digester, String pattern, String setNextMethod) {
        digester.addObjectCreate(pattern, DesignCell.class);
        digester.addSetNext(pattern, setNextMethod);
        digester.addRule(pattern, (Rule)new TableReportContextXmlRule());
        digester.addSetProperties(pattern, new String[]{"style"}, new String[0]);
        digester.addRule(pattern, (Rule)new StyleContainerRule());
    }

    protected void addTableGroupCellRules(Digester digester, String pattern, String setNextMethod) {
        digester.addObjectCreate(pattern, StandardGroupCell.class);
        digester.addSetProperties(pattern);
        this.addTableCellRules(digester, String.valueOf(pattern) + "/cell", "setCell");
        digester.addSetNext(pattern, setNextMethod);
    }

    protected <T> void addExpressionRules(Digester digester, String expressionPattern, Class<T> factoryClass, String setterMethod, boolean jrNamespace) {
        String originalNamespace = digester.getRuleNamespaceURI();
        if (jrNamespace) {
            digester.setRuleNamespaceURI(JRXmlWriter.JASPERREPORTS_NAMESPACE.getNamespaceURI());
        }
        digester.addFactoryCreate(expressionPattern, factoryClass);
        digester.addCallMethod(expressionPattern, "setText", 0);
        digester.addSetNext(expressionPattern, setterMethod, JRExpression.class.getName());
        if (jrNamespace) {
            digester.setRuleNamespaceURI(originalNamespace);
        }
    }
}

