/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.map.fill;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.components.map.Item;
import net.sf.jasperreports.components.map.ItemData;
import net.sf.jasperreports.components.map.fill.FillContextProvider;
import net.sf.jasperreports.components.map.fill.FillItem;
import net.sf.jasperreports.components.map.fill.FillItemDataset;
import net.sf.jasperreports.components.map.fill.FillMarkerItem;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.fill.JRFillExpressionEvaluator;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;

public class FillItemData {
    protected ItemData itemData;
    protected List<FillItem> itemsList;
    protected FillItemDataset fillItemDataset;
    protected FillContextProvider fillContextProvider;
    private List<Map<String, Object>> evaluatedItems = null;

    public FillItemData(FillContextProvider fillContextProvider, ItemData itemData, JRFillObjectFactory factory) {
        List<Item> srcItemList;
        factory.put(itemData, this);
        this.itemData = itemData;
        this.fillContextProvider = fillContextProvider;
        if (itemData.getDataset() != null) {
            this.fillItemDataset = new FillItemDataset(this, factory);
        }
        if ((srcItemList = itemData.getItems()) != null && !srcItemList.isEmpty()) {
            this.itemsList = new ArrayList<FillItem>();
            for (Item item : srcItemList) {
                if (item == null) continue;
                this.itemsList.add(new FillMarkerItem(item, factory));
            }
        }
    }

    public JRElementDataset getDataset() {
        return this.itemData.getDataset();
    }

    public void evaluateItems(JRFillExpressionEvaluator evaluator, byte evaluation) throws JRException {
        if (this.itemsList != null) {
            for (FillItem item : this.itemsList) {
                item.evaluateProperties(evaluator, evaluation);
            }
        }
    }

    public List<Map<String, Object>> getEvaluateItems(byte evaluation) throws JRException {
        if (this.fillItemDataset != null) {
            this.fillItemDataset.setEvaluation(evaluation);
            this.fillItemDataset.evaluateDatasetRun(evaluation);
        }
        if (this.itemsList != null) {
            if (this.getDataset() == null) {
                this.evaluateItems(this.fillContextProvider.getFillContext(), evaluation);
            }
            this.addEvaluateItems();
        }
        return this.evaluatedItems;
    }

    public void addEvaluateItems() {
        if (this.itemsList != null) {
            if (this.evaluatedItems == null || this.getDataset() == null) {
                this.evaluatedItems = new ArrayList<Map<String, Object>>();
            }
            for (FillItem item : this.itemsList) {
                this.evaluatedItems.add(item.getEvaluatedProperties());
            }
        }
    }
}

