/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.IterCalc;
import mondrian.calc.ListCalc;
import mondrian.calc.MemberIterCalc;
import mondrian.calc.MemberListCalc;
import mondrian.calc.StringCalc;
import mondrian.calc.TupleIterCalc;
import mondrian.calc.TupleListCalc;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.AbstractStringCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.Validator;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.olap.type.TypeUtil;

class GenerateFunDef
extends FunDefBase {
    static final ReflectiveMultiResolver ListResolver = new ReflectiveMultiResolver("Generate", "Generate(<Set1>, <Set2>[, ALL])", "Applies a set to each member of another set and joins the resulting sets by union.", new String[]{"fxxx", "fxxxy"}, GenerateFunDef.class);
    static final ReflectiveMultiResolver StringResolver = new ReflectiveMultiResolver("Generate", "Generate(<Set>, <String>[, <String>])", "Applies a set to a string expression and joins resulting sets by string concatenation.", new String[]{"fSxS", "fSxSS"}, GenerateFunDef.class);
    private static final String[] ReservedWords = new String[]{"ALL"};

    public GenerateFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Type getResultType(Validator validator, Exp[] args) {
        Type type = args[1].getType();
        if (type instanceof StringType) {
            return type;
        }
        Type memberType = TypeUtil.toMemberOrTupleType(type);
        return new SetType(memberType);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        boolean tupleIn;
        IterCalc iterCalc = compiler.compileIter(call.getArg(0));
        boolean bl = tupleIn = ((SetType)iterCalc.getType()).getArity() != 1;
        if (call.getArg(1).getType() instanceof StringType) {
            StringCalc stringCalc = compiler.compileString(call.getArg(1));
            StringCalc delimCalc = call.getArgCount() == 3 ? compiler.compileString(call.getArg(2)) : ConstantCalc.constantString("");
            return new GenerateStringCalcImpl(call, iterCalc, stringCalc, tupleIn, delimCalc);
        }
        ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        String literalArg = GenerateFunDef.getLiteralArg(call, 2, "", ReservedWords);
        boolean all = literalArg.equalsIgnoreCase("ALL");
        boolean tupleOut = ((SetType)call.getType()).getArity() != 1;
        return new GenerateListCalcImpl(call, iterCalc, listCalc2, tupleIn, tupleOut, all);
    }

    private static class GenerateStringCalcImpl
    extends AbstractStringCalc {
        private final MemberIterCalc memberIterCalc;
        private final TupleIterCalc tupleIterCalc;
        private final StringCalc stringCalc;
        private final boolean tuple;
        private final StringCalc sepCalc;

        public GenerateStringCalcImpl(ResolvedFunCall call, IterCalc listCalc, StringCalc stringCalc, boolean tuple, StringCalc sepCalc) {
            super(call, new Calc[]{listCalc, stringCalc});
            if (listCalc instanceof MemberIterCalc) {
                this.memberIterCalc = (MemberIterCalc)listCalc;
                this.tupleIterCalc = null;
            } else {
                this.memberIterCalc = null;
                this.tupleIterCalc = (TupleIterCalc)listCalc;
            }
            this.stringCalc = stringCalc;
            this.tuple = tuple;
            this.sepCalc = sepCalc;
        }

        public String evaluateString(Evaluator evaluator) {
            StringBuilder buf = new StringBuilder();
            int k = 0;
            if (this.tuple) {
                Iterable<Member[]> iter11 = this.tupleIterCalc.evaluateTupleIterable(evaluator);
                Evaluator evaluator2 = evaluator.push();
                for (Member[] members : iter11) {
                    evaluator2.setContext(members);
                    if (k++ > 0) {
                        String sep = this.sepCalc.evaluateString(evaluator2);
                        buf.append(sep);
                    }
                    String result2 = this.stringCalc.evaluateString(evaluator2);
                    buf.append(result2);
                }
            } else {
                Iterable<Member> iter1 = this.memberIterCalc.evaluateMemberIterable(evaluator);
                Evaluator evaluator2 = evaluator.push();
                for (Member member : iter1) {
                    evaluator2.setContext(member);
                    if (k++ > 0) {
                        String sep = this.sepCalc.evaluateString(evaluator2);
                        buf.append(sep);
                    }
                    String result2 = this.stringCalc.evaluateString(evaluator2);
                    buf.append(result2);
                }
            }
            return buf.toString();
        }

        public boolean dependsOn(Hierarchy hierarchy) {
            return GenerateStringCalcImpl.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class GenerateListCalcImpl
    extends AbstractListCalc {
        private final MemberIterCalc memberIterCalc1;
        private final TupleIterCalc tupleIterCalc1;
        private final MemberListCalc memberListCalc2;
        private final TupleListCalc tupleListCalc2;
        private final boolean tupleIn;
        private final boolean tupleOut;
        private final boolean all;

        public GenerateListCalcImpl(ResolvedFunCall call, IterCalc iterCalc, ListCalc listCalc2, boolean tupleIn, boolean tupleOut, boolean all) {
            super(call, new Calc[]{iterCalc, listCalc2});
            if (tupleIn) {
                this.memberIterCalc1 = null;
                this.tupleIterCalc1 = (TupleIterCalc)iterCalc;
            } else {
                this.memberIterCalc1 = (MemberIterCalc)iterCalc;
                this.tupleIterCalc1 = null;
            }
            if (tupleOut) {
                this.memberListCalc2 = null;
                this.tupleListCalc2 = (TupleListCalc)listCalc2;
            } else {
                this.memberListCalc2 = (MemberListCalc)listCalc2;
                this.tupleListCalc2 = null;
            }
            this.tupleIn = tupleIn;
            this.tupleOut = tupleOut;
            this.all = all;
        }

        @Override
        public List evaluateList(Evaluator evaluator) {
            evaluator = evaluator.push(false);
            Evaluator evaluator2 = evaluator.push();
            if (this.tupleIn) {
                Iterable<Member[]> iterable1 = this.tupleIterCalc1.evaluateTupleIterable(evaluator);
                if (this.tupleOut) {
                    ArrayList<Member[]> result = new ArrayList<Member[]>();
                    if (this.all) {
                        for (Member[] members : iterable1) {
                            evaluator2.setContext(members);
                            List<Member[]> result2 = this.tupleListCalc2.evaluateTupleList(evaluator2);
                            result.addAll(result2);
                        }
                    } else {
                        HashSet<List<Member>> emitted = new HashSet<List<Member>>();
                        for (Member[] members : iterable1) {
                            evaluator2.setContext(members);
                            List<Member[]> result2 = this.tupleListCalc2.evaluateTupleList(evaluator2);
                            GenerateListCalcImpl.addDistinctTuples(result, result2, emitted);
                        }
                    }
                    return result;
                }
                ArrayList<Member> result = new ArrayList<Member>();
                HashSet<Member> emitted = this.all ? null : new HashSet<Member>();
                for (Member[] members : iterable1) {
                    evaluator2.setContext(members);
                    List<Member> result2 = this.memberListCalc2.evaluateMemberList(evaluator2);
                    if (emitted != null) {
                        GenerateListCalcImpl.addDistinctMembers(result, result2, emitted);
                        continue;
                    }
                    result.addAll(result2);
                }
                return result;
            }
            Iterable<Member> iterable1 = this.memberIterCalc1.evaluateMemberIterable(evaluator);
            if (this.tupleOut) {
                ArrayList<Member[]> result = new ArrayList<Member[]>();
                if (this.all) {
                    for (Member member : iterable1) {
                        evaluator2.setContext(member);
                        List<Member[]> result2 = this.tupleListCalc2.evaluateTupleList(evaluator2);
                        result.addAll(result2);
                    }
                } else {
                    HashSet<List<Member>> emitted = new HashSet<List<Member>>();
                    for (Member member : iterable1) {
                        evaluator2.setContext(member);
                        List<Member[]> result2 = this.tupleListCalc2.evaluateTupleList(evaluator2);
                        GenerateListCalcImpl.addDistinctTuples(result, result2, emitted);
                    }
                }
                return result;
            }
            ArrayList<Member> result = new ArrayList<Member>();
            if (this.all) {
                for (Member member : iterable1) {
                    evaluator2.setContext(member);
                    List<Member> result2 = this.memberListCalc2.evaluateMemberList(evaluator2);
                    result.addAll(result2);
                }
            } else {
                HashSet<Member> emitted = new HashSet<Member>();
                for (Member member : iterable1) {
                    evaluator2.setContext(member);
                    List<Member> result2 = this.memberListCalc2.evaluateMemberList(evaluator2);
                    GenerateListCalcImpl.addDistinctMembers(result, result2, emitted);
                }
            }
            return result;
        }

        private static void addDistinctMembers(List<Member> result, List<Member> result2, Set<Member> emitted) {
            for (Member row : result2) {
                if (!emitted.add(row)) continue;
                result.add(row);
            }
        }

        private static void addDistinctTuples(List<Member[]> result, List<Member[]> result2, Set<List<Member>> emitted) {
            for (Member[] row : result2) {
                if (!emitted.add(Arrays.asList(row))) continue;
                result.add(row);
            }
        }

        @Override
        public boolean dependsOn(Hierarchy hierarchy) {
            return GenerateListCalcImpl.anyDependsButFirst(this.getCalcs(), hierarchy);
        }
    }
}

