/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.sort;

import com.jaspersoft.ireport.designer.AbstractReportObjectScene;
import com.jaspersoft.ireport.designer.widgets.JRDesignElementWidget;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import net.sf.jasperreports.components.sort.SortComponent;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.design.JRDesignComponentElement;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;

public class SortComponentWidget
extends JRDesignElementWidget {
    public SortComponentWidget(AbstractReportObjectScene scene, JRDesignElement element) {
        super(scene, element);
        if (((JRDesignComponentElement)element).getComponent() instanceof SortComponent) {
            SortComponent c = (SortComponent)((JRDesignComponentElement)element).getComponent();
            c.getEventSupport().addPropertyChangeListener((PropertyChangeListener)((Object)this));
        }
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("handlerColor") || evt.getPropertyName().equals("symbolFont") || evt.getPropertyName().equals("handlerHorizontalAlign") || evt.getPropertyName().equals("handlerVerticalAlign")) {
            this.updateBounds();
            this.repaint();
            this.revalidate(true);
            this.getSelectionWidget().updateBounds();
            this.getSelectionWidget().revalidate(true);
            this.getScene().validate();
        }
        super.propertyChange(evt);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void paintWidgetImplementation() {
        Graphics2D gr = this.getScene().getGraphics();
        Color oldColor = gr.getColor();
        Font oldFont = gr.getFont();
        Shape oldClip = gr.getClip();
        AffineTransform af = gr.getTransform();
        try {
            Rectangle r = this.getPreferredBounds();
            AffineTransform new_af = (AffineTransform)af.clone();
            AffineTransform translate = AffineTransform.getTranslateInstance(this.getBorder().getInsets().left + r.x, this.getBorder().getInsets().top + r.y);
            new_af.concatenate(translate);
            gr.setTransform(new_af);
            JRDesignElement e = this.getElement();
            Rectangle2D.Float rect = new Rectangle2D.Float(0.0f, 0.0f, e.getWidth(), e.getHeight());
            gr.clip(rect);
            if (this.getBackground() != null && e.getModeValue() == ModeEnum.OPAQUE) {
                gr.setColor(e.getBackcolor());
                gr.fillRect(0, 0, e.getWidth(), e.getHeight());
            }
            gr.setPaint(Color.lightGray);
            gr.drawRect(0, 0, e.getWidth() - 1, e.getHeight() - 1);
            SortComponent c = (SortComponent)((JRDesignComponentElement)e).getComponent();
            JRFont jrFont = c.getSymbolFont();
            if (jrFont != null) {
                Font f = new Font(jrFont.getFontName(), jrFont.isBold() ? 1 : 0, jrFont.getFontSize());
                gr.setFont(f);
            }
            Rectangle2D stringBounds = gr.getFontMetrics().getStringBounds("\u25b2", gr);
            Color col = Color.white;
            if (c.getHandlerColor() != null) {
                col = c.getHandlerColor();
            }
            gr.setColor(col);
            int x = 0;
            if (c.getHandlerHorizontalAlign() == null) {
                x = 0;
            } else if (c.getHandlerHorizontalAlign() == HorizontalAlignEnum.CENTER) {
                x = (int)(((double)e.getWidth() - stringBounds.getWidth()) / 2.0);
            } else if (c.getHandlerHorizontalAlign() == HorizontalAlignEnum.RIGHT) {
                x = (int)((double)e.getWidth() - stringBounds.getWidth());
            }
            int y = 0;
            if (c.getHandlerVerticalAlign() == null) {
                y = (int)stringBounds.getHeight();
            } else if (c.getHandlerVerticalAlign() == VerticalAlignEnum.TOP) {
                y = (int)stringBounds.getHeight();
            } else if (c.getHandlerVerticalAlign() == VerticalAlignEnum.MIDDLE) {
                y = (int)(((double)e.getHeight() + stringBounds.getHeight()) / 2.0);
            } else if (c.getHandlerVerticalAlign() == VerticalAlignEnum.BOTTOM) {
                y = e.getHeight();
            }
            gr.drawString("\u25b2", x, y);
        }
        catch (Exception ex) {
        }
        finally {
            gr.setTransform(af);
            gr.setColor(oldColor);
            gr.setFont(oldFont);
            gr.setClip(oldClip);
        }
    }
}

