/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.project.ui;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.filechooser.FileSystemView;
import org.netbeans.modules.project.ui.ExtIcon;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.NbBundle;
import org.openide.util.NbPreferences;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OpenProjectListSettings {
    private static OpenProjectListSettings INSTANCE = new OpenProjectListSettings();
    private static final String RECENT_PROJECTS_DISPLAY_NAMES = "RecentProjectsDisplayNames";
    private static final String RECENT_PROJECTS_DISPLAY_ICONS = "RecentProjectsIcons";
    private static final String LAST_OPEN_PROJECT_DIR = "lastOpenProjectDir";
    private static final String PROP_PROJECT_CATEGORY = "lastSelectedProjectCategory";
    private static final String PROP_PROJECT_TYPE = "lastSelectedProjectType";
    private static final String MAIN_PROJECT_URL = "mainProjectURL";
    private static final String OPEN_AS_MAIN = "openAsMain";
    private static final String OPEN_PROJECTS_URLS = "openProjectsURLs";
    private static final String OPEN_PROJECTS_DISPLAY_NAMES = "openProjectsDisplayNames";
    private static final String OPEN_PROJECTS_ICONS = "openProjectsIcons";
    private static final String OPEN_SUBPROJECTS = "openSubprojects";
    private static final String PROP_PROJECTS_FOLDER = "projectsFolder";
    private static final String RECENT_PROJECTS_URLS = "recentProjectsURLs";
    private static final String RECENT_TEMPLATES = "recentTemplates";
    public static final String PROP_CREATED_PROJECTS_FOLDER = "createdProjectsFolderInWizard";

    private OpenProjectListSettings() {
    }

    public static OpenProjectListSettings getInstance() {
        return INSTANCE;
    }

    protected final String putProperty(String string, String string2, boolean bl) {
        String string3 = this.getProperty(string);
        if (string2 != null) {
            this.getPreferences().put(string, string2);
        } else {
            this.getPreferences().remove(string);
        }
        return string3;
    }

    protected final String getProperty(String string) {
        return this.getPreferences().get(string, null);
    }

    protected final List<URL> getURLList(String string) {
        List<String> list = this.getStringList(string);
        ArrayList<URL> arrayList = new ArrayList<URL>();
        for (String string2 : list) {
            try {
                arrayList.add(new URL(string2));
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return arrayList;
    }

    protected final List<String> getStringList(String string) {
        Preferences preferences = this.getPreferences();
        int n = 0;
        String string2 = preferences.get(string + "." + n, null);
        ArrayList<String> arrayList = new ArrayList<String>();
        while (string2 != null) {
            arrayList.add(string2);
            string2 = preferences.get(string + "." + ++n, null);
        }
        return arrayList;
    }

    protected final List<ExtIcon> getIconList(String string) {
        Preferences preferences = this.getPreferences();
        int n = 0;
        byte[] byArray = preferences.getByteArray(string + "." + n, null);
        ArrayList<ExtIcon> arrayList = new ArrayList<ExtIcon>();
        while (byArray != null) {
            arrayList.add(byArray.length > 0 ? new ExtIcon(byArray) : new ExtIcon());
            byArray = preferences.getByteArray(string + "." + ++n, null);
        }
        return arrayList;
    }

    protected final void setIconList(String string, List<ExtIcon> list) throws IOException {
        assert (list != null);
        Preferences preferences = this.getPreferences();
        int n = 0;
        String string2 = string + "." + n;
        String string3 = preferences.get(string2, null);
        Iterator<ExtIcon> iterator = list.iterator();
        while (string3 != null || iterator.hasNext()) {
            if (iterator.hasNext()) {
                byte[] byArray = iterator.next().getBytes();
                if (byArray == null) {
                    byArray = new byte[]{};
                }
                preferences.putByteArray(string2, byArray);
            } else {
                preferences.remove(string2);
            }
            string2 = string + "." + ++n;
            string3 = preferences.get(string2, null);
        }
    }

    protected final void setStringList(String string, List<String> list) {
        assert (list != null);
        Preferences preferences = this.getPreferences();
        int n = 0;
        String string2 = string + "." + n;
        String string3 = preferences.get(string2, null);
        Iterator<String> iterator = list.iterator();
        while (string3 != null || iterator.hasNext()) {
            if (iterator.hasNext()) {
                preferences.put(string2, iterator.next());
            } else {
                preferences.remove(string2);
            }
            string2 = string + "." + ++n;
            string3 = preferences.get(string2, null);
        }
    }

    protected final void setURLList(String string, List<URL> list) {
        assert (list != null);
        ArrayList<String> arrayList = new ArrayList<String>(list.size());
        for (URL uRL : list) {
            arrayList.add(uRL.toExternalForm());
        }
        this.setStringList(string, arrayList);
    }

    protected final Preferences getPreferences() {
        return NbPreferences.forModule(OpenProjectListSettings.class);
    }

    public List<URL> getOpenProjectsURLs() {
        return this.getURLList(OPEN_PROJECTS_URLS);
    }

    public void setOpenProjectsURLs(List<URL> list) {
        this.setURLList(OPEN_PROJECTS_URLS, list);
    }

    public List<String> getOpenProjectsDisplayNames() {
        return this.getStringList(OPEN_PROJECTS_DISPLAY_NAMES);
    }

    public void setOpenProjectsDisplayNames(List<String> list) {
        this.setStringList(OPEN_PROJECTS_DISPLAY_NAMES, list);
    }

    public List<ExtIcon> getOpenProjectsIcons() {
        return this.getIconList(OPEN_PROJECTS_ICONS);
    }

    public void setOpenProjectsIcons(List<ExtIcon> list) {
        try {
            this.setIconList(OPEN_PROJECTS_ICONS, list);
        }
        catch (IOException iOException) {
            Exceptions.printStackTrace((Throwable)iOException);
        }
    }

    public boolean isOpenSubprojects() {
        return this.getPreferences().getBoolean(OPEN_SUBPROJECTS, false);
    }

    public void setOpenSubprojects(boolean bl) {
        this.getPreferences().putBoolean(OPEN_SUBPROJECTS, bl);
    }

    public boolean isOpenAsMain() {
        return this.getPreferences().getBoolean(OPEN_AS_MAIN, false);
    }

    public void setOpenAsMain(boolean bl) {
        this.getPreferences().putBoolean(OPEN_AS_MAIN, bl);
    }

    public URL getMainProjectURL() {
        String string = this.getProperty(MAIN_PROJECT_URL);
        if (string != null) {
            try {
                return new URL(string);
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
        }
        return null;
    }

    public void setMainProjectURL(URL uRL) {
        this.putProperty(MAIN_PROJECT_URL, uRL != null ? uRL.toString() : null, true);
    }

    public String getLastOpenProjectDir() {
        String string = this.getProperty(LAST_OPEN_PROJECT_DIR);
        if (string == null) {
            string = this.getProjectsFolder(false).getAbsolutePath();
        }
        return string;
    }

    public void setLastOpenProjectDir(String string) {
        this.putProperty(LAST_OPEN_PROJECT_DIR, string, true);
    }

    public List<URL> getRecentProjectsURLs() {
        return this.getURLList(RECENT_PROJECTS_URLS);
    }

    public List<String> getRecentProjectsDisplayNames() {
        return this.getStringList(RECENT_PROJECTS_DISPLAY_NAMES);
    }

    public List<ExtIcon> getRecentProjectsIcons() {
        return this.getIconList(RECENT_PROJECTS_DISPLAY_ICONS);
    }

    public void setRecentProjectsURLs(List<URL> list) {
        this.setURLList(RECENT_PROJECTS_URLS, list);
    }

    public void setRecentProjectsDisplayNames(List<String> list) {
        this.setStringList(RECENT_PROJECTS_DISPLAY_NAMES, list);
    }

    public void setRecentProjectsIcons(List<ExtIcon> list) {
        try {
            this.setIconList(RECENT_PROJECTS_DISPLAY_ICONS, list);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public File getProjectsFolder(boolean bl) {
        String string = this.getProperty(PROP_PROJECTS_FOLDER);
        if (string == null || !new File(string).exists()) {
            File file;
            String string2 = System.getProperty("netbeans.projects.dir");
            if (string2 != null && (file = new File(string2)).exists() && file.isDirectory()) {
                return FileUtil.normalizeFile((File)file);
            }
            file = FileSystemView.getFileSystemView().getDefaultDirectory();
            if (file != null && file.exists() && file.isDirectory()) {
                boolean bl2;
                String string3 = NbBundle.getMessage(OpenProjectListSettings.class, (String)"DIR_NetBeansProjects");
                File file2 = new File(file, string3);
                if (file2.exists() && file2.canWrite()) {
                    return file2;
                }
                boolean bl3 = bl2 = bl && file2.mkdir();
                if (bl2) {
                    this.getPreferences().put(PROP_CREATED_PROJECTS_FOLDER, file2.getAbsolutePath());
                    return file2;
                }
            }
            string = System.getProperty("user.home");
        }
        return FileUtil.normalizeFile((File)new File(string));
    }

    public void setProjectsFolder(File file) {
        if (file == null) {
            this.putProperty(PROP_PROJECTS_FOLDER, null, true);
        } else {
            this.putProperty(PROP_PROJECTS_FOLDER, file.getAbsolutePath(), true);
        }
    }

    public List<String> getRecentTemplates() {
        return this.getStringList(RECENT_TEMPLATES);
    }

    public void setRecentTemplates(List<String> list) {
        this.setStringList(RECENT_TEMPLATES, list);
    }

    public String getLastSelectedProjectCategory() {
        return this.getProperty(PROP_PROJECT_CATEGORY);
    }

    public void setLastSelectedProjectCategory(String string) {
        this.putProperty(PROP_PROJECT_CATEGORY, string, true);
    }

    public String getLastSelectedProjectType() {
        return this.getProperty(PROP_PROJECT_TYPE);
    }

    public void setLastSelectedProjectType(String string) {
        this.putProperty(PROP_PROJECT_TYPE, string, true);
    }
}

