/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.tools;

import com.jaspersoft.ireport.designer.tools.TimeZoneWrapper;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.TimeZone;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TimeZoneDialog
extends JDialog {
    private int dialogResult = 2;
    private String reportTimeZoneId = null;
    private JButton jButton1;
    private JButton jButton2;
    private JList jListTimeZones;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;

    public TimeZoneDialog(Dialog parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public TimeZoneDialog(Frame parent, boolean modal) {
        super(parent, modal);
        this.initAll();
    }

    public void initAll() {
        this.initComponents();
        Object[] tzids = TimeZone.getAvailableIDs();
        Arrays.sort(tzids);
        Vector<Object> v = new Vector<Object>();
        v.add(I18n.getString("TimeZoneDialog.Time.Default"));
        for (int i = 0; i < tzids.length; ++i) {
            TimeZone tz = TimeZone.getTimeZone((String)tzids[i]);
            v.add(new TimeZoneWrapper(tz));
        }
        this.jListTimeZones.setListData(v);
        this.jListTimeZones.setSelectedIndex(0);
        this.setLocationRelativeTo(null);
        KeyStroke escape = KeyStroke.getKeyStroke(27, 0, false);
        AbstractAction escapeAction = new AbstractAction(){

            public void actionPerformed(ActionEvent e) {
                TimeZoneDialog.this.jButton2ActionPerformed(e);
            }
        };
        this.getRootPane().getInputMap(2).put(escape, I18n.getString("Global.Pane.Escape"));
        this.getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);
        this.getRootPane().setDefaultButton(this.jButton1);
    }

    public int getDialogResult() {
        return this.dialogResult;
    }

    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }

    public String getReportTimeZoneId() {
        return this.reportTimeZoneId;
    }

    private void initComponents() {
        this.jPanel2 = new JPanel();
        this.jScrollPane1 = new JScrollPane();
        this.jListTimeZones = new JList();
        this.jPanel1 = new JPanel();
        this.jButton1 = new JButton();
        this.jButton2 = new JButton();
        this.setDefaultCloseOperation(2);
        this.getContentPane().setLayout(new GridBagLayout());
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), "Time Zone", 0, 0, new Font("Dialog", 0, 11)));
        this.jPanel2.setMinimumSize(new Dimension(350, 80));
        this.jPanel2.setPreferredSize(new Dimension(400, 300));
        this.jPanel2.setLayout(new GridBagLayout());
        this.jListTimeZones.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent evt) {
                TimeZoneDialog.this.jListTimeZonesValueChanged(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jListTimeZones);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.jPanel2.add((Component)this.jScrollPane1, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.ipadx = 4;
        gridBagConstraints.ipady = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new Insets(4, 4, 4, 4);
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints);
        this.jPanel1.setLayout(new GridBagLayout());
        this.jButton1.setText(I18n.getString("Global.Button.Ok"));
        this.jButton1.setEnabled(false);
        this.jButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeZoneDialog.this.jButton1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButton1, gridBagConstraints);
        this.jButton2.setText(I18n.getString("Global.Button.Cancel"));
        this.jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TimeZoneDialog.this.jButton2ActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(4, 0, 4, 4);
        this.jPanel1.add((Component)this.jButton2, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.pack();
    }

    private void jListTimeZonesValueChanged(ListSelectionEvent evt) {
        if (this.jListTimeZones.getSelectedIndex() >= 0) {
            this.jButton1.setEnabled(true);
        }
    }

    private void jButton2ActionPerformed(ActionEvent evt) {
        this.setDialogResult(2);
        this.setVisible(false);
        this.dispose();
    }

    private void jButton1ActionPerformed(ActionEvent evt) {
        this.reportTimeZoneId = this.jListTimeZones.getSelectedIndex() <= 0 ? null : ((TimeZoneWrapper)this.jListTimeZones.getSelectedValue()).getTimeZone().getID();
        this.setDialogResult(0);
        this.setVisible(false);
        this.dispose();
    }

    public void setReportTimeZoneId(String reportTimeZoneId) {
        this.reportTimeZoneId = reportTimeZoneId;
        for (int i = 1; i < this.jListTimeZones.getModel().getSize(); ++i) {
            TimeZoneWrapper tzw = (TimeZoneWrapper)this.jListTimeZones.getModel().getElementAt(i);
            if (!tzw.getTimeZone().getID().equals(reportTimeZoneId)) continue;
            this.jListTimeZones.setSelectedIndex(i);
            this.jListTimeZones.ensureIndexIsVisible(i);
            return;
        }
        if (this.jListTimeZones.getModel().getSize() > 0) {
            this.jListTimeZones.setSelectedIndex(0);
        }
    }
}

