/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer;

import com.jaspersoft.ireport.JrxmlDataObject;
import com.jaspersoft.ireport.designer.GenericCloseOperationHandler;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.JrxmlPreviewView;
import com.jaspersoft.ireport.designer.JrxmlTextView;
import com.jaspersoft.ireport.designer.JrxmlVisualView;
import com.jaspersoft.ireport.designer.ReportObjectScene;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriterHelper;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.logging.Logger;
import javax.swing.JOptionPane;
import javax.swing.text.BadLocationException;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.core.spi.multiview.CloseOperationHandler;
import org.netbeans.core.spi.multiview.MultiViewDescription;
import org.netbeans.core.spi.multiview.MultiViewFactory;
import org.openide.cookies.EditCookie;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.OpenCookie;
import org.openide.cookies.SaveCookie;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.SaveAsCapable;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.DataEditorSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.Task;
import org.openide.util.lookup.AbstractLookup;
import org.openide.util.lookup.InstanceContent;

public class JrxmlEditorSupport
extends DataEditorSupport
implements OpenCookie,
EditorCookie,
EditCookie,
SaveAsCapable {
    private static Logger LOG = Logger.getLogger(JrxmlEditorSupport.class.getName());
    private InstanceContent specialNodeLookupIC = null;
    private Lookup specialNodeLookup = null;
    private final SaveCookie saveCookie = new SaveCookie(){

        public void save() throws IOException {
            JrxmlEditorSupport.this.saveDocument();
        }
    };
    private MultiViewDescription[] descriptions = null;
    private JasperDesign currentModel = null;

    protected Task reloadDocument() {
        ((JrxmlVisualView)this.getDescriptions()[0]).refreshModel();
        return super.reloadDocument();
    }

    public MultiViewDescription[] getDescriptions() {
        if (this.descriptions == null) {
            JrxmlVisualView visualview = new JrxmlVisualView(this);
            this.descriptions = new MultiViewDescription[]{visualview, new JrxmlTextView(this), new JrxmlPreviewView(this, visualview)};
        }
        return this.descriptions;
    }

    private JrxmlEditorSupport(JrxmlDataObject obj) {
        super((DataObject)obj, (CloneableEditorSupport.Env)new JrxmlEnv(obj));
        this.specialNodeLookupIC = new InstanceContent();
        this.specialNodeLookup = new AbstractLookup((AbstractLookup.Content)this.specialNodeLookupIC);
    }

    public static JrxmlEditorSupport create(JrxmlDataObject obj) {
        JrxmlEditorSupport ed = new JrxmlEditorSupport(obj);
        ed.setMIMEType("text/xml");
        return ed;
    }

    protected CloneableEditorSupport.Pane createPane() {
        return (CloneableEditorSupport.Pane)MultiViewFactory.createCloneableMultiView((MultiViewDescription[])this.getDescriptions(), (MultiViewDescription)this.getDescriptions()[0], (CloseOperationHandler)new GenericCloseOperationHandler(this));
    }

    public boolean notifyModified() {
        boolean retValue = super.notifyModified();
        if (retValue) {
            JrxmlDataObject obj = (JrxmlDataObject)this.getDataObject();
            if (obj.getCookie(SaveCookie.class) == null) {
                obj.getIc().add((Object)this.saveCookie);
                this.specialNodeLookupIC.add((Object)this.saveCookie);
                obj.setModified(true);
            }
            ((JrxmlPreviewView)this.getDescriptions()[2]).setNeedRefresh(true);
        }
        return retValue;
    }

    public void notifyUnmodified() {
        super.notifyUnmodified();
        JrxmlDataObject obj = (JrxmlDataObject)this.getDataObject();
        SaveCookie cookie = obj.getCookie(SaveCookie.class);
        if (cookie != null && cookie.equals(this.saveCookie)) {
            obj.getIc().remove((Object)this.saveCookie);
            this.specialNodeLookupIC.remove((Object)this.saveCookie);
            obj.setModified(false);
        }
    }

    public void saveAs(FileObject folder, String fileName) throws IOException {
        if (this.getCurrentModel() != null) {
            JasperDesign jd = this.getCurrentModel();
            String content = null;
            try {
                String compatibility = IReportManager.getPreferences().get("compatibility", "");
                content = compatibility.length() == 0 ? JRXmlWriter.writeReport((JRReport)jd, (String)"UTF-8") : JRXmlWriterHelper.writeReport((JRReport)jd, "UTF-8", compatibility);
            }
            catch (Exception ex) {
                content = null;
            }
            if (content != null) {
                try {
                    this.getDocument().remove(0, this.getDocument().getLength());
                    this.getDocument().insertString(0, content, null);
                }
                catch (BadLocationException ex) {
                    // empty catch block
                }
            }
        }
        super.saveAs(folder, fileName);
    }

    public DataEditorSupport.Env getEnv() {
        return (DataEditorSupport.Env)this.env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void saveDocument() throws IOException {
        if (this.getCurrentModel() != null) {
            JasperDesign jd = this.getCurrentModel();
            if (this.getDescriptions()[0] != null && ((JrxmlVisualView)this.getDescriptions()[0]).getModel() != null) {
                ReportObjectScene scene = ((JrxmlVisualView)this.getDescriptions()[0]).getReportDesignerPanel().getScene();
                double zoomFactor = scene.getZoomFactor();
                int x = scene.getView().getVisibleRect().x;
                int y = scene.getView().getVisibleRect().y;
                if (IReportManager.getPreferences().getBoolean("save_zoom_and_location", true)) {
                    jd.setProperty("ireport.zoom", "" + zoomFactor);
                    jd.setProperty("ireport.x", "" + x);
                    jd.setProperty("ireport.y", "" + y);
                }
            }
            String content = null;
            try {
                String compatibility = IReportManager.getPreferences().get("compatibility", "");
                content = compatibility.length() == 0 ? JRXmlWriterHelper.writeReport((JRReport)jd, "UTF-8") : JRXmlWriterHelper.writeReport((JRReport)jd, "UTF-8", compatibility);
            }
            catch (Exception ex) {
                Mutex.EVENT.readAccess(new Runnable(){

                    public void run() {
                        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Error saving the JRXML: " + ex.getMessage() + "\nSee the log file for more details.", "Error saving", 0);
                    }
                });
                ex.printStackTrace();
                return;
            }
            if (content != null) {
                final String theContent = content;
                Mutex.EVENT.writeAccess(new Runnable(){

                    public void run() {
                        try {
                            JrxmlEditorSupport.this.getDocument().remove(0, JrxmlEditorSupport.this.getDocument().getLength());
                            JrxmlEditorSupport.this.getDocument().insertString(0, theContent, null);
                            ((JrxmlVisualView)JrxmlEditorSupport.this.getDescriptions()[0]).setNeedModelRefresh(false);
                        }
                        catch (BadLocationException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                    }
                });
            }
        }
        Charset cs = FileEncodingQuery.getDefaultEncoding();
        String fileEncoding = System.getProperty("file.encoding", "UTF-8");
        try {
            FileEncodingQuery.setDefaultEncoding((Charset)Charset.forName("UTF-8"));
            System.setProperty("file.encoding", "UTF-8");
        }
        catch (Exception ex) {
            System.out.println("UTF-8 encoding not supported!");
            System.out.flush();
        }
        try {
            this.getDataObject().getPrimaryFile().setAttribute("editor", (Object)cs);
            super.saveDocument();
        }
        finally {
            FileEncodingQuery.setDefaultEncoding((Charset)cs);
            System.setProperty("file.encoding", fileEncoding);
        }
    }

    public Lookup getSpecialNodeLookup() {
        return this.specialNodeLookup;
    }

    public void setSpecialNodeLookup(Lookup specialNodeLookup) {
        this.specialNodeLookup = specialNodeLookup;
    }

    public JasperDesign getCurrentModel() {
        return this.currentModel;
    }

    public void setCurrentModel(JasperDesign currentModel) {
        if (this.currentModel != null) {
            ((JrxmlDataObject)this.getDataObject()).getIc().remove((Object)this.currentModel);
        }
        this.currentModel = currentModel;
        if (this.currentModel != null) {
            ((JrxmlDataObject)this.getDataObject()).getIc().add((Object)this.currentModel);
        }
    }

    public static final class JrxmlEnv
    extends DataEditorSupport.Env {
        public JrxmlEnv(JrxmlDataObject obj) {
            super((DataObject)obj);
        }

        protected FileObject getFile() {
            return super.getDataObject().getPrimaryFile();
        }

        protected FileLock takeLock() throws IOException {
            return ((JrxmlDataObject)super.getDataObject()).getPrimaryEntry().takeLock();
        }
    }
}

