/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import org.apache.hadoop.hive.ql.exec.Description;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDFBaseCompare;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspectorUtils;

@Description(name="=", value="a _FUNC_ b - Returns TRUE if a equals b and false otherwise")
public class GenericUDFOPEqual
extends GenericUDFBaseCompare {
    public GenericUDFOPEqual() {
        this.opName = "EQUAL";
        this.opDisplayName = "=";
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object o0 = arguments[0].get();
        if (o0 == null) {
            return null;
        }
        Object o1 = arguments[1].get();
        if (o1 == null) {
            return null;
        }
        switch (this.compareType) {
            case COMPARE_TEXT: {
                this.result.set(this.soi0.getPrimitiveWritableObject(o0).equals((Object)this.soi1.getPrimitiveWritableObject(o1)));
                break;
            }
            case COMPARE_INT: {
                this.result.set(this.ioi0.get(o0) == this.ioi1.get(o1));
                break;
            }
            case COMPARE_LONG: {
                this.result.set(this.loi0.get(o0) == this.loi1.get(o1));
                break;
            }
            case COMPARE_BYTE: {
                this.result.set(this.byoi0.get(o0) == this.byoi1.get(o1));
                break;
            }
            case COMPARE_BOOL: {
                this.result.set(this.boi0.get(o0) == this.boi1.get(o1));
                break;
            }
            case COMPARE_STRING: {
                this.result.set(this.soi0.getPrimitiveJavaObject(o0).equals(this.soi1.getPrimitiveJavaObject(o1)));
                break;
            }
            case SAME_TYPE: {
                this.result.set(ObjectInspectorUtils.compare(o0, this.argumentOIs[0], o1, this.argumentOIs[1]) == 0);
                break;
            }
            default: {
                Object converted_o0 = this.converter0.convert(o0);
                if (converted_o0 == null) {
                    return null;
                }
                Object converted_o1 = this.converter1.convert(o1);
                if (converted_o1 == null) {
                    return null;
                }
                this.result.set(ObjectInspectorUtils.compare(converted_o0, this.compareOI, converted_o1, this.compareOI) == 0);
            }
        }
        return this.result;
    }
}

