/*
 * Copyright (C) 2005 - 2010 JasperSoft Corporation.  All rights reserved. 
 * http://www.jaspersoft.com.
 *
 * Unless you have purchased a commercial license agreement from JasperSoft,
 * the following license terms apply:
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as published by
 * the Free Software Foundation.
 *
 * This program is distributed WITHOUT ANY WARRANTY; and without the
 * implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, see http://www.gnu.org/licenses/gpl.txt
 * or write to:
 *
 * Free Software Foundation, Inc.,
 * 59 Temple Place - Suite 330,
 * Boston, MA  USA  02111-1307
 *
 *
 *
 *
 * StandardFusionPropertyDialog.java
 * 
 *
 */

package com.jaspersoft.ireport.components.map;



import com.jaspersoft.ireport.designer.editor.ExpObjectCellRenderer;
import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import net.sf.jasperreports.components.map.MarkerProperty;
import net.sf.jasperreports.components.map.StandardMarkerProperty;
import net.sf.jasperreports.engine.design.JRDesignExpression;

/**
 *
 * @author  Administrator
 */
public class StandardMarkerDialog extends javax.swing.JDialog {
    /** Creates new form JRParameterDialog */
    StandardMarkerProperty tmpProperty = null;
    private String oldName = null;
    private List<String>  currentPropertyNames = null;

    public static final String[] MARKER_PROPERTIES = new String[] {
                    "latitude",
                    "longitude",
                  };

   

    public StandardMarkerDialog(Dialog parent, List<MarkerProperty> currentProperties)
    {
         super(parent);
         initAll(currentProperties);
    }

    /** Creates new form ReportQueryFrame */
    public StandardMarkerDialog(Frame parent, List<MarkerProperty> currentProperties)
    {
         super(parent);
         initAll(currentProperties);
    }

    


    public void initAll(List<MarkerProperty>  currentProperties) {
        
        setModal(true);
        initComponents();
        
        this.currentPropertyNames = new ArrayList<String>();
        
        // Store all the names....
        for (MarkerProperty p : currentProperties)
            
        {
            currentPropertyNames.add(p.getName());
        }
        
       
        
        
        //applyI18n();
        this.jRTextExpressionValueExpression.setText("");   

        jComboBox1.setModel(new DefaultComboBoxModel());
        
        
        jComboBox1.setModel(new DefaultComboBoxModel(MARKER_PROPERTIES));
        
        jComboBox1.setRenderer( new ExpObjectCellRenderer() );

//        jComboBox2.removeAllItems();
//        jComboBox2.addItem("java.lang.String");
//        jComboBox2.addItem("java.lang.Boolean");
//        jComboBox2.addItem("java.awt.Color");
//        jComboBox2.addItem("java.lang.Integer");
//        jComboBox2.addItem("java.lang.Character");
//        jComboBox2.setSelectedIndex(0);

        // we have to force the context of the parameter.
        setLocationRelativeTo(null);
        
        javax.swing.KeyStroke escape =  javax.swing.KeyStroke.getKeyStroke(java.awt.event.KeyEvent.VK_ESCAPE, 0, false);
        javax.swing.Action escapeAction = new javax.swing.AbstractAction() {
            public void actionPerformed(java.awt.event.ActionEvent e) {
                jButtonCancelActionPerformed(e);
            }
        };
       
        getRootPane().getInputMap(javax.swing.JComponent.WHEN_IN_FOCUSED_WINDOW).put(escape, I18n.getString("Global.Pane.Escape"));
        getRootPane().getActionMap().put(I18n.getString("Global.Pane.Escape"), escapeAction);



        //to make the default button ...
        this.getRootPane().setDefaultButton(this.jButtonOK);
    }
    
    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {
        java.awt.GridBagConstraints gridBagConstraints;

        jScrollPaneValue = new javax.swing.JScrollPane();
        jTextArea1 = new javax.swing.JTextArea();
        jPanel1 = new javax.swing.JPanel();
        jButtonOK = new javax.swing.JButton();
        jButtonCancel = new javax.swing.JButton();
        jPanel2 = new javax.swing.JPanel();
        jLabel1 = new javax.swing.JLabel();
        jComboBox1 = new javax.swing.JComboBox();
        jCheckBox1 = new javax.swing.JCheckBox();
        jLabelValue = new javax.swing.JLabel();
        jPanelValue = new javax.swing.JPanel();
        jRTextExpressionValueExpression = new com.jaspersoft.ireport.designer.editor.ExpressionEditorArea();
        jSeparator1 = new javax.swing.JSeparator();

        jTextArea1.setColumns(20);
        jTextArea1.setRows(5);
        jScrollPaneValue.setViewportView(jTextArea1);

        setTitle("Add/modify property");
        setModal(true);
        addWindowListener(new java.awt.event.WindowAdapter() {
            public void windowClosing(java.awt.event.WindowEvent evt) {
                closeDialog(evt);
            }
        });

        jPanel1.setLayout(new java.awt.FlowLayout(java.awt.FlowLayout.RIGHT));

        jButtonOK.setMnemonic('o');
        jButtonOK.setText("OK");
        jButtonOK.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonOKActionPerformed(evt);
            }
        });
        jPanel1.add(jButtonOK);

        jButtonCancel.setMnemonic('c');
        jButtonCancel.setText("Cancel");
        jButtonCancel.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jButtonCancelActionPerformed(evt);
            }
        });
        jPanel1.add(jButtonCancel);

        getContentPane().add(jPanel1, java.awt.BorderLayout.SOUTH);

        jPanel2.setPreferredSize(new java.awt.Dimension(350, 250));
        jPanel2.setLayout(new java.awt.GridBagLayout());

        jLabel1.setText("Property Name");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 0, 3);
        jPanel2.add(jLabel1, gridBagConstraints);

        jComboBox1.setEditable(true);
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 0, 4);
        jPanel2.add(jComboBox1, gridBagConstraints);

        jCheckBox1.setSelected(true);
        jCheckBox1.setText("Use an expression");
        jCheckBox1.addActionListener(new java.awt.event.ActionListener() {
            public void actionPerformed(java.awt.event.ActionEvent evt) {
                jCheckBox1ActionPerformed(evt);
            }
        });
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        jPanel2.add(jCheckBox1, gridBagConstraints);

        jLabelValue.setText("Value / Expression");
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.anchor = java.awt.GridBagConstraints.NORTHWEST;
        gridBagConstraints.insets = new java.awt.Insets(3, 3, 3, 3);
        jPanel2.add(jLabelValue, gridBagConstraints);

        jPanelValue.setLayout(new java.awt.BorderLayout());

        jRTextExpressionValueExpression.setPreferredSize(new java.awt.Dimension(300, 80));
        jPanelValue.add(jRTextExpressionValueExpression, java.awt.BorderLayout.CENTER);

        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.BOTH;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.insets = new java.awt.Insets(0, 4, 4, 4);
        jPanel2.add(jPanelValue, gridBagConstraints);

        jSeparator1.setMinimumSize(new java.awt.Dimension(2, 2));
        jSeparator1.setPreferredSize(new java.awt.Dimension(2, 2));
        gridBagConstraints = new java.awt.GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = java.awt.GridBagConstraints.HORIZONTAL;
        gridBagConstraints.insets = new java.awt.Insets(4, 0, 4, 0);
        jPanel2.add(jSeparator1, gridBagConstraints);

        getContentPane().add(jPanel2, java.awt.BorderLayout.CENTER);

        setBounds(0, 0, 595, 494);
    }// </editor-fold>//GEN-END:initComponents

    private void jButtonCancelActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonCancelActionPerformed
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CANCEL_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonCancelActionPerformed

    private void jButtonOKActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jButtonOKActionPerformed
        
        String propretyName = jComboBox1.getSelectedItem() + "";
        if (propretyName == null || propretyName.trim().length() == 0)
        {
            javax.swing.JOptionPane.showMessageDialog(this,
                    "Invalid Property",
                    "Please specify a valid property name",
                    javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        if (oldName != null && 
            !oldName.equals(propretyName) &&
            currentPropertyNames != null &&
            currentPropertyNames.contains(propretyName))
        {
            javax.swing.JOptionPane.showMessageDialog(this,
                    "Duplicated Property",
                    "A property with this name already exists",
                    javax.swing.JOptionPane.WARNING_MESSAGE );
            return;
        }
        
        tmpProperty = new StandardMarkerProperty();

        tmpProperty.setName(propretyName);
        
        
        if (jCheckBox1.isSelected())
        {
            JRDesignExpression exp = new JRDesignExpression();
            exp.setText(this.jRTextExpressionValueExpression.getText());
            tmpProperty.setValueExpression(exp);
        }
        else
        {
            tmpProperty.setValue( jTextArea1.getText());
        }
            
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.OK_OPTION);
        dispose();
    }//GEN-LAST:event_jButtonOKActionPerformed
    
    /** Closes the dialog */
    private void closeDialog(java.awt.event.WindowEvent evt) {//GEN-FIRST:event_closeDialog
        setVisible(false);
        this.setDialogResult( javax.swing.JOptionPane.CLOSED_OPTION);
        dispose();
    }//GEN-LAST:event_closeDialog

    private void jCheckBox1ActionPerformed(java.awt.event.ActionEvent evt) {//GEN-FIRST:event_jCheckBox1ActionPerformed
        
        
        jPanelValue.removeAll();
        if (!jCheckBox1.isSelected())
        {
            jPanelValue.add(jScrollPaneValue, BorderLayout.CENTER);
        }
        else
        {
            jPanelValue.add(jRTextExpressionValueExpression, BorderLayout.CENTER);
        }
        jPanelValue.updateUI();
        
    }//GEN-LAST:event_jCheckBox1ActionPerformed
    
    /** Getter for property tmpParameter.
     * @return Value of property tmpParameter.
     *
     */
    public StandardMarkerProperty getProperty() {
        
        return tmpProperty;
    }    
    
    /** Setter for property tmpParameter.
     * @param tmpParameter New value of property tmpParameter.
     *
     */
    public void setProperty(StandardMarkerProperty tmpProperty) {
        
        jComboBox1.setSelectedItem(tmpProperty.getName());
//        if (tmpProperty.getValueExpression() != null &&
//            tmpProperty.getValueExpression().getValueClassName() != null)
//        {
//            jComboBox2.setSelectedItem(tmpProperty.getValueExpression().getValueClassName());
//        }
//        else
//        {
//            jComboBox2.setSelectedItem("java.lang.String");
//        }
        //this.jTextFieldName.setText( tmpParameter.getName() );
        
        oldName =tmpProperty.getName();
        
        
        this.jTextArea1.setText(  (String)tmpProperty.getValue() );
        this.jRTextExpressionValueExpression.setText( Misc.getExpressionText(tmpProperty.getValueExpression()) );
    
        jCheckBox1.setSelected( tmpProperty.getValue() == null );
        jCheckBox1ActionPerformed(null);
    }
    
    /** Getter for property dialogResult.
     * @return Value of property dialogResult.
     *
     */
    public int getDialogResult() {
        return dialogResult;
    }
    
    /** Setter for property dialogResult.
     * @param dialogResult New value of property dialogResult.
     *
     */
    public void setDialogResult(int dialogResult) {
        this.dialogResult = dialogResult;
    }
    
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JButton jButtonCancel;
    private javax.swing.JButton jButtonOK;
    private javax.swing.JCheckBox jCheckBox1;
    private javax.swing.JComboBox jComboBox1;
    private javax.swing.JLabel jLabel1;
    private javax.swing.JLabel jLabelValue;
    private javax.swing.JPanel jPanel1;
    private javax.swing.JPanel jPanel2;
    private javax.swing.JPanel jPanelValue;
    private com.jaspersoft.ireport.designer.editor.ExpressionEditorArea jRTextExpressionValueExpression;
    private javax.swing.JScrollPane jScrollPaneValue;
    private javax.swing.JSeparator jSeparator1;
    private javax.swing.JTextArea jTextArea1;
    // End of variables declaration//GEN-END:variables

    private int dialogResult;    
        
  
    
    public void setExpressionContext(ExpressionContext context)
    {
        this.jRTextExpressionValueExpression.setExpressionContext(context);
    }
}
