/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.exec;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.CollectOperator;
import org.apache.hadoop.hive.ql.exec.ExtractOperator;
import org.apache.hadoop.hive.ql.exec.FileSinkOperator;
import org.apache.hadoop.hive.ql.exec.FilterOperator;
import org.apache.hadoop.hive.ql.exec.ForwardOperator;
import org.apache.hadoop.hive.ql.exec.GroupByOperator;
import org.apache.hadoop.hive.ql.exec.HashTableDummyOperator;
import org.apache.hadoop.hive.ql.exec.HashTableSinkOperator;
import org.apache.hadoop.hive.ql.exec.JoinOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewForwardOperator;
import org.apache.hadoop.hive.ql.exec.LateralViewJoinOperator;
import org.apache.hadoop.hive.ql.exec.LimitOperator;
import org.apache.hadoop.hive.ql.exec.MapJoinOperator;
import org.apache.hadoop.hive.ql.exec.Operator;
import org.apache.hadoop.hive.ql.exec.ReduceSinkOperator;
import org.apache.hadoop.hive.ql.exec.RowSchema;
import org.apache.hadoop.hive.ql.exec.SMBMapJoinOperator;
import org.apache.hadoop.hive.ql.exec.ScriptOperator;
import org.apache.hadoop.hive.ql.exec.SelectOperator;
import org.apache.hadoop.hive.ql.exec.TableScanOperator;
import org.apache.hadoop.hive.ql.exec.UDTFOperator;
import org.apache.hadoop.hive.ql.exec.UnionOperator;
import org.apache.hadoop.hive.ql.plan.CollectDesc;
import org.apache.hadoop.hive.ql.plan.ExtractDesc;
import org.apache.hadoop.hive.ql.plan.FileSinkDesc;
import org.apache.hadoop.hive.ql.plan.FilterDesc;
import org.apache.hadoop.hive.ql.plan.ForwardDesc;
import org.apache.hadoop.hive.ql.plan.GroupByDesc;
import org.apache.hadoop.hive.ql.plan.HashTableDummyDesc;
import org.apache.hadoop.hive.ql.plan.HashTableSinkDesc;
import org.apache.hadoop.hive.ql.plan.JoinDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewForwardDesc;
import org.apache.hadoop.hive.ql.plan.LateralViewJoinDesc;
import org.apache.hadoop.hive.ql.plan.LimitDesc;
import org.apache.hadoop.hive.ql.plan.MapJoinDesc;
import org.apache.hadoop.hive.ql.plan.ReduceSinkDesc;
import org.apache.hadoop.hive.ql.plan.SMBJoinDesc;
import org.apache.hadoop.hive.ql.plan.ScriptDesc;
import org.apache.hadoop.hive.ql.plan.SelectDesc;
import org.apache.hadoop.hive.ql.plan.TableScanDesc;
import org.apache.hadoop.hive.ql.plan.UDTFDesc;
import org.apache.hadoop.hive.ql.plan.UnionDesc;

public final class OperatorFactory {
    public static ArrayList<OpTuple> opvec = new ArrayList();

    public static <T extends Serializable> Operator<T> get(Class<T> opClass) {
        for (OpTuple o : opvec) {
            if (o.descClass != opClass) continue;
            try {
                Operator op = o.opClass.newInstance();
                op.initializeCounters();
                return op;
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new RuntimeException(e);
            }
        }
        throw new RuntimeException("No operator for descriptor class " + opClass.getName());
    }

    public static <T extends Serializable> Operator<T> get(Class<T> opClass, RowSchema rwsch) {
        Operator<T> ret = OperatorFactory.get(opClass);
        ret.setSchema(rwsch);
        return ret;
    }

    public static <T extends Serializable> Operator<T> get(T conf, Operator<? extends Serializable> ... oplist) {
        Operator<?> ret = OperatorFactory.get(conf.getClass());
        ret.setConf(conf);
        if (oplist.length == 0) {
            return ret;
        }
        ArrayList<Operator<? extends Serializable>> clist = new ArrayList<Operator<? extends Serializable>>();
        for (Operator<? extends Serializable> op : oplist) {
            clist.add(op);
        }
        ret.setChildOperators(clist);
        for (Operator<? extends Serializable> op : oplist) {
            List<Operator<? extends Serializable>> parents = op.getParentOperators();
            if (parents == null) {
                parents = new ArrayList<Operator<Serializable>>();
            }
            parents.add(ret);
            op.setParentOperators(parents);
        }
        return ret;
    }

    public static <T extends Serializable> Operator<T> get(T conf, RowSchema rwsch, Operator ... oplist) {
        Operator<T> ret = OperatorFactory.get(conf, oplist);
        ret.setSchema(rwsch);
        return ret;
    }

    public static <T extends Serializable> Operator<T> getAndMakeChild(T conf, Operator ... oplist) {
        Operator<?> ret = OperatorFactory.get(conf.getClass());
        ret.setConf(conf);
        if (oplist.length == 0) {
            return ret;
        }
        for (Operator op : oplist) {
            List<Operator<? extends Serializable>> children = op.getChildOperators();
            if (children == null) {
                children = new ArrayList<Operator<Serializable>>();
            }
            children.add(ret);
            op.setChildOperators(children);
        }
        ArrayList<Operator<? extends Serializable>> parent = new ArrayList<Operator<? extends Serializable>>();
        for (Operator op : oplist) {
            parent.add(op);
        }
        ret.setParentOperators(parent);
        return ret;
    }

    public static <T extends Serializable> Operator<T> getAndMakeChild(T conf, List<Operator<? extends Serializable>> oplist) {
        Operator<?> ret = OperatorFactory.get(conf.getClass());
        ret.setConf(conf);
        if (oplist.size() == 0) {
            return ret;
        }
        for (Operator<? extends Serializable> op : oplist) {
            List<Operator<? extends Serializable>> children = op.getChildOperators();
            if (children == null) {
                children = new ArrayList<Operator<Serializable>>();
            }
            children.add(ret);
            op.setChildOperators(children);
        }
        ArrayList<Operator<? extends Serializable>> parent = new ArrayList<Operator<? extends Serializable>>();
        for (Operator<? extends Serializable> op : oplist) {
            parent.add(op);
        }
        ret.setParentOperators(parent);
        return ret;
    }

    public static <T extends Serializable> Operator<T> getAndMakeChild(T conf, RowSchema rwsch, Operator ... oplist) {
        Operator<T> ret = OperatorFactory.getAndMakeChild(conf, oplist);
        ret.setSchema(rwsch);
        return ret;
    }

    public static <T extends Serializable> Operator<T> getAndMakeChild(T conf, RowSchema rwsch, List<Operator<? extends Serializable>> oplist) {
        Operator<T> ret = OperatorFactory.getAndMakeChild(conf, oplist);
        ret.setSchema(rwsch);
        return ret;
    }

    private OperatorFactory() {
    }

    static {
        opvec.add(new OpTuple<FilterDesc>(FilterDesc.class, FilterOperator.class));
        opvec.add(new OpTuple<SelectDesc>(SelectDesc.class, SelectOperator.class));
        opvec.add(new OpTuple<ForwardDesc>(ForwardDesc.class, ForwardOperator.class));
        opvec.add(new OpTuple<FileSinkDesc>(FileSinkDesc.class, FileSinkOperator.class));
        opvec.add(new OpTuple<CollectDesc>(CollectDesc.class, CollectOperator.class));
        opvec.add(new OpTuple<ScriptDesc>(ScriptDesc.class, ScriptOperator.class));
        opvec.add(new OpTuple<ReduceSinkDesc>(ReduceSinkDesc.class, ReduceSinkOperator.class));
        opvec.add(new OpTuple<ExtractDesc>(ExtractDesc.class, ExtractOperator.class));
        opvec.add(new OpTuple<GroupByDesc>(GroupByDesc.class, GroupByOperator.class));
        opvec.add(new OpTuple<JoinDesc>(JoinDesc.class, JoinOperator.class));
        opvec.add(new OpTuple<MapJoinDesc>(MapJoinDesc.class, MapJoinOperator.class));
        opvec.add(new OpTuple<SMBJoinDesc>(SMBJoinDesc.class, SMBMapJoinOperator.class));
        opvec.add(new OpTuple<LimitDesc>(LimitDesc.class, LimitOperator.class));
        opvec.add(new OpTuple<TableScanDesc>(TableScanDesc.class, TableScanOperator.class));
        opvec.add(new OpTuple<UnionDesc>(UnionDesc.class, UnionOperator.class));
        opvec.add(new OpTuple<UDTFDesc>(UDTFDesc.class, UDTFOperator.class));
        opvec.add(new OpTuple<LateralViewJoinDesc>(LateralViewJoinDesc.class, LateralViewJoinOperator.class));
        opvec.add(new OpTuple<LateralViewForwardDesc>(LateralViewForwardDesc.class, LateralViewForwardOperator.class));
        opvec.add(new OpTuple<HashTableDummyDesc>(HashTableDummyDesc.class, HashTableDummyOperator.class));
        opvec.add(new OpTuple<HashTableSinkDesc>(HashTableSinkDesc.class, HashTableSinkOperator.class));
    }

    public static final class OpTuple<T extends Serializable> {
        public Class<T> descClass;
        public Class<? extends Operator<T>> opClass;

        public OpTuple(Class<T> descClass, Class<? extends Operator<T>> opClass) {
            this.descClass = descClass;
            this.opClass = opClass;
        }
    }
}

