/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.metastore.events;

import java.util.TimerTask;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.hive.metastore.HiveMetaStore;
import org.apache.hadoop.hive.metastore.RawStore;

public class EventCleanerTask
extends TimerTask {
    public static final Log LOG = LogFactory.getLog(EventCleanerTask.class);
    private final HiveMetaStore.HMSHandler handler;

    public EventCleanerTask(HiveMetaStore.HMSHandler handler) {
        this.handler = handler;
    }

    @Override
    public void run() {
        try {
            long deleteCnt = this.handler.executeWithRetry(new HiveMetaStore.HMSHandler.Command<Long>(){

                @Override
                public Long run(RawStore ms) throws Exception {
                    return ms.cleanupEvents();
                }
            });
            if (deleteCnt > 0L) {
                LOG.info((Object)("Number of events deleted from event Table: " + deleteCnt));
            }
        }
        catch (Exception e) {
            LOG.error((Object)e);
        }
    }
}

