/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.functions.standard;

import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.functions.AbstractFunctionSupport;
import net.sf.jasperreports.functions.annotations.Function;
import net.sf.jasperreports.functions.annotations.FunctionCategories;
import net.sf.jasperreports.functions.annotations.FunctionParameter;
import net.sf.jasperreports.functions.annotations.FunctionParameters;
import net.sf.jasperreports.functions.standard.TextCategory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

@FunctionCategories(value={TextCategory.class})
public final class TextFunctions
extends AbstractFunctionSupport {
    private static final Log log = LogFactory.getLog(TextFunctions.class);
    private static final int BASE_MIN_RADIX = 2;
    private static final int BASE_MAX_RADIX = 36;

    @Function(value="BASE")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="radix"), @FunctionParameter(value="minLength")})
    public static String BASE(Integer number, Integer radix) {
        if (number == null) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The number can not be null.");
            }
            return null;
        }
        if (radix == null || radix > 36 || radix < 2) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The radix parameter must be an integer number between 2 and 36.");
            }
            return null;
        }
        return Integer.toString(number, radix);
    }

    public static String BASE(Integer number, Integer radix, Integer minlength) {
        String base = TextFunctions.BASE(number, radix);
        if (base != null) {
            if (minlength == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)"The minimum length can not be null.");
                }
                return null;
            }
            String spacePaddedStr = String.format("%" + minlength + "s", base);
            return spacePaddedStr.replace(' ', '0');
        }
        return null;
    }

    @Function(value="CHAR")
    @FunctionParameters(value={@FunctionParameter(value="number")})
    public static String CHAR(Integer number) {
        if (number == null || number < 1 || number > 255) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"The number must be an integer number between 1 and 255.");
            }
            return null;
        }
        return Character.toString((char)number.intValue());
    }

    @Function(value="CLEAN")
    @FunctionParameters(value={@FunctionParameter(value="text")})
    public static String CLEAN(String text) {
        if (text == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        String cleanedString = text.replaceAll("\\p{Cntrl}", "");
        return cleanedString;
    }

    @Function(value="CODE")
    @FunctionParameters(value={@FunctionParameter(value="textString")})
    public static Integer CODE(String textString) {
        if (textString == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        char firstCharAsNum = textString.charAt(0);
        if (firstCharAsNum < '\u0000' || firstCharAsNum > '\u00ff') {
            throw new JRRuntimeException("The first character of the text can not be converted to a valid numeric ASCII code.");
        }
        return firstCharAsNum;
    }

    @Function(value="CONCATENATE")
    @FunctionParameters(value={@FunctionParameter(value="strings")})
    public static String CONCATENATE(String ... strings) {
        if (strings.length == 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"No arguments were specified.");
            }
            return null;
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < strings.length; ++i) {
            sb.append(strings[i]);
        }
        return sb.toString();
    }

    @Function(value="EXACT")
    @FunctionParameters(value={@FunctionParameter(value="text1"), @FunctionParameter(value="text2")})
    public static Boolean EXACT(String text1, String text2) {
        if (text1 != null) {
            return text1.equals(text2);
        }
        if (text2 != null) {
            return text2.equals(text1);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"The texts to be compared are both null.");
        }
        return null;
    }

    @Function(value="DOUBLE_VALUE")
    @FunctionParameters(value={@FunctionParameter(value="textNumber")})
    public static Double DOUBLE_VALUE(String textNumber) {
        if (textNumber == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return Double.parseDouble(textNumber);
    }

    @Function(value="FIND")
    @FunctionParameters(value={@FunctionParameter(value="findText"), @FunctionParameter(value="searchText"), @FunctionParameter(value="startPosition")})
    public static Integer FIND(String findText, String searchText) {
        return TextFunctions.FIND(findText, searchText, 0);
    }

    public static Integer FIND(String findText, String searchText, Integer startPosition) {
        if (findText == null || searchText == null || startPosition == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        int position = findText.indexOf(searchText, (int)startPosition);
        return position;
    }

    @Function(value="FIXED")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="decimals"), @FunctionParameter(value="omitSeparators")})
    public String FIXED(Number number, Integer decimals) {
        return this.FIXED(number, decimals, false);
    }

    public String FIXED(Number number, Integer decimals, Boolean omitSeparators) {
        if (number == null || decimals == null || omitSeparators == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        StringBuffer patternBuf = new StringBuffer("###");
        if (!omitSeparators.booleanValue()) {
            patternBuf.append(",###");
        }
        patternBuf.append(".");
        for (int i = 0; i < decimals; ++i) {
            patternBuf.append("0");
        }
        DecimalFormat myFormatter = this.getDecimalFormat();
        myFormatter.applyPattern(patternBuf.toString());
        return myFormatter.format(number);
    }

    @Function(value="FLOAT_VALUE")
    @FunctionParameters(value={@FunctionParameter(value="textNumber")})
    public static Float FLOAT_VALUE(String textNumber) {
        if (textNumber == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return Float.valueOf(Float.parseFloat(textNumber));
    }

    @Function(value="INTEGER_VALUE")
    @FunctionParameters(value={@FunctionParameter(value="textNumber")})
    public static Integer INTEGER_VALUE(String textNumber) {
        if (textNumber == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return Integer.parseInt(textNumber);
    }

    @Function(value="LEFT")
    @FunctionParameters(value={@FunctionParameter(value="text"), @FunctionParameter(value="charactersNum")})
    public static String LEFT(String text) {
        return TextFunctions.LEFT(text, 1);
    }

    public static String LEFT(String text, Integer charactersNum) {
        if (text == null || charactersNum == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        return text.substring(0, charactersNum);
    }

    @Function(value="LEN")
    @FunctionParameters(value={@FunctionParameter(value="text")})
    public static Integer LEN(String text) {
        if (text == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return text.length();
    }

    @Function(value="LONG_VALUE")
    @FunctionParameters(value={@FunctionParameter(value="textNumber")})
    public static Long LONG_VALUE(String textNumber) {
        if (textNumber == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return Long.parseLong(textNumber);
    }

    @Function(value="LOWER")
    @FunctionParameters(value={@FunctionParameter(value="text")})
    public static String LOWER(String text) {
        if (text == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return text.toLowerCase();
    }

    @Function(value="LTRIM")
    @FunctionParameters(value={@FunctionParameter(value="text")})
    public static String LTRIM(String text) {
        if (text == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return text.replaceAll("^\\s+", "");
    }

    @Function(value="MID")
    @FunctionParameters(value={@FunctionParameter(value="text"), @FunctionParameter(value="startPosition"), @FunctionParameter(value="charactersNum")})
    public static String MID(String text, Integer startPosition) {
        if (text == null || startPosition == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        return text.substring(startPosition - 1, text.length() - startPosition + 1);
    }

    public static String MID(String text, Integer startPosition, Integer charactersNum) {
        if (text == null || startPosition == null || charactersNum == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        return text.substring(startPosition - 1, startPosition - 1 + charactersNum);
    }

    @Function(value="PROPER")
    @FunctionParameters(value={@FunctionParameter(value="text")})
    public static String PROPER(String text) {
        if (text == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        String lowerCaseString = TextFunctions.LOWER(text);
        StringBuffer result = new StringBuffer();
        result.append(Character.toTitleCase(lowerCaseString.charAt(0)));
        boolean capitalizeNext = false;
        for (int i = 1; i < lowerCaseString.length(); ++i) {
            char c = lowerCaseString.charAt(i);
            if (!TextFunctions.isDelimiter(c)) {
                if (capitalizeNext) {
                    result.append(Character.toTitleCase(c));
                } else {
                    result.append(c);
                }
                capitalizeNext = false;
                continue;
            }
            result.append(c);
            capitalizeNext = true;
        }
        return result.toString();
    }

    @Function(value="REPLACE")
    @FunctionParameters(value={@FunctionParameter(value="originalText"), @FunctionParameter(value="startPosition"), @FunctionParameter(value="charsNum"), @FunctionParameter(value="newText")})
    public static String REPLACE(String originalText, Integer startPosition, Integer charsNum, String newText) {
        if (originalText == null || startPosition == null || charsNum == null || newText == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        StringBuffer output = new StringBuffer();
        output.append(originalText.substring(0, startPosition - 1));
        output.append(newText);
        output.append(originalText.substring(startPosition + charsNum - 1, originalText.length()));
        return output.toString();
    }

    @Function(value="REPT")
    @FunctionParameters(value={@FunctionParameter(value="originalText"), @FunctionParameter(value="numberOfTimes")})
    public static String REPT(String originalText, Integer numberOfTimes) {
        if (originalText == null || numberOfTimes == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        StringBuffer output = new StringBuffer();
        for (int i = 0; i < numberOfTimes; ++i) {
            output.append(originalText);
        }
        return output.toString();
    }

    @Function(value="RIGHT")
    @FunctionParameters(value={@FunctionParameter(value="text"), @FunctionParameter(value="charactersNum")})
    public static String RIGHT(String text) {
        return TextFunctions.RIGHT(text, 1);
    }

    public static String RIGHT(String text, Integer charactersNum) {
        if (text == null || charactersNum == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        int length = text.length();
        return text.substring(length - charactersNum, length);
    }

    @Function(value="RTRIM")
    @FunctionParameters(value={@FunctionParameter(value="text")})
    public static String RTRIM(String text) {
        if (text == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return text.replaceAll("\\s+$", "");
    }

    @Function(value="SEARCH")
    @FunctionParameters(value={@FunctionParameter(value="findText"), @FunctionParameter(value="textToSearch"), @FunctionParameter(value="startPosition")})
    public static Integer SEARCH(String findText, String textToSearch) {
        return TextFunctions.SEARCH(findText, textToSearch, 1);
    }

    public static Integer SEARCH(String findText, String textToSearch, Integer startPosition) {
        if (findText == null || textToSearch == null || startPosition == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        return textToSearch.toLowerCase().indexOf(findText.toLowerCase(), startPosition - 1);
    }

    @Function(value="SUBSTITUTE")
    @FunctionParameters(value={@FunctionParameter(value="originalText"), @FunctionParameter(value="oldText"), @FunctionParameter(value="newText"), @FunctionParameter(value="occurrenceNum")})
    public static String SUBSTITUTE(String originalText, String oldText, String newText) {
        return TextFunctions.SUBSTITUTE(originalText, oldText, newText, null);
    }

    public static String SUBSTITUTE(String originalText, String oldText, String newText, Integer occurrenceNum) {
        if (originalText == null || oldText == null || newText == null) {
            TextFunctions.logHavingNullArguments();
            return null;
        }
        if (occurrenceNum == null) {
            return originalText.replaceAll(Pattern.quote(oldText), Matcher.quoteReplacement(newText));
        }
        int startIdx = 0;
        int counter = 1;
        while (startIdx < originalText.length() - 1) {
            int foundPosition = originalText.indexOf(oldText, startIdx);
            if (counter == occurrenceNum) {
                return TextFunctions.REPLACE(originalText, foundPosition + 1, oldText.length(), newText);
            }
            startIdx = foundPosition + oldText.length();
            ++counter;
        }
        return null;
    }

    @Function(value="T")
    @FunctionParameters(value={@FunctionParameter(value="value")})
    public static String T(Object value) {
        if (value instanceof String) {
            return (String)value;
        }
        return "";
    }

    @Function(value="TEXT")
    @FunctionParameters(value={@FunctionParameter(value="number"), @FunctionParameter(value="numberFormat")})
    public String TEXT(Number number, String numberFormat) {
        if (number == null || numberFormat == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        DecimalFormat nformat = this.getDecimalFormat();
        nformat.applyPattern(numberFormat);
        return nformat.format(number);
    }

    @Function(value="TRIM")
    @FunctionParameters(value={@FunctionParameter(value="text")})
    public static String TRIM(String text) {
        if (text == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return text.trim();
    }

    @Function(value="UPPER")
    @FunctionParameters(value={@FunctionParameter(value="text")})
    public static String UPPER(String text) {
        if (text == null) {
            TextFunctions.logNullTextString();
            return null;
        }
        return text.toUpperCase();
    }

    private static boolean isDelimiter(char c) {
        return Character.isWhitespace(c) || Character.isSpaceChar(c);
    }

    private static void logNullTextString() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"The text string can not be null.");
        }
    }

    private static void logHavingNullArguments() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"None of the arguments can be null.");
        }
    }

    private DecimalFormat getDecimalFormat() {
        return (DecimalFormat)NumberFormat.getNumberInstance(this.getReportLocale());
    }

    private Locale getReportLocale() {
        Locale reportLocale = Locale.getDefault();
        if (this.getContext() != null) {
            reportLocale = (Locale)this.getContext().getParameterValue("REPORT_LOCALE");
        }
        return reportLocale;
    }
}

