/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.lib;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URL;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import javax.swing.text.Position;
import org.netbeans.modules.editor.lib.URLMapper;
import org.netbeans.modules.editor.lib.WeakPositions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class NavigationHistory {
    public static final String PROP_WAYPOINTS = "NavigationHHistory.PROP_WAYPOINTS";
    private static final Logger LOG = Logger.getLogger(NavigationHistory.class.getName());
    private static Map<String, NavigationHistory> instances = new HashMap<String, NavigationHistory>();
    private final String id;
    private final String LOCK = new String("NavigationHistory.LOCK");
    private final RingBuffer<Waypoint> waypoints = new RingBuffer<Waypoint>(new Waypoint[50]);
    private int pointer = 0;
    private List<Waypoint> sublistsCache = null;
    private final PropertyChangeSupport PCS = new PropertyChangeSupport(this);

    public static NavigationHistory getNavigations() {
        return NavigationHistory.get("navigation-history");
    }

    public static NavigationHistory getEdits() {
        return NavigationHistory.get("last-edit-history");
    }

    public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.addPropertyChangeListener(propertyChangeListener);
    }

    public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        this.PCS.removePropertyChangeListener(propertyChangeListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Waypoint markWaypoint(JTextComponent jTextComponent, int n, boolean bl, boolean bl2) throws BadLocationException {
        assert (jTextComponent != null) : "The comp parameter must not be null";
        Waypoint waypoint = null;
        String string = this.LOCK;
        synchronized (string) {
            Waypoint waypoint2;
            Position position;
            Position position2 = position = n == -1 ? null : WeakPositions.get(jTextComponent.getDocument(), n);
            if (!bl2) {
                while (this.waypoints.size() > this.pointer) {
                    waypoint2 = this.waypoints.remove(this.waypoints.size() - 1);
                    waypoint2.dispose();
                }
            }
            if (this.waypoints.size() > 0) {
                waypoint2 = this.waypoints.get(this.waypoints.size() - 1);
                JTextComponent jTextComponent2 = waypoint2.getComponent();
                int n2 = waypoint2.getOffset();
                if (jTextComponent2 != null && jTextComponent2.equals(jTextComponent) && n2 == n) {
                    waypoint = waypoint2;
                }
            }
            if (waypoint == null) {
                waypoint = new Waypoint(this, jTextComponent, position);
                int n3 = this.waypoints.addEx(waypoint);
                waypoint.initRawIndex(n3);
            }
            this.pointer = bl ? this.waypoints.size() - 1 : this.waypoints.size();
            this.sublistsCache = null;
        }
        this.PCS.firePropertyChange(PROP_WAYPOINTS, null, null);
        return waypoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Waypoint getCurrentWaypoint() {
        String string = this.LOCK;
        synchronized (string) {
            if (this.pointer < this.waypoints.size()) {
                return this.waypoints.get(this.pointer);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasPreviousWaypoints() {
        String string = this.LOCK;
        synchronized (string) {
            return this.pointer > 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasNextWaypoints() {
        String string = this.LOCK;
        synchronized (string) {
            return this.pointer + 1 < this.waypoints.size();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Waypoint> getPreviousWaypoints() {
        String string = this.LOCK;
        synchronized (string) {
            if (this.hasPreviousWaypoints()) {
                return this.getSublistsCache().subList(0, this.pointer);
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Waypoint> getNextWaypoints() {
        String string = this.LOCK;
        synchronized (string) {
            if (this.hasNextWaypoints()) {
                return this.getSublistsCache().subList(this.pointer + 1, this.waypoints.size());
            }
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Waypoint navigateBack() {
        Waypoint waypoint = null;
        String string = this.LOCK;
        synchronized (string) {
            if (this.hasPreviousWaypoints()) {
                --this.pointer;
                waypoint = this.waypoints.get(this.pointer);
            }
        }
        if (waypoint != null) {
            this.PCS.firePropertyChange(PROP_WAYPOINTS, null, null);
        }
        return waypoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Waypoint navigateForward() {
        Waypoint waypoint = null;
        String string = this.LOCK;
        synchronized (string) {
            if (this.hasNextWaypoints()) {
                ++this.pointer;
                waypoint = this.waypoints.get(this.pointer);
            }
        }
        if (waypoint != null) {
            this.PCS.firePropertyChange(PROP_WAYPOINTS, null, null);
        }
        return waypoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Waypoint navigateTo(Waypoint waypoint) {
        assert (waypoint != null) : "The waypoint parameter must not be null";
        String string = this.LOCK;
        synchronized (string) {
            int n = waypoint.getRawIndex();
            if (n == -1) {
                waypoint = null;
            } else {
                int n2 = this.waypoints.getIndex(n);
                if (this.pointer != n2) {
                    this.pointer = n2;
                } else {
                    waypoint = null;
                }
            }
        }
        if (waypoint != null) {
            this.PCS.firePropertyChange(PROP_WAYPOINTS, null, null);
        }
        return waypoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Waypoint navigateFirst() {
        Waypoint waypoint = null;
        String string = this.LOCK;
        synchronized (string) {
            if (this.waypoints.size() > 0) {
                this.pointer = 0;
                waypoint = this.waypoints.get(this.pointer);
            }
        }
        if (waypoint != null) {
            this.PCS.firePropertyChange(PROP_WAYPOINTS, null, null);
        }
        return waypoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Waypoint navigateLast() {
        Waypoint waypoint = null;
        String string = this.LOCK;
        synchronized (string) {
            if (this.waypoints.size() > 0) {
                this.pointer = this.waypoints.size() - 1;
                waypoint = this.waypoints.get(this.pointer);
            }
        }
        if (waypoint != null) {
            this.PCS.firePropertyChange(PROP_WAYPOINTS, null, null);
        }
        return waypoint;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static NavigationHistory get(String string) {
        Map<String, NavigationHistory> map = instances;
        synchronized (map) {
            NavigationHistory navigationHistory = instances.get(string);
            if (navigationHistory == null) {
                navigationHistory = new NavigationHistory(string);
                instances.put(string, navigationHistory);
            }
            return navigationHistory;
        }
    }

    private NavigationHistory(String string) {
        this.id = string;
    }

    private List<Waypoint> getSublistsCache() {
        if (this.sublistsCache == null) {
            this.sublistsCache = Collections.unmodifiableList(new ArrayList<Waypoint>(this.waypoints));
        }
        return this.sublistsCache;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RingBuffer<E>
    extends AbstractList<E> {
        private final E[] buffer;
        private int head = 0;
        private int tail = 0;

        public RingBuffer(E[] EArray) {
            assert (EArray != null) : "The buffer parameter must not be null";
            assert (EArray.length >= 2) : "The buffer size must be at least 2.";
            this.buffer = EArray;
        }

        @Override
        public E set(int n, E e) {
            int n2 = this.getRawIndex(n);
            E e2 = this.buffer[n2];
            this.buffer[n2] = e;
            return e2;
        }

        @Override
        public void add(int n, E e) {
            int n2 = (this.head + n) % this.buffer.length;
            if (n2 != this.tail) {
                throw new UnsupportedOperationException("This ring buffer only allows adding to the end of the buffer.");
            }
            this.addEx(e);
        }

        public int addEx(E e) {
            int n = this.tail;
            this.buffer[n] = e;
            this.tail = (this.tail + 1) % this.buffer.length;
            if (this.tail == this.head) {
                if (this.buffer[this.head] instanceof Waypoint) {
                    ((Waypoint)this.buffer[this.head]).dispose();
                }
                this.buffer[this.head] = null;
                this.head = (this.head + 1) % this.buffer.length;
            }
            return n;
        }

        @Override
        public E remove(int n) {
            int n2 = this.getRawIndex(n);
            if (n2 == this.head) {
                this.head = (this.head + 1) % this.buffer.length;
            } else {
                int n3 = (this.tail - 1 + this.buffer.length) % this.buffer.length;
                if (n2 == n3) {
                    this.tail = n3;
                } else {
                    throw new UnsupportedOperationException("This ring buffer only allows removing at the beginning or end of the buffer.");
                }
            }
            E e = this.buffer[n2];
            this.buffer[n2] = null;
            return e;
        }

        @Override
        public E get(int n) {
            return this.buffer[this.getRawIndex(n)];
        }

        @Override
        public int size() {
            return (this.tail - this.head + this.buffer.length) % this.buffer.length;
        }

        private int getRawIndex(int n) {
            if (n >= 0 && n < this.size()) {
                return (this.head + n) % this.buffer.length;
            }
            throw new IndexOutOfBoundsException("Index = " + n + ", size = " + this.size());
        }

        public int getIndex(int n) {
            boolean bl;
            if (this.tail < this.head) {
                bl = n >= 0 && n < this.tail || n >= this.head && n < this.buffer.length;
            } else {
                boolean bl2 = bl = n >= this.head && n < this.tail;
            }
            if (bl) {
                return (n - this.head + this.buffer.length) % this.buffer.length;
            }
            throw new IndexOutOfBoundsException("Invalid raw index. RawIndex = " + n + ", head = " + this.head + ", tail = " + this.tail);
        }
    }

    public static final class Waypoint {
        private NavigationHistory navigationHistory;
        private Reference<JTextComponent> compRef;
        private Position pos;
        private URL url;
        private int rawIndex = -2;

        private Waypoint(NavigationHistory navigationHistory, JTextComponent jTextComponent, Position position) throws BadLocationException {
            this.navigationHistory = navigationHistory;
            this.compRef = new WeakReference<JTextComponent>(jTextComponent);
            this.pos = position;
            this.url = URLMapper.findUrl(jTextComponent);
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.navigationHistory.id + ": waypoint added: " + this.getUrl());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public URL getUrl() {
            String string = this.navigationHistory.LOCK;
            synchronized (string) {
                return this.url;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public JTextComponent getComponent() {
            String string = this.navigationHistory.LOCK;
            synchronized (string) {
                return this.compRef == null ? null : this.compRef.get();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int getOffset() {
            String string = this.navigationHistory.LOCK;
            synchronized (string) {
                return this.pos == null ? -1 : this.pos.getOffset();
            }
        }

        private int getRawIndex() {
            return this.rawIndex;
        }

        private void initRawIndex(int n) {
            assert (this.rawIndex == -2) : "Can't call initRawIndex more than once.";
            this.rawIndex = n;
        }

        private void dispose() {
            if (LOG.isLoggable(Level.FINE)) {
                LOG.fine(this.navigationHistory.id + ": waypoint disposed: " + this.getUrl());
            }
            this.rawIndex = -1;
            this.url = null;
            this.compRef = null;
            this.pos = null;
        }
    }
}

