/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.style;

import com.jaspersoft.ireport.components.table.style.ComboBoxColorRenderer;
import com.jaspersoft.ireport.components.table.style.TableStylePreview;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.box.ColorSelectorPanel;
import com.jaspersoft.ireport.designer.utils.ColorSchemaGenerator;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.design.JRDesignConditionalStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import net.sf.jasperreports.engine.type.ModeEnum;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableStyleDesigner
extends JPanel {
    TableStylePreview previewPanel = null;
    private ButtonGroup buttonGroup1;
    private ColorSelectorPanel colorSelectorPanel1;
    private JCheckBox jCheckBox1;
    private JComboBox jComboBoxColors;
    private JComboBox jComboBoxVariations;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JPanel jPanelPreview;
    private JToggleButton jToggleButton1;
    private JToggleButton jToggleButton2;
    private JToggleButton jToggleButton3;

    public TableStyleDesigner() {
        this.initComponents();
        this.jComboBoxColors.setRenderer(new ComboBoxColorRenderer());
        List colors = ColorSchemaGenerator.getColors();
        for (int i = 0; i < colors.size(); ++i) {
            this.jComboBoxColors.addItem(colors.get(i));
        }
        List variants = ColorSchemaGenerator.getVariants();
        for (int i = 0; i < variants.size(); ++i) {
            this.jComboBoxVariations.addItem(variants.get(i));
        }
        this.previewPanel = new TableStylePreview();
        this.jPanelPreview.add((Component)this.previewPanel, "Center");
        this.updatePreview();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jComboBoxColors = new JComboBox();
        this.jComboBoxVariations = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jCheckBox1 = new JCheckBox();
        this.jPanel2 = new JPanel();
        this.colorSelectorPanel1 = new ColorSelectorPanel();
        this.jLabel3 = new JLabel();
        this.jToggleButton1 = new JToggleButton();
        this.jToggleButton2 = new JToggleButton();
        this.jLabel4 = new JLabel();
        this.jToggleButton3 = new JToggleButton();
        this.jPanelPreview = new JPanel();
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jPanel1.border.title")));
        this.jLabel1.setText(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jLabel1.text"));
        this.jComboBoxColors.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableStyleDesigner.this.jComboBoxColorsActionPerformed(evt);
            }
        });
        this.jComboBoxVariations.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableStyleDesigner.this.jComboBoxVariationsActionPerformed(evt);
            }
        });
        this.jLabel2.setText(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jLabel2.text"));
        this.jCheckBox1.setText(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jCheckBox1.text"));
        this.jCheckBox1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableStyleDesigner.this.jCheckBox1ActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jCheckBox1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jLabel1).add((Component)this.jLabel2)).addPreferredGap(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((Component)this.jComboBoxVariations, 0, 199, Short.MAX_VALUE).add((Component)this.jComboBoxColors, 0, 199, Short.MAX_VALUE)))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel1).add((Component)this.jComboBoxColors, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxVariations, -2, -1, -2)).add(18, 18, 18).add((Component)this.jCheckBox1).addContainerGap(10, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jPanel2.border.title")));
        this.colorSelectorPanel1.setColor(new Color(0, 0, 0));
        this.colorSelectorPanel1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableStyleDesigner.this.colorSelectorPanel1ActionPerformed(evt);
            }
        });
        this.jLabel3.setText(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jLabel3.text"));
        this.buttonGroup1.add(this.jToggleButton1);
        this.jToggleButton1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/components/table/style/full_borders.png")));
        this.jToggleButton1.setSelected(true);
        this.jToggleButton1.setText(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jToggleButton1.text"));
        this.jToggleButton1.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableStyleDesigner.this.jToggleButton1ActionPerformed(evt);
            }
        });
        this.buttonGroup1.add(this.jToggleButton2);
        this.jToggleButton2.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/components/table/style/horizontal_borders.png")));
        this.jToggleButton2.setText(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jToggleButton2.text"));
        this.jToggleButton2.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableStyleDesigner.this.jToggleButton2ActionPerformed(evt);
            }
        });
        this.jLabel4.setText(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jLabel4.text"));
        this.buttonGroup1.add(this.jToggleButton3);
        this.jToggleButton3.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/components/table/style/horizontal_borders2.png")));
        this.jToggleButton3.setText(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jToggleButton3.text"));
        this.jToggleButton3.setMargin(new Insets(2, 2, 2, 2));
        this.jToggleButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TableStyleDesigner.this.jToggleButton3ActionPerformed(evt);
            }
        });
        GroupLayout jPanel2Layout = new GroupLayout((Container)this.jPanel2);
        this.jPanel2.setLayout((LayoutManager)jPanel2Layout);
        jPanel2Layout.setHorizontalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jLabel3).add((Component)this.colorSelectorPanel1, -2, 101, -2)).add(27, 27, 27).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((Component)this.jToggleButton1).addPreferredGap(0).add((Component)this.jToggleButton2).addPreferredGap(0).add((Component)this.jToggleButton3)).add((Component)this.jLabel4)).addContainerGap(20, Short.MAX_VALUE)));
        jPanel2Layout.setVerticalGroup((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanel2Layout.createSequentialGroup().add((GroupLayout.Group)jPanel2Layout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jLabel4)).addPreferredGap(0, -1, Short.MAX_VALUE).add((GroupLayout.Group)jPanel2Layout.createParallelGroup(1).add((Component)this.jToggleButton3).add((Component)this.colorSelectorPanel1, -2, -1, -2).add((Component)this.jToggleButton1).add((Component)this.jToggleButton2)).add(30, 30, 30)));
        this.jPanelPreview.setBorder(BorderFactory.createTitledBorder(NbBundle.getMessage(TableStyleDesigner.class, (String)"TableStyleDesigner.jPanelPreview.border.title")));
        this.jPanelPreview.setMinimumSize(new Dimension(200, 100));
        this.jPanelPreview.setLayout(new BorderLayout());
        GroupLayout layout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)layout);
        layout.setHorizontalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add((Component)this.jPanel2, -1, -1, Short.MAX_VALUE).add((Component)this.jPanel1, -2, -1, -2)).addPreferredGap(0).add((Component)this.jPanelPreview, -1, 200, Short.MAX_VALUE).addContainerGap()));
        layout.setVerticalGroup((GroupLayout.Group)layout.createParallelGroup(1).add((GroupLayout.Group)layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)layout.createParallelGroup(2).add(1, (Component)this.jPanelPreview, -1, 235, Short.MAX_VALUE).add((GroupLayout.Group)layout.createSequentialGroup().add((Component)this.jPanel1, -1, -1, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.jPanel2, -2, 89, -2))).addContainerGap()));
    }

    private void jComboBoxColorsActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void jComboBoxVariationsActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void jToggleButton1ActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void jToggleButton2ActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void colorSelectorPanel1ActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void jCheckBox1ActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    private void jToggleButton3ActionPerformed(ActionEvent evt) {
        this.updatePreview();
    }

    public void updatePreview() {
        Tag var;
        if (this.previewPanel == null) {
            return;
        }
        String s = "" + this.jComboBoxColors.getSelectedItem();
        Color c = ColorSchemaGenerator.getColor((String)s);
        if (c != null) {
            this.previewPanel.setColor(c);
        }
        if ((var = (Tag)this.jComboBoxVariations.getSelectedItem()) != null) {
            this.previewPanel.setVariant((String)var.getValue());
        }
        this.previewPanel.setBorderType(this.jToggleButton1.isSelected() ? 0 : (this.jToggleButton2.isSelected() ? 1 : 2));
        this.previewPanel.setBorderColor(this.colorSelectorPanel1.getColor());
        this.previewPanel.setZebra(this.jCheckBox1.isSelected());
    }

    public List<JRDesignStyle> createStyles(String baseName) {
        ArrayList<JRDesignStyle> styles = new ArrayList<JRDesignStyle>();
        JRDesignStyle tableStyle = new JRDesignStyle();
        tableStyle.setName(baseName);
        if (this.jToggleButton1.isSelected() || this.jToggleButton2.isSelected()) {
            tableStyle.getLineBox().getPen().setLineColor(this.colorSelectorPanel1.getColor());
            tableStyle.getLineBox().getPen().setLineWidth(1.0f);
        } else {
            tableStyle.getLineBox().getTopPen().setLineColor(this.colorSelectorPanel1.getColor());
            tableStyle.getLineBox().getTopPen().setLineWidth(1.0f);
            tableStyle.getLineBox().getBottomPen().setLineColor(this.colorSelectorPanel1.getColor());
            tableStyle.getLineBox().getBottomPen().setLineWidth(1.0f);
        }
        styles.add(tableStyle);
        JRDesignStyle tableHeaderStyle = new JRDesignStyle();
        tableHeaderStyle.setName(baseName + "_TH");
        if (this.jToggleButton1.isSelected()) {
            tableHeaderStyle.getLineBox().getPen().setLineColor(this.colorSelectorPanel1.getColor());
            tableHeaderStyle.getLineBox().getPen().setLineWidth(0.5f);
        } else {
            tableHeaderStyle.getLineBox().getBottomPen().setLineColor(this.colorSelectorPanel1.getColor());
            tableHeaderStyle.getLineBox().getBottomPen().setLineWidth(0.5f);
            tableHeaderStyle.getLineBox().getTopPen().setLineColor(this.colorSelectorPanel1.getColor());
            tableHeaderStyle.getLineBox().getTopPen().setLineWidth(0.5f);
        }
        tableHeaderStyle.setMode(ModeEnum.OPAQUE);
        tableHeaderStyle.setBackcolor(ColorSchemaGenerator.createColor((Color)this.previewPanel.getColor(), (int)3, (String)this.previewPanel.getVariant()));
        styles.add(tableHeaderStyle);
        JRDesignStyle columnHeaderStyle = new JRDesignStyle();
        columnHeaderStyle.setName(baseName + "_CH");
        if (this.jToggleButton1.isSelected()) {
            columnHeaderStyle.getLineBox().getPen().setLineColor(this.colorSelectorPanel1.getColor());
            columnHeaderStyle.getLineBox().getPen().setLineWidth(0.5f);
        } else {
            columnHeaderStyle.getLineBox().getBottomPen().setLineColor(this.colorSelectorPanel1.getColor());
            columnHeaderStyle.getLineBox().getBottomPen().setLineWidth(0.5f);
            columnHeaderStyle.getLineBox().getTopPen().setLineColor(this.colorSelectorPanel1.getColor());
            columnHeaderStyle.getLineBox().getTopPen().setLineWidth(0.5f);
        }
        columnHeaderStyle.setMode(ModeEnum.OPAQUE);
        columnHeaderStyle.setBackcolor(ColorSchemaGenerator.createColor((Color)this.previewPanel.getColor(), (int)2, (String)this.previewPanel.getVariant()));
        styles.add(columnHeaderStyle);
        JRDesignStyle cellStyle = new JRDesignStyle();
        cellStyle.setName(baseName + "_TD");
        if (this.jToggleButton1.isSelected()) {
            cellStyle.getLineBox().getPen().setLineColor(this.colorSelectorPanel1.getColor());
            cellStyle.getLineBox().getPen().setLineWidth(0.5f);
        } else {
            cellStyle.getLineBox().getBottomPen().setLineColor(this.colorSelectorPanel1.getColor());
            cellStyle.getLineBox().getBottomPen().setLineWidth(0.5f);
            cellStyle.getLineBox().getTopPen().setLineColor(this.colorSelectorPanel1.getColor());
            cellStyle.getLineBox().getTopPen().setLineWidth(0.5f);
        }
        cellStyle.setMode(ModeEnum.OPAQUE);
        cellStyle.setBackcolor(Color.WHITE);
        if (this.jCheckBox1.isSelected()) {
            JRDesignConditionalStyle condStyle = new JRDesignConditionalStyle();
            condStyle.setConditionExpression((JRExpression)Misc.createExpression((String)"java.lang.Boolean", (String)"new Boolean($V{REPORT_COUNT}.intValue()%2==0)"));
            Color c = ColorSchemaGenerator.createColor((Color)this.previewPanel.getColor(), (int)2, (String)this.previewPanel.getVariant());
            c = ColorSchemaGenerator.overlayWhite((Color)c);
            c = ColorSchemaGenerator.overlayWhite((Color)c);
            condStyle.setBackcolor(c);
            cellStyle.addConditionalStyle((JRConditionalStyle)condStyle);
        }
        styles.add(cellStyle);
        return styles;
    }
}

