/*
 * Decompiled with CFR 0.152.
 */
package rex.graphics.datasourcetree.elements;

import javax.swing.ImageIcon;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import rex.graphics.datasourcetree.elements.DataSourceTreeElement;
import rex.metadata.ServerMetadata;
import rex.utils.DOM;
import rex.utils.I18n;
import rex.utils.S;
import rex.xmla.XMLADiscoverProperties;
import rex.xmla.XMLADiscoverRestrictions;
import rex.xmla.XMLAObjectsFactory;

public class DataSourceElement
implements DataSourceTreeElement {
    private String dataSourceName;
    private String dataSourceDescription;
    private String URL;
    private String providerName;
    private String providerType;
    private String authenticationMode;
    private ServerMetadata parent;
    static ImageIcon icon = S.getAppIcon("server.gif");
    static ImageIcon secureicon = S.getAppIcon("secureserver.gif");

    public DataSourceElement(ServerMetadata svm, Node rowNode) {
        this.parent = svm;
        NodeList nl = rowNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            if (nl.item(i).getNodeType() != 1) continue;
            if (nl.item(i).getNodeName().equals("DataSourceName")) {
                this.dataSourceName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("DataSourceDescription")) {
                this.dataSourceDescription = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("URL")) {
                this.URL = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("ProviderName")) {
                this.providerName = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (nl.item(i).getNodeName().equals("ProviderType")) {
                this.providerType = DOM.getTextFromDOMElement(nl.item(i));
                continue;
            }
            if (!nl.item(i).getNodeName().equals("AuthenticationMode")) continue;
            this.authenticationMode = DOM.getTextFromDOMElement(nl.item(i));
        }
    }

    @Override
    public DataSourceTreeElement[] getChildren() {
        XMLADiscoverRestrictions restrictions = XMLAObjectsFactory.newXMLADiscoverRestrictions();
        XMLADiscoverProperties properties = XMLAObjectsFactory.newXMLADiscoverProperties();
        properties.setDataSourceInfo(this.dataSourceName);
        return this.parent.getCatalogList(restrictions, properties);
    }

    @Override
    public String toString() {
        if (this.dataSourceName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "" + this.dataSourceName;
    }

    public String getDataSourceName() {
        return this.dataSourceName;
    }

    @Override
    public ImageIcon getIcon() {
        if (this.parent.isHTTPS()) {
            return secureicon;
        }
        return icon;
    }

    @Override
    public String getToolTip() {
        if (this.dataSourceName == null) {
            return I18n.getString("toolTip.notInitialized");
        }
        return "<html>" + this.dataSourceName + "<br>" + I18n.getString("toolTip.url") + this.URL + "<br>" + I18n.getString("toolTip.desc") + this.dataSourceDescription + "<br>" + I18n.getString("toolTip.providerName") + this.providerName + "<br>" + I18n.getString("toolTip.providerType") + this.providerType + "<br>" + I18n.getString("toolTip.authMode") + this.authenticationMode + "</html>";
    }

    @Override
    public String[] getPopUpActionList() {
        return null;
    }

    @Override
    public ServerMetadata getServerMetaData() {
        return this.parent;
    }

    @Override
    public String getDataSourceInfo() {
        return this.dataSourceName;
    }
}

