/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor;

import java.awt.Component;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledDocument;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.JumpList;
import org.netbeans.editor.Utilities;
import org.netbeans.editor.ext.ExtSyntaxSupport;
import org.netbeans.lib.editor.util.swing.DocumentUtilities;
import org.openide.ErrorManager;
import org.openide.cookies.EditorCookie;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.Line;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.windows.TopComponent;

public class NbEditorUtilities {
    public static DataObject getDataObject(Document document) {
        Object object;
        Object object2 = object = document == null ? null : document.getProperty("stream");
        if (object instanceof DataObject) {
            return (DataObject)object;
        }
        return null;
    }

    public static boolean isDocumentActive(Document document) {
        StyledDocument styledDocument;
        EditorCookie editorCookie;
        DataObject dataObject = NbEditorUtilities.getDataObject(document);
        return dataObject != null && (editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class)) != null && (styledDocument = editorCookie.getDocument()) == document;
    }

    public static FileObject getFileObject(Document document) {
        Object object = document.getProperty("stream");
        if (object instanceof FileObject) {
            return (FileObject)object;
        }
        if (object instanceof DataObject) {
            return ((DataObject)object).getPrimaryFile();
        }
        return null;
    }

    public static int[] getIdentifierAndMethodBlock(BaseDocument baseDocument, int n) throws BadLocationException {
        int[] nArray;
        int[] nArray2 = Utilities.getIdentifierBlock((BaseDocument)baseDocument, (int)n);
        if (nArray2 != null && (nArray = ((ExtSyntaxSupport)baseDocument.getSyntaxSupport()).getFunctionBlock(nArray2)) != null) {
            return new int[]{nArray2[0], nArray2[1], nArray[1]};
        }
        return nArray2;
    }

    public static Line getLine(BaseDocument baseDocument, int n, boolean bl) {
        Line.Set set;
        LineCookie lineCookie;
        DataObject dataObject = NbEditorUtilities.getDataObject((Document)baseDocument);
        if (dataObject != null && (lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) != null && (set = lineCookie.getLineSet()) != null) {
            try {
                int n2 = Utilities.getLineOffset((BaseDocument)baseDocument, (int)n);
                return bl ? set.getOriginal(n2) : set.getCurrent(n2);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Line getLine(Document document, int n, boolean bl) {
        Line.Set set;
        LineCookie lineCookie;
        DataObject dataObject = NbEditorUtilities.getDataObject(document);
        if (dataObject != null && (lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class)) != null && (set = lineCookie.getLineSet()) != null) {
            Element element = document instanceof AbstractDocument ? ((AbstractDocument)document).getParagraphElement(0).getParentElement() : document.getDefaultRootElement();
            int n2 = element.getElementIndex(n);
            return bl ? set.getOriginal(n2) : set.getCurrent(n2);
        }
        return null;
    }

    public static Line getLine(JTextComponent jTextComponent, boolean bl) {
        return NbEditorUtilities.getLine((BaseDocument)jTextComponent.getDocument(), jTextComponent.getCaret().getDot(), bl);
    }

    public static TopComponent getTopComponent(JTextComponent jTextComponent) {
        return (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jTextComponent);
    }

    public static TopComponent getOuterTopComponent(JTextComponent jTextComponent) {
        TopComponent topComponent = null;
        TopComponent topComponent2 = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, jTextComponent);
        while (topComponent2 != null) {
            topComponent = topComponent2;
            topComponent2 = (TopComponent)SwingUtilities.getAncestorOfClass(TopComponent.class, (Component)topComponent);
        }
        return topComponent;
    }

    public static void addJumpListEntry(DataObject dataObject) {
        final EditorCookie editorCookie = (EditorCookie)dataObject.getCookie(EditorCookie.class);
        if (editorCookie != null) {
            final Timer timer = new Timer(500, null);
            timer.addActionListener(new ActionListener(){
                private int countDown = 10;

                public void actionPerformed(ActionEvent actionEvent) {
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            if (--countDown >= 0) {
                                JEditorPane[] jEditorPaneArray = editorCookie.getOpenedPanes();
                                if (jEditorPaneArray != null && jEditorPaneArray.length > 0) {
                                    JumpList.checkAddEntry((JTextComponent)jEditorPaneArray[0]);
                                    timer.stop();
                                }
                            } else {
                                timer.stop();
                            }
                        }
                    });
                }
            });
            timer.start();
        }
    }

    public static String[] mergeStringArrays(String[] stringArray, String[] stringArray2) {
        int n;
        String[] stringArray3 = new String[stringArray.length + stringArray2.length];
        for (n = 0; n < stringArray.length; ++n) {
            stringArray3[n] = stringArray[n];
        }
        for (n = 0; n < stringArray2.length; ++n) {
            stringArray3[stringArray.length + n] = stringArray2[n];
        }
        return stringArray3;
    }

    public static String getMimeType(Document document) {
        return DocumentUtilities.getMimeType((Document)document);
    }

    public static String getMimeType(JTextComponent jTextComponent) {
        return DocumentUtilities.getMimeType((JTextComponent)jTextComponent);
    }

    public static void invalidArgument(String string) {
        IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Invalid argument");
        Toolkit.getDefaultToolkit().beep();
        ErrorManager errorManager = (ErrorManager)Lookup.getDefault().lookup(ErrorManager.class);
        if (errorManager != null) {
            errorManager.annotate((Throwable)illegalArgumentException, 256, illegalArgumentException.getMessage(), NbEditorUtilities.getString(string), null, null);
        }
        throw illegalArgumentException;
    }

    private static String getString(String string) {
        try {
            return NbBundle.getBundle(NbEditorUtilities.class).getString(string);
        }
        catch (MissingResourceException missingResourceException) {
            ErrorManager.getDefault().notify(1, (Throwable)missingResourceException);
            return string;
        }
    }
}

