/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages;

import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParseException;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.languages.TokenInput;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.FeatureList;
import org.netbeans.modules.languages.parser.LLSyntaxAnalyser;
import org.netbeans.modules.languages.parser.Parser;
import org.netbeans.modules.languages.parser.StringInput;
import org.netbeans.modules.languages.parser.SyntaxError;
import org.netbeans.modules.languages.parser.TokenInputUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Language
extends org.netbeans.api.languages.Language {
    public static Language create(String string) {
        return new EmptyLanguage(string);
    }

    @Override
    public abstract String getMimeType();

    public abstract Parser getParser();

    public abstract LLSyntaxAnalyser getAnalyser();

    public abstract FeatureList getFeatureList();

    public abstract void addPropertyChangeListener(PropertyChangeListener var1);

    public abstract void removePropertyChangeListener(PropertyChangeListener var1);

    public abstract int getTokenID(String var1);

    public abstract int getTokenTypeCount();

    public abstract String getTokenType(int var1);

    public abstract int getNTID(String var1);

    public abstract int getNTCount();

    public abstract String getNT(int var1);

    public abstract List<Language> getImportedLanguages();

    public abstract Feature getPreprocessorImport();

    public abstract Map<String, Feature> getTokenImports();

    @Override
    public ASTNode parse(InputStream inputStream) throws IOException, ParseException {
        ASTNode aSTNode;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));
        StringBuilder stringBuilder = new StringBuilder();
        String string = bufferedReader.readLine();
        while (string != null) {
            stringBuilder.append(string).append('\n');
            string = bufferedReader.readLine();
        }
        TokenInput tokenInput = TokenInputUtils.create(this, this.getParser(), new StringInput(stringBuilder.toString()));
        ASTNode aSTNode2 = this.getAnalyser().read(tokenInput, true, new ArrayList<SyntaxError>(), new boolean[]{false});
        Feature feature = this.getFeatureList().getFeature("AST");
        if (feature != null && aSTNode2 != null && (aSTNode = (ASTNode)feature.getValue("process", SyntaxContext.create(null, ASTPath.create(aSTNode2)))) != null) {
            aSTNode2 = aSTNode;
        }
        return aSTNode2;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EmptyLanguage
    extends Language {
        private String mimeType;
        private LLSyntaxAnalyser analyser = LLSyntaxAnalyser.createEmpty(this);
        private FeatureList featureList = new FeatureList();

        EmptyLanguage(String string) {
            this.mimeType = string;
        }

        @Override
        public String getMimeType() {
            return this.mimeType;
        }

        @Override
        public Parser getParser() {
            return null;
        }

        @Override
        public LLSyntaxAnalyser getAnalyser() {
            return this.analyser;
        }

        @Override
        public FeatureList getFeatureList() {
            return this.featureList;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        }

        @Override
        public int getTokenID(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getTokenTypeCount() {
            return 0;
        }

        @Override
        public String getTokenType(int n) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getNTID(String string) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public int getNTCount() {
            return 0;
        }

        @Override
        public String getNT(int n) {
            throw new UnsupportedOperationException("Not supported yet.");
        }

        @Override
        public List<Language> getImportedLanguages() {
            return Collections.emptyList();
        }

        @Override
        public Feature getPreprocessorImport() {
            return null;
        }

        @Override
        public Map<String, Feature> getTokenImports() {
            return Collections.emptyMap();
        }
    }
}

