/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.mongodb.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.mongodb.Installer;
import com.jaspersoft.ireport.mongodb.connection.MongoDbConnectionEditor;
import com.jaspersoft.ireport.mongodb.designer.MongoDbFieldsProvider;
import com.jaspersoft.mongodb.connection.MongoDbConnectionManager;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JREmptyDataSource;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JRDesignQuery;
import org.openide.util.NbBundle;

public class MongoDbConnection
extends JDBCConnection
implements WizardFieldsProvider {
    private static final String MONGO_URI_KEY = "MongoDB URI";
    private static final String USERNAME = "username";
    private static final String PASSWORD = "password";
    private String mongoURI;
    private String username;
    private String password;
    private com.jaspersoft.mongodb.connection.MongoDbConnection currentConnection;

    public MongoDbConnection() {
        this.setName(NbBundle.getMessage(MongoDbConnection.class, (String)"connectionName"));
    }

    public String getDescription() {
        return NbBundle.getMessage(MongoDbConnection.class, (String)"connectionType");
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new MongoDbConnectionEditor();
    }

    public Connection getConnection() {
        try {
            return this.createConnection();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private com.jaspersoft.mongodb.connection.MongoDbConnection createConnection() throws Exception {
        MongoDbConnectionManager connectionManager = Installer.getConnectionManager();
        if (this.currentConnection != null) {
            connectionManager.returnConnection(this.currentConnection);
        }
        connectionManager.setMongoURI(this.mongoURI);
        connectionManager.setUsername(this.username);
        connectionManager.setPassword(this.password);
        return connectionManager.borrowConnection();
    }

    public String getQueryLanguage() {
        return "MongoDbQuery";
    }

    public JRDataSource getJRDataSource() {
        return new JREmptyDataSource();
    }

    public boolean isJDBCConnection() {
        return true;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(MONGO_URI_KEY, this.getMongoURI());
        map.put(USERNAME, this.getUsername());
        map.put(PASSWORD, this.getPassword());
        return map;
    }

    public void loadProperties(HashMap map) {
        this.setMongoURI((String)map.get(MONGO_URI_KEY));
        this.setUsername((String)map.get(USERNAME));
        this.setPassword((String)map.get(PASSWORD));
    }

    public String getMongoURI() {
        return this.mongoURI;
    }

    public void setMongoURI(String mongoURI) {
        this.mongoURI = mongoURI;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void test() throws Exception {
        com.jaspersoft.mongodb.connection.MongoDbConnection connection = null;
        String errorMessage = null;
        try {
            connection = this.createConnection();
            if (connection != null) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), connection.test(), "", 1);
                return;
            }
            errorMessage = "A connection could not be created. Please review the IDE log";
        }
        catch (Exception e) {
            e.printStackTrace();
            errorMessage = String.valueOf(e);
        }
        finally {
            if (connection != null) {
                Installer.getConnectionManager().returnConnection(connection);
            }
        }
        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Error: " + String.valueOf(errorMessage), "", 0);
    }

    public String designQuery(String query) {
        return query;
    }

    public List<JRDesignField> readFields(String query) throws Exception {
        MongoDbFieldsProvider provider = new MongoDbFieldsProvider();
        ArrayList<JRDesignField> result = new ArrayList<JRDesignField>();
        JRDesignDataset dataset = new JRDesignDataset(true);
        JRDesignQuery designQuery = new JRDesignQuery();
        designQuery.setLanguage("MongoDbQuery");
        designQuery.setText(query);
        dataset.setQuery(designQuery);
        HashMap parameters = new HashMap();
        JRField[] fields = provider.getFields((IReportConnection)this, (JRDataset)dataset, parameters);
        for (int i = 0; i < fields.length; ++i) {
            result.add((JRDesignField)fields[i]);
        }
        return result;
    }

    public boolean supportsDesign() {
        return false;
    }
}

