/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.outline.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.actions.AddDatasetAction;
import com.jaspersoft.ireport.designer.actions.CompileReportAction;
import com.jaspersoft.ireport.designer.actions.RemoveMarginsAction;
import com.jaspersoft.ireport.designer.dnd.DnDUtilities;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.menu.EditPageFormatAction;
import com.jaspersoft.ireport.designer.menu.EditQueryAction;
import com.jaspersoft.ireport.designer.menu.OpenReportDirectoryInFavoritesAction;
import com.jaspersoft.ireport.designer.outline.nodes.ColumnDirectionProperty;
import com.jaspersoft.ireport.designer.outline.nodes.DatasetNode;
import com.jaspersoft.ireport.designer.outline.nodes.ExpressionHolder;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.designer.outline.nodes.ReportChildren;
import com.jaspersoft.ireport.designer.sheet.JRImportsProperty;
import com.jaspersoft.ireport.designer.sheet.JRPropertiesMapProperty;
import com.jaspersoft.ireport.designer.sheet.Tag;
import com.jaspersoft.ireport.designer.sheet.editors.ComboBoxPropertyEditor;
import com.jaspersoft.ireport.designer.sheet.properties.EnumProperty;
import com.jaspersoft.ireport.designer.sheet.properties.LanguageProperty;
import com.jaspersoft.ireport.designer.sheet.properties.WhenNoDataTypeProperty;
import com.jaspersoft.ireport.designer.undo.ObjectPropertyUndoableEdit;
import com.jaspersoft.ireport.designer.wizards.ReportGroupWizardAction;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.datatransfer.Transferable;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignGroup;
import net.sf.jasperreports.engine.design.JRDesignSection;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import org.openide.ErrorManager;
import org.openide.actions.PasteAction;
import org.openide.cookies.SaveCookie;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.nodes.PropertySupport;
import org.openide.nodes.Sheet;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.actions.NodeAction;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.PasteType;
import org.openide.util.lookup.Lookups;
import org.openide.util.lookup.ProxyLookup;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReportNode
extends IRAbstractNode
implements PropertyChangeListener,
ExpressionHolder {
    JasperDesign jd = null;
    public static final Action testPropertiesAction = new NodeAction(){

        protected void performAction(Node[] activatedNodes) {
            JasperDesign jd = (JasperDesign)activatedNodes[0].getLookup().lookup(JasperDesign.class);
            jd.setName("test name");
            jd.setPageWidth(700);
            jd.setPageHeight(400);
            jd.setOrientation(OrientationEnum.LANDSCAPE);
            jd.setTopMargin(10);
            jd.setBottomMargin(20);
            jd.setLeftMargin(35);
            jd.setRightMargin(5);
        }

        protected boolean enable(Node[] activatedNodes) {
            return activatedNodes.length > 0;
        }

        public String getName() {
            return "Test document properties changes";
        }

        public HelpCtx getHelpCtx() {
            return null;
        }
    };

    public ReportNode(JasperDesign jd, Lookup doLkp) {
        super((Children)new ReportChildren(jd, doLkp), (Lookup)new ProxyLookup(new Lookup[]{Lookups.singleton((Object)jd), doLkp}));
        this.jd = jd;
        jd.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        this.updateSectionListeners();
        this.setIconBaseWithExtension("com/jaspersoft/ireport/designer/resources/report-16.png");
    }

    public void updateSectionListeners() {
        ((JRDesignSection)this.jd.getDetailSection()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
        ((JRDesignSection)this.jd.getDetailSection()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        for (int i = 0; i < this.jd.getGroupsList().size(); ++i) {
            JRDesignGroup grp = (JRDesignGroup)this.jd.getGroupsList().get(i);
            grp.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
            grp.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            if ((JRDesignSection)grp.getGroupHeaderSection() != null) {
                ((JRDesignSection)grp.getGroupHeaderSection()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
                ((JRDesignSection)grp.getGroupHeaderSection()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            }
            if ((JRDesignSection)grp.getGroupFooterSection() == null) continue;
            ((JRDesignSection)grp.getGroupFooterSection()).getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
            ((JRDesignSection)grp.getGroupFooterSection()).getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
        }
    }

    public JasperDesign getJasperDesign() {
        return this.jd;
    }

    public String getDisplayName() {
        return "" + this.jd.getName();
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        JRDesignDataset dataset;
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        int dropAction = DnDUtilities.getTransferAction(t);
        if (null != dropNode && dropNode instanceof DatasetNode && null != (dataset = ((DatasetNode)dropNode).getDataset())) {
            return new PasteType(){

                public Transferable paste() throws IOException {
                    try {
                        JRDesignDataset newDataset = (JRDesignDataset)dataset.clone();
                        String name = newDataset.getName();
                        int i = 1;
                        while (true) {
                            if (!ReportNode.this.getJasperDesign().getDatasetMap().containsKey(name + "_" + i)) break;
                            ++i;
                        }
                        newDataset.setName(name + "_" + i);
                        ReportNode.this.getJasperDesign().addDataset(newDataset);
                    }
                    catch (JRException ex) {
                        ex.printStackTrace();
                    }
                    return null;
                }
            };
        }
        return null;
    }

    protected void createPasteTypes(Transferable t, List s) {
        super.createPasteTypes(t, s);
        PasteType paste = this.getDropType(t, 2, -1);
        if (null != paste) {
            s.add(paste);
        }
    }

    protected Sheet createSheet() {
        Sheet sheet = super.createSheet();
        Sheet.Set reportPropertiesSet = Sheet.createPropertiesSet();
        reportPropertiesSet.setName("REPORT_PROPERTIES");
        reportPropertiesSet.setDisplayName(I18n.getString("ReportNode.Display.Report_properties"));
        reportPropertiesSet.put((Node.Property)new NameProperty(this.jd));
        sheet.put(reportPropertiesSet);
        Sheet.Set pageSizeSet = Sheet.createPropertiesSet();
        pageSizeSet.setName("PAGE_SIZE");
        pageSizeSet.setDisplayName(I18n.getString("ReportNode.Display.Pagesize"));
        pageSizeSet.put((Node.Property)new PageWidthProperty(this.jd));
        pageSizeSet.put((Node.Property)new PageHeightProperty(this.jd));
        pageSizeSet.put((Node.Property)new OrientationProperty(this.jd));
        sheet.put(pageSizeSet);
        Sheet.Set marginsSet = Sheet.createPropertiesSet();
        marginsSet.setName("PAGE_MARGINS");
        marginsSet.setDisplayName(I18n.getString("ReportNode.Display.Margins"));
        marginsSet.put((Node.Property)new LeftMarginProperty(this.jd));
        marginsSet.put((Node.Property)new RightMarginProperty(this.jd));
        marginsSet.put((Node.Property)new TopMarginProperty(this.jd));
        marginsSet.put((Node.Property)new BottomMarginProperty(this.jd));
        sheet.put(marginsSet);
        Sheet.Set columnsSet = Sheet.createPropertiesSet();
        columnsSet.setName("PAGE_COLUMNS");
        columnsSet.setDisplayName(I18n.getString("ReportNode.Display.Columns"));
        columnsSet.put((Node.Property)new ColumnCountProperty(this.jd));
        columnsSet.put((Node.Property)new ColumnWidthProperty(this.jd));
        columnsSet.put((Node.Property)new ColumnSpacingProperty(this.jd));
        columnsSet.put((Node.Property)new PrintOrderProperty(this.jd));
        sheet.put(columnsSet);
        Sheet.Set moreSet = Sheet.createPropertiesSet();
        moreSet.setName("PAGE_MORE");
        moreSet.setDisplayName(I18n.getString("ReportNode.Display.More"));
        DatasetNode.fillDatasetPropertySet(moreSet, this.jd.getMainDesignDataset(), this.jd);
        moreSet.put((Node.Property)new JRPropertiesMapProperty((JRPropertiesHolder)this.jd));
        moreSet.put((Node.Property)new TitleNewPageProperty(this.jd));
        moreSet.put((Node.Property)new SummaryNewPageProperty(this.jd));
        moreSet.put((Node.Property)new SummaryWithPageHeaderAndFooterProperty(this.jd));
        moreSet.put((Node.Property)new FloatColumnFooterProperty(this.jd));
        moreSet.put((Node.Property)new IgnorePaginationProperty(this.jd));
        moreSet.put((Node.Property)new ColumnDirectionProperty(this.jd));
        moreSet.put((Node.Property)new WhenNoDataTypeProperty(this.jd));
        moreSet.put((Node.Property)new LanguageProperty(this.jd));
        moreSet.put((Node.Property)new FormatFactoryClassProperty(this.jd));
        moreSet.put((Node.Property)new JRImportsProperty(this.jd));
        sheet.put(moreSet);
        return sheet;
    }

    public Action[] getActions(boolean context) {
        Action[] actions = super.getActions(context);
        ArrayList<Object> myactions = new ArrayList<Object>();
        myactions.add(SystemAction.get(EditPageFormatAction.class));
        myactions.add(SystemAction.get(RemoveMarginsAction.class));
        myactions.add(null);
        myactions.add(SystemAction.get(CompileReportAction.class));
        myactions.add(null);
        for (int i = 0; i < actions.length; ++i) {
            myactions.add(actions[i]);
        }
        myactions.add(null);
        myactions.add(SystemAction.get(EditQueryAction.class));
        myactions.add(null);
        myactions.add(SystemAction.get(ReportGroupWizardAction.class));
        myactions.add(SystemAction.get(AddDatasetAction.class));
        myactions.add(SystemAction.get(PasteAction.class));
        myactions.add(null);
        myactions.add(SystemAction.get(OpenReportDirectoryInFavoritesAction.class));
        return myactions.toArray(new Action[myactions.size()]);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        IReportManager.getInstance().notifyReportChange();
        if (evt.getPropertyName() == null) {
            return;
        }
        if (evt.getPropertyName().equals("background") || evt.getPropertyName().equals("title") || evt.getPropertyName().equals("pageHeader") || evt.getPropertyName().equals("columnHeader") || evt.getPropertyName().equals("detail") || evt.getPropertyName().equals("columnFooter") || evt.getPropertyName().equals("pageFooter") || evt.getPropertyName().equals("lastPageFooter") || evt.getPropertyName().equals("summary") || evt.getPropertyName().equals("noData") || evt.getPropertyName().equals("groups") || evt.getPropertyName().equals("groupHeader") || evt.getPropertyName().equals("groupFooter") || evt.getPropertyName().equals("datasets") || evt.getPropertyName().equals("bands")) {
            this.updateSectionListeners();
            ((ReportChildren)this.getChildren()).updateChildren();
        }
        if (evt.getPropertyName().equals("name")) {
            this.fireDisplayNameChange(null, this.jd.getName());
        }
        if (evt.getPropertyName().equals("columnCount") || evt.getPropertyName().equals("columnSpacing") || evt.getPropertyName().equals("columnWidth") || evt.getPropertyName().equals("orientation") || evt.getPropertyName().equals("leftMargin") || evt.getPropertyName().equals("rightMargin") || evt.getPropertyName().equals("pageWidth")) {
            this.firePropertyChange("columnCount", null, this.jd.getColumnCount());
            this.firePropertyChange("columnSpacing", null, this.jd.getColumnSpacing());
            this.firePropertyChange("columnWidth", null, this.jd.getColumnWidth());
        }
        if (ModelUtils.containsProperty(this.getPropertySets(), evt.getPropertyName())) {
            this.firePropertyChange(evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
        }
        if (evt.getPropertyName().equals("groups")) {
            for (int i = 0; i < this.jd.getGroupsList().size(); ++i) {
                JRDesignGroup grp = (JRDesignGroup)this.jd.getGroupsList().get(i);
                grp.getEventSupport().removePropertyChangeListener((PropertyChangeListener)this);
                grp.getEventSupport().addPropertyChangeListener((PropertyChangeListener)this);
            }
        }
    }

    public static void adjustColumns(JasperDesign jasperDesign) {
        int total = jasperDesign.getPageWidth();
        total -= jasperDesign.getLeftMargin();
        total -= jasperDesign.getRightMargin();
        if (jasperDesign.getColumnCount() > 1) {
            total -= jasperDesign.getColumnSpacing() * (jasperDesign.getColumnCount() - 1);
        }
        ObjectPropertyUndoableEdit urob2 = new ObjectPropertyUndoableEdit(jasperDesign, "ColumnWidth", Integer.TYPE, jasperDesign.getColumnWidth(), total /= jasperDesign.getColumnCount());
        jasperDesign.setColumnWidth(total);
        IReportManager.getInstance().addUndoableEdit(urob2, true);
        if (jasperDesign.getColumnCount() == 1 && jasperDesign.getColumnSpacing() > 0) {
            ObjectPropertyUndoableEdit urob3 = new ObjectPropertyUndoableEdit(jasperDesign, "ColumnSpacing", Integer.TYPE, jasperDesign.getColumnSpacing(), 0);
            jasperDesign.setColumnSpacing(0);
            IReportManager.getInstance().addUndoableEdit(urob3, true);
        }
    }

    public <T extends Node.Cookie> T getCookie(Class<T> type) {
        Object o = this.getLookup().lookup(type);
        if (o == null && SaveCookie.class.isAssignableFrom(type)) {
            o = IReportManager.getInstance().getActiveVisualView().getEditorSupport().getDataObject().getLookup().lookup(SaveCookie.class);
        }
        if (o == null && Node.Cookie.class.isAssignableFrom(type)) {
            o = super.getCookie(type);
        }
        return (T)(o instanceof Node.Cookie ? (Node.Cookie)o : null);
    }

    @Override
    public boolean hasExpression(JRDesignExpression ex) {
        return this.jd.getFilterExpression() == ex;
    }

    @Override
    public ExpressionContext getExpressionContext(JRDesignExpression ex) {
        return new ExpressionContext(this.jd.getMainDesignDataset());
    }

    private static final class FormatFactoryClassProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public FormatFactoryClassProperty(JasperDesign jd) {
            super("formatFactoryClass", String.class, I18n.getString("ReportNode.Property.FactoryClass"), I18n.getString("ReportNode.Property.FactoryClassdetail"), true, true);
            this.jasperDesign = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getFormatFactoryClass() == null ? "" : this.jasperDesign.getFormatFactoryClass();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.jasperDesign.getFormatFactoryClass();
                String newValue = val == null || ((String)val).trim().length() == 0 ? null : ((String)val).trim();
                this.jasperDesign.setFormatFactoryClass(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "FormatFactoryClass", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class PrintOrderProperty
    extends EnumProperty {
        private final JasperDesign jasperDesign;
        private ComboBoxPropertyEditor editor;

        public PrintOrderProperty(JasperDesign jd) {
            super(PrintOrderEnum.class, jd);
            this.jasperDesign = jd;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getName() {
            return "printOrder";
        }

        public String getDisplayName() {
            return I18n.getString("ReportNode.Property.Print");
        }

        public String getShortDescription() {
            return I18n.getString("ReportNode.Property.Printdetail");
        }

        public List getTagList() {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag(PrintOrderEnum.VERTICAL, I18n.getString("ReportNode.Property.Vertical")));
            tags.add(new Tag(PrintOrderEnum.HORIZONTAL, I18n.getString("ReportNode.Property.Horizontal")));
            return tags;
        }

        public Object getPropertyValue() {
            return this.jasperDesign.getPrintOrderValue();
        }

        public Object getOwnPropertyValue() {
            return this.getPropertyValue();
        }

        public Object getDefaultValue() {
            return PrintOrderEnum.VERTICAL;
        }

        public void setPropertyValue(Object val) {
            this.jasperDesign.setPrintOrder((PrintOrderEnum)val);
        }
    }

    private static final class IgnorePaginationProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public IgnorePaginationProperty(JasperDesign jd) {
            super("isIgnorePagination", Boolean.class, I18n.getString("ReportNode.property.Pagination"), I18n.getString("ReportNode.property.Paginationdetail"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.isIgnorePagination();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                Boolean oldValue = this.jasperDesign.isIgnorePagination();
                Boolean newValue = (Boolean)val;
                this.jasperDesign.setIgnorePagination(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "IgnorePagination", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class FloatColumnFooterProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public FloatColumnFooterProperty(JasperDesign jd) {
            super("isFloatColumnFooter", Boolean.class, I18n.getString("ReportNode.Property.FloatColumnFooter"), I18n.getString("ReportNode.Property.FloatColumnFooterdetail"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.isFloatColumnFooter();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                Boolean oldValue = this.jasperDesign.isFloatColumnFooter();
                Boolean newValue = (Boolean)val;
                this.jasperDesign.setFloatColumnFooter(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "FloatColumnFooter", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class SummaryWithPageHeaderAndFooterProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public SummaryWithPageHeaderAndFooterProperty(JasperDesign jd) {
            super("isSummaryWithPageHeaderAndFooter", Boolean.class, I18n.getString("ReportNode.Property.SummaryWithPageHeaderAndFooter"), I18n.getString("ReportNode.Property.SummaryWithPageHeaderAndFooterdetails"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.isSummaryWithPageHeaderAndFooter();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                Boolean oldValue = this.jasperDesign.isSummaryWithPageHeaderAndFooter();
                Boolean newValue = (Boolean)val;
                this.jasperDesign.setSummaryWithPageHeaderAndFooter(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "SummaryWithPageHeaderAndFooter", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class SummaryNewPageProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public SummaryNewPageProperty(JasperDesign jd) {
            super("isSummaryNewPage", Boolean.class, I18n.getString("ReportNode.Property.Summary"), I18n.getString("ReportNode.Property.Summarydetails"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.isSummaryNewPage();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                Boolean oldValue = this.jasperDesign.isSummaryNewPage();
                Boolean newValue = (Boolean)val;
                this.jasperDesign.setSummaryNewPage(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "SummaryNewPage", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class TitleNewPageProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public TitleNewPageProperty(JasperDesign jd) {
            super("isTitleNewPage", Boolean.class, I18n.getString("ReportNode.Property.Title"), "ReportNode.Property.Titledetail", true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.isTitleNewPage();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Boolean) {
                Boolean oldValue = this.jasperDesign.isTitleNewPage();
                Boolean newValue = (Boolean)val;
                this.jasperDesign.setTitleNewPage(newValue.booleanValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "TitleNewPage", Boolean.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class OrientationProperty
    extends EnumProperty {
        private final JasperDesign jasperDesign;
        private ComboBoxPropertyEditor editor;

        public OrientationProperty(JasperDesign jd) {
            super(OrientationEnum.class, jd);
            this.jasperDesign = jd;
            this.setValue("suppressCustomEditor", Boolean.TRUE);
        }

        public String getName() {
            return "orientation";
        }

        public String getDisplayName() {
            return I18n.getString("ReportNode.Property.Orientation");
        }

        public String getShortDescription() {
            return I18n.getString("ReportNode.Property.Orientationdetails");
        }

        public List getTagList() {
            ArrayList<Tag> tags = new ArrayList<Tag>();
            tags.add(new Tag(OrientationEnum.PORTRAIT, I18n.getString("ReportNode.Orientation.Portrait")));
            tags.add(new Tag(OrientationEnum.LANDSCAPE, I18n.getString("ReportNode.Orientation.Landscape")));
            return tags;
        }

        public Object getPropertyValue() {
            return this.jasperDesign.getOrientationValue();
        }

        public Object getOwnPropertyValue() {
            return this.getPropertyValue();
        }

        public Object getDefaultValue() {
            return OrientationEnum.PORTRAIT;
        }

        public void setPropertyValue(Object alignment) {
            this.jasperDesign.setOrientation((OrientationEnum)alignment);
            int pWidth = this.jasperDesign.getPageWidth();
            int pHeight = this.jasperDesign.getPageHeight();
            if (this.jasperDesign.getOrientationValue() == OrientationEnum.LANDSCAPE && pWidth < pHeight || this.jasperDesign.getOrientationValue() == OrientationEnum.PORTRAIT && pWidth > pHeight) {
                this.jasperDesign.setPageWidth(pHeight);
                this.jasperDesign.setPageHeight(pWidth);
                ObjectPropertyUndoableEdit urob1 = new ObjectPropertyUndoableEdit(this.jasperDesign, "PageWidth", Integer.TYPE, pWidth, pHeight);
                IReportManager.getInstance().addUndoableEdit(urob1, true);
                ObjectPropertyUndoableEdit urob2 = new ObjectPropertyUndoableEdit(this.jasperDesign, "PageHeight", Integer.TYPE, pHeight, pWidth);
                IReportManager.getInstance().addUndoableEdit(urob2, true);
                if (this.jasperDesign.getColumnCount() > 0) {
                    int availableSpace = this.jasperDesign.getPageWidth() - this.jasperDesign.getLeftMargin() - this.jasperDesign.getRightMargin();
                    int columnWidth = (availableSpace -= (this.jasperDesign.getColumnCount() - 1) * this.jasperDesign.getColumnSpacing()) / this.jasperDesign.getColumnCount();
                    int oldColumnWidth = this.jasperDesign.getColumnWidth();
                    this.jasperDesign.setColumnWidth(columnWidth);
                    ObjectPropertyUndoableEdit urob3 = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnWidth", Integer.TYPE, oldColumnWidth, columnWidth);
                    IReportManager.getInstance().addUndoableEdit(urob3, true);
                }
            }
        }
    }

    private static final class ColumnSpacingProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public ColumnSpacingProperty(JasperDesign jd) {
            super("columnSpacing", Integer.class, I18n.getString("ReportNode.Property.ColumnSpacing"), I18n.getString("ReportNode.Property.ColumnSpacingdetails"), true, true);
            this.jasperDesign = jd;
        }

        public boolean canWrite() {
            return this.jasperDesign.getColumnCount() > 1;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getColumnSpacing();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getColumnSpacing();
                Integer newValue = (Integer)val;
                int available = this.jasperDesign.getPageWidth();
                available -= this.jasperDesign.getLeftMargin();
                available -= this.jasperDesign.getRightMargin();
                if (newValue > (available /= this.jasperDesign.getColumnCount() - 1)) {
                    IllegalArgumentException iae = this.annotateException(I18n.getString("ReportNode.Exception.ColumnSpace", available));
                    throw iae;
                }
                this.jasperDesign.setColumnSpacing(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnSpacing", Integer.TYPE, oldValue, newValue);
                available = this.jasperDesign.getPageWidth();
                available -= this.jasperDesign.getLeftMargin();
                available -= this.jasperDesign.getRightMargin();
                available -= (this.jasperDesign.getColumnCount() - 1) * newValue;
                ObjectPropertyUndoableEdit urob2 = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnWidth", Integer.TYPE, this.jasperDesign.getColumnWidth(), available /= this.jasperDesign.getColumnCount());
                this.jasperDesign.setColumnWidth(available);
                urob.concatenate(urob2);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class ColumnWidthProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public ColumnWidthProperty(JasperDesign jd) {
            super("columnWidth", Integer.class, I18n.getString("ReportNode.Property.ColumnWidth"), I18n.getString("ReportNode.Property.ColumnWidthdetails"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getColumnWidth();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getColumnWidth();
                Integer newValue = (Integer)val;
                int available = this.jasperDesign.getPageWidth();
                available -= this.jasperDesign.getLeftMargin();
                available -= this.jasperDesign.getRightMargin();
                if (newValue > (available /= this.jasperDesign.getColumnCount())) {
                    IllegalArgumentException iae = this.annotateException(I18n.getString("ReportNode.Exception.ColumnWidth", available));
                    throw iae;
                }
                this.jasperDesign.setColumnWidth(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnWidth", Integer.TYPE, oldValue, newValue);
                if (this.jasperDesign.getColumnCount() > 1) {
                    available = this.jasperDesign.getPageWidth();
                    available -= this.jasperDesign.getLeftMargin();
                    available -= this.jasperDesign.getRightMargin();
                    available -= this.jasperDesign.getColumnCount() * newValue;
                    ObjectPropertyUndoableEdit urob2 = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnWidth", Integer.TYPE, this.jasperDesign.getColumnSpacing(), available /= this.jasperDesign.getColumnCount() - 1);
                    this.jasperDesign.setColumnSpacing(available);
                    urob.concatenate(urob2);
                }
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class ColumnCountProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public ColumnCountProperty(JasperDesign jd) {
            super("columnCount", Integer.class, I18n.getString("ReportNode.Property.Columns"), I18n.getString("ReportNode.Property.Columnsdetails"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getColumnCount();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getColumnCount();
                Integer newValue = (Integer)val;
                if (newValue <= 0) {
                    IllegalArgumentException iae = this.annotateException(I18n.getString("ReportNode.Warning.Columns"));
                    throw iae;
                }
                this.jasperDesign.setColumnCount(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "ColumnCount", Integer.TYPE, oldValue, newValue);
                ReportNode.adjustColumns(this.jasperDesign);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }

        public IllegalArgumentException annotateException(String msg) {
            IllegalArgumentException iae = new IllegalArgumentException(msg);
            ErrorManager.getDefault().annotate((Throwable)iae, 4096, msg, msg, null, null);
            return iae;
        }
    }

    private static final class BottomMarginProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public BottomMarginProperty(JasperDesign jd) {
            super("bottomMargin", Integer.class, I18n.getString("ReportNode.Property.Bottomargin"), I18n.getString("ReportNode.Property.Bottomargindetails"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getBottomMargin();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getBottomMargin();
                Integer newValue = (Integer)val;
                this.jasperDesign.setBottomMargin(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "BottomMargin", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class TopMarginProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public TopMarginProperty(JasperDesign jd) {
            super("topMargin", Integer.class, I18n.getString("ReportNode.Property.Topmargin"), I18n.getString("ReportNode.Property.Topmargindetail"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getTopMargin();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getTopMargin();
                Integer newValue = (Integer)val;
                this.jasperDesign.setTopMargin(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "TopMargin", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class RightMarginProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public RightMarginProperty(JasperDesign jd) {
            super("rightMargin", Integer.class, I18n.getString("ReportNode.Property.Rightmargin"), I18n.getString("ReportNode.Property.Rightmargindetails"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getRightMargin();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getRightMargin();
                Integer newValue = (Integer)val;
                this.jasperDesign.setRightMargin(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "RightMargin", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
                ReportNode.adjustColumns(this.jasperDesign);
            }
        }
    }

    private static final class LeftMarginProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public LeftMarginProperty(JasperDesign jd) {
            super("leftMargin", Integer.class, I18n.getString("ReportNode.Property.Leftmargin"), I18n.getString("ReportNode.Property.Leftmargindetails"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getLeftMargin();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getLeftMargin();
                Integer newValue = (Integer)val;
                this.jasperDesign.setLeftMargin(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "LeftMargin", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
                ReportNode.adjustColumns(this.jasperDesign);
            }
        }
    }

    private static final class PageHeightProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public PageHeightProperty(JasperDesign jd) {
            super("pageHeight", Integer.class, I18n.getString("ReportNode.Property.Pageheight"), I18n.getString("ReportNode.Property.PageHeightdetails"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getPageHeight();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getPageHeight();
                Integer newValue = (Integer)val;
                this.jasperDesign.setPageHeight(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "PageHeight", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }

    private static final class PageWidthProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public PageWidthProperty(JasperDesign jd) {
            super("pageWidth", Integer.class, I18n.getString("ReportNode.Property.Pagewidth"), I18n.getString("ReportNode.Property.Pagewidthdetails"), true, true);
            this.jasperDesign = jd;
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getPageWidth();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof Integer) {
                Integer oldValue = this.jasperDesign.getPageWidth();
                Integer newValue = (Integer)val;
                this.jasperDesign.setPageWidth(newValue.intValue());
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "PageWidth", Integer.TYPE, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
                ReportNode.adjustColumns(this.jasperDesign);
            }
        }
    }

    private static final class NameProperty
    extends PropertySupport {
        private final JasperDesign jasperDesign;

        public NameProperty(JasperDesign jd) {
            super("name", String.class, I18n.getString("ReportNode.Property.ReportName"), I18n.getString("ReportNode.Property.DefaultName"), true, true);
            this.jasperDesign = jd;
            this.setValue("oneline", Boolean.TRUE);
        }

        public Object getValue() throws IllegalAccessException, InvocationTargetException {
            return this.jasperDesign.getName();
        }

        public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            if (val instanceof String) {
                String oldValue = this.jasperDesign.getName();
                String newValue = (String)val;
                this.jasperDesign.setName(newValue);
                ObjectPropertyUndoableEdit urob = new ObjectPropertyUndoableEdit(this.jasperDesign, "Name", String.class, oldValue, newValue);
                IReportManager.getInstance().addUndoableEdit(urob);
            }
        }
    }
}

