/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.options.jasperreports;

import com.jaspersoft.ireport.designer.IRLocalJasperReportsContext;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.options.IReportOptionsPanelController;
import com.jaspersoft.ireport.designer.options.OptionsPanel;
import com.jaspersoft.ireport.designer.options.jasperreports.JRPropertyDialog;
import com.jaspersoft.ireport.designer.options.jasperreports.JRPropertyTableCellRenderer;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableModel;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import org.jdesktop.layout.GroupLayout;
import org.jdesktop.swingx.JXTable;
import org.jdesktop.swingx.decorator.SortOrder;
import org.openide.util.NbBundle;

public class JROptionsPanel
extends JPanel
implements OptionsPanel {
    IReportOptionsPanelController controller = null;
    private boolean init = false;
    private JButton jButtonAddProperty;
    private JButton jButtonModify;
    private JButton jButtonRemove;
    private JButton jButtonRestoreDefault;
    private JLabel jLabel1;
    private JPanel jPanel1;
    private JScrollPane jScrollPane1;
    private JTable jTable1;

    public boolean setInit(boolean b) {
        boolean old = this.init;
        this.init = b;
        return old;
    }

    public boolean getInit() {
        return this.init;
    }

    public JROptionsPanel(IReportOptionsPanelController controller) {
        this.initComponents();
        this.controller = controller;
        this.jTable1.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                JROptionsPanel.this.jButtonRemove.setEnabled(JROptionsPanel.this.jTable1.getSelectedRowCount() > 0);
                JROptionsPanel.this.jButtonRestoreDefault.setEnabled(JROptionsPanel.this.jTable1.getSelectedRowCount() > 0);
                JROptionsPanel.this.jButtonModify.setEnabled(JROptionsPanel.this.jTable1.getSelectedRowCount() > 0);
            }
        });
        ((DefaultTableModel)this.jTable1.getModel()).addTableModelListener(new TableModelListener(){

            public void tableChanged(TableModelEvent e) {
                JROptionsPanel.this.notifyChange();
            }
        });
        JRPropertyTableCellRenderer cr = new JRPropertyTableCellRenderer();
        this.jTable1.getColumnModel().getColumn(0).setCellRenderer(cr);
        this.jTable1.getColumnModel().getColumn(1).setCellRenderer(cr);
        ((JXTable)this.jTable1).setColumnControlVisible(true);
        ((JXTable)this.jTable1).setSortOrder(0, SortOrder.ASCENDING);
    }

    public void notifyChange() {
        if (this.getInit()) {
            return;
        }
        if (this.controller != null) {
            this.controller.changed();
        }
    }

    private void initComponents() {
        this.jScrollPane1 = new JScrollPane();
        this.jTable1 = new JXTable();
        this.jPanel1 = new JPanel();
        this.jButtonAddProperty = new JButton();
        this.jButtonRemove = new JButton();
        this.jButtonRestoreDefault = new JButton();
        this.jButtonModify = new JButton();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.jTable1.setModel(new DefaultTableModel(new Object[0][], new String[]{"Name", "Value"}){
            Class[] types;
            boolean[] canEdit;
            {
                this.types = new Class[]{String.class, String.class};
                this.canEdit = new boolean[]{false, true};
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        });
        this.jTable1.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                JROptionsPanel.this.jTable1MouseClicked(evt);
            }
        });
        this.jScrollPane1.setViewportView(this.jTable1);
        this.jTable1.getColumnModel().getColumn(0).setHeaderValue(NbBundle.getMessage(JROptionsPanel.class, (String)"JROptionsPanel.jTable1.columnModel.title0"));
        this.jTable1.getColumnModel().getColumn(1).setHeaderValue(NbBundle.getMessage(JROptionsPanel.class, (String)"JROptionsPanel.jTable1.columnModel.title1"));
        this.add((Component)this.jScrollPane1, "Center");
        this.jButtonAddProperty.setText(NbBundle.getMessage(JROptionsPanel.class, (String)"JROptionsPanel.jButtonAddProperty.text"));
        this.jButtonAddProperty.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JROptionsPanel.this.jButtonAddPropertyActionPerformed(evt);
            }
        });
        this.jButtonRemove.setText(NbBundle.getMessage(JROptionsPanel.class, (String)"JROptionsPanel.jButtonRemove.text"));
        this.jButtonRemove.setEnabled(false);
        this.jButtonRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JROptionsPanel.this.jButtonRemoveActionPerformed(evt);
            }
        });
        this.jButtonRestoreDefault.setText(NbBundle.getMessage(JROptionsPanel.class, (String)"JROptionsPanel.jButtonRestoreDefault.text"));
        this.jButtonRestoreDefault.setEnabled(false);
        this.jButtonRestoreDefault.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JROptionsPanel.this.jButtonRestoreDefaultActionPerformed(evt);
            }
        });
        this.jButtonModify.setText(NbBundle.getMessage(JROptionsPanel.class, (String)"JROptionsPanel.jButtonModify.text"));
        this.jButtonModify.setEnabled(false);
        this.jButtonModify.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JROptionsPanel.this.jButtonModifyActionPerformed(evt);
            }
        });
        this.jLabel1.setText(NbBundle.getMessage(JROptionsPanel.class, (String)"JROptionsPanel.jLabel1.text"));
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().add(10, 10, 10).add((Component)this.jLabel1, -1, 558, Short.MAX_VALUE)).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.jButtonAddProperty, -2, 112, -2).addPreferredGap(0).add((Component)this.jButtonModify).addPreferredGap(0).add((Component)this.jButtonRemove).addPreferredGap(0).add((Component)this.jButtonRestoreDefault))).addContainerGap()));
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanel1Layout.createParallelGroup(3).add((Component)this.jButtonAddProperty).add((Component)this.jButtonModify).add((Component)this.jButtonRemove).add((Component)this.jButtonRestoreDefault)).add(18, 18, 18).add((Component)this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanel1, "Last");
    }

    private void jButtonRemoveActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.jTable1.getSelectedRows();
        Arrays.sort(selectedRows);
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            int modelIndex = ((JXTable)this.jTable1).convertRowIndexToModel(selectedRows[i]);
            String key = (String)((DefaultTableModel)this.jTable1.getModel()).getValueAt(modelIndex, 0);
            if (IRLocalJasperReportsContext.isJasperReportsDefaultProperty(key, null, true)) {
                JOptionPane.showMessageDialog(this, "The property \n" + key + "\ncan not be deleted since it is set by default by JasperReports.", "System property", 1);
                continue;
            }
            ((DefaultTableModel)this.jTable1.getModel()).removeRow(modelIndex);
            this.notifyChange();
        }
        this.jTable1.updateUI();
    }

    private void jButtonAddPropertyActionPerformed(ActionEvent evt) {
        JRPropertyDialog pd = new JRPropertyDialog(Misc.getMainFrame(), true);
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        ArrayList<String> usedKeys = new ArrayList<String>();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            String key = (String)dtm.getValueAt(i, 0);
            usedKeys.add(key);
        }
        pd.setExistingPropertiesNames(usedKeys);
        pd.setVisible(true);
        if (pd.getDialogResult() == 0) {
            dtm.addRow(new Object[]{pd.getPropertyName(), pd.getPropertyValue()});
            int newIndex = ((JXTable)this.jTable1).convertRowIndexToView(dtm.getRowCount() - 1);
            this.jTable1.getSelectionModel().setSelectionInterval(newIndex, newIndex);
            Rectangle rect = this.jTable1.getCellRect(newIndex, 0, true);
            this.jTable1.scrollRectToVisible(rect);
            this.notifyChange();
        }
    }

    private void jButtonRestoreDefaultActionPerformed(ActionEvent evt) {
        int[] selectedRows = this.jTable1.getSelectedRows();
        Arrays.sort(selectedRows);
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        for (int i = selectedRows.length - 1; i >= 0; --i) {
            int modelIndex = ((JXTable)this.jTable1).convertRowIndexToModel(selectedRows[i]);
            String key = (String)((DefaultTableModel)this.jTable1.getModel()).getValueAt(modelIndex, 0);
            String defValue = DefaultJasperReportsContext.getInstance().getProperty(key);
            if (defValue == null) continue;
            dtm.setValueAt(Misc.addSlashesString(defValue), modelIndex, 1);
        }
        this.jTable1.updateUI();
    }

    private void jTable1MouseClicked(MouseEvent evt) {
        if (evt.getClickCount() == 2 && SwingUtilities.isLeftMouseButton(evt)) {
            this.jButtonModifyActionPerformed(null);
        }
    }

    private void jButtonModifyActionPerformed(ActionEvent evt) {
        if (this.jTable1.getSelectedRow() >= 0) {
            DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
            int modelIndex = ((JXTable)this.jTable1).convertRowIndexToModel(this.jTable1.getSelectedRow());
            String keyProp = (String)dtm.getValueAt(modelIndex, 0);
            String valueProp = (String)dtm.getValueAt(modelIndex, 1);
            JRPropertyDialog pd = new JRPropertyDialog(Misc.getMainFrame(), true);
            ArrayList<String> usedKeys = new ArrayList<String>();
            for (int i = 0; i < dtm.getRowCount(); ++i) {
                String key = (String)dtm.getValueAt(i, 0);
                usedKeys.add(key);
            }
            pd.setExistingPropertiesNames(usedKeys);
            pd.setPropertyName(keyProp);
            pd.setPropertyValue(valueProp);
            pd.setVisible(true);
            if (pd.getDialogResult() == 0) {
                dtm.setValueAt(pd.getPropertyName(), modelIndex, 0);
                dtm.setValueAt(pd.getPropertyValue(), modelIndex, 1);
                this.jTable1.updateUI();
            }
        }
    }

    public void load() {
        this.setInit(true);
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        dtm.setRowCount(0);
        Map<String, String> props = IRLocalJasperReportsContext.getInstance().getProperties();
        for (String propName : props.keySet()) {
            dtm.addRow(new Object[]{propName, Misc.addSlashesString(props.get(propName))});
        }
        this.jTable1.updateUI();
        this.setInit(false);
    }

    public void store() {
        DefaultTableModel dtm = (DefaultTableModel)this.jTable1.getModel();
        ArrayList<String> usedKeys = new ArrayList<String>();
        for (int i = 0; i < dtm.getRowCount(); ++i) {
            String key = (String)dtm.getValueAt(i, 0);
            String value = (String)dtm.getValueAt(i, 1);
            usedKeys.add(key);
            if (IRLocalJasperReportsContext.isJasperReportsDefaultProperty(key, Misc.removeSlashesString(value), false)) continue;
            IReportManager.getPreferences().put("ireport.jrproperty." + key, Misc.removeSlashesString(value));
        }
        List props = IRLocalJasperReportsContext.getUtilities().getProperties("");
        for (int i = 0; i < props.size(); ++i) {
            String oldKey = ((JRPropertiesUtil.PropertySuffix)props.get(i)).getKey();
            if (usedKeys.contains(oldKey)) continue;
            IReportManager.getPreferences().remove("ireport.jrproperty." + oldKey);
            IRLocalJasperReportsContext.getInstance().removeProperty(oldKey);
        }
    }

    public boolean valid() {
        return true;
    }
}

