/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.compatibility;

import com.jaspersoft.ireport.designer.IRLocalJasperReportsContext;
import com.jaspersoft.ireport.designer.compatibility.JRXmlWriterHelper;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VersionJRContext
extends IRLocalJasperReportsContext {
    private String version = null;

    public VersionJRContext(String version) {
        if (version == null) {
            version = "";
        }
        if (version.length() > 0) {
            if (!JRXmlWriterHelper.getJRVersions().contains(version)) {
                version = version.replace("_", ".");
            }
            if (!JRXmlWriterHelper.getJRVersions().contains(version)) {
                Misc.log("XML writer for version " + version + " not found. Reset compatibility to default (null).");
                version = "";
            }
        }
        this.version = version;
    }

    @Override
    public Map<String, String> getProperties() {
        Map<String, String> map = super.getProperties();
        map.remove("net.sf.jasperreports.report.version");
        if (this.version != null && this.version.length() > 0) {
            map.put("net.sf.jasperreports.report.version", this.version);
        }
        return map;
    }

    @Override
    public String getProperty(String key) {
        System.out.println("Getting the property: " + key);
        if (key.equals("net.sf.jasperreports.report.version")) {
            return this.version.equals("") ? null : this.version;
        }
        return super.getProperty(key);
    }
}

