/*
 * iReport - Visual Designer for JasperReports.
 * Copyright (C) 2002 - 2013 Jaspersoft Corporation. All rights reserved.
 * http://www.jaspersoft.com
 *
 * Unless you have purchased a commercial license agreement from Jaspersoft,
 * the following license terms apply:
 *
 * This program is part of iReport.
 *
 * iReport is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Affero General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * iReport is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU Affero General Public License for more details.
 *
 * You should have received a copy of the GNU Affero General Public License
 * along with iReport. If not, see <http://www.gnu.org/licenses/>.
 */
package com.jaspersoft.ireport.designer.crosstab.wizard;

import com.jaspersoft.ireport.locale.I18n;
import com.jaspersoft.ireport.designer.IReportManager;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JPanel;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JasperDesign;

public final class CrosstabVisualPanel1 extends JPanel {

    /** Creates new form CrosstabVisualPanel1 */
    public CrosstabVisualPanel1() {
        initComponents();
        jComboBoxDataset.setRenderer( new DatasetListCellRenderer() );
        updateDatasets();
    }

    @Override
    public String getName() {
        return I18n.getString("CrosstabVisualPanel1.Label.Dataset");
    }

    /** This method is called from within the constructor to
     * initialize the form.
     * WARNING: Do NOT modify this code. The content of this method is
     * always regenerated by the Form Editor.
     */
    // <editor-fold defaultstate="collapsed" desc="Generated Code">//GEN-BEGIN:initComponents
    private void initComponents() {

        jLabelDataset = new javax.swing.JLabel();
        jComboBoxDataset = new javax.swing.JComboBox();

        org.openide.awt.Mnemonics.setLocalizedText(jLabelDataset, I18n.getString("CrosstabVisualPanel1.Label.Dataset")); // NOI18N

        org.jdesktop.layout.GroupLayout layout = new org.jdesktop.layout.GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
                    .add(jLabelDataset, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, 380, Short.MAX_VALUE)
                    .add(jComboBoxDataset, 0, 380, Short.MAX_VALUE))
                .addContainerGap())
        );
        layout.setVerticalGroup(
            layout.createParallelGroup(org.jdesktop.layout.GroupLayout.LEADING)
            .add(layout.createSequentialGroup()
                .addContainerGap()
                .add(jLabelDataset)
                .addPreferredGap(org.jdesktop.layout.LayoutStyle.RELATED)
                .add(jComboBoxDataset, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE, org.jdesktop.layout.GroupLayout.DEFAULT_SIZE, org.jdesktop.layout.GroupLayout.PREFERRED_SIZE)
                .addContainerGap(247, Short.MAX_VALUE))
        );
    }// </editor-fold>//GEN-END:initComponents
    // Variables declaration - do not modify//GEN-BEGIN:variables
    private javax.swing.JComboBox jComboBoxDataset;
    private javax.swing.JLabel jLabelDataset;
    // End of variables declaration//GEN-END:variables

    public void updateDatasets() {
        
        DefaultComboBoxModel model = (DefaultComboBoxModel)jComboBoxDataset.getModel();
        model.removeAllElements();
        
        JasperDesign design = IReportManager.getInstance().getActiveReport();
        if (design == null) return;
        
        List datasets = design.getDatasetsList();
        model.addElement( design.getMainDataset());
        for (int i=0; i<datasets.size(); ++i)
        {
            model.addElement( datasets.get(i));
        }
        
        jComboBoxDataset.setSelectedIndex(0);
        jComboBoxDataset.updateUI();
    }
    
    
    /**
     * 
     * @return the selected dataset
     */
    public JRDesignDataset getDataset()
    {
        return (JRDesignDataset)jComboBoxDataset.getSelectedItem();
    }
}

