/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeSet;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.ListPredicate;
import mondrian.rolap.agg.OrPredicate;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.rolap.sql.SqlQuery;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AndPredicate
extends ListPredicate {
    public AndPredicate(List<StarPredicate> predicateList) {
        super(predicateList);
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        for (StarPredicate childPredicate : this.children) {
            if (!childPredicate.evaluate(valueList)) continue;
            return true;
        }
        return false;
    }

    @Override
    public StarPredicate and(StarPredicate predicate) {
        if (predicate instanceof AndPredicate) {
            ListPredicate that = (ListPredicate)predicate;
            ArrayList<StarPredicate> list = new ArrayList<StarPredicate>(this.children);
            list.addAll(that.children);
            return new AndPredicate(list);
        }
        ArrayList<StarPredicate> list = new ArrayList<StarPredicate>(this.children);
        list.add(predicate);
        return new AndPredicate(list);
    }

    @Override
    public StarPredicate or(StarPredicate predicate) {
        ArrayList<StarPredicate> list = new ArrayList<StarPredicate>();
        list.add(this);
        list.add(predicate);
        return new OrPredicate(list);
    }

    public BitKey checkInList(SqlQuery sqlQuery, BitKey inListLHSBitKey) {
        BitKey inListRHSBitKey = inListLHSBitKey.copy();
        if (!this.columnBitKey.equals(inListLHSBitKey) || this.children.size() > 1 && !sqlQuery.getDialect().supportsMultiValueInExpr()) {
            inListRHSBitKey.clear();
        } else {
            for (StarPredicate predicate : this.children) {
                if (predicate instanceof ValueColumnPredicate) {
                    ValueColumnPredicate columnPred = (ValueColumnPredicate)predicate;
                    if (columnPred.getValue() != RolapUtil.sqlNullValue) continue;
                    inListRHSBitKey.clear(columnPred.getConstrainedColumn().getBitPosition());
                    continue;
                }
                inListRHSBitKey.clear();
                break;
            }
        }
        return inListRHSBitKey;
    }

    public void toInListSql(SqlQuery sqlQuery, StringBuilder buf, BitKey inListRHSBitKey) {
        boolean firstValue = true;
        buf.append("(");
        TreeSet<ValueColumnPredicate> sortedPredicates = new TreeSet<ValueColumnPredicate>();
        for (StarPredicate starPredicate : this.children) {
            assert (starPredicate instanceof ValueColumnPredicate);
            if (!inListRHSBitKey.get(((ValueColumnPredicate)starPredicate).getConstrainedColumn().getBitPosition())) continue;
            sortedPredicates.add((ValueColumnPredicate)starPredicate);
        }
        for (ValueColumnPredicate valueColumnPredicate : sortedPredicates) {
            if (firstValue) {
                firstValue = false;
            } else {
                buf.append(", ");
            }
            sqlQuery.getDialect().quote(buf, valueColumnPredicate.getValue(), valueColumnPredicate.getConstrainedColumn().getDatatype());
        }
        buf.append(")");
    }

    @Override
    protected String getOp() {
        return "and";
    }
}

