/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.UUID;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JROrigin;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.PrintElementVisitor;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.fill.JRVirtualizationContext;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.virtualization.VirtualizationInput;
import net.sf.jasperreports.engine.virtualization.VirtualizationOutput;
import net.sf.jasperreports.engine.virtualization.VirtualizationSerializable;

public class JRTemplatePrintElement
implements JRPrintElement,
Serializable,
VirtualizationSerializable {
    private static final long serialVersionUID = 10200L;
    private static final int SERIALIZATION_FLAG_CACHED_TEMPLATE = 1;
    private static final int SERIALIZATION_FLAG_HAS_UUID = 2;
    private static final int SERIALIZATION_FLAG_HAS_PROPERTIES = 4;
    private static final int SERIALIZATION_FLAG_CUSTOM_PROPERTIES = 8;
    protected JRTemplateElement template;
    private UUID uuid;
    private int x;
    private int y;
    private int height;
    private int width;
    private JRPropertiesMap properties;
    private int sourceElementId;

    public JRTemplatePrintElement() {
    }

    protected JRTemplatePrintElement(JRTemplateElement element) {
        this(element, 0);
    }

    protected JRTemplatePrintElement(JRTemplateElement element, int sourceElementId) {
        this.template = element;
        this.sourceElementId = sourceElementId;
    }

    protected void updateElementTemplate(JRTemplateElement elementTemplate) {
        this.template = elementTemplate;
    }

    @Override
    public JRDefaultStyleProvider getDefaultStyleProvider() {
        return this.template.getDefaultStyleProvider();
    }

    @Override
    public UUID getUUID() {
        return this.uuid;
    }

    @Override
    public void setUUID(UUID uuid) {
        this.uuid = uuid;
    }

    @Override
    public JROrigin getOrigin() {
        return this.template.getOrigin();
    }

    @Override
    public JRStyle getStyle() {
        return this.template.getStyle();
    }

    @Override
    public void setStyle(JRStyle style) {
    }

    @Override
    public ModeEnum getModeValue() {
        return this.template.getModeValue();
    }

    @Override
    public ModeEnum getOwnModeValue() {
        return this.template.getOwnModeValue();
    }

    @Override
    public void setMode(ModeEnum modeValue) {
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public void setX(int x) {
        this.x = x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public void setY(int y) {
        this.y = y;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void setWidth(int width) {
        this.width = width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public void setHeight(int height) {
        this.height = height;
    }

    @Override
    public Color getForecolor() {
        return this.template.getForecolor();
    }

    @Override
    public Color getOwnForecolor() {
        return this.template.getOwnForecolor();
    }

    @Override
    public void setForecolor(Color color) {
    }

    @Override
    public Color getBackcolor() {
        return this.template.getBackcolor();
    }

    @Override
    public Color getOwnBackcolor() {
        return this.template.getOwnBackcolor();
    }

    @Override
    public void setBackcolor(Color color) {
    }

    public JRTemplateElement getTemplate() {
        return this.template;
    }

    public void setTemplate(JRTemplateElement template) {
        this.template = template;
        if (this.properties != null) {
            if (template != null && template.hasProperties()) {
                this.properties.setBaseProperties(template.getPropertiesMap());
            } else {
                this.properties.setBaseProperties(null);
            }
        }
    }

    @Override
    public String getKey() {
        return this.template.getKey();
    }

    @Override
    public String getStyleNameReference() {
        return null;
    }

    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public synchronized boolean hasProperties() {
        return this.properties != null && this.properties.hasProperties() || this.template.hasProperties();
    }

    @Override
    public synchronized JRPropertiesMap getPropertiesMap() {
        if (this.properties == null) {
            this.properties = new JRPropertiesMap();
            if (this.template.hasProperties()) {
                this.properties.setBaseProperties(this.template.getPropertiesMap());
            }
        }
        return this.properties;
    }

    @Override
    public JRPropertiesHolder getParentProperties() {
        return null;
    }

    private synchronized void writeObject(ObjectOutputStream out) throws IOException {
        if (this.properties != null && !this.properties.hasOwnProperties()) {
            this.properties = null;
        }
        out.defaultWriteObject();
    }

    @Override
    public <T> void accept(PrintElementVisitor<T> visitor, T arg) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getSourceElementId() {
        return this.sourceElementId;
    }

    public void setSourceElementId(int sourceElementId) {
        this.sourceElementId = sourceElementId;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.sourceElementId == 0 && this.template != null) {
            this.sourceElementId = this.template.hashCode();
            if (this.sourceElementId == 0) {
                this.sourceElementId = Integer.MIN_VALUE;
            }
        }
    }

    @Override
    public void writeVirtualized(VirtualizationOutput out) throws IOException {
        JRVirtualizationContext virtualizationContext = out.getVirtualizationContext();
        String templateId = this.template.getId();
        boolean hasCachedTemplate = templateId != null && virtualizationContext.hasCachedTemplate(templateId);
        boolean hasUUID = this.uuid != null;
        boolean hasProperties = this.properties != null && this.properties.hasProperties();
        boolean customProperties = false;
        if (hasProperties) {
            JRPropertiesMap baseProperties;
            customProperties = !this.properties.getClass().equals(JRPropertiesMap.class) ? true : ((baseProperties = this.properties.getBaseProperties()) == null ? this.template.hasProperties() : baseProperties != this.template.getPropertiesMap());
        }
        int flags = 0;
        if (hasCachedTemplate) {
            flags |= 1;
        }
        if (hasUUID) {
            flags |= 2;
        }
        if (hasProperties) {
            flags |= 4;
        }
        if (customProperties) {
            flags |= 8;
        }
        out.writeByte(flags);
        if (hasCachedTemplate) {
            out.writeJRObject(templateId);
        } else {
            out.writeJRObject(this.template);
        }
        if (hasUUID) {
            out.writeJRObject(this.uuid);
        }
        out.writeIntCompressed(this.sourceElementId);
        out.writeIntCompressed(this.x);
        out.writeIntCompressed(this.y);
        out.writeIntCompressed(this.height);
        out.writeIntCompressed(this.width);
        if (hasProperties) {
            if (customProperties) {
                out.writeJRObject(this.properties);
            } else {
                String[] names = this.properties.getOwnPropertyNames();
                out.writeIntCompressed(names.length);
                for (int i = 0; i < names.length; ++i) {
                    String propName = names[i];
                    out.writeJRObject(propName);
                    String value = this.properties.getProperty(propName);
                    out.writeJRObject(value);
                }
            }
        }
    }

    @Override
    public void readVirtualized(VirtualizationInput in) throws IOException {
        JRVirtualizationContext virtualizationContext = in.getVirtualizationContext();
        int flags = in.readUnsignedByte();
        if ((flags & 1) != 0) {
            String templateId = (String)in.readJRObject();
            this.template = virtualizationContext.getCachedTemplate(templateId);
            if (this.template == null) {
                throw new JRRuntimeException("Did not find template with id " + templateId);
            }
        } else {
            this.template = (JRTemplateElement)in.readJRObject();
        }
        if ((flags & 2) != 0) {
            this.uuid = (UUID)in.readJRObject();
        }
        this.sourceElementId = in.readIntCompressed();
        this.x = in.readIntCompressed();
        this.y = in.readIntCompressed();
        this.height = in.readIntCompressed();
        this.width = in.readIntCompressed();
        if ((flags & 4) != 0) {
            if ((flags & 8) != 0) {
                this.properties = (JRPropertiesMap)in.readJRObject();
            } else {
                int propSize = in.readIntCompressed();
                if (propSize > 0) {
                    this.properties = new JRPropertiesMap();
                    this.properties.setBaseProperties(this.template.hasProperties() ? this.template.getPropertiesMap() : null);
                    for (int i = 0; i < propSize; ++i) {
                        String propName = (String)in.readJRObject();
                        String value = (String)in.readJRObject();
                        this.properties.setProperty(propName, value);
                    }
                }
            }
        }
    }
}

