/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import java.awt.Color;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlinkHelper;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignGraphicElement;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HorizontalAlignEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.ScaleImageEnum;
import net.sf.jasperreports.engine.type.VerticalAlignEnum;
import net.sf.jasperreports.engine.util.JRBoxUtil;
import net.sf.jasperreports.engine.util.JRCloneUtils;
import net.sf.jasperreports.engine.util.JRStyleResolver;

public class JRDesignImage
extends JRDesignGraphicElement
implements JRImage {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_ANCHOR_NAME_EXPRESSION = "anchorNameExpression";
    public static final String PROPERTY_BOOKMARK_LEVEL = "bookmarkLevel";
    public static final String PROPERTY_EVALUATION_GROUP = "evaluationGroup";
    public static final String PROPERTY_EVALUATION_TIME = "evaluationTime";
    public static final String PROPERTY_EXPRESSION = "expression";
    protected ScaleImageEnum scaleImageValue;
    protected HorizontalAlignEnum horizontalAlignmentValue;
    protected VerticalAlignEnum verticalAlignmentValue;
    protected Boolean isUsingCache;
    protected boolean isLazy;
    protected OnErrorTypeEnum onErrorTypeValue = OnErrorTypeEnum.ERROR;
    protected EvaluationTimeEnum evaluationTimeValue = EvaluationTimeEnum.NOW;
    protected String linkType;
    protected String linkTarget;
    private List<JRHyperlinkParameter> hyperlinkParameters = new ArrayList<JRHyperlinkParameter>();
    protected JRLineBox lineBox = new JRBaseLineBox(this);
    protected JRGroup evaluationGroup;
    protected JRExpression expression;
    protected JRExpression anchorNameExpression;
    protected JRExpression hyperlinkReferenceExpression;
    protected JRExpression hyperlinkWhenExpression;
    protected JRExpression hyperlinkAnchorExpression;
    protected JRExpression hyperlinkPageExpression;
    private JRExpression hyperlinkTooltipExpression;
    protected int bookmarkLevel = 0;
    private int PSEUDO_SERIAL_VERSION_UID = 50004;
    private Byte horizontalAlignment;
    private Byte verticalAlignment;
    private Byte border;
    private Byte topBorder;
    private Byte leftBorder;
    private Byte bottomBorder;
    private Byte rightBorder;
    private Color borderColor;
    private Color topBorderColor;
    private Color leftBorderColor;
    private Color bottomBorderColor;
    private Color rightBorderColor;
    private Integer padding;
    private Integer topPadding;
    private Integer leftPadding;
    private Integer bottomPadding;
    private Integer rightPadding;
    private byte hyperlinkType;
    private byte hyperlinkTarget;
    private Byte scaleImage;
    private byte onErrorType;
    private byte evaluationTime;

    public JRDesignImage(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    @Override
    public ModeEnum getModeValue() {
        return JRStyleResolver.getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public ScaleImageEnum getScaleImageValue() {
        return JRStyleResolver.getScaleImageValue(this);
    }

    @Override
    public ScaleImageEnum getOwnScaleImageValue() {
        return this.scaleImageValue;
    }

    @Override
    public void setScaleImage(ScaleImageEnum scaleImageValue) {
        ScaleImageEnum old = this.scaleImageValue;
        this.scaleImageValue = scaleImageValue;
        this.getEventSupport().firePropertyChange("scaleImage", old, this.scaleImageValue);
    }

    @Override
    public HorizontalAlignEnum getHorizontalAlignmentValue() {
        return JRStyleResolver.getHorizontalAlignmentValue(this);
    }

    @Override
    public HorizontalAlignEnum getOwnHorizontalAlignmentValue() {
        return this.horizontalAlignmentValue;
    }

    @Override
    public void setHorizontalAlignment(HorizontalAlignEnum horizontalAlignmentValue) {
        HorizontalAlignEnum old = this.horizontalAlignmentValue;
        this.horizontalAlignmentValue = horizontalAlignmentValue;
        this.getEventSupport().firePropertyChange("horizontalAlignment", old, this.horizontalAlignmentValue);
    }

    @Override
    public VerticalAlignEnum getVerticalAlignmentValue() {
        return JRStyleResolver.getVerticalAlignmentValue(this);
    }

    @Override
    public VerticalAlignEnum getOwnVerticalAlignmentValue() {
        return this.verticalAlignmentValue;
    }

    @Override
    public void setVerticalAlignment(VerticalAlignEnum verticalAlignmentValue) {
        VerticalAlignEnum old = this.verticalAlignmentValue;
        this.verticalAlignmentValue = verticalAlignmentValue;
        this.getEventSupport().firePropertyChange("verticalAlignment", old, this.verticalAlignmentValue);
    }

    @Override
    public boolean isUsingCache() {
        if (this.isUsingCache == null) {
            if (this.getExpression() != null) {
                return String.class.getName().equals(this.getExpression().getValueClassName());
            }
            return true;
        }
        return this.isUsingCache;
    }

    @Override
    public Boolean isOwnUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public Boolean getUsingCache() {
        return this.isUsingCache;
    }

    @Override
    public EvaluationTimeEnum getEvaluationTimeValue() {
        return this.evaluationTimeValue;
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @Override
    public byte getHyperlinkType() {
        return this.getHyperlinkTypeValue().getValue();
    }

    @Override
    public HyperlinkTypeEnum getHyperlinkTypeValue() {
        return JRHyperlinkHelper.getHyperlinkTypeValue(this);
    }

    @Override
    public byte getHyperlinkTarget() {
        return JRHyperlinkHelper.getHyperlinkTarget(this);
    }

    @Override
    public JRGroup getEvaluationGroup() {
        return this.evaluationGroup;
    }

    @Override
    public JRExpression getExpression() {
        return this.expression;
    }

    @Override
    public JRExpression getAnchorNameExpression() {
        return this.anchorNameExpression;
    }

    @Override
    public JRExpression getHyperlinkReferenceExpression() {
        return this.hyperlinkReferenceExpression;
    }

    @Override
    public JRExpression getHyperlinkWhenExpression() {
        return this.hyperlinkWhenExpression;
    }

    @Override
    public JRExpression getHyperlinkAnchorExpression() {
        return this.hyperlinkAnchorExpression;
    }

    @Override
    public JRExpression getHyperlinkPageExpression() {
        return this.hyperlinkPageExpression;
    }

    @Override
    public void setUsingCache(boolean isUsingCache) {
        this.setUsingCache(isUsingCache ? Boolean.TRUE : Boolean.FALSE);
    }

    @Override
    public void setUsingCache(Boolean isUsingCache) {
        Boolean old = this.isUsingCache;
        this.isUsingCache = isUsingCache;
        this.getEventSupport().firePropertyChange("isUsingCache", old, this.isUsingCache);
    }

    @Override
    public boolean isLazy() {
        return this.isLazy;
    }

    @Override
    public void setLazy(boolean isLazy) {
        boolean old = this.isLazy;
        this.isLazy = isLazy;
        this.getEventSupport().firePropertyChange("isLazy", old, this.isLazy);
    }

    @Override
    public OnErrorTypeEnum getOnErrorTypeValue() {
        return this.onErrorTypeValue;
    }

    @Override
    public void setOnErrorType(OnErrorTypeEnum onErrorTypeValue) {
        OnErrorTypeEnum old = this.onErrorTypeValue;
        this.onErrorTypeValue = onErrorTypeValue;
        this.getEventSupport().firePropertyChange("onErrorType", old, this.onErrorTypeValue);
    }

    public void setEvaluationTime(EvaluationTimeEnum evaluationTimeValue) {
        EvaluationTimeEnum old = this.evaluationTimeValue;
        this.evaluationTimeValue = evaluationTimeValue;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_TIME, old, this.evaluationTimeValue);
    }

    public void setHyperlinkType(byte hyperlinkType) {
        this.setHyperlinkType(HyperlinkTypeEnum.getByValue(hyperlinkType));
    }

    public void setHyperlinkType(HyperlinkTypeEnum hyperlinkType) {
        this.setLinkType(JRHyperlinkHelper.getLinkType(hyperlinkType));
    }

    public void setHyperlinkTarget(byte hyperlinkTarget) {
        this.setHyperlinkTarget(HyperlinkTargetEnum.getByValue(hyperlinkTarget));
    }

    public void setHyperlinkTarget(HyperlinkTargetEnum hyperlinkTarget) {
        this.setLinkTarget(JRHyperlinkHelper.getLinkTarget(hyperlinkTarget));
    }

    public void setEvaluationGroup(JRGroup evaluationGroup) {
        JRGroup old = this.evaluationGroup;
        this.evaluationGroup = evaluationGroup;
        this.getEventSupport().firePropertyChange(PROPERTY_EVALUATION_GROUP, old, this.evaluationGroup);
    }

    public void setExpression(JRExpression expression) {
        JRExpression old = this.expression;
        this.expression = expression;
        this.getEventSupport().firePropertyChange(PROPERTY_EXPRESSION, old, this.expression);
    }

    public void setAnchorNameExpression(JRExpression anchorNameExpression) {
        JRExpression old = this.anchorNameExpression;
        this.anchorNameExpression = anchorNameExpression;
        this.getEventSupport().firePropertyChange(PROPERTY_ANCHOR_NAME_EXPRESSION, old, this.anchorNameExpression);
    }

    public void setHyperlinkReferenceExpression(JRExpression hyperlinkReferenceExpression) {
        JRExpression old = this.hyperlinkReferenceExpression;
        this.hyperlinkReferenceExpression = hyperlinkReferenceExpression;
        this.getEventSupport().firePropertyChange("hyperlinkReferenceExpression", old, this.hyperlinkReferenceExpression);
    }

    public void setHyperlinkWhenExpression(JRExpression hyperlinkWhenExpression) {
        JRExpression old = this.hyperlinkWhenExpression;
        this.hyperlinkWhenExpression = hyperlinkWhenExpression;
        this.getEventSupport().firePropertyChange("hyperlinkWhenExpression", old, this.hyperlinkWhenExpression);
    }

    public void setHyperlinkAnchorExpression(JRExpression hyperlinkAnchorExpression) {
        JRExpression old = this.hyperlinkAnchorExpression;
        this.hyperlinkAnchorExpression = hyperlinkAnchorExpression;
        this.getEventSupport().firePropertyChange("hyperlinkAnchorExpression", old, this.hyperlinkAnchorExpression);
    }

    public void setHyperlinkPageExpression(JRExpression hyperlinkPageExpression) {
        JRExpression old = this.hyperlinkPageExpression;
        this.hyperlinkPageExpression = hyperlinkPageExpression;
        this.getEventSupport().firePropertyChange("hyperlinkPageExpression", old, this.hyperlinkPageExpression);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitImage(this);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public int getBookmarkLevel() {
        return this.bookmarkLevel;
    }

    public void setBookmarkLevel(int bookmarkLevel) {
        int old = this.bookmarkLevel;
        this.bookmarkLevel = bookmarkLevel;
        this.getEventSupport().firePropertyChange(PROPERTY_BOOKMARK_LEVEL, old, this.bookmarkLevel);
    }

    @Override
    public Float getDefaultLineWidth() {
        return JRPen.LINE_WIDTH_0;
    }

    @Override
    public String getLinkType() {
        return this.linkType;
    }

    @Override
    public String getLinkTarget() {
        return this.linkTarget;
    }

    public void setLinkType(String type) {
        String old = this.linkType;
        this.linkType = type;
        this.getEventSupport().firePropertyChange("hyperlinkType", old, this.linkType);
    }

    public void setLinkTarget(String target) {
        String old = this.linkTarget;
        this.linkTarget = target;
        this.getEventSupport().firePropertyChange("linkTarget", old, this.linkTarget);
    }

    @Override
    public JRHyperlinkParameter[] getHyperlinkParameters() {
        JRHyperlinkParameter[] parameters;
        if (this.hyperlinkParameters.isEmpty()) {
            parameters = null;
        } else {
            parameters = new JRHyperlinkParameter[this.hyperlinkParameters.size()];
            this.hyperlinkParameters.toArray(parameters);
        }
        return parameters;
    }

    public List<JRHyperlinkParameter> getHyperlinkParametersList() {
        return this.hyperlinkParameters;
    }

    public void addHyperlinkParameter(JRHyperlinkParameter parameter) {
        this.hyperlinkParameters.add(parameter);
        this.getEventSupport().fireCollectionElementAddedEvent("hyperlinkParameters", parameter, this.hyperlinkParameters.size() - 1);
    }

    public void removeHyperlinkParameter(JRHyperlinkParameter parameter) {
        int idx = this.hyperlinkParameters.indexOf(parameter);
        if (idx >= 0) {
            this.hyperlinkParameters.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, idx);
        }
    }

    public void removeHyperlinkParameter(String parameterName) {
        ListIterator<JRHyperlinkParameter> it = this.hyperlinkParameters.listIterator();
        while (it.hasNext()) {
            JRHyperlinkParameter parameter = it.next();
            if (parameter.getName() == null || !parameter.getName().equals(parameterName)) continue;
            it.remove();
            this.getEventSupport().fireCollectionElementRemovedEvent("hyperlinkParameters", parameter, it.nextIndex());
        }
    }

    @Override
    public JRExpression getHyperlinkTooltipExpression() {
        return this.hyperlinkTooltipExpression;
    }

    public void setHyperlinkTooltipExpression(JRExpression hyperlinkTooltipExpression) {
        JRExpression old = this.hyperlinkTooltipExpression;
        this.hyperlinkTooltipExpression = hyperlinkTooltipExpression;
        this.getEventSupport().firePropertyChange("hyperlinkTooltipExpression", old, this.hyperlinkTooltipExpression);
    }

    @Override
    public Object clone() {
        JRDesignImage clone = (JRDesignImage)super.clone();
        clone.lineBox = this.lineBox.clone(clone);
        clone.hyperlinkParameters = JRCloneUtils.cloneList(this.hyperlinkParameters);
        clone.expression = JRCloneUtils.nullSafeClone(this.expression);
        clone.anchorNameExpression = JRCloneUtils.nullSafeClone(this.anchorNameExpression);
        clone.hyperlinkReferenceExpression = JRCloneUtils.nullSafeClone(this.hyperlinkReferenceExpression);
        clone.hyperlinkWhenExpression = JRCloneUtils.nullSafeClone(this.hyperlinkWhenExpression);
        clone.hyperlinkAnchorExpression = JRCloneUtils.nullSafeClone(this.hyperlinkAnchorExpression);
        clone.hyperlinkPageExpression = JRCloneUtils.nullSafeClone(this.hyperlinkPageExpression);
        clone.hyperlinkTooltipExpression = JRCloneUtils.nullSafeClone(this.hyperlinkTooltipExpression);
        return clone;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        if (this.PSEUDO_SERIAL_VERSION_UID < 30702) {
            this.horizontalAlignmentValue = HorizontalAlignEnum.getByValue(this.horizontalAlignment);
            this.verticalAlignmentValue = VerticalAlignEnum.getByValue(this.verticalAlignment);
            this.scaleImageValue = ScaleImageEnum.getByValue(this.scaleImage);
            this.onErrorTypeValue = OnErrorTypeEnum.getByValue(this.onErrorType);
            this.evaluationTimeValue = EvaluationTimeEnum.getByValue(this.evaluationTime);
            this.horizontalAlignment = null;
            this.verticalAlignment = null;
            this.scaleImage = null;
        }
        if (this.lineBox == null) {
            this.lineBox = new JRBaseLineBox(this);
            JRBoxUtil.setToBox(this.border, this.topBorder, this.leftBorder, this.bottomBorder, this.rightBorder, this.borderColor, this.topBorderColor, this.leftBorderColor, this.bottomBorderColor, this.rightBorderColor, this.padding, this.topPadding, this.leftPadding, this.bottomPadding, this.rightPadding, this.lineBox);
            this.border = null;
            this.topBorder = null;
            this.leftBorder = null;
            this.bottomBorder = null;
            this.rightBorder = null;
            this.borderColor = null;
            this.topBorderColor = null;
            this.leftBorderColor = null;
            this.bottomBorderColor = null;
            this.rightBorderColor = null;
            this.padding = null;
            this.topPadding = null;
            this.leftPadding = null;
            this.bottomPadding = null;
            this.rightPadding = null;
        }
        if (this.linkType == null) {
            this.linkType = JRHyperlinkHelper.getLinkType(HyperlinkTypeEnum.getByValue(this.hyperlinkType));
        }
        if (this.linkTarget == null) {
            this.linkTarget = JRHyperlinkHelper.getLinkTarget(HyperlinkTargetEnum.getByValue(this.hyperlinkTarget));
        }
    }
}

