/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.styles;

import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.dnd.ReportObjectPaletteTransferable;
import com.jaspersoft.ireport.designer.jrtx.StyleNode;
import com.jaspersoft.ireport.designer.jrtx.TemplateNode;
import com.jaspersoft.ireport.designer.styles.AddStyleToReportAction;
import com.jaspersoft.ireport.designer.styles.StylesLibraryChildren;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import javax.swing.Action;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRSimpleTemplate;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRTemplateReference;
import net.sf.jasperreports.engine.base.JRBaseStyle;
import net.sf.jasperreports.engine.design.JRDesignStyle;
import org.openide.actions.NewAction;
import org.openide.nodes.Node;
import org.openide.nodes.NodeTransfer;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;
import org.openide.util.datatransfer.NewType;
import org.openide.util.datatransfer.PasteType;

public class LibraryStyleNode
extends StyleNode {
    public LibraryStyleNode(JRSimpleTemplate template, JRBaseStyle style, Lookup doLkp) {
        super(template, style, doLkp);
    }

    public Action[] getActions(boolean popup) {
        ArrayList<Object> actions = new ArrayList<Object>();
        actions.add(SystemAction.get(NewAction.class));
        actions.add(null);
        actions.add(SystemAction.get(AddStyleToReportAction.class));
        actions.add(null);
        Action[] originals = super.getActions(popup);
        for (int i = 0; i < originals.length; ++i) {
            actions.add(originals[i]);
        }
        return actions.toArray(new Action[actions.size()]);
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        tras.put((ExTransferable.Single)new ReportObjectPaletteTransferable("com.jaspersoft.ireport.designer.styles.DragStyleAction", this.getStyle()));
        return tras;
    }

    public PasteType getDropType(Transferable t, int action, int index) {
        Node dropNode = NodeTransfer.node((Transferable)t, (int)7);
        if (null != dropNode) {
            JRSimpleTemplate template;
            final JRDesignStyle style = (JRDesignStyle)dropNode.getLookup().lookup(JRDesignStyle.class);
            final JRTemplateReference reference = (JRTemplateReference)dropNode.getLookup().lookup(JRTemplateReference.class);
            JRSimpleTemplate jRSimpleTemplate = template = this.getParentNode() == null ? null : (JRSimpleTemplate)this.getParentNode().getLookup().lookup(JRSimpleTemplate.class);
            if (null != style && template != null) {
                return new PasteType(){

                    public Transferable paste() throws IOException {
                        ArrayList<JRDesignStyle> list = new ArrayList<JRDesignStyle>();
                        JRStyle[] ss = template.getStyles();
                        for (int i = 0; i < ss.length; ++i) {
                            list.add((JRDesignStyle)ss[i]);
                        }
                        int currentIndex = -1;
                        for (int i = 0; i < list.size(); ++i) {
                            JRDesignStyle s = (JRDesignStyle)list.get(i);
                            if (s != style) continue;
                            currentIndex = i;
                        }
                        if (currentIndex >= 0) {
                            return null;
                        }
                        try {
                            JRDesignStyle newStyle = ModelUtils.cloneStyle(style);
                            ArrayList<String> names = new ArrayList<String>();
                            String base = newStyle.getName();
                            JRStyle[] styles = LibraryStyleNode.this.getTemplate().getStyles();
                            for (int n = 0; n < styles.length; ++n) {
                                names.add(styles[n].getName());
                            }
                            int i = 1;
                            while (names.contains(base + i)) {
                                ++i;
                            }
                            newStyle.setName(base + i);
                            template.addStyle((JRStyle)newStyle);
                            ((StylesLibraryChildren)LibraryStyleNode.this.getParentNode().getChildren()).recalculateKeys();
                        }
                        catch (JRException ex) {
                            Exceptions.printStackTrace((Throwable)ex);
                        }
                        return null;
                    }
                };
            }
            if (null != reference && template != null) {
                return new PasteType(){

                    public Transferable paste() throws IOException {
                        JRTemplateReference[] ss = template.getIncludedTemplates();
                        for (int i = 0; i < ss.length; ++i) {
                            if (ss[i].getLocation() == null || !ss[i].getLocation().equals(reference.getLocation())) continue;
                            return null;
                        }
                        template.addIncludedTemplate(reference.getLocation());
                        ((StylesLibraryChildren)LibraryStyleNode.this.getParentNode().getChildren()).recalculateKeys();
                        return null;
                    }
                };
            }
        }
        return null;
    }

    public NewType[] getNewTypes() {
        if (this.getParentNode() instanceof TemplateNode) {
            return ((TemplateNode)this.getParentNode()).getNewTypes();
        }
        return super.getNewTypes();
    }
}

