/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.menu;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.IOException;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class EditWithExternalEditorAction
extends NodeAction {
    protected void performAction(Node[] nodes) {
        JasperDesign jd = IReportManager.getInstance().getActiveReport();
        if (jd != null) {
            if (IReportManager.getInstance().getActiveVisualView().getEditorSupport().isModified()) {
                int res = JOptionPane.showConfirmDialog(Misc.getMainFrame(), I18n.getString("messages.fileModifiedLaunchingEditor"), "", 1);
                if (res == 0) {
                    try {
                        IReportManager.getInstance().getActiveVisualView().getEditorSupport().saveDocument();
                    }
                    catch (IOException ex) {
                        return;
                    }
                } else {
                    return;
                }
            }
            Runtime rt = Runtime.getRuntime();
            String editor = null;
            String fileName = null;
            try {
                editor = IReportManager.getPreferences().get("ExternalEditor", null);
                if (editor == null) {
                    JOptionPane.showMessageDialog(Misc.getMainFrame(), I18n.getString("messages.noExternalEditorDefined"), "", 2);
                    return;
                }
                fileName = FileUtil.toFile((FileObject)IReportManager.getInstance().getActiveVisualView().getEditorSupport().getDataObject().getPrimaryFile()).getPath();
                rt.exec(new String[]{editor, fileName});
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(Misc.getMainFrame(), I18n.getString("messages.errorExecutingEditor", new Object[]{editor, fileName}), "", 0);
            }
        }
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public String getName() {
        return I18n.getString("action.editWithExternalEditor");
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected boolean enable(Node[] nodes) {
        return IReportManager.getInstance().getActiveReport() != null;
    }
}

