/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection.gui;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.connection.JDBCConnection;
import com.jaspersoft.ireport.designer.connection.gui.JDBCDriverDefinition;
import com.jaspersoft.ireport.designer.connection.gui.JDBCDriverListRenderer;
import com.jaspersoft.ireport.locale.I18n;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import org.jdesktop.layout.GroupLayout;

public class JDBCConnectionEditor
extends JPanel
implements IReportConnectionEditor {
    private IReportConnection iReportConnection = null;
    public static JDBCDriverDefinition[] definitions = new JDBCDriverDefinition[]{new JDBCDriverDefinition("Cloudscape", "COM.cloudscape.JDBCDriver", "jdbc:cloudscape:/{1}"), new JDBCDriverDefinition("IBM DB2", "COM.ibm.db2.jdbc.app.DB2Driver", "jdbc:db2:{0}/{1}"), new JDBCDriverDefinition("inetdae7", "com.inet.tds.TdsDriver", "jdbc:inetdae7:{0}:1433/{1}"), new JDBCDriverDefinition("Informix", "com.informix.jdbc.IfxDriver", "jdbc:informix-sqli://{0}:informixserver={1}"), new JDBCDriverDefinition("Ingres", "com.ingres.jdbc.IngresDriver", "jdbc:ingres://{0}:II7/{1}"), new JDBCDriverDefinition("HSQLDB (file)", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:[PATH_TO_DB_FILES]/{1}"), new JDBCDriverDefinition("HSQLDB (server)", "org.hsqldb.jdbcDriver", "jdbc:hsqldb:hsql://{0}"), new JDBCDriverDefinition("JDBC-ODBC Bridge", "sun.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:{1}", "DSNAME"), new JDBCDriverDefinition("JDBC-ODBC Bridge", "com.ms.jdbc.odbc.JdbcOdbcDriver", "jdbc:odbc:{1}", "DSNAME"), new JDBCDriverDefinition("MS SQLServer", "com.internetcds.jdbc.tds.Driver", "jdbc:freetds:sqlserver://{0}/{1}"), new JDBCDriverDefinition("MS SQLServer (2000)", "com.microsoft.jdbc.sqlserver.SQLServerDriver", "jdbc:microsoft:sqlserver://{0}:1433;DatabaseName={1}"), new JDBCDriverDefinition("MS SQLServer (2005)", "com.microsoft.sqlserver.jdbc.SQLServerDriver", "jdbc:sqlserver://{0}:1433;databaseName={1}"), new JDBCDriverDefinition("MS SQLServer", "net.sourceforge.jtds.jdbc.Driver", "jdbc:jtds:sqlserver://{0}/{1}"), new JDBCDriverDefinition("MS SQLServer", "com.merant.datadirect.jdbc.sqlserver.SQLServerDriver", "jdbc:sqlserver://{0}:1433/{1}"), new JDBCDriverDefinition("MySQL", "org.gjt.mm.mysql.Driver", "jdbc:mysql://{0}/{1}"), new JDBCDriverDefinition("MySQL", "com.mysql.jdbc.Driver", "jdbc:mysql://{0}/{1}"), new JDBCDriverDefinition("Oracle", "oracle.jdbc.driver.OracleDriver", "jdbc:oracle:thin:@{0}:1521:{1}"), new JDBCDriverDefinition("PostgreSQL", "org.postgresql.Driver", "jdbc:postgresql://{0}:5432/{1}"), new JDBCDriverDefinition("Sybase", "com.sybase.jdbc2.jdbc.SybDriver", "jdbc:sybase:Tds:{0}:2638/{1}"), new JDBCDriverDefinition("Vertica", "com.vertica.Driver", "jdbc:vertica://{0}:5433/{1}")};
    private JCheckBox jCheckBoxSavePassword;
    private JComboBox jComboBoxJDBCDriver;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JPanel jPanel3;
    private JPanel jPanelJDBC;
    private JTextField jTextFieldJDBCUrl;
    private JPasswordField jTextFieldPassword;
    private JTextField jTextFieldUsername;

    public JDBCConnectionEditor() {
        this.initComponents();
        this.jComboBoxJDBCDriver.setRenderer(new JDBCDriverListRenderer());
        this.jComboBoxJDBCDriver.setModel(new DefaultComboBoxModel<JDBCDriverDefinition>(definitions));
        this.jComboBoxJDBCDriver.setSelectedIndex(17);
        this.jLabel1.setText(I18n.getString("XMLADataSourceConnectionEditor.Label.Warning"));
    }

    private void initComponents() {
        this.jPanelJDBC = new JPanel();
        this.jLabel2 = new JLabel();
        this.jComboBoxJDBCDriver = new JComboBox();
        this.jLabel3 = new JLabel();
        this.jTextFieldJDBCUrl = new JTextField();
        this.jPanel3 = new JPanel();
        this.jLabel6 = new JLabel();
        this.jTextFieldUsername = new JTextField();
        this.jLabel7 = new JLabel();
        this.jTextFieldPassword = new JPasswordField();
        this.jCheckBoxSavePassword = new JCheckBox();
        this.jLabel1 = new JLabel();
        this.setLayout(new BorderLayout());
        this.jLabel2.setText(I18n.getString("JDBCConnectionEditor.Label.JDBC_Driver"));
        this.jComboBoxJDBCDriver.setEditable(true);
        this.jComboBoxJDBCDriver.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                JDBCConnectionEditor.this.jComboBoxJDBCDriverActionPerformed(evt);
            }
        });
        this.jLabel3.setText(I18n.getString("JDBCConnectionEditor.Label.JDBC_URL"));
        this.jPanel3.setBorder(BorderFactory.createTitledBorder("Credentials"));
        this.jPanel3.setMinimumSize(new Dimension(179, 70));
        this.jLabel6.setText(I18n.getString("Global.Label.Username"));
        this.jLabel7.setText(I18n.getString("Global.Label.Password"));
        this.jCheckBoxSavePassword.setText(I18n.getString("Global.CheckBox.Save_password"));
        this.jLabel1.setIcon(new ImageIcon(this.getClass().getResource("/com/jaspersoft/ireport/designer/connection/gui/warning.png")));
        this.jLabel1.setText("Attention! Passwords are saved in clear text.");
        GroupLayout jPanel3Layout = new GroupLayout((Container)this.jPanel3);
        this.jPanel3.setLayout((LayoutManager)jPanel3Layout);
        jPanel3Layout.setHorizontalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel7).addPreferredGap(1).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((Component)this.jCheckBoxSavePassword).add((Component)this.jTextFieldPassword, -1, 235, Short.MAX_VALUE))).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((Component)this.jLabel6).addPreferredGap(0).add((Component)this.jTextFieldUsername, -1, 236, Short.MAX_VALUE)).add((Component)this.jLabel1)).addContainerGap()));
        jPanel3Layout.setVerticalGroup((GroupLayout.Group)jPanel3Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel3Layout.createSequentialGroup().add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel6).add((Component)this.jTextFieldUsername, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanel3Layout.createParallelGroup(3).add((Component)this.jLabel7).add((Component)this.jTextFieldPassword, -2, -1, -2)).addPreferredGap(1).add((Component)this.jCheckBoxSavePassword).addPreferredGap(1).add((Component)this.jLabel1).addContainerGap(-1, Short.MAX_VALUE)));
        GroupLayout jPanelJDBCLayout = new GroupLayout((Container)this.jPanelJDBC);
        this.jPanelJDBC.setLayout((LayoutManager)jPanelJDBCLayout);
        jPanelJDBCLayout.setHorizontalGroup((GroupLayout.Group)jPanelJDBCLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelJDBCLayout.createSequentialGroup().add((GroupLayout.Group)jPanelJDBCLayout.createParallelGroup(1).add(2, (GroupLayout.Group)jPanelJDBCLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelJDBCLayout.createParallelGroup(1).add((Component)this.jLabel2).add((Component)this.jLabel3)).addPreferredGap(0).add((GroupLayout.Group)jPanelJDBCLayout.createParallelGroup(1).add((Component)this.jTextFieldJDBCUrl, -1, 247, Short.MAX_VALUE).add((Component)this.jComboBoxJDBCDriver, 0, 247, Short.MAX_VALUE))).add((GroupLayout.Group)jPanelJDBCLayout.createSequentialGroup().add(9, 9, 9).add((Component)this.jPanel3, -1, -1, Short.MAX_VALUE))).addContainerGap()));
        jPanelJDBCLayout.setVerticalGroup((GroupLayout.Group)jPanelJDBCLayout.createParallelGroup(1).add((GroupLayout.Group)jPanelJDBCLayout.createSequentialGroup().addContainerGap().add((GroupLayout.Group)jPanelJDBCLayout.createParallelGroup(3).add((Component)this.jLabel2).add((Component)this.jComboBoxJDBCDriver, -2, -1, -2)).addPreferredGap(0).add((GroupLayout.Group)jPanelJDBCLayout.createParallelGroup(3).add((Component)this.jLabel3).add((Component)this.jTextFieldJDBCUrl, -2, -1, -2)).addPreferredGap(1).add((Component)this.jPanel3, -2, -1, -2).addContainerGap(-1, Short.MAX_VALUE)));
        this.add((Component)this.jPanelJDBC, "Center");
    }

    private void jComboBoxJDBCDriverActionPerformed(ActionEvent evt) {
        this.jButtonWizardActionPerformed(null);
    }

    private void jButtonWizardActionPerformed(ActionEvent evt) {
        if (this.jComboBoxJDBCDriver.getSelectedIndex() < 0) {
            return;
        }
        if (this.jComboBoxJDBCDriver.getSelectedItem() instanceof JDBCDriverDefinition) {
            String server = "localhost";
            String databaseName = "DatabaseName";
            this.jTextFieldJDBCUrl.setText(((JDBCDriverDefinition)this.jComboBoxJDBCDriver.getSelectedItem()).getUrl(server, databaseName));
        }
    }

    public void setIReportConnection(IReportConnection c) {
        this.iReportConnection = c;
        if (this.iReportConnection instanceof JDBCConnection) {
            JDBCConnection con = (JDBCConnection)this.iReportConnection;
            boolean found = false;
            for (int i = 0; i < definitions.length; ++i) {
                if (!definitions[i].getDriverName().equals(con.getJDBCDriver())) continue;
                this.jComboBoxJDBCDriver.setSelectedItem(definitions[i]);
                found = true;
            }
            if (!found) {
                this.jComboBoxJDBCDriver.setSelectedItem(con.getJDBCDriver());
            }
            this.jTextFieldJDBCUrl.setText(con.getUrl());
            this.jTextFieldUsername.setText(con.getUsername());
            if (con.isSavePassword()) {
                this.jTextFieldPassword.setText(con.getPassword());
            } else {
                this.jTextFieldPassword.setText("");
            }
            this.jCheckBoxSavePassword.setSelected(con.isSavePassword());
        }
    }

    public IReportConnection getIReportConnection() {
        JDBCConnection irConn = new JDBCConnection();
        irConn.setUsername(this.jTextFieldUsername.getText().trim());
        if (this.jCheckBoxSavePassword.isSelected()) {
            irConn.setPassword(new String(this.jTextFieldPassword.getPassword()));
        } else {
            irConn.setPassword("");
        }
        irConn.setSavePassword(this.jCheckBoxSavePassword.isSelected());
        Object obj = this.jComboBoxJDBCDriver.getSelectedItem();
        String driver = obj + "";
        if (obj instanceof JDBCDriverDefinition) {
            driver = ((JDBCDriverDefinition)obj).getDriverName();
        }
        irConn.setJDBCDriver(driver.trim());
        if (driver.trim().length() == 0 || driver.indexOf(" ") >= 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JDBCConnectionEditor.Message.JDBCDriver"), I18n.getString("JDBCConnectionEditor.Message.InvalidDriver"), 2);
            return null;
        }
        if (this.jTextFieldJDBCUrl.getText().trim().length() == 0) {
            JOptionPane.showMessageDialog(this, I18n.getString("JDBCConnectionEditor.Message.JDBCurl"), I18n.getString("JDBCConnectionEditor.Message.InvalidUrl"), 2);
            return null;
        }
        irConn.setUrl(this.jTextFieldJDBCUrl.getText().trim());
        this.iReportConnection = irConn;
        return this.iReportConnection;
    }
}

