/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.connection.gui.JRHibernateConnectionEditor;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.sql.Connection;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import net.sf.jasperreports.engine.JRDataSource;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.Transaction;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.cfg.Configuration;
import org.hibernate.classic.Session;

public class JRHibernateConnection
extends IReportConnection {
    private String name;
    private boolean useAnnotations = true;

    public Connection getConnection() {
        return null;
    }

    public boolean isJDBCConnection() {
        return false;
    }

    public boolean isJRDataSource() {
        return false;
    }

    public HashMap getProperties() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("useAnnotations", "" + this.useAnnotations);
        return map;
    }

    public void loadProperties(HashMap map) {
        String b = (String)map.get("useAnnotations");
        if (b != null) {
            this.useAnnotations = Boolean.valueOf(b);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public JRDataSource getJRDataSource() {
        return null;
    }

    public Session createSession() throws HibernateException {
        return this.getSessionFactory().openSession();
    }

    public SessionFactory getSessionFactory() throws HibernateException {
        if (this.useAnnotations) {
            AnnotationConfiguration conf = new AnnotationConfiguration().configure();
            conf.setProperty("hibernate.connection.provider_class", "com.jaspersoft.ireport.designer.connection.HibernateConnectionProvider");
            return conf.buildSessionFactory();
        }
        return new Configuration().configure().buildSessionFactory();
    }

    public String getDescription() {
        return "Hibernate connection";
    }

    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JRHibernateConnectionEditor();
    }

    public void test() throws Exception {
        try {
            SwingUtilities.invokeLater(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    Thread thread = Thread.currentThread();
                    IReportManager.getInstance();
                    thread.setContextClassLoader(IReportManager.getReportClassLoader());
                    SessionFactory hb_sessionFactory = null;
                    try {
                        hb_sessionFactory = JRHibernateConnection.this.getSessionFactory();
                        Session hb_session = hb_sessionFactory.openSession();
                        Transaction transaction = hb_session.beginTransaction();
                        Query q = hb_session.createQuery("from java.lang.String s");
                        q.setFetchSize(100);
                        Iterator iterator = q.iterate();
                        while (iterator.hasNext()) {
                            Object obj = iterator.next();
                        }
                        JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
                    }
                    catch (Throwable ex) {
                        ex.printStackTrace();
                        JOptionPane.showMessageDialog(Misc.getMainWindow(), ex.getMessage(), "Error", 0);
                        return;
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isUseAnnotations() {
        return this.useAnnotations;
    }

    public void setUseAnnotations(boolean useAnnotations) {
        this.useAnnotations = useAnnotations;
    }
}

