/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.dataview.util;

import java.sql.Time;
import java.text.DateFormat;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.netbeans.modules.db.dataview.meta.DBException;
import org.netbeans.modules.db.dataview.util.TimestampType;
import org.openide.util.NbBundle;

public class TimeType
extends TimestampType {
    private final DateFormat[] TIME_PARSING_FORMATS = new DateFormat[]{new SimpleDateFormat("HH:mm:ss", LOCALE), DateFormat.getTimeInstance(3, LOCALE)};
    private static TimeZone TIME_ZONE = TimeZone.getDefault();

    public TimeType() {
        for (int i = 0; i < this.TIME_PARSING_FORMATS.length; ++i) {
            this.TIME_PARSING_FORMATS[i].setLenient(false);
        }
    }

    public static TimeZone getTimeZone() {
        return TIME_ZONE;
    }

    public static long normalizeTime(long l) {
        int n = TIME_ZONE.inDaylightTime(new Date(l)) ? TIME_ZONE.getDSTSavings() : 0;
        return l < 86400000L ? l : l % 86400000L + (long)n;
    }

    private Time getNormalizedTime(long l) {
        Time time = null;
        time = new Time(TimeType.normalizeTime(l));
        return time;
    }

    private Time convertToTime(Object object) throws DBException {
        if (null == object) {
            return null;
        }
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof String) {
            Date date = null;
            for (int i = 0; date == null && i < this.TIME_PARSING_FORMATS.length; ++i) {
                date = this.TIME_PARSING_FORMATS[i].parse((String)object, new ParsePosition(0));
            }
            if (date == null) {
                throw new DBException(NbBundle.getMessage(TimeType.class, (String)"LBL_invalid_time"));
            }
            return this.getNormalizedTime(date.getTime());
        }
        throw new DBException(NbBundle.getMessage(TimeType.class, (String)"LBL_invalid_time"));
    }

    public Object convert(Object object) throws DBException {
        if (object instanceof Time) {
            return object;
        }
        return this.convertToTime(object);
    }
}

