/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.db.mysql.actions;

import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.db.explorer.ConnectionListener;
import org.netbeans.api.db.explorer.ConnectionManager;
import org.netbeans.api.db.explorer.DatabaseConnection;
import org.netbeans.api.db.explorer.DatabaseException;
import org.netbeans.api.db.explorer.JDBCDriver;
import org.netbeans.modules.db.mysql.Database;
import org.netbeans.modules.db.mysql.DatabaseServer;
import org.netbeans.modules.db.mysql.util.DatabaseUtils;
import org.netbeans.modules.db.mysql.util.Utils;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnectAction
extends CookieAction {
    private static final Logger LOGGER = Logger.getLogger(ConnectAction.class.getName());
    private static final Class[] COOKIE_CLASSES = new Class[]{Database.class};

    public ConnectAction() {
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    protected boolean asynchronous() {
        return false;
    }

    public String getName() {
        return Utils.getBundle().getString("LBL_ConnectAction");
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(ConnectAction.class);
    }

    public boolean enable(Node[] nodeArray) {
        return true;
    }

    protected int mode() {
        return 8;
    }

    protected Class<?>[] cookieClasses() {
        return COOKIE_CLASSES;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void performAction(Node[] nodeArray) {
        if (nodeArray == null || nodeArray.length == 0) {
            return;
        }
        Database database = (Database)nodeArray[0].getCookie(Database.class);
        DatabaseServer databaseServer = database.getServer();
        String string = database.getDbName();
        List<DatabaseConnection> list = DatabaseUtils.findDatabaseConnections(databaseServer.getURL(string));
        try {
            if (list.size() == 0) {
                final DatabaseConnection databaseConnection = DatabaseConnection.create((JDBCDriver)DatabaseUtils.getJDBCDriver(), (String)databaseServer.getURL(string), (String)databaseServer.getUser(), null, (String)(databaseServer.isSavePassword() ? databaseServer.getPassword() : null), (boolean)databaseServer.isSavePassword());
                ConnectionManager.getDefault().addConnectionListener(new ConnectionListener(){

                    public void connectionsChanged() {
                        ConnectionManager.getDefault().showConnectionDialog(databaseConnection);
                        ConnectionManager.getDefault().removeConnectionListener((ConnectionListener)this);
                    }
                });
                ConnectionManager.getDefault().addConnection(databaseConnection);
            } else {
                ConnectionManager.getDefault().showConnectionDialog(list.get(0));
            }
        }
        catch (DatabaseException databaseException) {
            LOGGER.log(Level.INFO, databaseException.getMessage(), databaseException);
            Utils.displayErrorMessage(NbBundle.getMessage(ConnectAction.class, (String)"MSG_FailureConnecting", (Object)string, (Object)databaseException.getMessage()));
        }
        finally {
            databaseServer.refreshDatabaseList();
        }
    }
}

