/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.editor.options;

import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.prefs.Preferences;
import org.netbeans.api.editor.mimelookup.MimeLookup;
import org.netbeans.api.editor.mimelookup.MimePath;
import org.netbeans.editor.BaseKit;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.editor.deprecated.pre61settings.KitchenSink;
import org.openide.options.SystemOption;
import org.openide.util.NbBundle;

public class OptionSupport
extends SystemOption {
    private static final Logger LOG = Logger.getLogger(OptionSupport.class.getName());
    static final long serialVersionUID = 2002899758839584077L;
    static final String OPTIONS_PREFIX = "OPTIONS_";
    private final Class kitClass;
    private final String typeName;
    private MimePath mimePath = null;
    private Preferences prefs = null;
    private static final HashMap kitClass2Type = new HashMap();

    public OptionSupport(Class clazz, String string) {
        this.kitClass = clazz;
        this.typeName = string;
        kitClass2Type.put(clazz, string);
    }

    public Class getKitClass() {
        return this.kitClass;
    }

    public String getTypeName() {
        return this.typeName;
    }

    public static String getTypeName(Class clazz) {
        return (String)kitClass2Type.get(clazz);
    }

    public String displayName() {
        return this.getString(OPTIONS_PREFIX + this.typeName);
    }

    public Object getSettingValue(String string) {
        return KitchenSink.getValueFromPrefs(string, this.getPreferences(), this.mimePath);
    }

    protected final boolean getSettingBoolean(String string) {
        return this.getPreferences().getBoolean(string, false);
    }

    protected final int getSettingInteger(String string) {
        return this.getPreferences().getInt(string, 0);
    }

    public void setSettingValue(String string, Object object) {
        this.setSettingValue(string, object, string);
    }

    public void setSettingValue(String string, Object object, String string2) {
        this.doSetSettingValue(string, object, string2);
    }

    public void doSetSettingValue(String string, Object object, String string2) {
        KitchenSink.setValueToPreferences(string, object, this.getPreferences(), this.mimePath);
    }

    protected void setSettingBoolean(String string, boolean bl, String string2) {
        this.getPreferences().putBoolean(string, bl);
    }

    protected void setSettingInteger(String string, int n, String string2) {
        this.getPreferences().putInt(string, n);
    }

    protected String getString(String string) {
        return NbBundle.getMessage(OptionSupport.class, (String)string);
    }

    public static String[] mergeStringArrays(String[] stringArray, String[] stringArray2) {
        return NbEditorUtilities.mergeStringArrays((String[])stringArray, (String[])stringArray2);
    }

    protected String getSettingsInitializerName() {
        return this.getTypeName() + "-options-initalizer";
    }

    protected void updateSettingsMap(Class clazz, Map map) {
    }

    Preferences getPreferences() {
        if (this.prefs == null) {
            this.mimePath = this.kitClass.equals(BaseKit.class) ? MimePath.EMPTY : MimePath.parse((String)this.getCTImpl());
            this.prefs = (Preferences)MimeLookup.getLookup((MimePath)this.mimePath).lookup(Preferences.class);
        }
        return this.prefs;
    }

    protected String getContentType() {
        BaseKit baseKit = BaseKit.getKit((Class)this.getKitClass());
        return baseKit.getContentType();
    }

    String getCTImpl() {
        String string = this.getContentType();
        if (string == null) {
            String string2 = "Can't determine mime type for " + OptionSupport.simpleToString((Object)this) + "; kitClass = " + this.getKitClass();
            LOG.log(Level.WARNING, null, new Throwable(string2));
            string = "text/plain";
        }
        return string;
    }

    private static String simpleToString(Object object) {
        if (object == null) {
            return null;
        }
        return object.getClass().getName() + "@" + Integer.toHexString(System.identityHashCode(object));
    }
}

