/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.util;

import java.awt.Color;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.SortedSet;
import net.sf.jasperreports.charts.JRAreaPlot;
import net.sf.jasperreports.charts.JRBar3DPlot;
import net.sf.jasperreports.charts.JRBarPlot;
import net.sf.jasperreports.charts.JRBubblePlot;
import net.sf.jasperreports.charts.JRCandlestickPlot;
import net.sf.jasperreports.charts.JRCategoryDataset;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.charts.JRChartAxis;
import net.sf.jasperreports.charts.JRDataRange;
import net.sf.jasperreports.charts.JRGanttDataset;
import net.sf.jasperreports.charts.JRGanttSeries;
import net.sf.jasperreports.charts.JRHighLowDataset;
import net.sf.jasperreports.charts.JRHighLowPlot;
import net.sf.jasperreports.charts.JRItemLabel;
import net.sf.jasperreports.charts.JRLinePlot;
import net.sf.jasperreports.charts.JRMeterPlot;
import net.sf.jasperreports.charts.JRMultiAxisPlot;
import net.sf.jasperreports.charts.JRPie3DPlot;
import net.sf.jasperreports.charts.JRPieDataset;
import net.sf.jasperreports.charts.JRPiePlot;
import net.sf.jasperreports.charts.JRPieSeries;
import net.sf.jasperreports.charts.JRScatterPlot;
import net.sf.jasperreports.charts.JRThermometerPlot;
import net.sf.jasperreports.charts.JRTimePeriodDataset;
import net.sf.jasperreports.charts.JRTimePeriodSeries;
import net.sf.jasperreports.charts.JRTimeSeries;
import net.sf.jasperreports.charts.JRTimeSeriesDataset;
import net.sf.jasperreports.charts.JRTimeSeriesPlot;
import net.sf.jasperreports.charts.JRValueDataset;
import net.sf.jasperreports.charts.JRValueDisplay;
import net.sf.jasperreports.charts.JRXyDataset;
import net.sf.jasperreports.charts.JRXySeries;
import net.sf.jasperreports.charts.JRXyzDataset;
import net.sf.jasperreports.charts.JRXyzSeries;
import net.sf.jasperreports.charts.util.JRMeterInterval;
import net.sf.jasperreports.crosstabs.JRCellContents;
import net.sf.jasperreports.crosstabs.JRCrosstab;
import net.sf.jasperreports.crosstabs.JRCrosstabBucket;
import net.sf.jasperreports.crosstabs.JRCrosstabCell;
import net.sf.jasperreports.crosstabs.JRCrosstabColumnGroup;
import net.sf.jasperreports.crosstabs.JRCrosstabDataset;
import net.sf.jasperreports.crosstabs.JRCrosstabMeasure;
import net.sf.jasperreports.crosstabs.JRCrosstabParameter;
import net.sf.jasperreports.crosstabs.JRCrosstabRowGroup;
import net.sf.jasperreports.crosstabs.design.JRDesignCrosstab;
import net.sf.jasperreports.crosstabs.type.CrosstabColumnPositionEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabPercentageEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabRowPositionEnum;
import net.sf.jasperreports.crosstabs.type.CrosstabTotalPositionEnum;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRBand;
import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRChart;
import net.sf.jasperreports.engine.JRChartDataset;
import net.sf.jasperreports.engine.JRChartPlot;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRConditionalStyle;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRDatasetParameter;
import net.sf.jasperreports.engine.JRDatasetRun;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementDataset;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JREllipse;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRGenericElement;
import net.sf.jasperreports.engine.JRGenericElementParameter;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGraphicElement;
import net.sf.jasperreports.engine.JRGroup;
import net.sf.jasperreports.engine.JRHyperlink;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JRImage;
import net.sf.jasperreports.engine.JRLine;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRParagraph;
import net.sf.jasperreports.engine.JRParameter;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.JRQuery;
import net.sf.jasperreports.engine.JRRectangle;
import net.sf.jasperreports.engine.JRReport;
import net.sf.jasperreports.engine.JRReportTemplate;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRScriptlet;
import net.sf.jasperreports.engine.JRSection;
import net.sf.jasperreports.engine.JRSortField;
import net.sf.jasperreports.engine.JRStaticText;
import net.sf.jasperreports.engine.JRStyle;
import net.sf.jasperreports.engine.JRStyleContainer;
import net.sf.jasperreports.engine.JRSubreport;
import net.sf.jasperreports.engine.JRSubreportParameter;
import net.sf.jasperreports.engine.JRSubreportReturnValue;
import net.sf.jasperreports.engine.JRTextElement;
import net.sf.jasperreports.engine.JRTextField;
import net.sf.jasperreports.engine.JRVariable;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.ReturnValue;
import net.sf.jasperreports.engine.TabStop;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.type.BreakTypeEnum;
import net.sf.jasperreports.engine.type.CalculationEnum;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.FooterPositionEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.IncrementTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.OnErrorTypeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.PrintOrderEnum;
import net.sf.jasperreports.engine.type.ResetTypeEnum;
import net.sf.jasperreports.engine.type.RunDirectionEnum;
import net.sf.jasperreports.engine.type.SortFieldTypeEnum;
import net.sf.jasperreports.engine.type.SortOrderEnum;
import net.sf.jasperreports.engine.type.StretchTypeEnum;
import net.sf.jasperreports.engine.type.TabStopAlignEnum;
import net.sf.jasperreports.engine.type.WhenNoDataTypeEnum;
import net.sf.jasperreports.engine.type.WhenResourceMissingTypeEnum;
import net.sf.jasperreports.engine.util.JRApiWriterVisitor;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.engine.util.ReportCreator;
import net.sf.jasperreports.engine.xml.JRXmlWriter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.time.Day;

public class JRApiWriter {
    private static final Log log = LogFactory.getLog(JRApiWriter.class);
    private JasperReportsContext jasperReportsContext;
    private JRReport report;
    private Map<String, String> stylesMap = new HashMap<String, String>();
    private Map<String, String> groupsMap = new HashMap<String, String>();
    private Writer writer;
    private JRApiWriterVisitor apiWriterVisitor = new JRApiWriterVisitor(this);
    private String indent;

    public JRApiWriter(JasperReportsContext jasperReportsContext) {
        this.jasperReportsContext = jasperReportsContext;
    }

    protected JRApiWriter(JRReport report) {
        this.report = report;
    }

    public String write(JRReport report) {
        StringWriter buffer = new StringWriter();
        this.writeReport(report, buffer);
        return buffer.toString();
    }

    public void write(JRReport report, String destFileName) throws JRException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(destFileName);
            String encoding = report.getProperty("net.sf.jasperreports.export.character.encoding") != null ? report.getProperty("net.sf.jasperreports.export.character.encoding") : "UTF-8";
            OutputStreamWriter out = new OutputStreamWriter((OutputStream)fos, encoding);
            this.writeReport(report, out);
        }
        catch (IOException e) {
            throw new JRException("Error writing to file : " + destFileName, e);
        }
        finally {
            if (fos != null) {
                try {
                    fos.close();
                }
                catch (IOException e) {}
            }
        }
    }

    public void write(JRReport report, OutputStream outputStream) throws JRException {
        try {
            String encoding = report.getProperty("net.sf.jasperreports.export.character.encoding") != null ? report.getProperty("net.sf.jasperreports.export.character.encoding") : "UTF-8";
            OutputStreamWriter out = new OutputStreamWriter(outputStream, encoding);
            this.writeReport(report, out);
        }
        catch (Exception e) {
            throw new JRException("Error writing to OutputStream : " + report.getName(), e);
        }
    }

    public static String writeReport(JRReport report) {
        return new JRApiWriter(DefaultJasperReportsContext.getInstance()).write(report);
    }

    public static void writeReport(JRReport report, String destFileName) throws JRException {
        new JRApiWriter(DefaultJasperReportsContext.getInstance()).write(report, destFileName);
    }

    public static void writeReport(JRReport report, OutputStream outputStream) throws JRException {
        new JRApiWriter(DefaultJasperReportsContext.getInstance()).write(report, outputStream);
    }

    protected void writeReport(JRReport report, Writer aWriter) {
        JRSection detail;
        JRDataset[] datasets;
        this.writer = aWriter;
        this.indent = "";
        this.write("/*\n");
        this.write(" * Generated by JasperReports - ");
        this.write(new SimpleDateFormat().format(new Date()));
        this.write("\n");
        this.write(" */\n");
        this.write("import java.awt.Color;\n");
        this.write("\n");
        this.write("import org.jfree.chart.plot.PlotOrientation;\n");
        this.write("import org.jfree.chart.renderer.xy.XYBubbleRenderer;\n");
        this.write("\n");
        this.write("import net.sf.jasperreports.charts.*;\n");
        this.write("import net.sf.jasperreports.charts.design.*;\n");
        this.write("import net.sf.jasperreports.charts.util.*;\n");
        this.write("import net.sf.jasperreports.crosstabs.*;\n");
        this.write("import net.sf.jasperreports.crosstabs.design.*;\n");
        this.write("import net.sf.jasperreports.crosstabs.fill.calculation.BucketDefinition;\n");
        this.write("import net.sf.jasperreports.engine.*;\n");
        this.write("import net.sf.jasperreports.engine.base.JRBaseChartPlot.JRBaseSeriesColor;\n");
        this.write("import net.sf.jasperreports.engine.base.JRBaseFont;\n");
        this.write("import net.sf.jasperreports.engine.design.*;\n");
        this.write("import net.sf.jasperreports.engine.type.*;\n");
        this.write("import net.sf.jasperreports.engine.util.ReportCreator;\n");
        this.write("\n\n");
        this.write("public class {0} implements ReportCreator\n", (Object)JRStringUtil.escapeJavaStringLiteral(report.getName()));
        this.write("{\n\n");
        this.indent = this.indent + "  ";
        this.write("public JasperDesign create() throws JRException\n");
        this.write("{\n");
        this.indent = this.indent + "  ";
        this.write("JasperDesign jasperDesign = new JasperDesign();\n");
        this.write("jasperDesign.setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(report.getName()));
        this.write("jasperDesign.setLanguage(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(report.getLanguage()));
        this.write("jasperDesign.setColumnCount({0, number, #});\n", report.getColumnCount(), 1);
        this.write("jasperDesign.setPrintOrder({0});\n", report.getPrintOrderValue(), PrintOrderEnum.VERTICAL);
        this.write("jasperDesign.setColumnDirection({0});\n", report.getColumnDirection(), RunDirectionEnum.LTR);
        this.write("jasperDesign.setPageWidth({0, number, #});\n", report.getPageWidth());
        this.write("jasperDesign.setPageHeight({0, number, #});\n", report.getPageHeight());
        this.write("jasperDesign.setOrientation({0});\n", report.getOrientationValue(), OrientationEnum.PORTRAIT);
        this.write("jasperDesign.setWhenNoDataType({0});\n", report.getWhenNoDataTypeValue(), WhenNoDataTypeEnum.NO_PAGES);
        this.write("jasperDesign.setColumnWidth({0, number, #});\n", report.getColumnWidth());
        this.write("jasperDesign.setColumnSpacing({0, number, #});\n", report.getColumnSpacing());
        this.write("jasperDesign.setLeftMargin({0, number, #});\n", report.getLeftMargin());
        this.write("jasperDesign.setRightMargin({0, number, #});\n", report.getRightMargin());
        this.write("jasperDesign.setTopMargin({0, number, #});\n", report.getTopMargin());
        this.write("jasperDesign.setBottomMargin({0, number, #});\n", report.getBottomMargin());
        this.write("jasperDesign.setTitleNewPage({0});\n", report.isTitleNewPage(), false);
        this.write("jasperDesign.setSummaryNewPage({0});\n", report.isSummaryNewPage(), false);
        this.write("jasperDesign.setSummaryWithPageHeaderAndFooter({0});\n", report.isSummaryWithPageHeaderAndFooter(), false);
        this.write("jasperDesign.setFloatColumnFooter({0});\n", report.isFloatColumnFooter(), false);
        this.write("jasperDesign.setScriptletClass(\"{0}\");\n", (Object)report.getScriptletClass());
        this.write("jasperDesign.setFormatFactoryClass(\"{0}\");\n", (Object)report.getFormatFactoryClass());
        this.write("jasperDesign.setResourceBundle(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(report.getResourceBundle()));
        this.write("jasperDesign.setWhenResourceMissingType({0});\n", report.getWhenResourceMissingTypeValue(), WhenResourceMissingTypeEnum.NULL);
        this.write("jasperDesign.setIgnorePagination({0});\n\n", report.isIgnorePagination(), false);
        this.writeProperties(report, "jasperDesign");
        this.write("\n");
        String[] imports = report.getImports();
        if (imports != null && imports.length > 0) {
            for (int i = 0; i < imports.length; ++i) {
                String value = imports[i];
                if (value == null) continue;
                this.write("jasperDesign.addImport(\"{0}\");\n", (Object)value);
            }
        }
        this.writeTemplates(report, this.indent);
        this.write("\n");
        JRStyle[] styles = report.getStyles();
        if (styles != null && styles.length > 0) {
            this.write("//styles\n");
            for (int i = 0; i < styles.length; ++i) {
                String styleName = JRStringUtil.getJavaIdentifier(styles[i].getName());
                this.writeStyle(styles[i], styleName);
                this.write("jasperDesign.addStyle(" + styleName + ");\n\n");
                if (!this.toWriteConditionalStyles()) continue;
                JRConditionalStyle[] conditionalStyles = styles[i].getConditionalStyles();
                if (styles[i] instanceof JRConditionalStyle || conditionalStyles == null) continue;
                for (int j = 0; j < conditionalStyles.length; ++j) {
                    String conditionalStyleName = styleName + "Conditional" + j;
                    this.writeConditionalStyle(conditionalStyles[j], conditionalStyleName);
                    this.write(styles[i].getName() + ".addConditionalStyle(" + conditionalStyleName + ");\n\n");
                }
                this.flush();
            }
            this.flush();
        }
        if ((datasets = report.getDatasets()) != null && datasets.length > 0) {
            this.write("//datasets\n");
            for (int i = 0; i < datasets.length; ++i) {
                this.writeDataset(datasets[i], "reportDataset" + i);
                if (datasets[i] == null) continue;
                this.write("jasperDesign.addDataset(reportDataset" + i + ");\n");
            }
            this.write("\n");
            this.flush();
        }
        if (report.getMainDataset() != null) {
            this.writeDataset(report.getMainDataset(), "reportMainDataset");
            this.write("jasperDesign.setMainDataset(reportMainDataset);\n");
        }
        if (report.getBackground() != null) {
            this.write("//background\n\n");
            this.writeBand(report.getBackground(), "backgroundBand");
            this.write("jasperDesign.setBackground(backgroundBand);\n\n");
        }
        if (report.getTitle() != null) {
            this.write("//title\n\n");
            this.writeBand(report.getTitle(), "titleBand");
            this.write("jasperDesign.setTitle(titleBand);\n\n");
        }
        if (report.getPageHeader() != null) {
            this.write("//page header\n\n");
            this.writeBand(report.getPageHeader(), "pageHeaderBand");
            this.write("jasperDesign.setPageHeader(pageHeaderBand);\n\n");
        }
        if (report.getColumnHeader() != null) {
            this.write("//column header\n\n");
            this.writeBand(report.getColumnHeader(), "columnHeaderBand");
            this.write("jasperDesign.setColumnHeader(columnHeaderBand);\n\n");
        }
        if ((detail = report.getDetailSection()) != null && detail.getBands() != null && detail.getBands().length > 0) {
            this.writeSection(detail, "detailBand", this.indent + "((JRDesignSection)jasperDesign.getDetailSection()).getBandsList()");
        }
        if (report.getColumnFooter() != null) {
            this.write("//column footer\n\n");
            this.writeBand(report.getColumnFooter(), "columnFooterBand");
            this.write("jasperDesign.setColumnFooter(columnFooterBand);\n\n");
        }
        if (report.getPageFooter() != null) {
            this.write("//page footer\n\n");
            this.writeBand(report.getPageFooter(), "pageFooterBand");
            this.write("jasperDesign.setPageFooter(pageFooterBand);\n\n");
        }
        if (report.getLastPageFooter() != null) {
            this.write("//last page footer\n\n");
            this.writeBand(report.getLastPageFooter(), "lastPageFooterBand");
            this.write("jasperDesign.setLastPageFooter(lastPageFooterBand);\n\n");
        }
        if (report.getSummary() != null) {
            this.write("//summary\n\n");
            this.writeBand(report.getSummary(), "summaryBand");
            this.write("jasperDesign.setSummary(summaryBand);\n\n");
        }
        if (report.getNoData() != null) {
            this.write("//no data\n\n");
            this.writeBand(report.getNoData(), "noDataBand");
            this.write("jasperDesign.setNoData(noDataBand);\n\n");
        }
        this.write("return jasperDesign;\n");
        this.indent = "  ";
        this.write("}\n\n");
        this.indent = "";
        this.write("}\n");
        this.flush();
        this.close();
    }

    protected void writeReport(Writer aWriter) {
        this.writeReport(this.report, aWriter);
    }

    private void writeProperties(JRPropertiesHolder propertiesHolder, String propertiesHolderName) {
        if (propertiesHolder.hasProperties()) {
            JRPropertiesMap propertiesMap = propertiesHolder.getPropertiesMap();
            String[] propertyNames = propertiesMap.getPropertyNames();
            if (propertyNames != null && propertyNames.length > 0) {
                this.write("//properties\n");
                for (int i = 0; i < propertyNames.length; ++i) {
                    String value = propertiesMap.getProperty(propertyNames[i]);
                    if (value == null) continue;
                    this.write(propertiesHolderName + ".setProperty(\"" + propertyNames[i] + "\", \"" + JRStringUtil.escapeJavaStringLiteral(value) + "\");\n");
                }
                this.write("\n");
            }
            this.flush();
        }
    }

    protected void writeTemplates(JRReport report, String indent) {
        JRReportTemplate[] templates = report.getTemplates();
        if (templates != null) {
            for (int i = 0; i < templates.length; ++i) {
                JRReportTemplate template = templates[i];
                this.writeTemplate(template, "reportTemplate" + i);
                this.write("jasperDesign.addTemplate(reportTemplate" + i + ");\n");
            }
            this.write("\n");
            this.flush();
        }
    }

    protected void writeTemplate(JRReportTemplate template, String templateName) {
        this.write("JRDesignReportTemplate " + templateName + " = new JRDesignReportTemplate();\n");
        this.writeExpression(template.getSourceExpression(), templateName, "SourceExpression", String.class.getName());
        this.flush();
    }

    private void writeScriptlet(JRScriptlet scriptlet, String scriptletName) {
        if (scriptlet != null) {
            this.write("JRDesignScriptlet " + scriptletName + " = new JRDesignScriptlet();\n");
            this.write(scriptletName + ".setDescription(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(scriptlet.getDescription()));
            this.write(scriptletName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(scriptlet.getName()));
            this.write(scriptletName + ".setValueClassName(\"{0}\");\n", (Object)scriptlet.getValueClassName());
            this.writeProperties(scriptlet, scriptletName);
            this.flush();
        }
    }

    private void writeParameter(JRParameter parameter, String parameterName) {
        if (parameter != null) {
            this.write("JRDesignParameter " + parameterName + " = new JRDesignParameter();\n");
            this.write(parameterName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(parameter.getName()));
            this.write(parameterName + ".setDescription(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(parameter.getDescription()));
            this.write(parameterName + ".setValueClassName(\"{0}\");\n", (Object)parameter.getValueClassName());
            this.write(parameterName + ".setNestedTypeName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(parameter.getNestedTypeName()));
            this.write(parameterName + ".setForPrompting({0});\n", parameter.isForPrompting(), true);
            this.writeProperties(parameter, parameterName);
            this.writeExpression(parameter.getDefaultValueExpression(), parameterName, "DefaultValueExpression");
            this.flush();
        }
    }

    private void writeQuery(JRQuery query, String queryName) {
        if (query != null) {
            this.write("JRDesignQuery " + queryName + " = new JRDesignQuery();\n");
            this.write(queryName + ".setLanguage(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(query.getLanguage()), "sql");
            this.write(queryName + ".setText(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(query.getText()));
            this.flush();
        }
    }

    private void writeField(JRField field, String fieldName) {
        if (field != null) {
            this.write("JRDesignField " + fieldName + " = new JRDesignField();\n");
            this.write(fieldName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(field.getName()));
            this.write(fieldName + ".setDescription(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(field.getDescription()));
            this.write(fieldName + ".setValueClassName(\"{0}\");\n", (Object)field.getValueClassName());
            this.writeProperties(field, fieldName);
            this.flush();
        }
    }

    private void writeSortField(JRSortField sortField, String sortFieldName) {
        if (sortField != null) {
            this.write("JRDesignSortField " + sortFieldName + " = new JRDesignSortField();\n");
            this.write(sortFieldName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(sortField.getName()));
            this.write(sortFieldName + ".setOrder({0});\n", sortField.getOrderValue(), SortOrderEnum.ASCENDING);
            this.write(sortFieldName + ".setType({0});\n", sortField.getType(), SortFieldTypeEnum.FIELD);
            this.flush();
        }
    }

    private void writeVariable(JRVariable variable, String variableName) {
        if (variable != null) {
            String resetGroupName = this.getGroupName(variable.getResetGroup());
            String incrementGroupName = this.getGroupName(variable.getIncrementGroup());
            this.write("JRDesignVariable " + variableName + " = new JRDesignVariable();\n");
            this.write(variableName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(variable.getName()));
            this.write(variableName + ".setValueClassName(\"{0}\");\n", (Object)variable.getValueClassName());
            this.write(variableName + ".setResetType({0});\n", variable.getResetTypeValue(), ResetTypeEnum.REPORT);
            this.write(variableName + ".setResetGroup({0});\n", (Object)resetGroupName);
            this.write(variableName + ".setIncrementType({0});\n", variable.getIncrementTypeValue(), IncrementTypeEnum.NONE);
            this.write(variableName + ".setIncrementGroup({0});\n", (Object)incrementGroupName);
            this.write(variableName + ".setCalculation({0});\n", variable.getCalculationValue(), CalculationEnum.NOTHING);
            this.write(variableName + ".setIncrementerFactoryClass({0}.class);\n", (Object)JRStringUtil.escapeJavaStringLiteral(variable.getIncrementerFactoryClassName()));
            this.writeExpression(variable.getExpression(), variableName, "Expression");
            this.writeExpression(variable.getInitialValueExpression(), variableName, "InitialValueExpression");
            this.flush();
        }
    }

    private void writeGroup(JRGroup group) {
        JRSection groupFooter;
        String groupName = group.getName();
        this.groupsMap.put(groupName, groupName);
        this.write("JRDesignGroup " + groupName + " = new JRDesignGroup();\n");
        this.write(groupName + ".setName(\"" + JRStringUtil.escapeJavaStringLiteral(groupName) + "\");\n");
        this.write(groupName + ".setStartNewColumn({0});\n", group.isStartNewColumn(), false);
        this.write(groupName + ".setStartNewPage({0});\n", group.isStartNewPage(), false);
        this.write(groupName + ".setReprintHeaderOnEachPage({0});\n", group.isReprintHeaderOnEachPage(), false);
        this.write(groupName + ".setMinHeightToStartNewPage({0});\n", group.getMinHeightToStartNewPage());
        this.write(groupName + ".setFooterPosition({0});\n", group.getFooterPositionValue(), FooterPositionEnum.NORMAL);
        this.write(groupName + ".setKeepTogether({0});\n", group.isKeepTogether(), false);
        this.writeExpression(group.getExpression(), groupName, "Expression");
        JRSection groupHeader = group.getGroupHeaderSection();
        if (groupHeader != null) {
            this.writeSection(groupHeader, groupName + "Header", "((JRDesignSection)" + groupName + ".getGroupHeaderSection()).getBandsList()");
        }
        if ((groupFooter = group.getGroupFooterSection()) != null) {
            this.writeSection(groupFooter, groupName + "Footer", "((JRDesignSection)" + groupName + ".getGroupFooterSection()).getBandsList()");
        }
        this.flush();
    }

    protected void writeSection(JRSection section, String sectionName, String sectionBandListGetterName) {
        if (section != null) {
            JRBand[] bands = section.getBands();
            if (bands != null && bands.length > 0) {
                this.write("//" + sectionName + "\n\n");
                for (int i = 0; i < bands.length; ++i) {
                    this.writeBand(bands[i], sectionName + i);
                    this.write(sectionBandListGetterName + ".add(" + i + ", " + sectionName + i + ");\n\n");
                }
            }
            this.flush();
        }
    }

    private void writeBand(JRBand band, String bandName) {
        if (band != null) {
            this.write("//band name = " + bandName + "\n\n");
            this.write("JRDesignBand " + bandName + " = new JRDesignBand();\n");
            this.write(bandName + ".setHeight({0, number, #});\n", band.getHeight());
            this.write(bandName + ".setSplitType({0});\n", band.getSplitTypeValue());
            this.writeExpression(band.getPrintWhenExpression(), bandName, "PrintWhenExpression");
            this.writeChildElements(band, bandName);
            this.flush();
        }
    }

    public void writeChildElements(JRElementGroup elementContainer, String parentName) {
        List<JRChild> children = elementContainer.getChildren();
        if (children != null && children.size() > 0) {
            for (int i = 0; i < children.size(); ++i) {
                String childName = parentName + "_" + i;
                this.apiWriterVisitor.setName(childName);
                children.get(i).visit(this.apiWriterVisitor);
                if (children.get(i) instanceof JRElementGroup && !(children.get(i) instanceof JRElement)) {
                    this.write(parentName + ".addElementGroup(" + childName + ");\n\n");
                    continue;
                }
                if (children.get(i) instanceof JRComponentElement) continue;
                this.write(parentName + ".addElement(" + childName + ");\n\n");
            }
        }
    }

    public void writeElementGroup(JRElementGroup elementGroup, String groupName) {
        if (elementGroup != null) {
            this.write("JRDesignElementGroup " + groupName + " = new JRDesignElementGroup();\n");
            this.writeChildElements(elementGroup, groupName);
            this.flush();
        }
    }

    public void writeBreak(JRBreak breakElement, String breakName) {
        if (breakElement != null) {
            this.write("JRDesignBreak " + breakName + " = new JRDesignBreak(jasperDesign);\n");
            this.write(breakName + ".setType({0});\n", breakElement.getTypeValue(), BreakTypeEnum.PAGE);
            this.writeReportElement(breakElement, breakName);
            this.flush();
        }
    }

    public void writeLine(JRLine line, String lineName) {
        if (line != null) {
            this.write("JRDesignLine " + lineName + " = new JRDesignLine(jasperDesign);\n");
            this.write(lineName + ".setDirection({0});\n", line.getDirectionValue(), LineDirectionEnum.TOP_DOWN);
            this.writeReportElement(line, lineName);
            this.writeGraphicElement(line, lineName);
            this.flush();
        }
    }

    private void writeReportElement(JRElement element, String elementName) {
        if (element != null) {
            this.write(elementName + ".setKey(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(element.getKey()));
            this.writeStyleReferenceAttr(element, elementName);
            this.write(elementName + ".setPositionType({0});\n", element.getPositionTypeValue());
            this.write(elementName + ".setStretchType({0});\n", element.getStretchTypeValue(), StretchTypeEnum.NO_STRETCH);
            this.write(elementName + ".setPrintRepeatedValues({0});\n", element.isPrintRepeatedValues(), true);
            this.write(elementName + ".setMode({0});\n", element.getOwnModeValue());
            this.write(elementName + ".setX({0, number, #});\n", element.getX());
            this.write(elementName + ".setY({0, number, #});\n", element.getY());
            this.write(elementName + ".setWidth({0, number, #});\n", element.getWidth());
            this.write(elementName + ".setHeight({0, number, #});\n", element.getHeight());
            this.write(elementName + ".setRemoveLineWhenBlank({0});\n", element.isRemoveLineWhenBlank(), false);
            this.write(elementName + ".setPrintInFirstWholeBand({0});\n", element.isPrintInFirstWholeBand(), false);
            this.write(elementName + ".setPrintWhenDetailOverflows({0});\n", element.isPrintWhenDetailOverflows(), false);
            if (element.getPrintWhenGroupChanges() != null) {
                String groupName = this.getGroupName(element.getPrintWhenGroupChanges());
                this.write(elementName + ".setPrintWhenGroupChanges(" + groupName + ");\n");
            }
            this.write(elementName + ".setForecolor({0});\n", element.getOwnForecolor());
            this.write(elementName + ".setBackcolor({0});\n", element.getOwnBackcolor());
            this.writeProperties(element, elementName + ".getPropertiesMap()");
            this.writePropertyExpressions(element.getPropertyExpressions(), elementName);
            this.writeExpression(element.getPrintWhenExpression(), elementName, "PrintWhenExpression");
            this.flush();
        }
    }

    protected void writePropertyExpressions(JRPropertyExpression[] propertyExpressions, String propertyHolderName) {
        if (propertyExpressions != null && propertyExpressions.length > 0) {
            for (int i = 0; i < propertyExpressions.length; ++i) {
                this.writePropertyExpression(propertyExpressions[i], propertyHolderName + "PropertyExpression" + i);
                this.write(propertyHolderName + ".addPropertyExpression(" + propertyHolderName + "PropertyExpression" + i + ");\n");
            }
            this.flush();
        }
    }

    protected void writePropertyExpression(JRPropertyExpression propertyExpression, String propertyExpressionName) {
        if (propertyExpression != null) {
            this.write("JRDesignPropertyExpression " + propertyExpressionName + " = new JRDesignPropertyExpression();\n");
            this.write(propertyExpressionName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(propertyExpression.getName()));
            this.writeExpression(propertyExpression.getValueExpression(), propertyExpressionName, "ValueExpression");
            this.flush();
        }
    }

    private void writeGraphicElement(JRGraphicElement element, String elementName) {
        if (element != null) {
            this.write(elementName + ".setFill({0});\n", element.getOwnFillValue());
            this.writePen(element.getLinePen(), elementName + ".getLinePen()");
            this.flush();
        }
    }

    public void writeRectangle(JRRectangle rectangle, String rectangleName) {
        if (rectangle != null) {
            this.write("JRDesignRectangle " + rectangleName + " = new JRDesignRectangle(jasperDesign);\n");
            this.write(rectangleName + ".setRadius({0});\n", rectangle.getOwnRadius());
            this.writeReportElement(rectangle, rectangleName);
            this.writeGraphicElement(rectangle, rectangleName);
            this.flush();
        }
    }

    public void writeEllipse(JREllipse ellipse, String ellipseName) {
        if (ellipse != null) {
            this.write("JRDesignEllipse " + ellipseName + " = new JRDesignEllipse(jasperDesign);\n");
            this.writeReportElement(ellipse, ellipseName);
            this.writeGraphicElement(ellipse, ellipseName);
            this.flush();
        }
    }

    public void writeImage(JRImage image, String imageName) {
        if (image != null) {
            this.write("JRDesignImage " + imageName + " = new JRDesignImage(jasperDesign);\n");
            this.write(imageName + ".setScaleImage({0});\n", image.getOwnScaleImageValue());
            this.write(imageName + ".setHorizontalAlignment({0});\n", image.getOwnHorizontalAlignmentValue());
            this.write(imageName + ".setVerticalAlignment({0});\n", image.getOwnVerticalAlignmentValue());
            this.write(imageName + ".setUsingCache({0});\n", image.getUsingCache());
            this.write(imageName + ".setLazy({0});\n", image.isLazy(), false);
            this.write(imageName + ".setOnErrorType({0});\n", image.getOnErrorTypeValue(), OnErrorTypeEnum.ERROR);
            this.write(imageName + ".setEvaluationTime({0});\n", image.getEvaluationTimeValue(), EvaluationTimeEnum.NOW);
            this.write(imageName + ".setEvaluationGroup({0});\n", (Object)this.getGroupName(image.getEvaluationGroup()));
            if (image.getLinkType() != null) {
                this.write(imageName + ".setLinkType(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(image.getLinkType()), HyperlinkTypeEnum.NONE.getName());
            }
            if (image.getLinkTarget() != null) {
                this.write(imageName + ".setLinkTarget(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(image.getLinkTarget()), HyperlinkTargetEnum.SELF.getName());
            }
            this.write(imageName + ".setBookmarkLevel({0, number, #});\n", image.getBookmarkLevel(), 0);
            this.writeReportElement(image, imageName);
            this.writeBox(image.getLineBox(), imageName + ".getLineBox()");
            this.writeGraphicElement(image, imageName);
            this.writeExpression(image.getExpression(), imageName, "Expression");
            this.writeExpression(image.getAnchorNameExpression(), imageName, "AnchorNameExpression");
            this.writeExpression(image.getHyperlinkReferenceExpression(), imageName, "HyperlinkReferenceExpression");
            this.writeExpression(image.getHyperlinkWhenExpression(), imageName, "HyperlinkWhenExpression");
            this.writeExpression(image.getHyperlinkAnchorExpression(), imageName, "HyperlinkAnchorExpression");
            this.writeExpression(image.getHyperlinkPageExpression(), imageName, "HyperlinkPageExpression");
            this.writeExpression(image.getHyperlinkTooltipExpression(), imageName, "HyperlinkTooltipExpression");
            this.writeHyperlinkParameters(image.getHyperlinkParameters(), imageName);
            this.flush();
        }
    }

    public void writeStaticText(JRStaticText staticText, String staticTextName) {
        if (staticText != null) {
            this.write("JRDesignStaticText " + staticTextName + " = new JRDesignStaticText(jasperDesign);\n");
            this.writeReportElement(staticText, staticTextName);
            this.writeBox(staticText.getLineBox(), staticTextName + ".getLineBox()");
            this.writeTextElement(staticText, staticTextName);
            this.write(staticTextName + ".setText(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(staticText.getText()));
            this.flush();
        }
    }

    private void writeTextElement(JRTextElement textElement, String textElementName) {
        if (textElement != null) {
            this.write(textElementName + ".setHorizontalAlignment({0});\n", textElement.getOwnHorizontalAlignmentValue());
            this.write(textElementName + ".setVerticalAlignment({0});\n", textElement.getOwnVerticalAlignmentValue());
            this.write(textElementName + ".setRotation({0});\n", textElement.getOwnRotationValue());
            this.write(textElementName + ".setMarkup(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(textElement.getOwnMarkup()));
            this.writeFont(textElement, textElementName);
            this.writeParagraph(textElement.getParagraph(), textElementName);
            this.flush();
        }
    }

    private void writeFont(JRFont font, String fontHolderName) {
        if (font != null) {
            this.write(fontHolderName + ".setFontName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(font.getOwnFontName()));
            this.write(fontHolderName + ".setFontSize({0, number, #});\n", font.getOwnFontSize());
            this.write(fontHolderName + ".setBold({0});\n", font.isOwnBold());
            this.write(fontHolderName + ".setItalic({0});\n", font.isOwnItalic());
            this.write(fontHolderName + ".setUnderline({0});\n", font.isOwnUnderline());
            this.write(fontHolderName + ".setStrikeThrough({0});\n", font.isOwnStrikeThrough());
            this.write(fontHolderName + ".setPdfFontName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(font.getOwnPdfFontName()));
            this.write(fontHolderName + ".setPdfEncoding(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(font.getOwnPdfEncoding()));
            this.write(fontHolderName + ".setPdfEmbedded({0});\n", font.isOwnPdfEmbedded());
            this.flush();
        }
    }

    private void writeCommonStyle(JRStyle style, String styleName) {
        this.write(styleName + ".setMode({0});\n", style.getOwnModeValue());
        this.write(styleName + ".setFontName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getOwnFontName()));
        this.write(styleName + ".setFontSize({0, number, #});\n", style.getOwnFontSize());
        this.write(styleName + ".setBold({0});\n", style.isOwnBold());
        this.write(styleName + ".setItalic({0});\n", style.isOwnItalic());
        this.write(styleName + ".setUnderline({0});\n", style.isOwnUnderline());
        this.write(styleName + ".setStrikeThrough({0});\n", style.isOwnStrikeThrough());
        this.write(styleName + ".setPdfFontName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getOwnPdfFontName()));
        this.write(styleName + ".setPdfEncoding(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getOwnPdfEncoding()));
        this.write(styleName + ".setPdfEmbedded({0});\n", style.isOwnPdfEmbedded());
        this.write(styleName + ".setForecolor({0});\n", style.getOwnForecolor());
        this.write(styleName + ".setBackcolor({0});\n", style.getOwnBackcolor());
        this.write(styleName + ".setFill({0});\n", style.getOwnFillValue());
        this.write(styleName + ".setRadius({0});\n", style.getOwnRadius());
        this.write(styleName + ".setScaleImage({0});\n", style.getOwnScaleImageValue());
        this.write(styleName + ".setHorizontalAlignment({0});\n", style.getOwnHorizontalAlignmentValue());
        this.write(styleName + ".setVerticalAlignment({0});\n", style.getOwnVerticalAlignmentValue());
        this.write(styleName + ".setRotation({0});\n", style.getOwnRotationValue());
        this.write(styleName + ".setMarkup(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getOwnMarkup()));
        this.write(styleName + ".setPattern(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getOwnPattern()));
        this.write(styleName + ".setBlankWhenNull({0});\n", style.isOwnBlankWhenNull());
        this.writePen(style.getLinePen(), styleName + ".getLinePen()");
        this.writeBox(style.getLineBox(), styleName + ".getLineBox()");
        this.writeParagraph(style.getParagraph(), styleName);
    }

    private void writeStyle(JRStyle style, String styleName) {
        if (style != null && this.stylesMap.get(style.getName()) == null) {
            this.write("JRDesignStyle " + styleName + " = new JRDesignStyle();\n");
            this.write(styleName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getName()));
            if (style.getStyle() != null) {
                this.write(styleName + ".setParentStyle({0});\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getStyle().getName()));
            } else if (style.getStyleNameReference() != null) {
                this.write(styleName + ".setParentStyleNameReference(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getStyleNameReference()));
            }
            this.write(styleName + ".setDefault({0});\n", style.isDefault(), false);
            this.writeCommonStyle(style, styleName);
            this.stylesMap.put(style.getName(), styleName);
            this.flush();
        }
    }

    public void writeTextField(JRTextField textField, String textFieldName) {
        if (textField != null) {
            this.write("JRDesignTextField " + textFieldName + " = new JRDesignTextField(jasperDesign);\n");
            this.write(textFieldName + ".setBold({0});\n", textField.isOwnBold());
            this.write(textFieldName + ".setStretchWithOverflow({0});\n", textField.isStretchWithOverflow(), false);
            this.write(textFieldName + ".setEvaluationTime({0});\n", textField.getEvaluationTimeValue(), EvaluationTimeEnum.NOW);
            this.write(textFieldName + ".setEvaluationGroup({0});\n", (Object)this.getGroupName(textField.getEvaluationGroup()));
            this.write(textFieldName + ".setPattern(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(textField.getOwnPattern()));
            this.write(textFieldName + ".setBlankWhenNull({0});\n", textField.isOwnBlankWhenNull());
            if (textField.getLinkType() != null) {
                this.write(textFieldName + ".setLinkType(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(textField.getLinkType()), HyperlinkTypeEnum.NONE.getName());
            }
            if (textField.getLinkTarget() != null) {
                this.write(textFieldName + ".setLinkTarget(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(textField.getLinkTarget()), HyperlinkTargetEnum.SELF.getName());
            }
            this.write(textFieldName + ".setBookmarkLevel({0, number, #});\n", textField.getBookmarkLevel(), 0);
            this.writeReportElement(textField, textFieldName);
            this.writeBox(textField.getLineBox(), textFieldName + ".getLineBox()");
            this.writeTextElement(textField, textFieldName);
            this.writeExpression(textField.getExpression(), textFieldName, "Expression");
            this.writeExpression(textField.getPatternExpression(), textFieldName, "PatternExpression");
            this.writeExpression(textField.getAnchorNameExpression(), textFieldName, "AnchorNameExpression");
            this.writeExpression(textField.getHyperlinkReferenceExpression(), textFieldName, "HyperlinkReferenceExpression");
            this.writeExpression(textField.getHyperlinkWhenExpression(), textFieldName, "HyperlinkWhenExpression");
            this.writeExpression(textField.getHyperlinkAnchorExpression(), textFieldName, "HyperlinkAnchorExpression");
            this.writeExpression(textField.getHyperlinkPageExpression(), textFieldName, "HyperlinkPageExpression");
            this.writeExpression(textField.getHyperlinkTooltipExpression(), textFieldName, "HyperlinkTooltipExpression");
            this.writeHyperlinkParameters(textField.getHyperlinkParameters(), textFieldName);
            this.flush();
        }
    }

    public void writeSubreport(JRSubreport subreport, String subreportName) {
        if (subreport != null) {
            this.write("JRDesignSubreport " + subreportName + " = new JRDesignSubreport(jasperDesign);\n");
            this.write(subreportName + ".setUsingCache({0});\n", subreport.getUsingCache());
            this.write(subreportName + ".setRunToBottom({0});\n", subreport.isRunToBottom());
            this.writeReportElement(subreport, subreportName);
            this.writeExpression(subreport.getParametersMapExpression(), subreportName, "ParametersMapExpression");
            JRSubreportParameter[] parameters = subreport.getParameters();
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    this.writeSubreportParameter(parameters[i], subreportName + "Parameter" + i);
                    this.write(subreportName + ".addParameter(" + subreportName + "Parameter" + i + ");\n");
                }
            }
            this.writeExpression(subreport.getConnectionExpression(), subreportName, "ConnectionExpression");
            this.writeExpression(subreport.getDataSourceExpression(), subreportName, "DataSourceExpression");
            JRSubreportReturnValue[] returnValues = subreport.getReturnValues();
            if (returnValues != null && returnValues.length > 0) {
                for (int i = 0; i < returnValues.length; ++i) {
                    this.writeSubreportReturnValue(returnValues[i], subreportName + "ReturnValue" + i);
                    this.write(subreportName + ".addReturnValue(" + subreportName + "ReturnValue" + i + ");\n");
                }
            }
            this.writeExpression(subreport.getExpression(), subreportName, "Expression");
            this.flush();
        }
    }

    private void writeSubreportParameter(JRSubreportParameter subreportParameter, String subreportParameterName) {
        if (subreportParameter != null) {
            this.write("JRDesignSubreportParameter " + subreportParameterName + " = new JRDesignSubreportParameter();\n");
            this.write(subreportParameterName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(subreportParameter.getName()));
            this.writeExpression(subreportParameter.getExpression(), subreportParameterName, "Expression");
            this.flush();
        }
    }

    private void writeDatasetParameter(JRDatasetParameter datasetParameter, String runName, String datasetParameterName) {
        if (datasetParameter != null) {
            this.write("JRDesignDatasetParameter " + datasetParameterName + " = new JRDesignSubreportParameter();\n");
            this.write(datasetParameterName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(datasetParameter.getName()));
            this.writeExpression(datasetParameter.getExpression(), datasetParameterName, "Expression");
            this.write(runName + ".addParameter(" + datasetParameterName + ");\n");
            this.flush();
        }
    }

    private void writeChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write(chartName + ".setShowLegend({0});\n", (Object)this.getBooleanText(chart.getShowLegend()));
            this.write(chartName + ".setEvaluationTime({0});\n", chart.getEvaluationTimeValue(), EvaluationTimeEnum.NOW);
            this.write(chartName + ".setEvaluationGroup({0});\n", (Object)this.getGroupName(chart.getEvaluationGroup()));
            if (chart.getLinkType() != null) {
                this.write(chartName + ".setLinkType(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(chart.getLinkType()), HyperlinkTypeEnum.NONE.getName());
            }
            if (chart.getLinkTarget() != null) {
                this.write(chartName + ".setLinkTarget(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(chart.getLinkTarget()), HyperlinkTargetEnum.SELF.getName());
            }
            this.write(chartName + ".setBookmarkLevel({0, number, #});\n", chart.getBookmarkLevel(), 0);
            if (chart.getCustomizerClass() != null) {
                this.write(chartName + ".setCustomizerClass(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(chart.getCustomizerClass()));
            }
            this.write(chartName + ".setRenderType(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(chart.getRenderType()));
            this.write(chartName + ".setTheme(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(chart.getTheme()));
            this.writeReportElement(chart, chartName);
            this.writeBox(chart.getLineBox(), chartName + ".getLineBox()");
            this.write(chartName + ".setTitlePosition({0});\n", chart.getTitlePositionValue());
            this.write(chartName + ".setTitleColor({0});\n", chart.getOwnTitleColor());
            if (chart.getTitleFont() != null) {
                this.write(chartName + ".setTitleFont(new JRBaseFont());\n");
                this.writeFont(chart.getTitleFont(), chartName + ".getTitleFont()");
            }
            this.writeExpression(chart.getTitleExpression(), chartName, "TitleExpression");
            this.write(chartName + ".setSubtitleColor({0});\n", chart.getOwnSubtitleColor());
            if (chart.getSubtitleFont() != null) {
                this.write(chartName + ".setSubtitleFont(new JRBaseFont());\n");
                this.writeFont(chart.getSubtitleFont(), chartName + ".getSubtitleFont()");
            }
            this.writeExpression(chart.getSubtitleExpression(), chartName, "SubtitleExpression");
            this.write(chartName + ".setLegendColor({0});\n", chart.getOwnLegendColor());
            this.write(chartName + ".setLegendBackgroundColor({0});\n", chart.getOwnLegendBackgroundColor());
            this.write(chartName + ".setLegendPosition({0});\n", chart.getLegendPositionValue());
            if (chart.getLegendFont() != null) {
                this.write(chartName + ".setLegendFont(new JRBaseFont());\n");
                this.writeFont(chart.getLegendFont(), chartName + ".getLegendFont()");
            }
            this.writeExpression(chart.getAnchorNameExpression(), chartName, "AnchorNameExpression");
            this.writeExpression(chart.getHyperlinkReferenceExpression(), chartName, "HyperlinkReferenceExpression");
            this.writeExpression(chart.getHyperlinkWhenExpression(), chartName, "HyperlinkWhenExpression");
            this.writeExpression(chart.getHyperlinkAnchorExpression(), chartName, "HyperlinkAnchorExpression");
            this.writeExpression(chart.getHyperlinkPageExpression(), chartName, "HyperlinkPageExpression");
            this.writeExpression(chart.getHyperlinkTooltipExpression(), chartName, "HyperlinkTooltipExpression");
            this.writeHyperlinkParameters(chart.getHyperlinkParameters(), chartName);
            this.flush();
        }
    }

    public void writeElementDataset(JRElementDataset dataset, String datasetName) {
        this.writeElementDataset(dataset, true, datasetName);
    }

    public void writeElementDataset(JRElementDataset dataset, boolean skipIfEmpty, String datasetName) {
        if (dataset != null) {
            this.write(datasetName + ".setResetType({0});\n", dataset.getResetTypeValue(), ResetTypeEnum.REPORT);
            if (dataset.getResetTypeValue() == ResetTypeEnum.GROUP) {
                String resetGroupName = this.getGroupName(dataset.getResetGroup());
                this.write(datasetName + ".setResetGroup(" + resetGroupName + ");\n");
            }
            this.write(datasetName + ".setIncrementType({0});\n", dataset.getIncrementTypeValue(), IncrementTypeEnum.NONE);
            if (dataset.getIncrementTypeValue() == IncrementTypeEnum.GROUP) {
                String incrementGroupName = this.getGroupName(dataset.getIncrementGroup());
                this.write(datasetName + ".setIncrementGroup(" + incrementGroupName + ");\n");
            }
            this.writeExpression(dataset.getIncrementWhenExpression(), datasetName, "IncrementWhenExpression");
            JRDatasetRun datasetRun = dataset.getDatasetRun();
            if (datasetRun != null) {
                this.writeDatasetRun(datasetRun, datasetName);
            }
            this.flush();
        }
    }

    private void writeCategoryDataSet(JRCategoryDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignCategoryDataset " + datasetName + " = new JRDesignCategoryDataset(" + parentName + ".getDataset());\n");
            this.writeElementDataset(dataset, datasetName);
            JRCategorySeries[] categorySeries = dataset.getSeries();
            if (categorySeries != null && categorySeries.length > 0) {
                for (int i = 0; i < categorySeries.length; ++i) {
                    this.writeCategorySeries(categorySeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeTimeSeriesDataset(JRTimeSeriesDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignTimeSeriesDataset " + datasetName + " =  new JRDesignTimeSeriesDataset(" + parentName + ".getDataset());\n");
            if (dataset.getTimePeriod() != null && !Day.class.getName().equals(dataset.getTimePeriod().getName())) {
                this.write(datasetName + ".setTimePeriod({0}.class);\n", (Object)dataset.getTimePeriod().getName());
            }
            this.writeElementDataset(dataset, datasetName);
            JRTimeSeries[] timeSeries = dataset.getSeries();
            if (timeSeries != null && timeSeries.length > 0) {
                for (int i = 0; i < timeSeries.length; ++i) {
                    this.writeTimeSeries(timeSeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeGanttDataset(JRGanttDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignGanttDataset " + datasetName + " = new JRDesignGanttDataset(" + parentName + ".getDataset());\n");
            this.writeElementDataset(dataset, datasetName);
            JRGanttSeries[] ganttSeries = dataset.getSeries();
            if (ganttSeries != null && ganttSeries.length > 0) {
                for (int i = 0; i < ganttSeries.length; ++i) {
                    this.writeGanttSeries(ganttSeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeTimePeriodDataset(JRTimePeriodDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignTimePeriodDataset " + datasetName + " = new JRDesignTimePeriodDataset(" + parentName + ".getDataset());\n");
            this.writeElementDataset(dataset, datasetName);
            JRTimePeriodSeries[] timePeriodSeries = dataset.getSeries();
            if (timePeriodSeries != null && timePeriodSeries.length > 0) {
                for (int i = 0; i < timePeriodSeries.length; ++i) {
                    this.writeTimePeriodSeries(timePeriodSeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writePieSeries(JRPieSeries pieSeries, String parentName, int index) {
        if (pieSeries != null) {
            String pieSeriesName = parentName + "PieSeries" + index;
            this.write("JRDesignPieSeries " + pieSeriesName + " = new JRDesignPieSeries();\n");
            this.writeExpression(pieSeries.getKeyExpression(), pieSeriesName, "KeyExpression");
            this.writeExpression(pieSeries.getValueExpression(), pieSeriesName, "ValueExpression");
            this.writeExpression(pieSeries.getLabelExpression(), pieSeriesName, "LabelExpression");
            this.writeHyperlink(pieSeries.getSectionHyperlink(), pieSeriesName, "SectionHyperlink");
            this.write(parentName + ".addPieSeries(" + pieSeriesName + ");\n");
            this.flush();
        }
    }

    private void writeCategorySeries(JRCategorySeries categorySeries, String parentName, int index) {
        if (categorySeries != null) {
            String categorySeriesName = parentName + "CategorySeries" + index;
            this.write("JRDesignCategorySeries " + categorySeriesName + " = new JRDesignCategorySeries();\n");
            this.writeExpression(categorySeries.getSeriesExpression(), categorySeriesName, "SeriesExpression");
            this.writeExpression(categorySeries.getCategoryExpression(), categorySeriesName, "CategoryExpression");
            this.writeExpression(categorySeries.getValueExpression(), categorySeriesName, "ValueExpression");
            this.writeExpression(categorySeries.getLabelExpression(), categorySeriesName, "LabelExpression");
            this.writeHyperlink(categorySeries.getItemHyperlink(), categorySeriesName, "ItemHyperlink");
            this.write(parentName + ".addCategorySeries(" + categorySeriesName + ");\n");
            this.flush();
        }
    }

    private void writeXyzDataset(JRXyzDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignXyzDataset " + datasetName + " = new JRDesignXyzDataset(" + parentName + ".getDataset());\n");
            this.writeElementDataset(dataset, datasetName);
            JRXyzSeries[] series = dataset.getSeries();
            if (series != null && series.length > 0) {
                for (int i = 0; i < series.length; ++i) {
                    this.writeXyzSeries(series[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeXyzSeries(JRXyzSeries series, String parentName, int index) {
        if (series != null) {
            String xyzSeriesName = parentName + "XyzSeries" + index;
            this.write("JRDesignXyzSeries " + xyzSeriesName + " = new JRDesignXyzSeries();\n");
            this.writeExpression(series.getSeriesExpression(), xyzSeriesName, "SeriesExpression");
            this.writeExpression(series.getXValueExpression(), xyzSeriesName, "XValueExpression");
            this.writeExpression(series.getYValueExpression(), xyzSeriesName, "YValueExpression");
            this.writeExpression(series.getZValueExpression(), xyzSeriesName, "ZValueExpression");
            this.writeHyperlink(series.getItemHyperlink(), xyzSeriesName, "ItemHyperlink");
            this.write(parentName + ".addXyzSeries(" + xyzSeriesName + ");\n");
            this.flush();
        }
    }

    private void writeXySeries(JRXySeries xySeries, String parentName, int index) {
        if (xySeries != null) {
            String xySeriesName = parentName + "XySeries" + index;
            this.write("JRDesignXySeries " + xySeriesName + " = new JRDesignXySeries();\n");
            if (xySeries.getAutoSort() != null) {
                this.write(xySeriesName + ".setAutoSort({0});\n", xySeries.getAutoSort());
            }
            this.writeExpression(xySeries.getSeriesExpression(), xySeriesName, "SeriesExpression");
            this.writeExpression(xySeries.getXValueExpression(), xySeriesName, "XValueExpression");
            this.writeExpression(xySeries.getYValueExpression(), xySeriesName, "YValueExpression");
            this.writeExpression(xySeries.getLabelExpression(), xySeriesName, "LabelExpression");
            this.writeHyperlink(xySeries.getItemHyperlink(), xySeriesName, "ItemHyperlink");
            this.write(parentName + ".addXySeries(" + xySeriesName + ");\n");
            this.flush();
        }
    }

    private void writeXyDataset(JRXyDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignXyDataset " + datasetName + " = new JRDesignXyDataset(" + parentName + ".getDataset());\n");
            this.writeElementDataset(dataset, datasetName);
            JRXySeries[] xySeries = dataset.getSeries();
            if (xySeries != null && xySeries.length > 0) {
                for (int i = 0; i < xySeries.length; ++i) {
                    this.writeXySeries(xySeries[i], datasetName, i);
                }
            }
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeTimeSeries(JRTimeSeries timeSeries, String parentName, int index) {
        if (timeSeries != null) {
            String timeSeriesName = parentName + "TimeSeries" + index;
            this.write("JRDesignTimeSeries " + timeSeriesName + " = new JRDesignTimeSeries();\n");
            this.writeExpression(timeSeries.getSeriesExpression(), timeSeriesName, "SeriesExpression");
            this.writeExpression(timeSeries.getTimePeriodExpression(), timeSeriesName, "TimePeriodExpression");
            this.writeExpression(timeSeries.getValueExpression(), timeSeriesName, "ValueExpression");
            this.writeExpression(timeSeries.getLabelExpression(), timeSeriesName, "LabelExpression");
            this.writeHyperlink(timeSeries.getItemHyperlink(), timeSeriesName, "ItemHyperlink");
            this.write(parentName + ".addTimeSeries(" + timeSeriesName + ");\n");
            this.flush();
        }
    }

    private void writeGanttSeries(JRGanttSeries ganttSeries, String parentName, int index) {
        if (ganttSeries != null) {
            String ganttSeriesName = parentName + "GanttSeries" + index;
            this.write("JRDesignGanttSeries " + ganttSeriesName + " = new JRDesignGanttSeries();\n");
            this.writeExpression(ganttSeries.getSeriesExpression(), ganttSeriesName, "SeriesExpression");
            this.writeExpression(ganttSeries.getTaskExpression(), ganttSeriesName, "TaskExpression");
            this.writeExpression(ganttSeries.getSubtaskExpression(), ganttSeriesName, "SubtaskExpression");
            this.writeExpression(ganttSeries.getStartDateExpression(), ganttSeriesName, "StartDateExpression");
            this.writeExpression(ganttSeries.getEndDateExpression(), ganttSeriesName, "EndDateExpression");
            this.writeExpression(ganttSeries.getPercentExpression(), ganttSeriesName, "PercentExpression");
            this.writeExpression(ganttSeries.getLabelExpression(), ganttSeriesName, "LabelExpression");
            this.writeHyperlink(ganttSeries.getItemHyperlink(), ganttSeriesName, "ItemHyperlink");
            this.write(parentName + ".addGanttSeries(" + ganttSeriesName + ");\n");
            this.flush();
        }
    }

    private void writeTimePeriodSeries(JRTimePeriodSeries timePeriodSeries, String parentName, int index) {
        if (timePeriodSeries != null) {
            String timePeriodSeriesName = parentName + "TimePeriodSeries" + index;
            this.write("JRDesignTimePeriodSeries " + timePeriodSeriesName + " = new JRDesignTimePeriodSeries();\n");
            this.writeExpression(timePeriodSeries.getSeriesExpression(), timePeriodSeriesName, "SeriesExpression");
            this.writeExpression(timePeriodSeries.getStartDateExpression(), timePeriodSeriesName, "StartDateExpression");
            this.writeExpression(timePeriodSeries.getEndDateExpression(), timePeriodSeriesName, "EndDateExpression");
            this.writeExpression(timePeriodSeries.getValueExpression(), timePeriodSeriesName, "ValueExpression");
            this.writeExpression(timePeriodSeries.getLabelExpression(), timePeriodSeriesName, "LabelExpression");
            this.writeHyperlink(timePeriodSeries.getItemHyperlink(), timePeriodSeriesName, "ItemHyperlink");
            this.write(parentName + ".addTimePeriodSeries(" + timePeriodSeriesName + ");\n");
            this.flush();
        }
    }

    public void writePieDataset(JRPieDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignPieDataset " + datasetName + " = new JRDesignPieDataset(" + parentName + ".getDataset());\n");
            this.write(datasetName + ".setMaxCount(Integer.valueOf({0, number, #}));\n", dataset.getMaxCount());
            this.write(datasetName + ".setMinPercentage({0});\n", dataset.getMinPercentage());
            this.writeElementDataset(dataset, datasetName);
            JRPieSeries[] pieSeries = dataset.getSeries();
            if (pieSeries != null) {
                if (pieSeries.length > 1) {
                    for (int i = 0; i < pieSeries.length; ++i) {
                        this.writePieSeries(pieSeries[i], datasetName, i);
                    }
                } else {
                    this.writePieSeries(pieSeries[0], datasetName, 0);
                }
            }
            this.writeExpression(dataset.getOtherKeyExpression(), datasetName, "OtherKeyExpression");
            this.writeExpression(dataset.getOtherLabelExpression(), datasetName, "OtherLabelExpression");
            this.writeHyperlink(dataset.getOtherSectionHyperlink(), datasetName, "OtherSectionHyperlink");
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    public void writeValueDataset(JRValueDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignValueDataset " + datasetName + " = new JRDesignValueDataset(" + parentName + ".getDataset());\n");
            this.writeElementDataset(dataset, datasetName);
            this.writeExpression(dataset.getValueExpression(), datasetName, "ValueExpression");
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    public void writeValueDisplay(JRValueDisplay valueDisplay, String parentName) {
        if (valueDisplay != null) {
            String valueDisplayName = parentName + "ValueDisplay";
            this.write("JRDesignValueDisplay " + valueDisplayName + " = new JRDesignValueDisplay(" + parentName + ".getValueDisplay(), " + parentName + ".getChart());\n");
            this.write(valueDisplayName + ".setColor({0});\n", valueDisplay.getColor());
            this.write(valueDisplayName + ".setMask(\"{0}\");\n", (Object)valueDisplay.getMask());
            this.write(valueDisplayName + ".setFont(new JRBaseFont());\n");
            if (valueDisplay.getFont() != null) {
                this.write(valueDisplayName + ".setFont(new JRBaseFont());\n");
                this.writeFont(valueDisplay.getFont(), valueDisplayName + ".getFont()");
            }
            this.write(parentName + ".setValueDisplay(" + valueDisplayName + ");\n");
            this.flush();
        }
    }

    public void writeItemLabel(JRItemLabel itemLabel, String parentName, String itemLabelSuffix) {
        if (itemLabel != null) {
            String itemLabelName = parentName + itemLabelSuffix;
            this.write("JRDesignItemLabel " + itemLabelName + " = new JRDesignItemLabel(" + parentName + ".getItemLabel(), " + parentName + ".getChart());\n");
            this.write(itemLabelName + ".setColor({0});\n", itemLabel.getColor());
            this.write(itemLabelName + ".setBackgroundColor({0});\n", itemLabel.getBackgroundColor());
            if (itemLabel.getFont() != null) {
                this.write(itemLabelName + ".setFont(new JRBaseFont());\n");
                this.writeFont(itemLabel.getFont(), itemLabelName + ".getFont()");
            }
            this.write(parentName + ".set" + itemLabelSuffix + "(" + itemLabelName + ");\n");
            this.flush();
        }
    }

    public void writeDataRange(JRDataRange dataRange, String parentName, String dataRangeSuffix) {
        if (dataRange != null) {
            String dataRangeName = parentName + dataRangeSuffix;
            this.write("JRDesignDataRange " + dataRangeName + " = new JRDesignDataRange(" + parentName + ".get" + dataRangeSuffix + "());\n");
            this.writeExpression(dataRange.getLowExpression(), dataRangeName, "LowExpression");
            this.writeExpression(dataRange.getHighExpression(), dataRangeName, "HighExpression");
            this.write(parentName + ".set" + dataRangeSuffix + "(" + dataRangeName + ");\n");
            this.flush();
        }
    }

    private void writeMeterInterval(JRMeterInterval interval, String parentName, String meterIntervalName) {
        if (interval != null) {
            this.write("JRMeterInterval " + meterIntervalName + " = new JRMeterInterval();\n");
            this.write(meterIntervalName + ".setLabel(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(interval.getLabel()));
            this.write(meterIntervalName + ".setBackgroundColor({0});\n", interval.getBackgroundColor());
            this.write(meterIntervalName + ".setAlpha({0});\n", interval.getAlphaDouble());
            this.writeDataRange(interval.getDataRange(), meterIntervalName, "DataRange");
            this.write(parentName + ".addInterval(" + meterIntervalName + ");\n");
            this.flush();
        }
    }

    private void writeSeriesColors(SortedSet<JRChartPlot.JRSeriesColor> seriesColors, String parentName) {
        if (seriesColors == null || seriesColors.size() == 0) {
            return;
        }
        JRChartPlot.JRSeriesColor[] colors = seriesColors.toArray(new JRChartPlot.JRSeriesColor[seriesColors.size()]);
        for (int i = 0; i < colors.length; ++i) {
            String seriesColorName = parentName + "SeriesColor" + i;
            this.write("JRBaseSeriesColor " + seriesColorName + " = new JRBaseSeriesColor(" + colors[i].getSeriesOrder() + ", {0});\n", colors[i].getColor());
            this.write(parentName + ".addSeriesColor(" + seriesColorName + ");\n");
            this.flush();
        }
    }

    private void writeChartAxis(JRChartAxis chartAxis, String parentName, String axisName, String chartName) {
        if (chartAxis != null) {
            this.writeChartTag(chartAxis.getChart(), axisName + "Chart");
            this.write("JRDesignChartAxis " + axisName + " = new JRDesignChartAxis(" + axisName + "Chart);\n");
            this.write(axisName + ".setPosition({0});\n", chartAxis.getPositionValue());
            this.write(axisName + ".setChart(" + axisName + "Chart);\n");
            this.write(parentName + ".addAxis(" + axisName + ");\n");
            this.flush();
        }
    }

    private void writePlot(JRChartPlot plot, String plotName) {
        if (plot != null) {
            this.write(plotName + ".setBackcolor({0});\n", plot.getOwnBackcolor());
            if (plot.getOrientationValue() != null && plot.getOrientationValue().getOrientation() != PlotOrientation.VERTICAL) {
                this.write(plotName + ".setOrientation(PlotOrientation.{0});\n", plot.getOrientationValue());
            }
            this.write(plotName + ".setBackgroundAlpha({0});\n", plot.getBackgroundAlphaFloat());
            this.write(plotName + ".setForegroundAlpha({0});\n", plot.getForegroundAlphaFloat());
            this.writeSeriesColors(plot.getSeriesColors(), plotName);
            this.flush();
        }
    }

    public void writePieChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_PIE);\n");
            this.writeChart(chart, chartName);
            this.writePieDataset((JRPieDataset)chart.getDataset(), chartName, "PieDataset");
            JRPiePlot plot = (JRPiePlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "PiePlot";
                this.write("JRDesignPiePlot " + plotName + " = (JRDesignPiePlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setShowLabels({0});\n", (Object)this.getBooleanText(plot.getShowLabels()));
                this.write(plotName + ".setCircular({0});\n", (Object)this.getBooleanText(plot.getCircular()));
                this.write(plotName + ".setLabelFormat(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(plot.getLabelFormat()));
                this.write(plotName + ".setLegendLabelFormat(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(plot.getLegendLabelFormat()));
                this.writePlot(plot, plotName);
                this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
                this.flush();
            }
            this.flush();
        }
    }

    public void writePie3DChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_PIE3D);\n");
            this.writeChart(chart, chartName);
            this.writePieDataset((JRPieDataset)chart.getDataset(), chartName, "PieDataset");
            JRPie3DPlot plot = (JRPie3DPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "Pie3DPlot";
                this.write("JRDesignPie3DPlot " + plotName + " = (JRDesignPie3DPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setShowLabels({0});\n", (Object)this.getBooleanText(plot.getShowLabels()));
                this.write(plotName + ".setCircular({0});\n", (Object)this.getBooleanText(plot.getCircular()));
                this.write(plotName + ".setLabelFormat(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(plot.getLabelFormat()));
                this.write(plotName + ".setLegendLabelFormat(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(plot.getLegendLabelFormat()));
                this.write(plotName + ".setDepthFactor({0});\n", plot.getDepthFactorDouble());
                this.writePlot(plot, plotName);
                this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
                this.flush();
            }
            this.flush();
        }
    }

    public void writeCategoryAxisFormat(String indent, JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Boolean axisVerticalTickLabels, Double labelRotation, Color axisLineColor, String parentName, String axisNameSuffix) {
        if (axisLabelFont == null && axisLabelColor == null && axisTickLabelFont == null && axisTickLabelColor == null && axisLineColor == null) {
            return;
        }
        String axisName = parentName + axisNameSuffix;
        this.write("JRCategoryAxisFormat " + axisName + " = " + parentName + ";\n");
        this.write(axisName + ".setCategoryAxisTickLabelRotation({0});\n", labelRotation);
        this.writeAxisFormat(indent, axisLabelFont, axisLabelColor, axisTickLabelFont, axisTickLabelColor, axisTickLabelMask, axisVerticalTickLabels, axisLineColor, parentName, axisNameSuffix, false);
        this.flush();
    }

    public void writeAxisFormat(String indent, JRFont axisLabelFont, Color axisLabelColor, JRFont axisTickLabelFont, Color axisTickLabelColor, String axisTickLabelMask, Boolean axisVerticalTickLabels, Color axisLineColor, String parentName, String axisNameSuffix, boolean isToSet) {
        if (axisLabelFont == null && axisLabelColor == null && axisTickLabelFont == null && axisTickLabelColor == null && axisLineColor == null) {
            return;
        }
        String axisName = parentName + axisNameSuffix;
        if (isToSet) {
            this.write("JRAxisFormat " + axisName + " = new JRAxisFormat();\n");
        }
        this.write(axisName + ".setLabelColor({0});\n", axisLabelColor);
        this.write(axisName + ".setTickLabelColor({0});\n", axisTickLabelColor);
        this.write(axisName + ".setLineColor({0});\n", axisLineColor);
        this.write(axisName + ".setTickLabelMask(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(axisTickLabelMask));
        this.write(axisName + ".setVerticalTickLabel({0});\n", (Object)this.getBooleanText(axisVerticalTickLabels));
        if (axisLabelFont != null) {
            this.write(axisName + ".setLabelFont(new JRBaseFont());\n");
            this.writeFont(axisLabelFont, axisName + ".getLabelFont()");
        }
        if (axisTickLabelFont != null) {
            this.write(axisName + ".setTickLabelFont(new JRBaseFont());\n");
            this.writeFont(axisTickLabelFont, axisName + ".getTickLabelFont()");
        }
        if (isToSet) {
            this.write(parentName + ".set" + axisNameSuffix + "(" + axisName + ");\n");
        }
        this.flush();
    }

    private void writeBarPlot(JRBarPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "BarPlot";
            this.write("JRDesignBarPlot " + plotName + " = (JRDesignBarPlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLabels({0});\n", (Object)this.getBooleanText(plot.getShowLabels()));
            this.write(plotName + ".setShowTickLabels({0});\n", (Object)this.getBooleanText(plot.getShowTickLabels()));
            this.write(plotName + ".setShowTickMarks({0});\n", (Object)this.getBooleanText(plot.getShowTickMarks()));
            this.writePlot(plot, plotName);
            this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
            this.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.indent, plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName, "CategoryAxisFormat");
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    private void writeBubblePlot(JRBubblePlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "BubblePlot";
            this.write("JRDesignBubblePlot " + plotName + " = (JRDesignBubblePlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setScaleType({0});\n", plot.getScaleTypeValue());
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getXAxisLabelExpression(), plotName, "XAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getXAxisVerticalTickLabels(), plot.getOwnXAxisLineColor(), plotName, "XAxisFormat", true);
            this.writeExpression(plot.getYAxisLabelExpression(), plotName, "YAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getYAxisVerticalTickLabels(), plot.getOwnYAxisLineColor(), plotName, "YAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    private void writeLinePlot(JRLinePlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "LinePlot";
            this.write("JRDesignLinePlot " + plotName + " = (JRDesignLinePlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLines({0});\n", (Object)this.getBooleanText(plot.getShowLines()));
            this.write(plotName + ".setShowShapes({0});\n", (Object)this.getBooleanText(plot.getShowShapes()));
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.indent, plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName, "CategoryAxisFormat");
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    private void writeTimeSeriesPlot(JRTimeSeriesPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "TimeSeriesPlot";
            this.write("JRDesignTimeSeriesPlot " + plotName + " = (JRDesignTimeSeriesPlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLines({0});\n", (Object)this.getBooleanText(plot.getShowLines()));
            this.write(plotName + ".setShowShapes({0});\n", (Object)this.getBooleanText(plot.getShowShapes()));
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getTimeAxisLabelExpression(), plotName, "TimeAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor(), plotName, "TimeAxisFormat", true);
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    public void writeBar3DPlot(JRBar3DPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "Bar3DPlot";
            this.write("JRDesignBar3DPlot " + plotName + " = (JRDesignBar3DPlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLabels({0});\n", (Object)this.getBooleanText(plot.getShowLabels()));
            this.write(plotName + ".setXOffset({0});\n", plot.getXOffsetDouble());
            this.write(plotName + ".setYOffset({0});\n", plot.getYOffsetDouble());
            this.writePlot(plot, plotName);
            this.writeItemLabel(plot.getItemLabel(), plotName, "ItemLabel");
            this.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.indent, plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName, "CategoryAxisFormat");
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    public void writeBarChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_BAR);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeBar3DChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_BAR3D);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBar3DPlot((JRBar3DPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeBubbleChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_BUBBLE);\n");
            this.writeChart(chart, chartName);
            this.writeXyzDataset((JRXyzDataset)chart.getDataset(), chartName, "XyzDataset");
            this.writeBubblePlot((JRBubblePlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeStackedBarChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_STACKEDBAR);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeStackedBar3DChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_STACKEDBAR3D);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeBar3DPlot((JRBar3DPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeLineChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_LINE);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeLinePlot((JRLinePlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeTimeSeriesChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_TIMESERIES);\n");
            this.writeChart(chart, chartName);
            this.writeTimeSeriesDataset((JRTimeSeriesDataset)chart.getDataset(), chartName, "TimeSeriesDataset");
            this.writeTimeSeriesPlot((JRTimeSeriesPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeHighLowDataset(JRHighLowDataset dataset, String parentName, String datasetNameSuffix) {
        if (dataset != null) {
            String datasetName = parentName + datasetNameSuffix;
            this.write("JRDesignHighLowDataset " + datasetName + " = (JRDesignHighLowDataset)" + parentName + ".getDataset();\n");
            this.writeElementDataset(dataset, datasetName);
            this.writeExpression(dataset.getSeriesExpression(), datasetName, "SeriesExpression");
            this.writeExpression(dataset.getDateExpression(), datasetName, "DateExpression");
            this.writeExpression(dataset.getHighExpression(), datasetName, "HighExpression");
            this.writeExpression(dataset.getLowExpression(), datasetName, "LowExpression");
            this.writeExpression(dataset.getOpenExpression(), datasetName, "OpenExpression");
            this.writeExpression(dataset.getCloseExpression(), datasetName, "CloseExpression");
            this.writeExpression(dataset.getVolumeExpression(), datasetName, "VolumeExpression");
            this.writeHyperlink(dataset.getItemHyperlink(), datasetName, "ItemHyperlink");
            this.write(parentName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    public void writeHighLowChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_HIGHLOW);\n");
            this.writeChart(chart, chartName);
            this.writeHighLowDataset((JRHighLowDataset)chart.getDataset(), chartName, "HighLowDataset");
            JRHighLowPlot plot = (JRHighLowPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "HighLowPlot";
                this.write("JRDesignHighLowPlot " + plotName + " = (JRDesignHighLowPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setShowOpenTicks({0});\n", (Object)this.getBooleanText(plot.getShowOpenTicks()));
                this.write(plotName + ".setShowCloseTicks({0});\n", (Object)this.getBooleanText(plot.getShowCloseTicks()));
                this.writePlot(plot, plotName);
                this.writeExpression(plot.getTimeAxisLabelExpression(), plotName, "TimeAxisLabelExpression");
                this.writeAxisFormat(this.indent, plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor(), plotName, "TimeAxisFormat", true);
                this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
                this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
                this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
                this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
                this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
                this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
                this.flush();
            }
            this.flush();
        }
    }

    public void writeGanttChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_GANTT);\n");
            this.writeChart(chart, chartName);
            this.writeGanttDataset((JRGanttDataset)chart.getDataset(), chartName, "GanttDataset");
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeCandlestickChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_CANDLESTICK);\n");
            this.writeChart(chart, chartName);
            this.writeHighLowDataset((JRHighLowDataset)chart.getDataset(), chartName, "HighLowDataset");
            JRCandlestickPlot plot = (JRCandlestickPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "CandlestickPlot";
                this.write("JRDesignCandlestickPlot " + plotName + " = (JRDesignCandlestickPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setShowVolume({0});\n", (Object)this.getBooleanText(plot.getShowVolume()));
                this.writePlot(plot, plotName);
                this.writeExpression(plot.getTimeAxisLabelExpression(), plotName, "TimeAxisLabelExpression");
                this.writeAxisFormat(this.indent, plot.getTimeAxisLabelFont(), plot.getOwnTimeAxisLabelColor(), plot.getTimeAxisTickLabelFont(), plot.getOwnTimeAxisTickLabelColor(), plot.getTimeAxisTickLabelMask(), plot.getTimeAxisVerticalTickLabels(), plot.getOwnTimeAxisLineColor(), plotName, "TimeAxisFormat", true);
                this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
                this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
                this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
                this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
                this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
                this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
                this.flush();
            }
            this.flush();
        }
    }

    private void writeAreaPlot(JRAreaPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "AreaPlot";
            this.write("JRDesignAreaPlot " + plotName + " = (JRDesignAreaPlot)" + chartName + ".getPlot();\n");
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getCategoryAxisLabelExpression(), plotName, "CategoryAxisLabelExpression");
            this.writeCategoryAxisFormat(this.indent, plot.getCategoryAxisLabelFont(), plot.getOwnCategoryAxisLabelColor(), plot.getCategoryAxisTickLabelFont(), plot.getOwnCategoryAxisTickLabelColor(), plot.getCategoryAxisTickLabelMask(), plot.getCategoryAxisVerticalTickLabels(), plot.getCategoryAxisTickLabelRotation(), plot.getOwnCategoryAxisLineColor(), plotName, "CategoryAxisFormat");
            this.writeExpression(plot.getValueAxisLabelExpression(), plotName, "ValueAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getValueAxisLabelFont(), plot.getOwnValueAxisLabelColor(), plot.getValueAxisTickLabelFont(), plot.getOwnValueAxisTickLabelColor(), plot.getValueAxisTickLabelMask(), plot.getValueAxisVerticalTickLabels(), plot.getOwnValueAxisLineColor(), plotName, "ValueAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    public void writeAreaChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_AREA);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeAreaPlot((JRAreaPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    private void writeScatterPlot(JRScatterPlot plot, String chartName) {
        if (plot != null) {
            String plotName = chartName + "ScatterPlot";
            this.write("JRDesignScatterPlot " + plotName + " = (JRDesignScatterPlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setShowLines({0});\n", (Object)this.getBooleanText(plot.getShowLines()));
            this.write(plotName + ".setShowShapes({0});\n", (Object)this.getBooleanText(plot.getShowShapes()));
            this.writePlot(plot, plotName);
            this.writeExpression(plot.getXAxisLabelExpression(), plotName, "XAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getXAxisLabelFont(), plot.getOwnXAxisLabelColor(), plot.getXAxisTickLabelFont(), plot.getOwnXAxisTickLabelColor(), plot.getXAxisTickLabelMask(), plot.getXAxisVerticalTickLabels(), plot.getOwnXAxisLineColor(), plotName, "XAxisFormat", true);
            this.writeExpression(plot.getYAxisLabelExpression(), plotName, "YAxisLabelExpression");
            this.writeAxisFormat(this.indent, plot.getYAxisLabelFont(), plot.getOwnYAxisLabelColor(), plot.getYAxisTickLabelFont(), plot.getOwnYAxisTickLabelColor(), plot.getYAxisTickLabelMask(), plot.getYAxisVerticalTickLabels(), plot.getOwnYAxisLineColor(), plotName, "YAxisFormat", true);
            this.writeExpression(plot.getDomainAxisMinValueExpression(), plotName, "DomainAxisMinValueExpression");
            this.writeExpression(plot.getDomainAxisMaxValueExpression(), plotName, "DomainAxisMaxValueExpression");
            this.writeExpression(plot.getRangeAxisMinValueExpression(), plotName, "RangeAxisMinValueExpression");
            this.writeExpression(plot.getRangeAxisMaxValueExpression(), plotName, "RangeAxisMaxValueExpression");
            this.flush();
        }
    }

    public void writeScatterChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_SCATTER);\n");
            this.writeChart(chart, chartName);
            this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            this.writeScatterPlot((JRScatterPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeXyAreaChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_XYAREA);\n");
            this.writeChart(chart, chartName);
            this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            this.writeAreaPlot((JRAreaPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeXyBarChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_XYBAR);\n");
            this.writeChart(chart, chartName);
            JRChartDataset dataset = chart.getDataset();
            if (dataset.getDatasetType() == 6) {
                this.writeTimeSeriesDataset((JRTimeSeriesDataset)dataset, chartName, "TimeSeriesDataset");
            } else if (dataset.getDatasetType() == 5) {
                this.writeTimePeriodDataset((JRTimePeriodDataset)dataset, chartName, "XyDataset");
            } else if (dataset.getDatasetType() == 3) {
                this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            }
            this.writeBarPlot((JRBarPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeXyLineChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_XYLINE);\n");
            this.writeChart(chart, chartName);
            this.writeXyDataset((JRXyDataset)chart.getDataset(), chartName, "XyDataset");
            this.writeLinePlot((JRLinePlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeMeterChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_METER);\n");
            this.writeChart(chart, chartName);
            this.writeValueDataset((JRValueDataset)chart.getDataset(), chartName, "ValueDataset");
            JRMeterPlot plot = (JRMeterPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "MeterPlot";
                this.write("JRDesignMeterPlot " + plotName + " = (JRDesignMeterPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setShape({0});\n", plot.getShapeValue());
                this.write(plotName + ".setMeterAngle(Integer.valueOf({0, number, #}));\n", plot.getMeterAngleInteger());
                this.write(plotName + ".setUnits(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(plot.getUnits()));
                this.write(plotName + ".setTickInterval({0});\n", plot.getTickIntervalDouble());
                this.write(plotName + ".setMeterBackgroundColor({0});\n", plot.getMeterBackgroundColor());
                this.write(plotName + ".setNeedleColor({0});\n", plot.getNeedleColor());
                this.write(plotName + ".setTickColor({0});\n", plot.getTickColor());
                this.write(plotName + ".setTickCount({0});\n", plot.getTickCount());
                this.writePlot(plot, plotName);
                if (plot.getTickLabelFont() != null) {
                    this.write(plotName + ".setTickLabelFont(new JRBaseFont());\n");
                    this.writeFont(plot.getTickLabelFont(), plotName + ".getTickLabelFont()");
                    this.flush();
                }
                this.writeValueDisplay(plot.getValueDisplay(), plotName);
                this.writeDataRange(plot.getDataRange(), plotName, "DataRange");
                List<JRMeterInterval> intervals = plot.getIntervals();
                if (intervals != null && intervals.size() > 0) {
                    for (int i = 0; i < intervals.size(); ++i) {
                        JRMeterInterval meterInterval = intervals.get(i);
                        this.writeMeterInterval(meterInterval, plotName, plotName + "Interval" + i);
                    }
                }
                this.flush();
            }
            this.flush();
        }
    }

    public void writeThermometerChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_THERMOMETER);\n");
            this.writeChart(chart, chartName);
            this.writeValueDataset((JRValueDataset)chart.getDataset(), chartName, "ValueDataset");
            JRThermometerPlot plot = (JRThermometerPlot)chart.getPlot();
            if (plot != null) {
                String plotName = chartName + "ThermometerPlot";
                this.write("JRDesignThermometerPlot " + plotName + " = (JRDesignThermometerPlot)" + chartName + ".getPlot();\n");
                this.write(plotName + ".setValueLocation({0});\n", plot.getValueLocationValue());
                this.write(plotName + ".setMercuryColor({0});\n", plot.getMercuryColor());
                this.writePlot(plot, plotName);
                this.writeValueDisplay(plot.getValueDisplay(), plotName);
                this.writeDataRange(plot.getDataRange(), plotName, "DataRange");
                if (plot.getLowRange() != null) {
                    this.writeDataRange(plot.getLowRange(), plotName, "LowRange");
                }
                if (plot.getMediumRange() != null) {
                    this.writeDataRange(plot.getMediumRange(), plotName, "MediumRange");
                }
                if (plot.getHighRange() != null) {
                    this.writeDataRange(plot.getHighRange(), plotName, "HighRange");
                }
                this.flush();
            }
            this.flush();
        }
    }

    public void writeMultiAxisChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_MULTI_AXIS);\n");
            this.writeChart(chart, chartName);
            JRMultiAxisPlot plot = (JRMultiAxisPlot)chart.getPlot();
            String plotName = chartName + "MultiAxisPlot";
            this.write("JRDesignMultiAxisPlot " + plotName + " = (JRDesignMultiAxisPlot)" + chartName + ".getPlot();\n");
            this.write(plotName + ".setChart(" + chartName + ");\n");
            this.writePlot(chart.getPlot(), plotName);
            List<JRChartAxis> axes = plot.getAxes();
            if (axes != null && axes.size() > 0) {
                for (int i = 0; i < axes.size(); ++i) {
                    JRChartAxis chartAxis = axes.get(i);
                    this.writeChartAxis(chartAxis, plotName, plotName + "Axis" + i, chartName);
                }
            }
            this.flush();
        }
    }

    public void writeStackedAreaChart(JRChart chart, String chartName) {
        if (chart != null) {
            this.write("JRDesignChart " + chartName + " = new JRDesignChart(jasperDesign, JRChart.CHART_TYPE_STACKEDAREA);\n");
            this.writeChart(chart, chartName);
            this.writeCategoryDataSet((JRCategoryDataset)chart.getDataset(), chartName, "CategoryDataset");
            this.writeAreaPlot((JRAreaPlot)chart.getPlot(), chartName);
            this.flush();
        }
    }

    public void writeChartTag(JRChart chart, String chartName) {
        switch (chart.getChartType()) {
            case 1: {
                this.writeAreaChart(chart, chartName);
                break;
            }
            case 3: {
                this.writeBarChart(chart, chartName);
                break;
            }
            case 2: {
                this.writeBar3DChart(chart, chartName);
                break;
            }
            case 4: {
                this.writeBubbleChart(chart, chartName);
                break;
            }
            case 5: {
                this.writeCandlestickChart(chart, chartName);
                break;
            }
            case 6: {
                this.writeHighLowChart(chart, chartName);
                break;
            }
            case 7: {
                this.writeLineChart(chart, chartName);
                break;
            }
            case 17: {
                this.writeMeterChart(chart, chartName);
                break;
            }
            case 19: {
                this.writeMultiAxisChart(chart, chartName);
                break;
            }
            case 9: {
                this.writePieChart(chart, chartName);
                break;
            }
            case 8: {
                this.writePie3DChart(chart, chartName);
                break;
            }
            case 10: {
                this.writeScatterChart(chart, chartName);
                break;
            }
            case 12: {
                this.writeStackedBarChart(chart, chartName);
                break;
            }
            case 11: {
                this.writeStackedBar3DChart(chart, chartName);
                break;
            }
            case 18: {
                this.writeThermometerChart(chart, chartName);
                break;
            }
            case 16: {
                this.writeTimeSeriesChart(chart, chartName);
                break;
            }
            case 13: {
                this.writeXyAreaChart(chart, chartName);
                break;
            }
            case 14: {
                this.writeXyBarChart(chart, chartName);
                break;
            }
            case 15: {
                this.writeXyLineChart(chart, chartName);
                break;
            }
            case 20: {
                this.writeStackedAreaChart(chart, chartName);
                break;
            }
            case 21: {
                this.writeGanttChart(chart, chartName);
                break;
            }
            default: {
                throw new JRRuntimeException("Chart type not supported.");
            }
        }
    }

    private void writeSubreportReturnValue(JRSubreportReturnValue returnValue, String returnValueName) {
        if (returnValue != null) {
            this.write("JRDesignSubreportReturnValue " + returnValueName + " = new JRDesignSubreportReturnValue();\n");
            this.write(returnValueName + ".setSubreportVariable(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(returnValue.getSubreportVariable()));
            this.write(returnValueName + ".setToVariable(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(returnValue.getToVariable()));
            this.write(returnValueName + ".setCalculation({0});\n", returnValue.getCalculationValue(), CalculationEnum.NOTHING);
            this.write(returnValueName + ".setIncrementerFactoryClassName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(returnValue.getIncrementerFactoryClassName()));
            this.flush();
        }
    }

    private void writeReturnValue(ReturnValue returnValue, String returnValueName) {
        if (returnValue != null) {
            this.write("DesignReturnValue " + returnValueName + " = new DesignReturnValue();\n");
            this.write(returnValueName + ".setFromVariable(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(returnValue.getFromVariable()));
            this.write(returnValueName + ".setToVariable(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(returnValue.getToVariable()));
            this.write(returnValueName + ".setCalculation({0});\n", returnValue.getCalculation(), CalculationEnum.NOTHING);
            this.write(returnValueName + ".setIncrementerFactoryClassName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(returnValue.getIncrementerFactoryClassName()));
            this.flush();
        }
    }

    public void writeCrosstab(JRCrosstab crosstab, String crosstabName) {
        if (crosstab != null) {
            this.write("JRDesignCrosstab " + crosstabName + " = new JRDesignCrosstab(jasperDesign);\n");
            this.write(crosstabName + ".setRepeatColumnHeaders({0});\n", crosstab.isRepeatColumnHeaders(), true);
            this.write(crosstabName + ".setRepeatRowHeaders({0});\n", crosstab.isRepeatRowHeaders(), true);
            this.write(crosstabName + ".setColumnBreakOffset({0, number, #});\n", crosstab.getColumnBreakOffset(), 10);
            this.write(crosstabName + ".setRunDirection({0});\n", crosstab.getRunDirectionValue(), RunDirectionEnum.LTR);
            this.write(crosstabName + ".setIgnoreWidth({0});\n", (Object)this.getBooleanText(crosstab.getIgnoreWidth()));
            this.writeReportElement(crosstab, crosstabName);
            this.writeBox(crosstab.getLineBox(), crosstabName + ".getLineBox()");
            JRCrosstabParameter[] parameters = crosstab.getParameters();
            if (parameters != null) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (parameters[i].isSystemDefined()) continue;
                    this.writeCrosstabParameter(parameters[i], crosstabName + "Parameter" + i);
                    this.write(crosstabName + ".addParameter(" + crosstabName + "Parameter" + i + ");\n");
                }
            }
            this.writeExpression(crosstab.getParametersMapExpression(), crosstabName, "ParametersMapExpression");
            this.writeCrosstabDataset(crosstab, crosstabName);
            this.writeCrosstabHeaderCell(crosstab, crosstabName);
            JRCrosstabRowGroup[] rowGroups = crosstab.getRowGroups();
            for (int i = 0; i < rowGroups.length; ++i) {
                this.writeCrosstabRowGroup(rowGroups[i], crosstabName + "RowGroup" + i);
                this.write(crosstabName + ".addRowGroup(" + crosstabName + "RowGroup" + i + ");\n");
            }
            JRCrosstabColumnGroup[] columnGroups = crosstab.getColumnGroups();
            for (int i = 0; i < columnGroups.length; ++i) {
                this.writeCrosstabColumnGroup(columnGroups[i], crosstabName + "ColumnGroup" + i);
                this.write(crosstabName + ".addColumnGroup(" + crosstabName + "ColumnGroup" + i + ");\n");
            }
            JRCrosstabMeasure[] measures = crosstab.getMeasures();
            for (int i = 0; i < measures.length; ++i) {
                this.writeCrosstabMeasure(measures[i], crosstabName + "Measure" + i);
                this.write(crosstabName + ".addMeasure(" + crosstabName + "Measure" + i + ");\n");
            }
            if (crosstab instanceof JRDesignCrosstab) {
                List<JRCrosstabCell> cellsList = ((JRDesignCrosstab)crosstab).getCellsList();
                for (int i = 0; i < cellsList.size(); ++i) {
                    JRCrosstabCell cell = cellsList.get(i);
                    this.writeCrosstabCell(cell, crosstabName + "Cell" + i);
                    this.write(crosstabName + ".addCell(" + crosstabName + "Cell" + i + ");\n");
                }
            } else {
                JRCrosstabCell[][] cells = crosstab.getCells();
                HashSet<JRCrosstabCell> cellsSet = new HashSet<JRCrosstabCell>();
                for (int i = cells.length - 1; i >= 0; --i) {
                    for (int j = cells[i].length - 1; j >= 0; --j) {
                        JRCrosstabCell cell = cells[i][j];
                        if (cell == null || !cellsSet.add(cell)) continue;
                        this.writeCrosstabCell(cell, crosstabName + "Cell" + i + "" + j);
                        this.write(crosstabName + ".addCell(" + crosstabName + "Cell" + i + "" + j + ");\n");
                    }
                }
            }
            this.writeCrosstabWhenNoDataCell(crosstab, crosstabName);
            this.flush();
        }
    }

    private void writeCrosstabDataset(JRCrosstab crosstab, String crosstabName) {
        if (crosstab != null) {
            String datasetName = crosstabName + "Dataset";
            JRCrosstabDataset dataset = crosstab.getDataset();
            this.write("JRDesignCrosstabDataset " + datasetName + " = new JRDesignCrosstabDataset();\n");
            this.write(datasetName + ".setDataPreSorted({0});\n", dataset.isDataPreSorted(), false);
            this.writeElementDataset(dataset, datasetName);
            this.write(crosstabName + ".setDataset(" + datasetName + ");\n");
            this.flush();
        }
    }

    private void writeCrosstabWhenNoDataCell(JRCrosstab crosstab, String parentName) {
        JRCellContents whenNoDataCell = crosstab.getWhenNoDataCell();
        if (whenNoDataCell != null) {
            this.writeCellContents(whenNoDataCell, parentName + "NoDataCell");
            this.write(parentName + ".setWhenNoDataCell(" + parentName + "NoDataCell);\n");
            this.flush();
        }
    }

    private void writeCrosstabHeaderCell(JRCrosstab crosstab, String parentName) {
        JRCellContents headerCell = crosstab.getHeaderCell();
        if (headerCell != null) {
            this.writeCellContents(headerCell, parentName + "HeaderCellContents");
            this.write(parentName + ".setHeaderCell(" + parentName + "HeaderCellContents);\n");
            this.flush();
        }
    }

    protected void writeCrosstabRowGroup(JRCrosstabRowGroup group, String groupName) {
        if (group != null) {
            JRCellContents totalHeader;
            this.write("JRDesignCrosstabRowGroup " + groupName + " = new JRDesignCrosstabRowGroup();\n");
            this.write(groupName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(group.getName()));
            this.write(groupName + ".setWidth({0, number, #});\n", group.getWidth());
            this.write(groupName + ".setTotalPosition({0});\n", group.getTotalPositionValue(), CrosstabTotalPositionEnum.NONE);
            this.write(groupName + ".setPosition({0});\n", group.getPositionValue(), CrosstabRowPositionEnum.TOP);
            this.writeBucket(group.getBucket(), groupName);
            JRCellContents header = group.getHeader();
            if (header != null) {
                this.writeCellContents(header, groupName + "HeaderContents");
                this.write(groupName + ".setHeader(" + groupName + "HeaderContents);\n");
            }
            if ((totalHeader = group.getTotalHeader()) != null) {
                this.writeCellContents(totalHeader, groupName + "TotalHeaderContents");
                this.write(groupName + ".setTotalHeader(" + groupName + "TotalHeaderContents);\n");
            }
            this.flush();
        }
    }

    protected void writeCrosstabColumnGroup(JRCrosstabColumnGroup group, String groupName) {
        if (group != null) {
            JRCellContents totalHeader;
            JRCellContents header;
            this.write("JRDesignCrosstabColumnGroup " + groupName + " = new JRDesignCrosstabColumnGroup();\n");
            this.write(groupName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(group.getName()));
            this.write(groupName + ".setHeight({0, number, #});\n", group.getHeight());
            this.write(groupName + ".setTotalPosition({0});\n", group.getTotalPositionValue(), CrosstabTotalPositionEnum.NONE);
            this.write(groupName + ".setPosition({0});\n", group.getPositionValue(), CrosstabColumnPositionEnum.LEFT);
            this.writeBucket(group.getBucket(), groupName);
            JRCellContents crosstabHeader = group.getCrosstabHeader();
            if (crosstabHeader != null) {
                this.writeCellContents(crosstabHeader, groupName + "CrosstabHeaderContents");
                this.write(groupName + ".setCrosstabHeader(" + groupName + "CrosstabHeaderContents);\n");
            }
            if ((header = group.getHeader()) != null) {
                this.writeCellContents(header, groupName + "HeaderContents");
                this.write(groupName + ".setHeader(" + groupName + "HeaderContents);\n");
            }
            if ((totalHeader = group.getTotalHeader()) != null) {
                this.writeCellContents(totalHeader, groupName + "TotalHeaderContents");
                this.write(groupName + ".setTotalHeader(" + groupName + "TotalHeaderContents);\n");
            }
            this.flush();
        }
    }

    protected void writeBucket(JRCrosstabBucket bucket, String parentName) {
        if (bucket != null) {
            String bucketName = parentName + "Bucket";
            this.write("JRDesignCrosstabBucket " + bucketName + " = new JRDesignCrosstabBucket();\n");
            this.write(bucketName + ".setValueClassName(\"{0}\");\n", (Object)bucket.getValueClassName());
            this.writeExpression(bucket.getExpression(), bucketName, "Expression");
            this.writeExpression(bucket.getComparatorExpression(), bucketName, "ComparatorExpression");
            this.writeExpression(bucket.getOrderByExpression(), bucketName, "OrderByExpression", Object.class.getName());
            this.write(parentName + ".setBucket(" + bucketName + ");\n");
            this.flush();
        }
    }

    protected void writeCrosstabMeasure(JRCrosstabMeasure measure, String measureName) {
        if (measure != null) {
            this.write("JRDesignCrosstabMeasure " + measureName + " = new JRDesignCrosstabMeasure();\n");
            this.write(measureName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(measure.getName()));
            this.write(measureName + ".setValueClassName(\"{0}\");\n", (Object)measure.getValueClassName());
            this.write(measureName + ".setCalculation({0});\n", measure.getCalculationValue(), CalculationEnum.NOTHING);
            this.write(measureName + ".setPercentageType({0});\n", measure.getPercentageType(), CrosstabPercentageEnum.NONE);
            this.write(measureName + ".setPercentageCalculatorClassName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(measure.getPercentageCalculatorClassName()));
            this.writeExpression(measure.getValueExpression(), measureName, "ValueExpression");
            this.flush();
        }
    }

    protected void writeCrosstabCell(JRCrosstabCell cell, String cellName) {
        if (cell != null) {
            this.write("JRDesignCrosstabCell " + cellName + " = new JRDesignCrosstabCell();\n");
            this.write(cellName + ".setWidth({0, number, #});\n", cell.getWidth());
            this.write(cellName + ".setHeight({0, number, #});\n", cell.getHeight());
            this.write(cellName + ".setRowTotalGroup(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(cell.getRowTotalGroup()));
            this.write(cellName + ".setColumnTotalGroup(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(cell.getColumnTotalGroup()));
            this.writeCellContents(cell.getContents(), cellName + "Contents");
            this.write(cellName + ".setContents(" + cellName + "Contents);\n");
            this.flush();
        }
    }

    protected void writeCellContents(JRCellContents contents, String cellName) {
        if (contents != null) {
            this.write("JRDesignCellContents " + cellName + " = new JRDesignCellContents();\n");
            this.write(cellName + ".setBackcolor({0});\n", contents.getBackcolor());
            this.write(cellName + ".setMode({0});\n", contents.getModeValue());
            this.writeStyleReferenceAttr(contents, cellName);
            this.writeBox(contents.getLineBox(), cellName + ".getLineBox()");
            this.writeChildElements(contents, cellName);
            this.flush();
        }
    }

    protected void writeCrosstabParameter(JRCrosstabParameter parameter, String parameterName) {
        if (parameter != null) {
            this.write("JRDesignCrosstabParameter " + parameterName + " = new JRDesignCrosstabParameter();\n");
            this.write(parameterName + ".setDescription(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(parameter.getDescription()));
            this.write(parameterName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(parameter.getName()));
            this.write(parameterName + ".setValueClassName(\"{0}\");\n", parameter.getValueClassName(), "java.lang.String");
            this.writeExpression(parameter.getExpression(), parameterName, "Expression");
            this.flush();
        }
    }

    public void writeDataset(JRDataset dataset, String datasetName) {
        if (dataset != null) {
            this.write("JRDesignDataset " + datasetName + " = new JRDesignDataset(" + dataset.isMainDataset() + ");\n");
            this.write(datasetName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(dataset.getName()));
            this.write(datasetName + ".setScriptletClass(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(dataset.getScriptletClass()));
            this.write(datasetName + ".setResourceBundle(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(dataset.getResourceBundle()));
            this.write(datasetName + ".setWhenResourceMissingType({0});\n", dataset.getWhenResourceMissingTypeValue(), WhenResourceMissingTypeEnum.NULL);
            this.writeProperties(dataset, datasetName);
            this.writeDatasetContents(dataset, datasetName);
            this.flush();
        }
    }

    protected void writeDatasetContents(JRDataset dataset, String datasetName) {
        JRVariable[] variables;
        JRSortField[] sortFields;
        JRField[] fields;
        JRParameter[] parameters;
        JRScriptlet[] scriptlets = dataset.getScriptlets();
        if (scriptlets != null && scriptlets.length > 0) {
            for (int i = 0; i < scriptlets.length; ++i) {
                this.writeScriptlet(scriptlets[i], datasetName + "Scriptlet" + i);
                this.write(datasetName + ".addScriptlet(" + datasetName + "Scriptlet" + i + ");\n");
            }
        }
        if ((parameters = dataset.getParameters()) != null && parameters.length > 0) {
            for (int i = 0; i < parameters.length; ++i) {
                if (parameters[i].isSystemDefined()) continue;
                this.writeParameter(parameters[i], datasetName + "Parameter" + i);
                this.write(datasetName + ".addParameter(" + datasetName + "Parameter" + i + ");\n");
            }
        }
        if (dataset.getQuery() != null) {
            this.writeQuery(dataset.getQuery(), datasetName + "Query");
            this.write(datasetName + ".setQuery(" + datasetName + "Query);\n");
        }
        if ((fields = dataset.getFields()) != null && fields.length > 0) {
            for (int i = 0; i < fields.length; ++i) {
                this.writeField(fields[i], datasetName + "Field" + i);
                this.write(datasetName + ".addField(" + datasetName + "Field" + i + ");\n");
            }
        }
        if ((sortFields = dataset.getSortFields()) != null && sortFields.length > 0) {
            for (int i = 0; i < sortFields.length; ++i) {
                this.writeSortField(sortFields[i], datasetName + "SortField" + i);
                this.write(datasetName + ".addSortField(" + datasetName + "SortField" + i + ");\n");
            }
        }
        if ((variables = dataset.getVariables()) != null && variables.length > 0) {
            for (int i = 0; i < variables.length; ++i) {
                if (variables[i].isSystemDefined()) continue;
                this.writeVariable(variables[i], datasetName + "Variable" + i);
                this.write(datasetName + ".addVariable(" + datasetName + "Variable" + i + ");\n");
            }
        }
        this.writeExpression(dataset.getFilterExpression(), datasetName, "FilterExpression");
        JRGroup[] groups = dataset.getGroups();
        if (groups != null && groups.length > 0) {
            for (int i = 0; i < groups.length; ++i) {
                String groupName = this.getGroupName(groups[i]);
                if (groupName == null) continue;
                this.write(datasetName + ".addGroup(" + groupName + ");\n");
            }
        }
        this.flush();
    }

    public void writeDatasetRun(JRDatasetRun datasetRun, String parentName) {
        if (datasetRun != null) {
            String runName = parentName + "Run";
            this.write("JRDesignDatasetRun " + runName + " = new JRDesignDatasetRun();\n");
            this.write(runName + ".setDatasetName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(datasetRun.getDatasetName()));
            this.writeExpression(datasetRun.getParametersMapExpression(), runName, "ParametersMapExpression");
            JRDatasetParameter[] parameters = datasetRun.getParameters();
            if (parameters != null && parameters.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    this.writeDatasetParameter(parameters[i], runName, runName + "Parameter" + i);
                }
            }
            this.writeExpression(datasetRun.getConnectionExpression(), runName, "ConnectionExpression");
            this.writeExpression(datasetRun.getDataSourceExpression(), runName, "DataSourceExpression");
            List<ReturnValue> returnValues = datasetRun.getReturnValues();
            if (returnValues != null && !returnValues.isEmpty()) {
                ListIterator<ReturnValue> it = returnValues.listIterator();
                while (it.hasNext()) {
                    ReturnValue returnValue = it.next();
                    String returnValueVarName = runName + "ReturnValue" + it.previousIndex();
                    this.writeReturnValue(returnValue, returnValueVarName);
                    this.write(runName + ".addReturnValue(" + returnValueVarName + ");\n");
                }
            }
            this.write(parentName + ".setDatasetRun(" + runName + ");\n");
            this.flush();
        }
    }

    public void writeFrame(JRFrame frame, String frameName) {
        if (frame != null) {
            this.write("JRDesignFrame " + frameName + " = new JRDesignFrame(jasperDesign);\n");
            this.writeReportElement(frame, frameName);
            this.writeBox(frame.getLineBox(), frameName + ".getLineBox()");
            this.writeChildElements(frame, frameName);
            this.flush();
        }
    }

    protected void writeHyperlinkParameters(JRHyperlinkParameter[] parameters, String parentName) {
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRHyperlinkParameter parameter = parameters[i];
                this.writeHyperlinkParameter(parameter, parentName + "HyperlinkParameter" + i);
                this.write(parentName + ".addHyperlinkParameter(" + parentName + "HyperlinkParameter" + i + ");\n");
            }
            this.flush();
        }
    }

    protected void writeHyperlinkParameter(JRHyperlinkParameter parameter, String parameterName) {
        if (parameter != null) {
            this.write("JRDesignHyperlinkParameter " + parameterName + " = new JRDesignHyperlinkParameter();\n");
            this.write(parameterName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(parameter.getName()));
            this.writeExpression(parameter.getValueExpression(), parameterName, "ValueExpression", String.class.getName());
            this.flush();
        }
    }

    public void writeHyperlink(JRHyperlink hyperlink, String parentName, String hyperlinkSuffix) {
        if (hyperlink != null) {
            String hyperlinkName = parentName + hyperlinkSuffix;
            this.write("JRDesignHyperlink " + hyperlinkName + " = new JRDesignHyperlink();\n");
            if (hyperlink.getLinkType() != null) {
                this.write(hyperlinkName + ".setLinkType(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(hyperlink.getLinkType()), HyperlinkTypeEnum.NONE.getName());
            }
            if (hyperlink.getLinkTarget() != null) {
                this.write(hyperlinkName + ".setLinkTarget(\"{0}\");\n", JRStringUtil.escapeJavaStringLiteral(hyperlink.getLinkTarget()), HyperlinkTargetEnum.SELF.getName());
            }
            this.writeExpression(hyperlink.getHyperlinkReferenceExpression(), hyperlinkName, "HyperlinkReferenceExpression");
            this.writeExpression(hyperlink.getHyperlinkWhenExpression(), hyperlinkName, "HyperlinkWhenExpression");
            this.writeExpression(hyperlink.getHyperlinkAnchorExpression(), hyperlinkName, "HyperlinkAnchorExpression");
            this.writeExpression(hyperlink.getHyperlinkPageExpression(), hyperlinkName, "HyperlinkPageExpression");
            this.writeExpression(hyperlink.getHyperlinkTooltipExpression(), hyperlinkName, "HyperlinkTooltipExpression");
            this.writeHyperlinkParameters(hyperlink.getHyperlinkParameters(), hyperlinkName);
            this.write(parentName + ".set" + hyperlinkSuffix + "(" + hyperlinkName + ");\n");
            this.flush();
        }
    }

    protected boolean toWriteConditionalStyles() {
        return true;
    }

    protected void writeConditionalStyle(JRConditionalStyle style, String styleName) {
        if (style != null) {
            this.write("JRDesignConditionalStyle " + styleName + " = new JRDesignConditionalStyle();\n");
            this.writeExpression(style.getConditionExpression(), styleName, "ConditionExpression");
            if (style.getStyle() != null) {
                this.write(styleName + ".setParentStyle({0});\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getStyle().getName()));
            } else if (style.getStyleNameReference() != null) {
                this.write(styleName + ".setParentStyleNameReference(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(style.getStyleNameReference()));
            }
            this.writeCommonStyle(style, styleName);
            this.flush();
        }
    }

    public void writeComponentElement(JRComponentElement componentElement, String componentName) {
        this.write("JRDesignComponentElement " + componentName + " = new JRDesignComponentElement(jasperDesign);\n");
        this.writeReportElement(componentElement, componentName);
        this.flush();
    }

    public void writeGenericElement(JRGenericElement element, String elementName) {
        this.write("JRDesignGenericElement " + elementName + " = new JRDesignGenericElement(jasperDesign);\n");
        this.write(elementName + ".setEvaluationTime({0});\n", element.getEvaluationTimeValue(), EvaluationTimeEnum.NOW);
        this.write(elementName + ".setEvaluationGroup(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(element.getEvaluationGroupName()));
        this.writeReportElement(element, elementName);
        JRGenericElementType printKey = element.getGenericType();
        this.write("JRGenericElementType " + elementName + "Type = new JRGenericElementType(\"" + JRStringUtil.escapeJavaStringLiteral(printKey.getNamespace()) + "\", \"" + JRStringUtil.escapeJavaStringLiteral(printKey.getName()) + "\");\n");
        this.write(elementName + ".setGenericType(" + elementName + "Type);\n");
        this.flush();
        JRGenericElementParameter[] params = element.getParameters();
        for (int i = 0; i < params.length; ++i) {
            JRGenericElementParameter param = params[i];
            String paramName = elementName + "Parameter" + i;
            this.write("JRDesignGenericElementParameter " + paramName + " = new JRDesignGenericElementParameter();\n");
            this.write(paramName + ".setName(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(param.getName()));
            this.write(paramName + ".setSkipWhenEmpty({0});\n", param.isSkipWhenEmpty(), false);
            this.writeExpression(param.getValueExpression(), paramName, "ValueExpression");
            this.write(elementName + ".addParameter({0});\n", (Object)paramName);
            this.flush();
        }
        this.flush();
    }

    protected void writeStyleReferenceAttr(JRStyleContainer styleContainer, String styleName) {
        if (styleContainer.getStyle() != null) {
            this.write(styleName + ".setStyle(" + JRStringUtil.getJavaIdentifier(styleContainer.getStyle().getName()) + ");\n");
        } else if (styleContainer.getStyleNameReference() != null) {
            this.write(styleName + ".setStyleNameReference(\"{0}\");\n", (Object)styleContainer.getStyleNameReference());
        }
        this.flush();
    }

    private void writePen(JRPen pen, String penHolder) {
        if (pen != null) {
            this.write(penHolder + ".setLineWidth({0});\n", pen.getOwnLineWidth());
            this.write(penHolder + ".setLineStyle({0});\n", pen.getOwnLineStyleValue());
            this.write(penHolder + ".setLineColor({0});\n", pen.getOwnLineColor());
            this.flush();
        }
    }

    protected void writeBox(JRLineBox box, String boxHolder) {
        if (box != null) {
            this.write(boxHolder + ".setPadding(Integer.valueOf({0, number, #}));\n", box.getOwnPadding());
            this.write(boxHolder + ".setTopPadding(Integer.valueOf({0, number, #}));\n", box.getOwnTopPadding());
            this.write(boxHolder + ".setLeftPadding(Integer.valueOf({0, number, #}));\n", box.getOwnLeftPadding());
            this.write(boxHolder + ".setBottomPadding(Integer.valueOf({0, number, #}));\n", box.getOwnBottomPadding());
            this.write(boxHolder + ".setRightPadding(Integer.valueOf({0, number, #}));\n", box.getOwnRightPadding());
            this.writePen(box.getPen(), boxHolder + ".getPen()");
            this.writePen(box.getTopPen(), boxHolder + ".getTopPen()");
            this.writePen(box.getLeftPen(), boxHolder + ".getLeftPen()");
            this.writePen(box.getBottomPen(), boxHolder + ".getBottomPen()");
            this.writePen(box.getRightPen(), boxHolder + ".getRightPen()");
            this.flush();
        }
    }

    protected void writeParagraph(JRParagraph paragraph, String paragraphHolder) {
        if (paragraph != null) {
            String paragraphName = paragraphHolder + "Paragraph";
            this.write("JRParagraph " + paragraphName + " = " + paragraphHolder + ".getParagraph();\n");
            this.write(paragraphName + ".setLineSpacing({0});\n", paragraph.getOwnLineSpacing());
            this.write(paragraphName + ".setLineSpacingSize({0});\n", paragraph.getOwnLineSpacingSize());
            this.write(paragraphName + ".setFirstLineIndent({0});\n", paragraph.getOwnFirstLineIndent());
            this.write(paragraphName + ".setLeftIndent({0});\n", paragraph.getOwnLeftIndent());
            this.write(paragraphName + ".setRightIndent({0});\n", paragraph.getOwnRightIndent());
            this.write(paragraphName + ".setSpacingBefore({0});\n", paragraph.getOwnSpacingBefore());
            this.write(paragraphName + ".setSpacingAfter({0});\n", paragraph.getOwnSpacingAfter());
            this.write(paragraphName + ".setTabStopWidth(Integer.valueOf({0, number, #}));\n", paragraph.getOwnTabStopWidth());
            TabStop[] tabStops = paragraph.getTabStops();
            if (tabStops != null && tabStops.length > 0) {
                for (int i = 0; i < tabStops.length; ++i) {
                    this.writeTabStop(tabStops[i], paragraphName + "TabStop" + i);
                    this.write(paragraphName + ".addTabStop(" + paragraphName + "TabStop" + i + ");\n");
                }
            }
            this.flush();
        }
    }

    private void writeTabStop(TabStop tabStop, String tabStopName) {
        if (tabStop != null) {
            this.write("TabStop " + tabStopName + " = new TabStop();\n");
            this.write(tabStopName + ".setAlignment({0});\n", tabStop.getAlignment(), TabStopAlignEnum.LEFT);
            this.write(tabStopName + ".setPosition({0});\n", tabStop.getPosition());
            this.flush();
        }
    }

    public void writeExpression(JRExpression expression, String parentName, String expressionSuffix) {
        this.writeExpression(expression, parentName, expressionSuffix, null);
    }

    public void writeExpression(JRExpression expression, String parentName, String expressionSuffix, String defaultClassName) {
        if (expression != null) {
            String expressionName = parentName + expressionSuffix;
            this.write("JRDesignExpression " + expressionName + " = new JRDesignExpression();\n");
            this.write(expressionName + ".setId({0, number, #});\n", expression.getId());
            this.write(expressionName + ".setText(\"{0}\");\n", (Object)JRStringUtil.escapeJavaStringLiteral(expression.getText()));
            this.write(parentName + ".set" + expressionSuffix + "(" + expressionName + ");\n");
            this.flush();
        }
    }

    private String getGroupName(JRGroup group) {
        if (group != null) {
            if (this.groupsMap.get(group.getName()) == null) {
                this.writeGroup(group);
            }
            return group.getName();
        }
        return null;
    }

    protected void write(String text) {
        try {
            this.writer.write(this.indent + text);
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void write(String pattern, Object value) {
        this.write(pattern, value, null);
    }

    protected void write(String pattern, Object value, Object defaultValue) {
        if (value != null && value != defaultValue) {
            this.write(MessageFormat.format(pattern, value));
        }
    }

    protected void write(String pattern, Enum<?> value) {
        this.write(pattern, value, null);
    }

    protected void write(String pattern, Enum<?> value, Enum<?> defaultValue) {
        if (value != null && value != defaultValue) {
            this.write(MessageFormat.format(pattern, value.getClass().getName() + "." + value.name()));
        }
    }

    protected void write(String pattern, int value) {
        this.write(MessageFormat.format(pattern, value));
    }

    protected void write(String pattern, int value, int defaultValue) {
        if (value != defaultValue) {
            this.write(MessageFormat.format(pattern, value));
        }
    }

    protected void write(String pattern, Float value) {
        this.write(pattern, value, null);
    }

    protected void write(String pattern, Float value, Float defaultValue) {
        if (value != null && value != defaultValue) {
            String strFloat = MessageFormat.format("new Float({0})", NumberFormat.getInstance(Locale.ENGLISH).format(value).replaceAll(",", ""));
            this.write(MessageFormat.format(pattern, strFloat));
        }
    }

    protected void write(String pattern, Double value) {
        this.write(pattern, value, null);
    }

    protected void write(String pattern, Double value, Double defaultValue) {
        if (value != null && value != defaultValue) {
            String strDouble = MessageFormat.format("new Double({0})", NumberFormat.getInstance(Locale.ENGLISH).format(value).replaceAll(",", ""));
            this.write(MessageFormat.format(pattern, strDouble));
        }
    }

    protected void write(String pattern, boolean value, boolean defaultValue) {
        if (value != defaultValue) {
            this.write(MessageFormat.format(pattern, value ? Boolean.TRUE : Boolean.FALSE));
        }
    }

    protected void write(String pattern, byte value, byte defaultValue) {
        if (value != defaultValue) {
            this.write(MessageFormat.format(pattern, new Byte(value)));
        }
    }

    protected void write(String pattern, Color value) {
        this.write(pattern, value, null);
    }

    protected void write(String pattern, Color value, Color defaultValue) {
        if (value != null && value != defaultValue) {
            String strColor = MessageFormat.format("new Color({0}, {1}, {2})", value.getRed(), value.getGreen(), value.getBlue());
            this.write(MessageFormat.format(pattern, strColor));
        }
    }

    private String getBooleanText(Boolean key) {
        return key == null ? null : (key != false ? "Boolean.TRUE" : "Boolean.FALSE");
    }

    protected void close() {
        try {
            this.writer.close();
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    protected void flush() {
        try {
            this.writer.flush();
        }
        catch (IOException e) {
            throw new JRRuntimeException(e);
        }
    }

    public static void main(String[] args) {
        block3: {
            if (args.length < 2) {
                System.out.println("JRApiWriter usage:");
                System.out.println("\tjava JRApiWriter reportCreatorClassName file");
                return;
            }
            String reportCreatorClassName = args[0];
            String destFileName = args[1];
            try {
                Class<?> reportCreatorClass = Class.forName(reportCreatorClassName);
                ReportCreator reportCreator = (ReportCreator)reportCreatorClass.newInstance();
                JasperDesign jasperDesign = reportCreator.create();
                new JRXmlWriter(DefaultJasperReportsContext.getInstance()).write((JRReport)jasperDesign, destFileName, "UTF-8");
            }
            catch (Exception e) {
                if (!log.isErrorEnabled()) break block3;
                log.error((Object)("Error running report creator class : " + reportCreatorClassName), (Throwable)e);
            }
        }
    }
}

