/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.iconlabel;

import net.sf.jasperreports.components.iconlabel.ContainerFillEnum;
import net.sf.jasperreports.components.iconlabel.IconLabelComponent;
import net.sf.jasperreports.components.iconlabel.IconLabelElement;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRGenericElementType;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.base.JRBaseGenericPrintElement;
import net.sf.jasperreports.engine.component.BaseFillComponent;
import net.sf.jasperreports.engine.component.FillPrepareResult;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRFillTextField;
import net.sf.jasperreports.engine.fill.JRTemplateGenericElement;
import net.sf.jasperreports.engine.fill.JRTemplateGenericPrintElement;

public class IconLabelComponentFill
extends BaseFillComponent {
    private final IconLabelComponent iconLabelComponent;
    private final JRFillTextField labelTextField;
    private final JRFillTextField iconTextField;
    private JRTemplateGenericElement template;
    private JRTemplateGenericPrintElement printElement;
    private JRPrintText labelPrintText;
    private JRPrintText iconPrintText;

    public IconLabelComponentFill(IconLabelComponent iconLabelComponent, JRFillObjectFactory factory) {
        this.iconLabelComponent = iconLabelComponent;
        this.labelTextField = (JRFillTextField)factory.getVisitResult(iconLabelComponent.getLabelTextField());
        this.iconTextField = (JRFillTextField)factory.getVisitResult(iconLabelComponent.getIconTextField());
    }

    public IconLabelComponentFill(IconLabelComponent iconLabelComponent, JRFillCloneFactory factory) {
        this.iconLabelComponent = iconLabelComponent;
        this.labelTextField = null;
        this.iconTextField = null;
    }

    protected IconLabelComponent getIconLabelComponent() {
        return this.iconLabelComponent;
    }

    @Override
    public void evaluate(byte evaluation) throws JRException {
        this.labelTextField.evaluate(evaluation);
        this.iconTextField.evaluate(evaluation);
    }

    @Override
    public JRPrintElement fill() {
        try {
            this.labelPrintText = (JRPrintText)this.labelTextField.fill();
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        this.printElement.setY(this.fillContext.getElementPrintY());
        this.printElement.setHeight(this.labelPrintText.getHeight());
        if (this.iconLabelComponent.getLabelFill() != ContainerFillEnum.HORIZONTAL && this.iconLabelComponent.getLabelFill() != ContainerFillEnum.BOTH) {
            this.labelPrintText.setWidth((int)this.labelTextField.getTextWidth() + 1);
        }
        try {
            this.iconPrintText = (JRPrintText)this.iconTextField.fill();
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        this.iconPrintText.setY(this.labelPrintText.getY());
        this.iconPrintText.setX(this.labelPrintText.getX() + this.labelPrintText.getWidth());
        this.iconPrintText.setWidth((int)this.iconTextField.getTextWidth());
        this.copy(this.printElement);
        return this.printElement;
    }

    @Override
    public FillPrepareResult prepare(int availableHeight) {
        this.iconTextField.setWidth(this.iconLabelComponent.getContext().getComponentElement().getWidth());
        try {
            this.iconTextField.prepare(availableHeight, this.fillContext.getFillContainerContext().isCurrentOverflow());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        this.labelTextField.setWidth(this.iconLabelComponent.getContext().getComponentElement().getWidth() - (int)this.iconTextField.getTextWidth());
        try {
            this.labelTextField.prepare(availableHeight, this.fillContext.getFillContainerContext().isCurrentOverflow());
        }
        catch (JRException e) {
            throw new JRRuntimeException(e);
        }
        FillPrepareResult result = null;
        JRComponentElement element = this.fillContext.getComponentElement();
        if (this.template == null) {
            this.template = new JRTemplateGenericElement(this.fillContext.getElementOrigin(), this.fillContext.getDefaultStyleProvider(), IconLabelElement.ICONLABEL_ELEMENT_TYPE);
            this.template.setMode(this.iconLabelComponent.getContext().getComponentElement().getModeValue());
            this.template.setBackcolor(this.iconLabelComponent.getContext().getComponentElement().getBackcolor());
            this.template.setForecolor(this.iconLabelComponent.getContext().getComponentElement().getForecolor());
            this.template = this.deduplicate(this.template);
        }
        this.printElement = new JRTemplateGenericPrintElement(this.template, this.elementId);
        this.printElement.setUUID(element.getUUID());
        this.printElement.setX(element.getX());
        this.printElement.setWidth(element.getWidth());
        this.printElement.setHeight(element.getHeight());
        result = FillPrepareResult.printStretch(this.labelTextField.getStretchHeight(), false);
        return result;
    }

    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void evaluateDelayedElement(JRPrintElement element, byte evaluation) throws JRException {
        this.evaluate(evaluation);
        this.copy((JRGenericPrintElement)element);
    }

    protected void copy(JRGenericPrintElement printElement) {
        printElement.setParameterValue("labelTextElement", this.labelPrintText);
        JRBaseGenericPrintElement iconGenericElement = new JRBaseGenericPrintElement(this.labelPrintText.getDefaultStyleProvider());
        iconGenericElement.setGenericType(new JRGenericElementType("http://jasperreports.sourceforge.net/jasperreports/pictonic", "pictonic"));
        iconGenericElement.setX(this.iconPrintText.getX());
        iconGenericElement.setY(this.iconPrintText.getY());
        iconGenericElement.setWidth(this.iconPrintText.getWidth());
        iconGenericElement.setHeight(this.iconPrintText.getHeight());
        iconGenericElement.setParameterValue("iconTextElement", this.iconPrintText);
        printElement.setParameterValue("iconGenericElement", iconGenericElement);
    }
}

