/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.components.table.nodes.properties;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.editor.ExpressionContext;
import com.jaspersoft.ireport.designer.sheet.GenericProperty;
import com.jaspersoft.ireport.designer.sheet.editors.JRPropertiesMapPropertyEditor;
import java.beans.PropertyEditor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.components.table.StandardBaseColumn;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRPropertiesMap;
import net.sf.jasperreports.engine.JRPropertyExpression;
import net.sf.jasperreports.engine.design.JRDesignDataset;
import net.sf.jasperreports.engine.design.JRDesignExpression;
import net.sf.jasperreports.engine.design.JRDesignPropertyExpression;
import org.openide.nodes.PropertySupport;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ColumnPropertyExpressionsProperty
extends PropertySupport {
    PropertyEditor editor = null;
    StandardBaseColumn column = null;

    public ColumnPropertyExpressionsProperty(StandardBaseColumn column, JRDesignDataset dataset) {
        super("expressionProperties", List.class, "Properties expressions", "List of property expressions for this element", true, true);
        this.setValue("canEditAsText", Boolean.FALSE);
        this.setValue("useList", Boolean.TRUE);
        this.setValue("canUseExpression", Boolean.TRUE);
        this.setValue("EXPRESSION_CONTEXT", new ExpressionContext(dataset));
        this.setValue("hintType", 4);
        this.column = column;
    }

    public Object getValue() throws IllegalAccessException, InvocationTargetException {
        JRPropertiesMap map = this.column.getPropertiesMap();
        ArrayList<GenericProperty> properties = new ArrayList<GenericProperty>();
        String[] names = map.getPropertyNames();
        for (int i = 0; i < names.length; ++i) {
            properties.add(new GenericProperty(names[i], (Object)map.getProperty(names[i])));
        }
        JRPropertyExpression[] expProperties = this.column.getPropertyExpressions();
        for (int i = 0; expProperties != null && i < expProperties.length; ++i) {
            properties.add(new GenericProperty(expProperties[i].getName(), (JRDesignExpression)expProperties[i].getValueExpression()));
        }
        return properties;
    }

    public void setValue(Object val) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (!(val instanceof List)) {
            throw new IllegalArgumentException();
        }
        JRPropertiesMap map = new JRPropertiesMap();
        List values = (List)val;
        for (int i = 0; i < values.size(); ++i) {
            GenericProperty prop = (GenericProperty)values.get(i);
            if (prop.isUseExpression()) continue;
            map.setProperty(prop.getKey(), (String)prop.getValue());
        }
        ModelUtils.replacePropertiesMap((JRPropertiesMap)map, (JRPropertiesMap)this.column.getPropertiesMap());
        ColumnPropertyExpressionsProperty.replaceExpressionProperties(this.column, values);
        IReportManager.getInstance().notifyReportChange();
    }

    public PropertyEditor getPropertyEditor() {
        if (this.editor == null) {
            this.editor = new JRPropertiesMapPropertyEditor();
        }
        return this.editor;
    }

    public static void replaceExpressionProperties(StandardBaseColumn column, List<GenericProperty> newExpressionProperties) {
        ArrayList usedProps = new ArrayList();
        List propertyExpressions = column.getPropertyExpressionsList();
        for (int i = 0; i < propertyExpressions.size(); ++i) {
            column.removePropertyExpression((JRPropertyExpression)propertyExpressions.get(i));
        }
        if (newExpressionProperties == null) {
            return;
        }
        for (GenericProperty prop : newExpressionProperties) {
            if (!prop.isUseExpression()) continue;
            JRDesignPropertyExpression newProp = new JRDesignPropertyExpression();
            newProp.setName(prop.getKey());
            newProp.setValueExpression((JRExpression)prop.getExpression());
            column.addPropertyExpression((JRPropertyExpression)newProp);
        }
    }
}

