/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.jasperserver.ui.nodes;

import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.dnd.ReportObjectPaletteTransferable;
import com.jaspersoft.ireport.designer.outline.nodes.IRAbstractNode;
import com.jaspersoft.ireport.jasperserver.JasperServerManager;
import com.jaspersoft.ireport.jasperserver.RepositoryFile;
import com.jaspersoft.ireport.jasperserver.RepositoryFolder;
import com.jaspersoft.ireport.jasperserver.ui.RepositoryListCellRenderer;
import com.jaspersoft.ireport.jasperserver.ui.actions.DeleteAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.ImportDatasourceAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.ImportXMLADatasourceAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.OpenFileAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.PropertiesAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.RefreshAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.ReplaceFileAction;
import com.jaspersoft.ireport.jasperserver.ui.actions.RunReportUnitAction;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ReportUnitNode;
import com.jaspersoft.ireport.jasperserver.ui.nodes.ResourceNode;
import com.jaspersoft.jasperserver.api.metadata.xml.domain.impl.ResourceDescriptor;
import java.awt.Image;
import java.awt.datatransfer.Transferable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.Action;
import javax.swing.ImageIcon;
import org.openide.actions.CopyAction;
import org.openide.actions.CutAction;
import org.openide.nodes.Children;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.actions.SystemAction;
import org.openide.util.datatransfer.ExTransferable;

public class FileNode
extends IRAbstractNode
implements ResourceNode {
    private RepositoryFile file = null;

    public FileNode(RepositoryFile file, Lookup doLkp) {
        super(Children.LEAF, doLkp);
        this.file = file;
        IReportManager.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            public void preferenceChange(PreferenceChangeEvent pce) {
                FileNode.this.fireDisplayNameChange(null, FileNode.this.getDisplayName());
            }
        });
    }

    public String getDisplayName() {
        if (!IReportManager.getPreferences().getBoolean("jasperserver.showResourceIDs", false)) {
            return "" + this.getFile().getDescriptor().getLabel();
        }
        return "" + this.getFile().getDescriptor().getName();
    }

    public Image getIcon(int arg0) {
        return FileNode.getResourceIcon(this.getFile().getDescriptor()).getImage();
    }

    public boolean hasCustomizer() {
        return false;
    }

    public static ImageIcon getResourceIcon(ResourceDescriptor resource) {
        return RepositoryListCellRenderer.getResourceIcon(resource);
    }

    public RepositoryFile getFile() {
        return this.file;
    }

    public void setFile(RepositoryFile file) {
        this.file = file;
    }

    public Action[] getActions(boolean arg0) {
        ArrayList<Object> actions = new ArrayList<Object>();
        ResourceDescriptor resource = this.getFile().getDescriptor();
        if (resource.getWsType().equals("img") || resource.getWsType().equals("jrxml") || resource.getWsType().equals("prop") || resource.getWsType().equals("xml") || resource.getWsType().equals("jrtx")) {
            actions.add(SystemAction.get(OpenFileAction.class));
            actions.add(SystemAction.get(ReplaceFileAction.class));
        }
        if (ReportUnitNode.getParentReportUnit((Node)this) == null) {
            actions.add(SystemAction.get(CopyAction.class));
            actions.add(SystemAction.get(CutAction.class));
        }
        actions.add(SystemAction.get(DeleteAction.class));
        if (ReportUnitNode.getParentReportUnit((Node)this) != null) {
            actions.add(null);
            actions.add(SystemAction.get(RunReportUnitAction.class));
        }
        if (this.getFile().getDescriptor().getWsType().equals("jdbc")) {
            actions.add(SystemAction.get(ImportDatasourceAction.class));
        }
        if (this.getFile().getDescriptor().getWsType().equals("olapXmlaCon")) {
            actions.add(SystemAction.get(ImportXMLADatasourceAction.class));
        }
        actions.add(null);
        List<Action> actionsToAdd = JasperServerManager.getContributedMenuActionsFor(this.getResourceDescriptor());
        if (actionsToAdd != null) {
            actions.addAll(actionsToAdd);
        }
        actions.add(SystemAction.get(RefreshAction.class));
        actions.add(SystemAction.get(PropertiesAction.class));
        return actions.toArray(new Action[actions.size()]);
    }

    public Action getPreferredAction() {
        if (this.getFile().getDescriptor().getWsType().equals("jrxml")) {
            return SystemAction.get(OpenFileAction.class);
        }
        return SystemAction.get(PropertiesAction.class);
    }

    public ResourceDescriptor getResourceDescriptor() {
        return this.getFile().getDescriptor();
    }

    public RepositoryFolder getRepositoryObject() {
        return this.getFile();
    }

    public void refreshChildrens(boolean b) {
    }

    public void updateDisplayName() {
        this.fireDisplayNameChange(null, null);
    }

    public void removeChildren(Node[] nodes) {
        this.getChildren().remove(nodes);
        this.fireNodeDestroyed();
    }

    public Transferable drag() throws IOException {
        ExTransferable tras = ExTransferable.create((Transferable)this.clipboardCut());
        if (this.getFile().getDescriptor().getWsType().equals("img")) {
            tras.put((ExTransferable.Single)new ReportObjectPaletteTransferable("com.jaspersoft.ireport.jasperserver.ui.actions.CreateImageAction", (Object)this.getFile()));
        }
        return tras;
    }

    public boolean canCopy() {
        return ReportUnitNode.getParentReportUnit((Node)this) == null;
    }

    public boolean canCut() {
        return ReportUnitNode.getParentReportUnit((Node)this) == null;
    }
}

