/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.undo;

import java.util.ArrayList;
import java.util.List;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;

public class AggregatedUndoableEdit
extends AbstractUndoableEdit {
    private String presentationName = "";
    private List<UndoableEdit> otherEdits = new ArrayList<UndoableEdit>();

    public AggregatedUndoableEdit() {
        this("");
    }

    public AggregatedUndoableEdit(String name) {
        this.presentationName = name;
    }

    public void undo() throws CannotUndoException {
        for (int i = this.otherEdits.size() - 1; i >= 0; --i) {
            UndoableEdit undoOp = this.otherEdits.get(i);
            undoOp.undo();
        }
        super.undo();
    }

    public void redo() throws CannotRedoException {
        super.redo();
        for (UndoableEdit undoOp : this.otherEdits) {
            undoOp.redo();
        }
    }

    public String getPresentationName() {
        return this.presentationName;
    }

    public boolean concatenate(UndoableEdit anEdit) {
        this.otherEdits.add(anEdit);
        return true;
    }

    public void setPresentationName(String presentationName) {
        this.presentationName = presentationName;
    }

    public int getAggregatedEditCount() {
        return this.otherEdits.size();
    }
}

