/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.connection;

import com.jaspersoft.ireport.designer.IReportConnection;
import com.jaspersoft.ireport.designer.IReportConnectionEditor;
import com.jaspersoft.ireport.designer.IReportManager;
import com.jaspersoft.ireport.designer.ModelUtils;
import com.jaspersoft.ireport.designer.connection.gui.JRDataSourceProviderConnectionEditor;
import com.jaspersoft.ireport.designer.data.WizardFieldsProvider;
import com.jaspersoft.ireport.designer.utils.Misc;
import com.jaspersoft.ireport.locale.I18n;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRDataSourceProvider;
import net.sf.jasperreports.engine.JRField;
import net.sf.jasperreports.engine.JasperCompileManager;
import net.sf.jasperreports.engine.JasperReport;
import net.sf.jasperreports.engine.design.JRDesignField;
import net.sf.jasperreports.engine.design.JasperDesign;
import net.sf.jasperreports.engine.xml.JRXmlLoader;
import org.openide.util.Mutex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JRDataSourceProviderConnection
extends IReportConnection
implements WizardFieldsProvider {
    private JRDataSourceProvider dsp;
    private JRDataSource ds;
    private HashMap properties = new HashMap();

    public JRDataSourceProvider getDataSourceProvider() {
        if (this.dsp == null && this.getProperties().get("JRDataSourceProvider") != null) {
            try {
                String string = (String)this.getProperties().get("JRDataSourceProvider");
                IReportManager.getInstance();
                this.dsp = (JRDataSourceProvider)Class.forName(string, true, IReportManager.getReportClassLoader()).newInstance();
            }
            catch (NoClassDefFoundError ex) {
                this.showErrorMessage("No class definition found error!!\nCheck your classpath!", "Exception");
            }
            catch (ClassNotFoundException ex) {
                this.showErrorMessage("Class not found error!!\nCheck your classpath!", "Exception");
            }
            catch (Exception ex) {
                this.showErrorMessage(I18n.getString("unexpected.datasource.error", (Object)ex.getMessage(), Misc.getLogFile()), "Exception");
            }
        }
        return this.dsp;
    }

    @Override
    public JRDataSource getJRDataSource() {
        return this.getJRDataSource(null);
    }

    @Override
    public JRDataSource getJRDataSource(JasperReport jasper) {
        if (this.ds != null) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "This datasource is already in use by another filling process!!", "Error", 0);
            return null;
        }
        try {
            this.ds = this.getDataSourceProvider().create(jasper);
        }
        catch (Exception ex) {
            Mutex.EVENT.readAccess(new Runnable(){

                public void run() {
                    JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("Problems occurred creating the new datasource!!\n{0}", new Object[]{"" + ex.getMessage()}), "Error", 0);
                }
            });
        }
        return this.ds;
    }

    public void disposeDataSource() {
        if (this.dsp != null) {
            try {
                this.dsp.dispose(this.ds);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.ds = null;
        }
    }

    @Override
    public HashMap getProperties() {
        return this.properties;
    }

    @Override
    public void loadProperties(HashMap map) {
        this.properties = map;
    }

    @Override
    public void save(PrintWriter pw) {
        HashMap hm = this.getProperties();
        pw.println("\t<iReportConnection name=\"" + this.getName() + "\" connectionClass=\"" + this.getClass().getName() + "\">");
        for (String key : hm.keySet()) {
            pw.println("\t\t<connectionParameter name=\"" + key + "\"><![CDATA[" + hm.get(key) + "]]></connectionParameter>");
        }
        pw.println("\t</iReportConnection>");
    }

    @Override
    public String getDescription() {
        return "JRDataSourceProvider";
    }

    @Override
    public IReportConnectionEditor getIReportConnectionEditor() {
        return new JRDataSourceProviderConnectionEditor();
    }

    @Override
    public void test() throws Exception {
        try {
            String string = (String)this.getProperties().get("JRDataSourceProvider");
            IReportManager.getInstance();
            Class<?> c = Class.forName(string, true, IReportManager.getReportClassLoader());
            if (!JRDataSourceProvider.class.isAssignableFrom(c)) {
                JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("\"{0}\" is not a subclass of\nnet.sf.jasperreports.engine.JRDataSourceProvider.", new Object[]{this.getProperties().get("JRDataSourceProvider")}), "Error", 0);
                return;
            }
            JOptionPane.showMessageDialog(Misc.getMainWindow(), "Connection test successful!", "", 1);
            return;
        }
        catch (NoClassDefFoundError ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nNoClassDefFoundError!!\nCheck your classpath!\n{1}", new Object[]{"", "" + ex.getMessage()}), "Exception", 0);
            return;
        }
        catch (ClassNotFoundException ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nClassNotFoundError!\nMsg: {1}\nPossible not found class: {2}\nCheck your classpath!", new Object[]{"", "" + ex.getMessage(), "" + this.getProperties().get("JRDataSourceProvider")}), "Exception", 0);
            return;
        }
        catch (Exception ex) {
            JOptionPane.showMessageDialog(Misc.getMainWindow(), Misc.formatString("{0}\nGeneral problem:\n {1}", new Object[]{"", "" + ex.getMessage()}), "Exception", 0);
            return;
        }
    }

    @Override
    public String getQueryLanguage() {
        return null;
    }

    @Override
    public List<JRDesignField> readFields(String query) throws Exception {
        ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>();
        try {
            InputStream is = this.getClass().getResourceAsStream("/com/jaspersoft/ireport/designer/data/data.jrxml");
            JasperDesign dataJd = JRXmlLoader.load((InputStream)is);
            dataJd.getFieldsList().clear();
            dataJd.getFieldsMap().clear();
            JasperReport jr = JasperCompileManager.compileReport((JasperDesign)dataJd);
            JRField[] jrfields = this.getDataSourceProvider().getFields(jr);
            for (int i = 0; i < jrfields.length; ++i) {
                JRDesignField field = new JRDesignField();
                field.setName(jrfields[i].getName());
                field.setDescription(jrfields[i].getDescription());
                field.setValueClassName(jrfields[i].getValueClassName());
                field.setValueClass(jrfields[i].getValueClass());
                ModelUtils.replacePropertiesMap(jrfields[i].getPropertiesMap(), field.getPropertiesMap());
                fields.add(field);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return fields;
    }

    @Override
    public boolean supportsDesign() {
        return false;
    }

    @Override
    public String designQuery(String query) {
        return query;
    }
}

