/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.ireport.designer.actions;

import com.jaspersoft.ireport.designer.editor.ExpressionEditor;
import com.jaspersoft.ireport.designer.editor.FullExpressionContext;
import com.jaspersoft.ireport.designer.outline.nodes.ConditionalStyleNode;
import com.jaspersoft.ireport.designer.utils.Misc;
import java.lang.reflect.InvocationTargetException;
import net.sf.jasperreports.engine.design.JasperDesign;
import org.openide.nodes.Node;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.actions.NodeAction;

public final class EditConditionalStyleExpressionBandAction
extends NodeAction {
    private static EditConditionalStyleExpressionBandAction instance = null;

    public static synchronized EditConditionalStyleExpressionBandAction getInstance() {
        if (instance == null) {
            instance = new EditConditionalStyleExpressionBandAction();
        }
        return instance;
    }

    private EditConditionalStyleExpressionBandAction() {
    }

    public String getName() {
        return "Edit Condition";
    }

    protected void initialize() {
        super.initialize();
        this.putValue("noIconInMenu", Boolean.TRUE);
    }

    public HelpCtx getHelpCtx() {
        return HelpCtx.DEFAULT_HELP;
    }

    protected boolean asynchronous() {
        return false;
    }

    protected void performAction(Node[] activatedNodes) {
        ConditionalStyleNode node = (ConditionalStyleNode)activatedNodes[0];
        String exp = Misc.getExpressionText(node.getConditionalStyle().getConditionExpression());
        FullExpressionContext context = new FullExpressionContext((JasperDesign)node.getLookup().lookup(JasperDesign.class));
        ExpressionEditor editor = new ExpressionEditor();
        editor.setExpression(exp);
        editor.setExpressionContext(context);
        int res = editor.showDialog(Misc.getMainFrame());
        if (res == 0) {
            Node.PropertySet[] sets = node.getPropertySets();
            for (int i = 0; i < sets.length; ++i) {
                if (!sets[i].getName().equals("properties")) continue;
                Node.Property[] props = sets[i].getProperties();
                for (int k = 0; k < props.length; ++k) {
                    if (!props[k].getName().equals("conditionExpression")) continue;
                    try {
                        props[k].setValue((Object)editor.getExpression());
                        return;
                    }
                    catch (IllegalAccessException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        continue;
                    }
                    catch (IllegalArgumentException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                        continue;
                    }
                    catch (InvocationTargetException ex) {
                        Exceptions.printStackTrace((Throwable)ex);
                    }
                }
            }
        }
    }

    protected boolean enable(Node[] activatedNodes) {
        return activatedNodes != null && activatedNodes.length == 1 && activatedNodes[0] instanceof ConditionalStyleNode;
    }
}

