/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.components.spiderchart;

import java.io.IOException;
import net.sf.jasperreports.charts.JRCategorySeries;
import net.sf.jasperreports.components.charts.ChartSettings;
import net.sf.jasperreports.components.spiderchart.SpiderChartComponent;
import net.sf.jasperreports.components.spiderchart.SpiderDataset;
import net.sf.jasperreports.components.spiderchart.SpiderPlot;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRComponentElement;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRHyperlinkParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.component.Component;
import net.sf.jasperreports.engine.component.ComponentKey;
import net.sf.jasperreports.engine.component.ComponentXmlWriter;
import net.sf.jasperreports.engine.component.ComponentsEnvironment;
import net.sf.jasperreports.engine.type.EvaluationTimeEnum;
import net.sf.jasperreports.engine.type.HyperlinkTargetEnum;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.util.JRXmlWriteHelper;
import net.sf.jasperreports.engine.util.VersionComparator;
import net.sf.jasperreports.engine.util.XmlNamespace;
import net.sf.jasperreports.engine.xml.JRXmlWriter;

public class SpiderChartXmlWriter
implements ComponentXmlWriter {
    public static final String ELEMENT_spiderChart = "spiderChart";
    public static final String ELEMENT_chartSettings = "chartSettings";
    public static final String ELEMENT_spiderDataset = "spiderDataset";
    public static final String ELEMENT_spiderPlot = "spiderPlot";
    public static final String ELEMENT_maxValueExpression = "maxValueExpression";
    public static final String ATTRIBUTE_rotation = "rotation";
    public static final String ATTRIBUTE_tableOrder = "tableOrder";
    public static final String ATTRIBUTE_webFilled = "isWebFilled";
    public static final String ATTRIBUTE_startAngle = "startAngle";
    public static final String ATTRIBUTE_headPercent = "headPercent";
    public static final String ATTRIBUTE_interiorGap = "interiorGap";
    public static final String ATTRIBUTE_axisLineColor = "axisLineColor";
    public static final String ATTRIBUTE_axisLineWidth = "axisLineWidth";
    public static final String ATTRIBUTE_labelGap = "labelGap";
    public static final String ATTRIBUTE_labelColor = "labelColor";
    private JasperReportsContext jasperReportsContext;
    private final String version;
    private final VersionComparator versionComparator;

    public SpiderChartXmlWriter() {
        this(DefaultJasperReportsContext.getInstance());
    }

    public SpiderChartXmlWriter(JasperReportsContext jasperReportsContext) {
        this(jasperReportsContext, null, new VersionComparator());
    }

    public SpiderChartXmlWriter(JasperReportsContext jasperReportsContext, String version, VersionComparator versionComparator) {
        this.jasperReportsContext = jasperReportsContext;
        this.version = version;
        this.versionComparator = versionComparator;
    }

    @Override
    public boolean isToWrite(JRComponentElement componentElement, JRXmlWriter reportWriter) {
        return this.isNewerVersionOrEqual(this.version, "3.7.4");
    }

    @Override
    public void writeToXml(JRComponentElement componentElement, JRXmlWriter reportWriter) throws IOException {
        Component component = componentElement.getComponent();
        SpiderChartComponent spiderChartComponent = (SpiderChartComponent)component;
        JRXmlWriteHelper writer = reportWriter.getXmlWriteHelper();
        ComponentKey componentKey = componentElement.getComponentKey();
        String namespaceURI = componentKey.getNamespace();
        String schemaLocation = ComponentsEnvironment.getInstance(this.jasperReportsContext).getBundle(namespaceURI).getXmlParser().getPublicSchemaLocation();
        XmlNamespace componentNamespace = new XmlNamespace(namespaceURI, componentKey.getNamespacePrefix(), schemaLocation);
        writer.startElement(ELEMENT_spiderChart, componentNamespace);
        writer.addAttribute("evaluationTime", spiderChartComponent.getEvaluationTime(), EvaluationTimeEnum.NOW);
        if (spiderChartComponent.getEvaluationTime() == EvaluationTimeEnum.GROUP) {
            writer.addEncodedAttribute("evaluationGroup", spiderChartComponent.getEvaluationGroup());
        }
        ChartSettings chartSettings = spiderChartComponent.getChartSettings();
        this.writeChart(chartSettings, writer, reportWriter, componentNamespace);
        SpiderDataset dataset = (SpiderDataset)spiderChartComponent.getDataset();
        this.writeSpiderDataSet(dataset, writer, reportWriter, componentNamespace);
        SpiderPlot spiderPlot = (SpiderPlot)spiderChartComponent.getPlot();
        this.writeSpiderPlot(spiderPlot, chartSettings, writer, componentNamespace);
        writer.closeElement();
    }

    private void writeChart(ChartSettings chartSettings, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace) throws IOException {
        writer.startElement(ELEMENT_chartSettings, namespace);
        writer.addAttribute("isShowLegend", chartSettings.getShowLegend());
        writer.addAttribute("backcolor", chartSettings.getBackcolor());
        writer.addEncodedAttribute("hyperlinkType", chartSettings.getLinkType(), HyperlinkTypeEnum.NONE.getName());
        writer.addEncodedAttribute("hyperlinkTarget", chartSettings.getLinkTarget(), HyperlinkTargetEnum.SELF.getName());
        writer.addAttribute("bookmarkLevel", chartSettings.getBookmarkLevel(), 0);
        if (this.isNewerVersionOrEqual(this.version, "3.7.5")) {
            writer.addEncodedAttribute("customizerClass", chartSettings.getCustomizerClass());
        }
        writer.addEncodedAttribute("renderType", chartSettings.getRenderType());
        writer.startElement("chartTitle", JRXmlWriter.JASPERREPORTS_NAMESPACE);
        writer.addAttribute("position", chartSettings.getTitlePosition());
        writer.addAttribute("color", chartSettings.getTitleColor());
        this.writeFont(chartSettings.getTitleFont(), writer);
        if (chartSettings.getTitleExpression() != null) {
            this.writeExpression("titleExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, chartSettings.getTitleExpression(), false, writer);
        }
        writer.closeElement();
        writer.startElement("chartSubtitle", JRXmlWriter.JASPERREPORTS_NAMESPACE);
        writer.addAttribute("color", chartSettings.getSubtitleColor());
        this.writeFont(chartSettings.getSubtitleFont(), writer);
        if (chartSettings.getSubtitleExpression() != null) {
            this.writeExpression("subtitleExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, chartSettings.getSubtitleExpression(), false, writer);
        }
        writer.closeElement();
        writer.startElement("chartLegend", JRXmlWriter.JASPERREPORTS_NAMESPACE);
        if (chartSettings.getLegendColor() != null) {
            writer.addAttribute("textColor", chartSettings.getLegendColor());
        }
        if (chartSettings.getLegendBackgroundColor() != null) {
            writer.addAttribute("backgroundColor", chartSettings.getLegendBackgroundColor());
        }
        writer.addAttribute("position", chartSettings.getLegendPosition());
        this.writeFont(chartSettings.getLegendFont(), writer);
        writer.closeElement();
        this.writeExpression("anchorNameExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, chartSettings.getAnchorNameExpression(), false, writer);
        this.writeExpression("hyperlinkReferenceExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, chartSettings.getHyperlinkReferenceExpression(), false, writer);
        this.writeExpression("hyperlinkWhenExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, chartSettings.getHyperlinkWhenExpression(), false, writer);
        this.writeExpression("hyperlinkAnchorExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, chartSettings.getHyperlinkAnchorExpression(), false, writer);
        this.writeExpression("hyperlinkPageExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, chartSettings.getHyperlinkPageExpression(), false, writer);
        this.writeExpression("hyperlinkTooltipExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, chartSettings.getHyperlinkTooltipExpression(), false, writer);
        this.writeHyperlinkParameters(chartSettings.getHyperlinkParameters(), writer);
        writer.closeElement();
    }

    private void writeSpiderDataSet(SpiderDataset dataset, JRXmlWriteHelper writer, JRXmlWriter reportWriter, XmlNamespace namespace) throws IOException {
        writer.startElement(ELEMENT_spiderDataset, namespace);
        reportWriter.writeElementDataset(dataset);
        JRCategorySeries[] categorySeries = dataset.getSeries();
        if (categorySeries != null && categorySeries.length > 0) {
            for (int i = 0; i < categorySeries.length; ++i) {
                this.writeCategorySeries(categorySeries[i], writer, reportWriter);
            }
        }
        writer.closeElement();
    }

    private void writeCategorySeries(JRCategorySeries categorySeries, JRXmlWriteHelper writer, JRXmlWriter reportWriter) throws IOException {
        writer.startElement("categorySeries", JRXmlWriter.JASPERREPORTS_NAMESPACE);
        this.writeExpression("seriesExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, categorySeries.getSeriesExpression(), false, writer);
        this.writeExpression("categoryExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, categorySeries.getCategoryExpression(), false, writer);
        this.writeExpression("valueExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, categorySeries.getValueExpression(), false, writer);
        this.writeExpression("labelExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, categorySeries.getLabelExpression(), false, writer);
        reportWriter.writeHyperlink("itemHyperlink", JRXmlWriter.JASPERREPORTS_NAMESPACE, categorySeries.getItemHyperlink());
        writer.closeElement();
    }

    private void writeFont(JRFont font, JRXmlWriteHelper writer) throws IOException {
        if (font != null) {
            writer.startElement("font", JRXmlWriter.JASPERREPORTS_NAMESPACE);
            writer.addEncodedAttribute("fontName", font.getOwnFontName());
            writer.addAttribute("size", font.getOwnFontSize());
            writer.addAttribute("isBold", font.isOwnBold());
            writer.addAttribute("isItalic", font.isOwnItalic());
            writer.addAttribute("isUnderline", font.isOwnUnderline());
            writer.addAttribute("isStrikeThrough", font.isOwnStrikeThrough());
            writer.addEncodedAttribute("pdfFontName", font.getOwnPdfFontName());
            writer.addEncodedAttribute("pdfEncoding", font.getOwnPdfEncoding());
            writer.addAttribute("isPdfEmbedded", font.isOwnPdfEmbedded());
            writer.closeElement(true);
        }
    }

    private void writeHyperlinkParameters(JRHyperlinkParameter[] parameters, JRXmlWriteHelper writer) throws IOException {
        if (parameters != null) {
            for (int i = 0; i < parameters.length; ++i) {
                JRHyperlinkParameter parameter = parameters[i];
                this.writeHyperlinkParameter(parameter, writer);
            }
        }
    }

    private void writeHyperlinkParameter(JRHyperlinkParameter parameter, JRXmlWriteHelper writer) throws IOException {
        if (parameter != null) {
            writer.startElement("hyperlinkParameter", JRXmlWriter.JASPERREPORTS_NAMESPACE);
            writer.addEncodedAttribute("name", parameter.getName());
            this.writeExpression("hyperlinkParameterExpression", JRXmlWriter.JASPERREPORTS_NAMESPACE, parameter.getValueExpression(), false, writer);
            writer.closeElement();
        }
    }

    private void writeSpiderPlot(SpiderPlot spiderPlot, ChartSettings chartSettings, JRXmlWriteHelper writer, XmlNamespace namespace) throws IOException {
        writer.startElement(ELEMENT_spiderPlot, namespace);
        writer.addAttribute(ATTRIBUTE_rotation, spiderPlot.getRotation());
        writer.addAttribute(ATTRIBUTE_tableOrder, spiderPlot.getTableOrder());
        writer.addAttribute(ATTRIBUTE_webFilled, spiderPlot.getWebFilled());
        writer.addAttribute(ATTRIBUTE_startAngle, spiderPlot.getStartAngle());
        writer.addAttribute(ATTRIBUTE_headPercent, spiderPlot.getHeadPercent());
        writer.addAttribute(ATTRIBUTE_interiorGap, spiderPlot.getInteriorGap());
        writer.addAttribute(ATTRIBUTE_axisLineColor, spiderPlot.getAxisLineColor());
        writer.addAttribute(ATTRIBUTE_axisLineWidth, spiderPlot.getAxisLineWidth());
        writer.addAttribute(ATTRIBUTE_labelGap, spiderPlot.getLabelGap());
        writer.addAttribute(ATTRIBUTE_labelColor, spiderPlot.getLabelColor());
        writer.addAttribute("backcolor", spiderPlot.getBackcolor());
        writer.addAttribute("backgroundAlpha", spiderPlot.getBackgroundAlpha());
        writer.addAttribute("foregroundAlpha", spiderPlot.getForegroundAlpha());
        this.writeLabelFont(spiderPlot.getLabelFont(), writer);
        this.writeExpression(ELEMENT_maxValueExpression, namespace, spiderPlot.getMaxValueExpression(), false, writer);
        writer.closeElement(true);
    }

    private void writeLabelFont(JRFont labelFont, JRXmlWriteHelper writer) throws IOException {
        if (labelFont != null) {
            writer.startElement("labelFont", JRXmlWriter.JASPERREPORTS_NAMESPACE);
            this.writeFont(labelFont, writer);
            writer.closeElement();
        }
    }

    protected boolean isNewerVersionOrEqual(String currentVersion, String oldVersion) {
        return this.versionComparator.compare(currentVersion, oldVersion) >= 0;
    }

    protected void writeExpression(String name, XmlNamespace namespace, JRExpression expression, boolean writeClass, JRXmlWriteHelper writer) throws IOException {
        if (this.isNewerVersionOrEqual(this.version, "4.1.1")) {
            writer.writeExpression(name, namespace, expression);
        } else {
            writer.writeExpression(name, namespace, expression, writeClass);
        }
    }
}

