/*
 * Decompiled with CFR 0.152.
 */
package com.jaspersoft.mongodb;

import com.jaspersoft.mongodb.connection.MongoDbConnection;
import com.jaspersoft.mongodb.query.MongoDbParameter;
import com.jaspersoft.mongodb.query.MongoDbQueryExecuter;
import com.jaspersoft.mongodb.query.MongoDbQueryWrapper;
import com.mongodb.BasicDBList;
import com.mongodb.BasicDBObject;
import com.mongodb.DBObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.design.JRDesignField;
import org.apache.log4j.Logger;

public class MongoDbFieldsProvider {
    private static MongoDbFieldsProvider instance;
    private static final Lock lock;
    private static final Logger logger;
    public static final String FIELD_NAME_SEPARATOR = ".";

    static {
        lock = new ReentrantLock();
        logger = Logger.getLogger(MongoDbFieldsProvider.class);
    }

    private MongoDbFieldsProvider() {
    }

    public static MongoDbFieldsProvider getInstance() {
        lock.lock();
        try {
            if (instance == null) {
                instance = new MongoDbFieldsProvider();
            }
            MongoDbFieldsProvider mongoDbFieldsProvider = instance;
            return mongoDbFieldsProvider;
        }
        finally {
            lock.unlock();
        }
    }

    public List<JRDesignField> getFields(JRDataset dataset, Map<String, Object> parameters, MongoDbConnection connection) throws JRException {
        MongoDbQueryExecuter queryExecuter = null;
        MongoDbQueryWrapper wrapper = null;
        try {
            HashMap<String, MongoDbParameter> newValueParameters = new HashMap<String, MongoDbParameter>();
            for (String parameterName : parameters.keySet()) {
                Object parameterValue = parameters.get(parameterName);
                MongoDbParameter newParameter = new MongoDbParameter(parameterName, parameterValue);
                newValueParameters.put(parameterName, newParameter);
            }
            parameters.clear();
            newValueParameters.put("REPORT_PARAMETERS_MAP", new MongoDbParameter("REPORT_PARAMETERS_MAP", parameters));
            queryExecuter = new MongoDbQueryExecuter(dataset, newValueParameters, true);
            wrapper = new MongoDbQueryWrapper(queryExecuter.getProcessedQueryString(), connection, queryExecuter.getParameters());
            logger.info((Object)("FieldsProvider will find fields from the first " + wrapper.rowsToProcess + " records."));
            TreeMap fieldNames = new TreeMap();
            if (wrapper.iterator != null) {
                this.processCursorFields(wrapper, fieldNames);
            } else if (wrapper.commandResults != null) {
                this.processCommandResultFields(wrapper, fieldNames);
            }
            ArrayList<JRDesignField> fields = new ArrayList<JRDesignField>();
            JRDesignField field = null;
            logger.info((Object)("Found " + fieldNames.keySet().size() + " fields"));
            for (String fieldName : fieldNames.keySet()) {
                field = new JRDesignField();
                field.setName(fieldName);
                field.setValueClass((Class)fieldNames.get(fieldName));
                field.setDescription(null);
                fields.add(field);
            }
            ArrayList<JRDesignField> arrayList = fields;
            return arrayList;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
    }

    private void processCommandResultFields(MongoDbQueryWrapper wrapper, Map<String, Class<?>> fieldNames) {
        Iterator<?> resultsIterator = wrapper.commandResults.iterator();
        while (resultsIterator.hasNext() && wrapper.rowsToProcess >= 0) {
            Map currentResult = (Map)resultsIterator.next();
            this.processMapResult(null, currentResult, fieldNames);
            --wrapper.rowsToProcess;
        }
    }

    /*
     * Handled impossible loop by duplicating code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void processCursorFields(MongoDbQueryWrapper wrapper, Map<String, Class<?>> fieldNames) {
        try {
            block7: {
                block6: {
                    if (!true) break block6;
                    if (!wrapper.iterator.hasNext()) return;
                    if (wrapper.rowsToProcess < 0) break block7;
                }
                do {
                    DBObject currentDbObject = wrapper.iterator.next();
                    this.processDBObject(null, currentDbObject, fieldNames);
                    --wrapper.rowsToProcess;
                    if (!wrapper.iterator.hasNext()) return;
                } while (wrapper.rowsToProcess >= 0);
            }
            return;
        }
        finally {
            if (wrapper.iterator != null) {
                wrapper.iterator.close();
            }
        }
    }

    private void processMapResult(String parentFieldName, Map<?, ?> currentResult, Map<String, Class<?>> fieldNames) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processDBObject parentFieldName: " + parentFieldName));
            logger.debug((Object)("processDBObject currentDbObject: " + currentResult.toString()));
        }
        for (Object fieldName : currentResult.keySet()) {
            Object value = currentResult.get(fieldName);
            if (value == null) continue;
            if (value instanceof Map) {
                this.processMapResult(String.valueOf(parentFieldName == null ? "" : String.valueOf(parentFieldName) + FIELD_NAME_SEPARATOR) + fieldName, (Map)value, fieldNames);
                continue;
            }
            fieldNames.put(String.valueOf(parentFieldName == null ? "" : String.valueOf(parentFieldName) + FIELD_NAME_SEPARATOR) + fieldName, value.getClass());
        }
    }

    private void processDBObject(String parentFieldName, DBObject currentDbObject, Map<String, Class<?>> fieldNames) {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("processDBObject parentFieldName: " + parentFieldName));
            logger.debug((Object)("processDBObject currentDbObject: " + currentDbObject.toString()));
        }
        for (String fieldName : currentDbObject.keySet()) {
            Object value = currentDbObject.get(fieldName);
            if (value == null) continue;
            if (value instanceof BasicDBList) {
                fieldNames.put(String.valueOf(parentFieldName == null ? "" : String.valueOf(parentFieldName) + FIELD_NAME_SEPARATOR) + fieldName, List.class);
                continue;
            }
            if (value instanceof BasicDBObject) {
                this.processDBObject(String.valueOf(parentFieldName == null ? "" : String.valueOf(parentFieldName) + FIELD_NAME_SEPARATOR) + fieldName, (DBObject)value, fieldNames);
                continue;
            }
            fieldNames.put(String.valueOf(parentFieldName == null ? "" : String.valueOf(parentFieldName) + FIELD_NAME_SEPARATOR) + fieldName, value.getClass());
        }
    }
}

