/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.expressions.functions.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.jasperreports.engine.JRExpression;
import net.sf.jasperreports.expressions.JRExprFunctions;
import net.sf.jasperreports.expressions.annotations.JRExprAnnotationsUtils;
import net.sf.jasperreports.expressions.annotations.JRExprFunctionBean;
import net.sf.jasperreports.extensions.ExtensionsEnvironment;

public class FunctionsLibraryUtil {
    private static Map<String, List<JRExprFunctionBean>> functionsByCategory = null;
    private static List<JRExprFunctionBean> allFunctions = null;
    private static List<String> libraryClassNames = null;
    private static String[] PREFIX_STRINGS = new String[]{"(", "+", "-", "/", "*", "!", "&", "|", "[", "{"};
    private static String[] WRONG_PREFIX_STRING = new String[]{"$P{", "$F{", "$V{", "$X{"};

    public static Collection<String> getCategories() {
        if (functionsByCategory == null) {
            FunctionsLibraryUtil.initLibrary();
        }
        return functionsByCategory.keySet();
    }

    private static void initLibrary() {
        functionsByCategory = new HashMap<String, List<JRExprFunctionBean>>();
        allFunctions = new ArrayList<JRExprFunctionBean>();
        libraryClassNames = new ArrayList<String>();
        List extensionObjects = ExtensionsEnvironment.getExtensionsRegistry().getExtensions(JRExprFunctions.class);
        ArrayList foundClasses = new ArrayList();
        for (JRExprFunctions extObj : extensionObjects) {
            foundClasses.addAll(extObj.getFunctionsClasses());
        }
        for (Class clazz : foundClasses) {
            String clazzName = clazz.getName();
            if (!libraryClassNames.contains(clazzName)) {
                libraryClassNames.add(clazzName);
            }
            List jrFunctionsList = JRExprAnnotationsUtils.getJRFunctionsList((Class)clazz);
            for (JRExprFunctionBean f : jrFunctionsList) {
                for (String category : f.getCategories()) {
                    if (!functionsByCategory.containsKey(category)) {
                        functionsByCategory.put(category, new ArrayList());
                    }
                    functionsByCategory.get(category).add(f);
                    if (allFunctions.contains(f)) continue;
                    allFunctions.add(f);
                }
            }
        }
    }

    public static List<JRExprFunctionBean> getFunctionsByCategory(String categoryKey) {
        ArrayList list;
        if (functionsByCategory == null) {
            FunctionsLibraryUtil.initLibrary();
        }
        return (list = functionsByCategory.get(categoryKey)) != null ? list : new ArrayList(0);
    }

    public static List<JRExprFunctionBean> getAllFunctions() {
        if (allFunctions == null) {
            FunctionsLibraryUtil.initLibrary();
        }
        return allFunctions;
    }

    public static List<String> getLibraryClasses() {
        if (libraryClassNames == null) {
            FunctionsLibraryUtil.initLibrary();
        }
        return libraryClassNames;
    }

    public static boolean existsFunction(String functionName) {
        for (JRExprFunctionBean f : FunctionsLibraryUtil.getAllFunctions()) {
            if (!f.getName().equals(functionName)) continue;
            return true;
        }
        return false;
    }

    public static List<JRExprFunctionBean> findFunctions(JRExpression jre) {
        ArrayList<JRExprFunctionBean> functionsFound = new ArrayList<JRExprFunctionBean>();
        String expressionText = jre.getText();
        if (expressionText != null && !expressionText.isEmpty()) {
            int expressionLength = expressionText.length();
            block0: for (JRExprFunctionBean f : FunctionsLibraryUtil.getAllFunctions()) {
                String fname = f.getName();
                int flength = f.getName().length();
                int findex = expressionText.indexOf(fname);
                while (findex != -1) {
                    String fprefix = expressionText.substring(0, findex);
                    String fsuffix = expressionText.substring(findex + flength, expressionLength);
                    if (FunctionsLibraryUtil.checkPossibleFunctionPrefix(fprefix) && FunctionsLibraryUtil.checkPossibleFunctionSuffix(fsuffix)) {
                        functionsFound.add(f);
                        continue block0;
                    }
                    findex = expressionText.indexOf(fname, findex + flength);
                }
            }
        }
        return functionsFound;
    }

    private static boolean checkPossibleFunctionPrefix(String prefix) {
        if (prefix.isEmpty()) {
            return true;
        }
        boolean prefixOk = false;
        prefix = prefix.replace('\t', ' ').trim();
        for (String s : WRONG_PREFIX_STRING) {
            if (!prefix.endsWith(s)) continue;
            return false;
        }
        for (String s : PREFIX_STRINGS) {
            if (!prefix.endsWith(s)) continue;
            prefixOk = true;
            break;
        }
        return prefixOk;
    }

    private static boolean checkPossibleFunctionSuffix(String suffix) {
        for (int i = 0; i < suffix.length(); ++i) {
            char readchar = suffix.charAt(i);
            if (readchar == '(') {
                return true;
            }
            if (readchar == ' ' || readchar == '\t') continue;
            return false;
        }
        return false;
    }

    public static void reloadLibrary() {
        functionsByCategory.clear();
        functionsByCategory = null;
        allFunctions.clear();
        allFunctions = null;
        libraryClassNames.clear();
        libraryClassNames = null;
        FunctionsLibraryUtil.initLibrary();
    }
}

